/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroTransferenciaPatrimonial
extends Colecao<ItemQuadroTransferenciaPatrimonial> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroTransferenciaPatrimonial() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroTransferenciaPatrimonial itemQuadroTransferenciaPatrimonial) {
        itemQuadroTransferenciaPatrimonial.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroTransferenciaPatrimonial)((Object)o)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroTransferenciaPatrimonial itemQuadroAuxiliar = (ItemQuadroTransferenciaPatrimonial)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroTransferenciaPatrimonial item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroTransferenciaPatrimonial item = (ItemQuadroTransferenciaPatrimonial)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroTransferenciaPatrimonial instanciaNovoObjeto() {
        return new ItemQuadroTransferenciaPatrimonial((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }
}

