/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroOutrosRendimentos
extends Colecao<ItemQuadroOutrosRendimentos> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;
    private transient ObjetoNegocio parent;

    public ColecaoItemQuadroOutrosRendimentos() {
        this.getTotais().setReadOnly(true);
    }

    public ColecaoItemQuadroOutrosRendimentos(ObjetoNegocio parent) {
        this();
        this.parent = parent;
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos) {
        itemQuadroOutrosRendimentos.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroOutrosRendimentos)((Object)o)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroOutrosRendimentos itemQuadroAuxiliar = (ItemQuadroOutrosRendimentos)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroOutrosRendimentos item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroOutrosRendimentos item = (ItemQuadroOutrosRendimentos)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroOutrosRendimentos instanciaNovoObjeto() {
        return this.parent == null ? new ItemQuadroOutrosRendimentos((DeclaracaoIRPF)((Object)this.dec.get())) : new ItemQuadroOutrosRendimentos((DeclaracaoIRPF)((Object)this.dec.get()), this.parent);
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }

    public ObjetoNegocio getParent() {
        return this.parent;
    }
}

