/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroMeacaoDissolucao
extends Colecao<ItemQuadroMeacaoDissolucao> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroMeacaoDissolucao() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao) {
        itemQuadroMeacaoDissolucao.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroMeacaoDissolucao)((Object)o)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroMeacaoDissolucao itemQuadroAuxiliar = (ItemQuadroMeacaoDissolucao)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public ItemQuadroMeacaoDissolucao obterPorCPF(String cpf) {
        for (ItemQuadroMeacaoDissolucao item : this.itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(cpf)) continue;
            return item;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroMeacaoDissolucao item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroMeacaoDissolucao item = (ItemQuadroMeacaoDissolucao)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroMeacaoDissolucao instanciaNovoObjeto() {
        return new ItemQuadroMeacaoDissolucao((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }
}

