/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.herdeiros;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Observador;

public class Herdeiros
extends Colecao<Herdeiro> {
    private WeakReference<DeclaracaoIRPF> weakDec = null;
    private ObservadorNomeAlterado obsNomeAlterado = new ObservadorNomeAlterado();

    public Herdeiros(DeclaracaoIRPF dec) {
        this.setFicha("Herdeiros");
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public void objetoInserido(Herdeiro herdeiro) {
        this.setFicha(this.getFicha());
        herdeiro.getNome().addObservador((Observador)this.obsNomeAlterado);
    }

    public void objetoRemovido(Object o) {
        ((Herdeiro)((Object)o)).getNome().removeObservador((Observador)this.obsNomeAlterado);
    }

    public Herdeiro instanciaNovoObjeto() {
        return new Herdeiro(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao());
    }

    public boolean isNiDuplicado(String ni) {
        int counter = 0;
        for (Herdeiro h : this.itens()) {
            if (h.getNiHerdeiro().naoFormatado().isEmpty() || !h.getNiHerdeiro().naoFormatado().equals(ni)) continue;
            if (counter > 0) {
                return true;
            }
            ++counter;
        }
        return false;
    }

    public boolean isExisteNi(String ni) {
        for (Herdeiro h : this.itens()) {
            if (h.getNiHerdeiro().naoFormatado().isEmpty() || !h.getNiHerdeiro().naoFormatado().equals(ni)) continue;
            return true;
        }
        return false;
    }

    public String getChaveHerdeiroByNI(String ni) {
        for (Herdeiro h : this.itens()) {
            if (!h.getNiHerdeiro().naoFormatado().equals(ni)) continue;
            return h.getChave();
        }
        return null;
    }

    public boolean existeHerdeiro(String ni) {
        for (Herdeiro h : this.itens()) {
            if (!h.getNiHerdeiro().naoFormatado().equals(ni)) continue;
            return true;
        }
        return false;
    }

    public Herdeiro getHerdeiroByChave(String chave) {
        for (Herdeiro h : this.itens()) {
            if (!h.getChave().equals(chave)) continue;
            return h;
        }
        return null;
    }

    public DeclaracaoIRPF getDec() {
        return (DeclaracaoIRPF)((Object)this.weakDec.get());
    }

    public class ObservadorNomeAlterado
    extends Observador {
        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            for (Bem bem : Herdeiros.this.getDec().getBens().itens()) {
                for (ItemPercentualParticipacaoInventario participacao : bem.getParticipacoesInventario().itens()) {
                    for (Herdeiro herdeiro : Herdeiros.this.itens()) {
                        if (!participacao.getNi().naoFormatado().equals(herdeiro.getNiHerdeiro().naoFormatado())) continue;
                        participacao.getNome().setConteudo(herdeiro.getNome());
                    }
                }
            }
        }
    }
}

