/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.psocietarias;

import java.util.ArrayList;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.ValorBigDecimalGCME;
import serpro.ppgd.irpf.gcap.aquisicao.ParcelaAquisicao;
import serpro.ppgd.irpf.gcap.psocietarias.ParticipacaoSocietariaAlienada;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.ObjetoNegocio;

public class ParcelaAquisicaoParticipacaoSocietaria
extends ParcelaAquisicao {
    public static final String CAMPO_QUANTIDADE_QUOTAS = "Quantidade de Quotas/A\u00e7\u00f5es Alienadas";
    public static final String CAMPO_CUSTO_MEDIO = "Custo M\u00e9dio Ponderado Unit\u00e1rio em Reais";
    public static final String CAMPO_CUSTO_AQUISICAO = "Custo total de aquisi\u00e7\u00e3o";
    public static final int CODIGO_ACAO_PREFERENCIAL = 1;
    public static final int CODIGO_ACAO_ORDINARIA = 2;
    public static final int CODIGO_QUOTA = 3;
    public static final int CODIGO_OUTRAS = 4;
    public static final String DESCRICAO_ACAO_PREFERENCIAL = "A\u00e7\u00e3o preferencial nominativa";
    public static final String DESCRICAO_ACAO_ORDINARIA = "A\u00e7\u00e3o ordin\u00e1ria nominativa";
    public static final String DESCRICAO_QUOTA = "Quota";
    public static final String DESCRICAO_OUTRAS = "Outras";
    private Codigo especieAquisicao = new Codigo((ObjetoNegocio)this, "Esp\u00e9cie de Participa\u00e7\u00e3o Societ\u00e1ria", new ArrayList());
    private Inteiro quantidadeQuotas = new Inteiro((ObjetoNegocio)this, "Quantidade de Quotas/A\u00e7\u00f5es Alienadas");
    private ValorBigDecimalGCME custoMedio = new ValorBigDecimalGCME(this, "Custo M\u00e9dio Ponderado Unit\u00e1rio em Reais", 11, 6);
    private ValorPositivo custoAquisicao = new ValorPositivo(this, "Custo total de aquisi\u00e7\u00e3o", 11, 2);
    private ParticipacaoSocietariaAlienada participacaoSocietariaAlienada = new ParticipacaoSocietariaAlienada();

    public ParcelaAquisicaoParticipacaoSocietaria() {
        this.getCustoAquisicao().setReadOnly(true);
    }

    public void inicializarCmbEspecie(Codigo especieParticipacaoSocietaria) {
        if (!especieParticipacaoSocietaria.isVazio()) {
            String especieSelecionada = especieParticipacaoSocietaria.getConteudoAtual(0);
            if (especieSelecionada.equals("A")) {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarEspecieAquisicaoPSAcoes());
            } else if (especieSelecionada.equals("O")) {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarEspecieAquisicaoPSOutras());
            } else {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarEspecieAquisicaoPSQuota());
            }
        }
    }

    public Codigo getEspecieAquisicao() {
        return this.especieAquisicao;
    }

    public Alfa getEspecieParticipacaoSocietariaAlfa() {
        Alfa campo = new Alfa();
        campo.setConteudo(this.especieAquisicao.getConteudoAtual(1));
        return campo;
    }

    public String getEspecieAquisicaoImpressao() {
        return this.especieAquisicao.getConteudoAtual(1);
    }

    public Inteiro getQuantidadeQuotas() {
        return this.quantidadeQuotas;
    }

    public String getQuantidadeQuotasImpressao() {
        return this.quantidadeQuotas.formatado();
    }

    public ValorBigDecimalGCME getCustoMedio() {
        return this.custoMedio;
    }

    public String getCustoMedioImpressao() {
        return this.custoMedio.formatado();
    }

    @Override
    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public String getCustoAquisicaoImpressao() {
        return this.custoAquisicao.formatado();
    }

    public ParticipacaoSocietariaAlienada getParticipacaoSocietariaAlienada() {
        return this.participacaoSocietariaAlienada;
    }
}

