/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.consolidacao;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.GCAP;
import serpro.ppgd.irpf.gcap.consolidacao.ConsolidacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.ColecaoMoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.MoedasAlienadasMensal;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class ColecaoConsolidacaoEspecie
extends Colecao<ConsolidacaoEspecie> {
    private ValorPositivo ganhoCapitalTotal = new ValorPositivo((ObjetoNegocio)this, "Ganho de capital total (R$)", 11, 2);
    private ValorPositivo impostoDevido = new ValorPositivo((ObjetoNegocio)this, "Imposto devido (R$)", 11, 2);

    public ColecaoConsolidacaoEspecie() {
        super(ConsolidacaoEspecie.class.getName());
    }

    public ValorPositivo getGanhoCapitalTotal() {
        return this.ganhoCapitalTotal;
    }

    public ValorPositivo getImpostoDevido() {
        return this.impostoDevido;
    }

    public void consolidar() {
        if (ControladorGui.getDemonstrativoAberto() != null) {
            ValorPositivo lGanhoCapitalTotal = new ValorPositivo();
            ValorPositivo lImpostoDevido = new ValorPositivo();
            for (ConsolidacaoEspecie consolidacao : this.itens()) {
                lGanhoCapitalTotal.append('+', consolidacao.getGanhoCapitalTotal());
                GCAP gcap = ControladorGui.getDemonstrativoAberto().getGCAP();
                lImpostoDevido.append('+', gcap.getColecaoTotalizacaoMoedasAlienadas().obterTotalizacaoPorCPF(consolidacao.getCpf().naoFormatado()).obterValorAnual(MoedasAlienadasMensal.CONST_CAMPO_IMPOSTO_DEVIDO));
            }
            this.getGanhoCapitalTotal().setConteudo(lGanhoCapitalTotal);
            this.getImpostoDevido().setConteudo(lImpostoDevido);
        }
    }

    public void adicionarConsolidacaoEspecia(ColecaoMoedaAlienada colecaoMoeda) {
        GCAP gcap = ControladorGui.getDemonstrativoAberto().getGCAP();
        ConsolidacaoEspecie consolidacaoEspecie = new ConsolidacaoEspecie();
        consolidacaoEspecie.getCpf().setConteudo(colecaoMoeda.getCpf());
        consolidacaoEspecie.getDataInicioPermanencia().setConteudo(colecaoMoeda.getDataInicioPermanencia());
        consolidacaoEspecie.getDataFimPermanencia().setConteudo(colecaoMoeda.getDataFimPermanencia());
        consolidacaoEspecie.getAliquotaMedia().setConteudo(colecaoMoeda.getAliquotaMedia());
        consolidacaoEspecie.getGanhoCapitalTotal().setConteudo(colecaoMoeda.getGanhoCapitalTotal());
        consolidacaoEspecie.getImpostoDevido().setConteudo(gcap.getColecaoTotalizacaoMoedasAlienadas().obterTotalizacaoPorCPF(colecaoMoeda.getCpf().naoFormatado()).obterValorAnual(MoedasAlienadasMensal.CONST_CAMPO_IMPOSTO_DEVIDO));
        gcap.removerObjetoGCAP(consolidacaoEspecie, this);
        this.add(consolidacaoEspecie);
    }
}

