/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.bensimoveis;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class Endereco
extends ObjetoNegocio {
    private Codigo tipoLogradouro = new Codigo((ObjetoNegocio)this, "Tipo de logradouro", CadastroTabelasIRPF.recuperarTiposLogradouro());
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa logradouroEx = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa numero = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa numeroEx = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa complemento = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa complementoEx = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa bairro = new Alfa((ObjetoNegocio)this, "Bairro", 20);
    private Alfa bairroEx = new Alfa((ObjetoNegocio)this, "Bairro", 20);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa cidadeEx = new Alfa((ObjetoNegocio)this, "Cidade", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private CEP codigoPostalEx = new CEP((ObjetoNegocio)this, "C\u00f3digo postal");
    private Codigo paisEx = new Codigo((ObjetoNegocio)this, "Pa\u00eds", CadastroTabelasIRPF.recuperarPaisesExterior());

    public Endereco() {
        this.getTipoLogradouro().setColunaFiltro(1);
        this.getUf().setColunaFiltro(1);
        this.getUf().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Endereco.this.uf.isVazio()) {
                    Endereco.this.municipio.setColecaoElementoTabela(new ArrayList());
                } else {
                    String strUf = Endereco.this.uf.getConteudoAtual(0);
                    Endereco.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipios(strUf, 1));
                }
            }
        });
        this.setReadOnlyEndereco();
    }

    public void setReadOnlyEndereco() {
        this.tipoLogradouro.setReadOnly(true);
        this.logradouro.setReadOnly(true);
        this.logradouroEx.setReadOnly(true);
        this.numero.setReadOnly(true);
        this.numeroEx.setReadOnly(true);
        this.complemento.setReadOnly(true);
        this.complementoEx.setReadOnly(true);
        this.bairro.setReadOnly(true);
        this.bairroEx.setReadOnly(true);
        this.uf.setReadOnly(true);
        this.municipio.setReadOnly(true);
        this.cidadeEx.setReadOnly(true);
        this.cep.setReadOnly(true);
        this.codigoPostalEx.setReadOnly(true);
        this.paisEx.setReadOnly(true);
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getTipoLogradouro());
        lista.add((Informacao)this.getLogradouro());
        lista.add((Informacao)this.getLogradouroEx());
        lista.add((Informacao)this.getNumero());
        lista.add((Informacao)this.getNumeroEx());
        lista.add((Informacao)this.getComplemento());
        lista.add((Informacao)this.getComplementoEx());
        lista.add((Informacao)this.getBairro());
        lista.add((Informacao)this.getBairroEx());
        lista.add((Informacao)this.getUf());
        lista.add((Informacao)this.getMunicipio());
        lista.add((Informacao)this.getPaisEx());
        lista.add((Informacao)this.getCidadeEx());
        lista.add((Informacao)this.getCep());
        lista.add((Informacao)this.getCodigoPostalEx());
        return lista;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public CEP getCep() {
        return this.cep;
    }

    public CEP getCodigoPostalEx() {
        return this.codigoPostalEx;
    }

    public Codigo getPaisEx() {
        return this.paisEx;
    }

    public Alfa getLogradouroEx() {
        return this.logradouroEx;
    }

    public Alfa getNumeroEx() {
        return this.numeroEx;
    }

    public Alfa getComplementoEx() {
        return this.complementoEx;
    }

    public Alfa getBairroEx() {
        return this.bairroEx;
    }

    public Alfa getCidadeEx() {
        return this.cidadeEx;
    }
}

