/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;

public class ColecaoParcelaAlienacao
extends Colecao<ParcelaAlienacao> {
    private ValorPositivo valorRecebidoTotal = new ValorPositivo();
    private ValorPositivo custoCorretagemTotal = new ValorPositivo();
    private ValorPositivo valorLiquidoAlienacaoTotal = new ValorPositivo();
    private ValorPositivo ganhoProporcionalTotal = new ValorPositivo();
    private ValorPositivo impostoDevidoTotal = new ValorPositivo();
    private ValorPositivo impostoPagoTotal = new ValorPositivo();
    private ValorPositivo impostoDevido2Total = new ValorPositivo();
    private ValorPositivo irrfLei110332004Total = new ValorPositivo();
    private ValorPositivo custoAquisicaoProporcionalTotal = new ValorPositivo();
    private WeakReference<Alienacao> weakAlienacao = null;

    public ColecaoParcelaAlienacao(Alienacao weakAlienacao) {
        super(ParcelaAlienacao.class.getName());
        this.weakAlienacao = new WeakReference<Alienacao>(weakAlienacao);
        this.valorRecebidoTotal.setReadOnly(true);
        this.custoCorretagemTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoTotal.setReadOnly(true);
        this.ganhoProporcionalTotal.setReadOnly(true);
        this.impostoDevidoTotal.setReadOnly(true);
        this.impostoPagoTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalTotal.setReadOnly(true);
    }

    public void ajustarPosicaoParcela(ParcelaAlienacao parcela) {
        if (parcela.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
            parcela.setEmReordenacao(true);
            this.itens().remove((Object)parcela);
            int posicao = 0;
            Iterator itParcelas = this.itens().iterator();
            while (itParcelas.hasNext() && !((ParcelaAlienacao)((Object)itParcelas.next())).getDataRecebimento().maisNova(parcela.getDataRecebimento())) {
                ++posicao;
            }
            this.itens().add(posicao, parcela);
            parcela.setEmReordenacao(false);
        }
    }

    public Data getDataRecebimentoUltimaParcela() {
        Data dataUltimaParcela = new Data();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            dataUltimaParcela.setConteudo(parcela.getDataRecebimento());
        }
        return dataUltimaParcela;
    }

    public boolean jaTemUltimaParcela() {
        int counter = 0;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            ++counter;
        }
        return counter > 1;
    }

    public ValorPositivo obterImpostoPagoUltimaParcela() {
        ValorPositivo valorPago = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            valorPago.setConteudo(parcela.getImpostoPago());
            break;
        }
        return valorPago;
    }

    public ValorPositivo obterGanhoCapitalRealTotalSemUltimaParcela() {
        ValorPositivo ganhoCapital = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.isUltimaParcela()) continue;
            ganhoCapital.append('+', parcela.getGanhoCapital1Proporcional());
        }
        return ganhoCapital;
    }

    public ValorPositivo obterImpostoDevidoSemUltimaParcela() {
        ValorPositivo impostoDevido = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.isUltimaParcela()) continue;
            impostoDevido.append('+', parcela.getImpostoDevido());
        }
        return impostoDevido;
    }

    public ParcelaAlienacao obterUltimaParcela() {
        ParcelaAlienacao lparcela = null;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            lparcela = parcela;
        }
        return lparcela;
    }

    public boolean existeParcelaAposUltima(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!pParcela.isUltimaParcela() || parcela.isUltimaParcela() || parcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().maisAntiga(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public boolean parcelaPosteriorUltima(Data data) {
        boolean retorno = false;
        Data dataUltimaParcela = this.getDataRecebimentoUltimaParcela();
        if (!dataUltimaParcela.isVazio() && data.maisNova(dataUltimaParcela)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean existeParcelaNaMesmaData(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (pParcela == parcela || pParcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().igual(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public ValorPositivo getValorRecebidoTotal() {
        return this.valorRecebidoTotal;
    }

    public ValorPositivo getGanhoProporcionalTotal() {
        return this.ganhoProporcionalTotal;
    }

    public ValorPositivo getImpostoDevidoTotal() {
        return this.impostoDevidoTotal;
    }

    public ValorPositivo getImpostoPagoTotal() {
        return this.impostoPagoTotal;
    }

    public ValorPositivo getCustoCorretagemTotal() {
        return this.custoCorretagemTotal;
    }

    public ValorPositivo getValorLiquidoAlienacaoTotal() {
        return this.valorLiquidoAlienacaoTotal;
    }

    public ValorPositivo getImpostoDevido2Total() {
        return this.impostoDevido2Total;
    }

    public ValorPositivo getIrrfLei110332004Total() {
        return this.irrfLei110332004Total;
    }

    public ValorPositivo getCustoAquisicaoProporcionalTotal() {
        return this.custoAquisicaoProporcionalTotal;
    }
}

