/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap;

import java.io.File;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.irpf.gcap.especie.ColecaoMoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.MoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.TotalizacaoMoedasAlienadas;
import serpro.ppgd.negocio.ObjetoNegocio;

public class DemonstrativoGCAP
extends ObjetoNegocio {
    private transient IdDemonstrativoGCAP idDemonstrativo;
    private IdDemonstrativoGCAP copiaIdentificador = new IdDemonstrativoGCAP();
    private ColecaoAlienacaoBemImovel bensImoveis;
    private ColecaoAlienacaoBemMovel bensMoveis;
    private ColecaoAlienacaoParticipacaoSocietaria participacoesSocietarias;
    private ColecaoMoedaAlienada moedasAlienadas;
    private Consolidacao consolidacaoBrasil;
    private Consolidacao consolidacaoExterior;
    private TotalizacaoMoedasAlienadas totalizacaoMoedasAlienadas;

    public DemonstrativoGCAP(IdDemonstrativoGCAP pIdentificadorDemonstrativo) {
        this.idDemonstrativo = pIdentificadorDemonstrativo;
        this.copiaIdentificador = pIdentificadorDemonstrativo;
        this.bensImoveis = new ColecaoAlienacaoBemImovel();
        this.bensMoveis = new ColecaoAlienacaoBemMovel();
        this.participacoesSocietarias = new ColecaoAlienacaoParticipacaoSocietaria();
        this.moedasAlienadas = new ColecaoMoedaAlienada();
        this.consolidacaoBrasil = new Consolidacao();
        this.consolidacaoExterior = new Consolidacao();
        this.totalizacaoMoedasAlienadas = new TotalizacaoMoedasAlienadas();
    }

    public IdDemonstrativoGCAP getIdentificador() {
        return this.idDemonstrativo;
    }

    public IdDemonstrativoGCAP getIdentificadorDeclaracao() {
        return this.idDemonstrativo;
    }

    public IdDemonstrativoGCAP getCopiaIdentificador() {
        return this.copiaIdentificador;
    }

    public IdDemonstrativoGCAP getIdDemonstrativo() {
        return this.idDemonstrativo;
    }

    public void setIdDemonstrativo(IdDemonstrativoGCAP idDemonstrativo) {
        this.idDemonstrativo = idDemonstrativo;
    }

    public ColecaoAlienacaoBemImovel getBensImoveis() {
        return this.bensImoveis;
    }

    public ColecaoAlienacaoBemMovel getBensMoveis() {
        return this.bensMoveis;
    }

    public ColecaoAlienacaoParticipacaoSocietaria getParticipacoesSocietarias() {
        return this.participacoesSocietarias;
    }

    public ColecaoMoedaAlienada getMoedasAlienadas() {
        return this.moedasAlienadas;
    }

    public Consolidacao getConsolidacaoBrasil() {
        return this.consolidacaoBrasil;
    }

    public Consolidacao getConsolidacaoExterior() {
        return this.consolidacaoExterior;
    }

    public TotalizacaoMoedasAlienadas getTotalizacaoMoedasAlienadas() {
        return this.totalizacaoMoedasAlienadas;
    }

    public void associarAlienacoesIdDemonstrativo() {
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            alienacao.getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
            alienacao.getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
            alienacao.getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
            alienacao.getNomePaisDeclarante().setConteudo(this.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(1));
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            alienacao.getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
            alienacao.getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
            alienacao.getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
            alienacao.getNomePaisDeclarante().setConteudo(this.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(1));
        }
        for (Alienacao alienacao : this.getParticipacoesSocietarias().itens()) {
            alienacao.getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
            alienacao.getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
            alienacao.getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
            alienacao.getNomePaisDeclarante().setConteudo(this.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(1));
        }
        for (MoedaAlienada moeda : this.getMoedasAlienadas().itens()) {
            moeda.getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
            moeda.getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
            moeda.getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
            moeda.getPaisDeclarante().setConteudo(this.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(1));
        }
        this.getConsolidacaoBrasil().getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
        this.getConsolidacaoBrasil().getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
        this.getConsolidacaoBrasil().getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
        this.getConsolidacaoExterior().getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
        this.getConsolidacaoExterior().getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
        this.getConsolidacaoExterior().getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
        this.getMoedasAlienadas().getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
        this.getMoedasAlienadas().getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
        this.getMoedasAlienadas().getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
        this.getTotalizacaoMoedasAlienadas().getCpf().setConteudo(this.getIdDemonstrativo().getCpf());
        this.getTotalizacaoMoedasAlienadas().getDataInicioPermanencia().setConteudo(this.getIdDemonstrativo().getDataInicioPermanencia());
        this.getTotalizacaoMoedasAlienadas().getDataFimPermanencia().setConteudo(this.getIdDemonstrativo().getDataFimPermanencia());
    }

    public boolean demonstrativoAssociadoArquivo(File file) {
        boolean associado = false;
        if (file != null && file.getName().length() > 11) {
            String cpfArquivo = file.getName().substring(0, 11);
            String cpfDemonstrativo = this.getIdDemonstrativo().getCpf().naoFormatado();
            associado = cpfArquivo.equals(cpfDemonstrativo);
        }
        return associado;
    }
}

