/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import java.util.List;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.gui.espolio.PainelEscolheEspolio;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class EspolioDecisaoJudicial
extends ObjetoNegocio
implements ObjetoFicha {
    private Alfa numProcessoJudicial = new Alfa((ObjetoNegocio)this, "N\u00b0 do processo judicial");
    private Alfa idVaraCivil = new Alfa((ObjetoNegocio)this, "Identifica\u00e7\u00e3o da vara c\u00edvel");
    private Alfa comarca = new Alfa((ObjetoNegocio)this, "Comarca");
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarSiglasUFs(0));
    private Data dtDecisaoJud = new Data((ObjetoNegocio)this, "Data da decis\u00e3o judicial da partilha");
    private Data dtTransito = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado da decis\u00e3o judicial da partilha");
    private String nomeAba;

    public EspolioDecisaoJudicial(String nomeAba) {
        this.nomeAba = nomeAba;
        this.setFicha("Esp\u00f3lio");
        this.getUf().setColunaFiltro(1);
        this.getComarca().addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public Alfa getComarca() {
        return this.comarca;
    }

    public Data getDtDecisaoJud() {
        return this.dtDecisaoJud;
    }

    public Data getDtTransito() {
        return this.dtTransito;
    }

    public Alfa getIdVaraCivil() {
        return this.idVaraCivil;
    }

    public Alfa getNumProcessoJudicial() {
        return this.numProcessoJudicial;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public String getMesDecisaoJudicial() {
        return this.getDtDecisaoJud().formatado().substring(3, 5);
    }

    public String getAnoDecisaoJudicial() {
        return this.getDtDecisaoJud().formatado().substring(6);
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        return super.recuperarCamposInformacao();
    }

    public boolean isVazio() {
        return this.getNumProcessoJudicial().isVazio() && this.getIdVaraCivil().isVazio() && this.getComarca().isVazio() && this.getUf().isVazio() && this.getDtDecisaoJud().isVazio() && this.getDtTransito().isVazio();
    }

    public String getClasseFicha() {
        return PainelEscolheEspolio.class.getName();
    }

    public String getNomeAba() {
        return this.nomeAba;
    }

    public String getTituloFichaDashboard() {
        return "Esp\u00f3lio";
    }
}

