/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorAproximaAno;
import serpro.ppgd.irpf.ValidadorCPFIRPF;
import serpro.ppgd.irpf.ValidadorDataIrpf;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.atividaderural.brasil.ReceitasDespesas;
import serpro.ppgd.irpf.espolio.EspolioPartilha;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.espolio.PainelEscolheEspolio;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Espolio
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String OPCAO_NAO_SE_TRATA_DE_MORTE_DE_AMBOS = "2";
    public static final String FASE_FINAL_PARTILHA = "0";
    public static final String FASE_FINAL_SOBREPARTILHA = "1";
    public static final String FASE_FINAL_PARTILHA_INICIAL_SOBREPARTILHA = "2";
    public static final String FASE_FINAL_PARTILHA_FINAL_SOBREPARTILHA = "3";
    public static final String FINAL_ESPOLIO_PARTILHA = "0";
    public static final String FINAL_ESPOLIO_SOBREPARTILHA = "1";
    public static final String FINAL_ESPOLIO_PARTILHA_SOBREPARTILHA = "3";
    public static final String BENS_INVENTARIAR_NAO_MARCADO = "0";
    public static final String BENS_INVENTARIAR_MARCADO = "1";
    private Alfa indicadorBensInventariar = new Alfa((ObjetoNegocio)this, "Ainda h\u00e1 bens a iventariar?");
    private Alfa anoObito = new Alfa((ObjetoNegocio)this, "Ano de \u00f3bito");
    private Alfa indicadorSobrepartilha = new Alfa((ObjetoNegocio)this, "Informar sobrepartilha?");
    private Alfa indicadorFinalEspolio = new Alfa((ObjetoNegocio)this, "Informar Final de Esp\u00f3lio?");
    EspolioPartilha partilha;
    EspolioPartilha sobrepartilha;
    private CPF cpfInventariante = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nomeInventariante = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private WeakReference<DeclaracaoIRPF> weakDec;

    public Espolio(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.partilha = new EspolioPartilha(dec, "Partilha");
        this.sobrepartilha = new EspolioPartilha(dec, "Sobrepartilha");
        CacheNI.getInstancia().registrarNINome((NI)this.getCpfInventariante(), this.getNomeInventariante());
        this.setFicha("Esp\u00f3lio");
        this.getIndicadorFinalEspolio().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().isEspolio() && Espolio.this.getIndicadorFinalEspolio().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{"Final de Esp\u00f3lio"}));
                }
                return null;
            }
        });
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isAjuste()) {
            this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3, MensagemUtil.getMensagem("espolio_cpf_invalido")){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialPartilha()) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialPartilha() && Espolio.this.getPartilha().getCpfInventariante().naoFormatado().equals(((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_inventariante_igual_contribuinte"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialPartilha() && this.getInformacao().isVazio() && !Espolio.this.getPartilha().getNomeInventariante().isVazio()) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{"CPF do inventariante"}), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getPartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialPartilha()) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialPartilha() && this.getInformacao().isVazio() && !Espolio.this.getPartilha().getCpfInventariante().isVazio()) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{"Nome do inventariante"}), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3, MensagemUtil.getMensagem("espolio_cpf_invalido")){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialSobrepartilha()) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialSobrepartilha() && Espolio.this.getSobrepartilha().getCpfInventariante().naoFormatado().equals(((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_inventariante_igual_contribuinte"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialSobrepartilha() && this.getInformacao().isVazio() && !Espolio.this.getSobrepartilha().getNomeInventariante().isVazio()) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{"CPF do inventariante"}), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialSobrepartilha()) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehInicialSobrepartilha() && this.getInformacao().isVazio() && !Espolio.this.getSobrepartilha().getCpfInventariante().isVazio()) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{"Nome do inventariante"}), this.getSeveridade());
                    }
                    return null;
                }
            });
        }
        this.getCpfInventariante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3, MensagemUtil.getMensagem("espolio_cpf_invalido")){

            public RetornoValidacao validarImplementado() {
                if (Espolio.this.isBensInventariarMarcado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Espolio.this.isBensInventariarMarcado() && Espolio.this.getCpfInventariante().naoFormatado().equals(((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_inventariante_igual_contribuinte"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeInventariante().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.isBensInventariarMarcado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3, MensagemUtil.getMensagem("espolio_cpf_invalido")){

            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3, MensagemUtil.getMensagem("espolio_cpf_invalido")){

            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getPartilha().getCpfInventariante().naoFormatado().equals(((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_inventariante_igual_contribuinte"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getSobrepartilha().getCpfInventariante().naoFormatado().equals(((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_inventariante_igual_contribuinte"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("espolio_cpf_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("espolio_cpf_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("espolio_nome_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSobrepartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("espolio_nome_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSobrepartilha().getNomeInventariante().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            this.getAnoObito().addObservador((Observador)new ObservadorAproximaAno(ConstantesGlobais.ANO_BASE));
            Observador obsZeraRendasMesais = this.adicionaObservadorEspolio();
            this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().addObservador(obsZeraRendasMesais);
            this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addObservador(obsZeraRendasMesais);
            this.getPartilha().getEscrituracaoPublica().getDataLavratura().addObservador(obsZeraRendasMesais);
            this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addObservador(obsZeraRendasMesais);
            this.getIndicadorSobrepartilha().addObservador(obsZeraRendasMesais);
            this.getIndicadorBensInventariar().addObservador(obsZeraRendasMesais);
            this.getAnoObito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    try {
                        String anoNascimentoFormatado;
                        int anoNascimento;
                        if (Espolio.this.getAnoObito().isVazio()) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("ano_obito_vazio"), this.getSeveridade());
                        }
                        int anoObitoInt = Integer.parseInt(Espolio.this.getAnoObito().naoFormatado());
                        int anoBase = Integer.parseInt(ConstantesGlobais.ANO_BASE);
                        if (anoObitoInt < 1000 || anoObitoInt > anoBase) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("ano_obito_invalido"), this.getSeveridade());
                        }
                        Data dataNascimentoContribuinte = ((DeclaracaoIRPF)((Object)Espolio.this.weakDec.get())).getContribuinte().getDataNascimento();
                        dataNascimentoContribuinte.validar();
                        if (dataNascimentoContribuinte.isValido() && anoObitoInt < (anoNascimento = Integer.parseInt((anoNascimentoFormatado = dataNascimentoContribuinte.formatado()).substring(6, 10)))) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("ano_obito_menor_ano_nascimento"), this.getSeveridade());
                        }
                    }
                    catch (Exception ex) {
                        LogPPGD.erro((String)ex.getMessage());
                    }
                    return null;
                }
            });
            this.getPartilha().getNomeConjugeCompanheiro().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getPartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM)) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getNomeConjugeCompanheiro().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getSobrepartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM)) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getNomeConjugeCompanheiro().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getPartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM)) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getNomeConjugeCompanheiro().addValidador((ValidadorIf)new ValidadorNomeIRPF(){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Espolio.this.getSobrepartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM)) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, "O campo indicativo 'Data da decis\u00e3o judicial da sobrepartilha' n\u00e3o foi informado."){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, "O campo indicativo 'Data do tr\u00e2nsito em julgado da decis\u00e3o judicial da sobrepartilha' n\u00e3o foi informado."){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !ConstantesGlobais.ANO_BASE.equals(Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().getAno())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_decisao_jud_partilha", new String[]{ConstantesGlobais.ANO_BASE}), 3);
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !ConstantesGlobais.ANO_BASE.equals(Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().getAno())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_decisao_jud_sobrepartilha", new String[]{ConstantesGlobais.ANO_BASE}), 3);
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehFinalEspolioPartilhaSobrepartilha() && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado()) && (Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) ? !Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().maisAntiga(Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud()) : Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().maisAntiga(Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura()))) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_sobrepartilha_anterior_partilha"), 3);
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !Espolio.this.getPartilha().getDecisaoJudicial().getDtTransito().isVazio() && Espolio.this.getPartilha().getDecisaoJudicial().getDtTransito().maisAntiga(Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_transito_anterior_dt_decisao_jud_partilha"), 3);
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.SIM.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && !Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtTransito().isVazio() && Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtTransito().maisAntiga(Espolio.this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_transito_anterior_dt_decisao_jud_sobrepartilha"), 3);
                    }
                    return null;
                }
            });
            this.getPartilha().getEscrituracaoPublica().getCnpjCartorio().addValidador((ValidadorIf)new ValidadorCNPJ(3){

                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getEscrituracaoPublica().getCnpjCartorio().addValidador((ValidadorIf)new ValidadorCNPJ(3){

                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getPartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorDataIrpf(3, 9999){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado())) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehFinalEspolioPartilhaSobrepartilha() && Logico.NAO.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado()) && (Logico.SIM.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) ? !Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && !Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().isVazio() && Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().maisAntiga(Espolio.this.getPartilha().getDecisaoJudicial().getDtDecisaoJud()) : Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && !Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().maisAntiga(Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura()))) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_sobrepartilha_anterior_partilha"), 3);
                    }
                    return null;
                }
            });
            this.getPartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioPartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getPartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && !ConstantesGlobais.ANO_BASE.equals(Espolio.this.getPartilha().getEscrituracaoPublica().getDataLavratura().getAno())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_escrituracao_publica_partilha", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR}), 3);
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if ((Espolio.this.ehFinalEspolioSobrepartilha() || Espolio.this.ehFinalEspolioPartilhaSobrepartilha()) && Logico.NAO.equals(Espolio.this.getSobrepartilha().getTipoJudicial().naoFormatado()) && !Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().isVazio() && !ConstantesGlobais.ANO_BASE.equals(Espolio.this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().getAno())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_dt_escrituracao_publica_sobrepartilha", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR}), 3);
                    }
                    return null;
                }
            });
            this.getPartilha().getMorteAmbosConjuges().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehFinalEspolioPartilhaSobrepartilha() && !Espolio.this.getPartilha().getMorteAmbosConjuges().naoFormatado().equals(Espolio.this.getSobrepartilha().getMorteAmbosConjuges().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_morte_ambos_conjuges"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getSobrepartilha().getMorteAmbosConjuges().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Espolio.this.ehFinalEspolioPartilhaSobrepartilha() && !Espolio.this.getSobrepartilha().getMorteAmbosConjuges().naoFormatado().equals(Espolio.this.getPartilha().getMorteAmbosConjuges().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("espolio_morte_ambos_conjuges"), this.getSeveridade());
                    }
                    return null;
                }
            });
        }
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao();
    }

    public boolean ehFinalEspolioPartilha() {
        String faseEspolio = this.obterFaseFinalEspolio();
        return "0".equals(faseEspolio);
    }

    public boolean ehFinalEspolioSobrepartilha() {
        String faseEspolio = this.obterFaseFinalEspolio();
        return "1".equals(faseEspolio);
    }

    public boolean ehFinalEspolioPartilhaSobrepartilha() {
        String faseEspolio = this.obterFaseFinalEspolio();
        return "3".equals(faseEspolio);
    }

    public boolean ehInicialSobrepartilha() {
        if (this.getIdentificadorDeclaracao().isAjuste()) {
            return Logico.SIM.equals(this.getIndicadorSobrepartilha().naoFormatado());
        }
        String faseEspolio = this.obterFaseFinalEspolio();
        return "1".equals(faseEspolio);
    }

    public boolean ehInicialPartilha() {
        return this.getIdentificadorDeclaracao().isAjuste() && Logico.NAO.equals(this.getIndicadorSobrepartilha().naoFormatado());
    }

    public String obterFaseFinalEspolio() {
        if (this.getIdentificadorDeclaracao().isEspolio()) {
            return this.getIndicadorFinalEspolio().naoFormatado();
        }
        return "";
    }

    private Observador adicionaObservadorEspolio() {
        return new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                int mes;
                try {
                    mes = Integer.valueOf(Espolio.this.obterDataLimiteParaCalculos().getMes());
                }
                catch (Exception e) {
                    mes = 12;
                }
                DeclaracaoIRPF dec = (DeclaracaoIRPF)((Object)Espolio.this.weakDec.get());
                if (!Logico.SIM.equals(dec.getEspolio().getIndicadorBensInventariar().naoFormatado())) {
                    RendPF rendPFTitular = dec.getRendPFTitular();
                    ColecaoRendPFDependente colecaoRendPFDependente = dec.getRendPFDependente();
                    ReceitasDespesas receitasDespesas = dec.getAtividadeRural().getBrasil().getReceitasDespesas();
                    RendaVariavel rendVar = dec.getRendaVariavel();
                    ColecaoRendaVariavelDependente colRendaVarDependentes = dec.getRendaVariavelDependente();
                    FundosInvestimentos fundosInvest = dec.getFundosInvestimentos();
                    ColecaoFundosInvestimentosDependente fundosInvestDep = dec.getFundosInvestimentosDependente();
                    for (int i = mes; i < 12; ++i) {
                        rendPFTitular.getContasAno().getArrayMeses()[i].clear();
                        rendPFTitular.getMesRendPFPorIndice(i).clear();
                        receitasDespesas.getMesReceitaPorIndice(i).clear();
                        rendVar.getGanhosPorIndice(i).clear();
                        fundosInvest.getMeses()[i].clear();
                        for (ItemRendPFDependente itemRendPFDependente : colecaoRendPFDependente.itens()) {
                            itemRendPFDependente.getRendimentos().getContasAno().getArrayMeses()[i].clear();
                            itemRendPFDependente.getRendimentos().getMesRendPFPorIndice(i).clear();
                        }
                        for (ItemRendaVariavelDependente itemRendaVarDep : colRendaVarDependentes.itens()) {
                            itemRendaVarDep.getRendaVariavel().getGanhosPorIndice(i).clear();
                        }
                        for (ItemFundosInvestimentosDependente itemFundosInvestDep : fundosInvestDep.itens()) {
                            itemFundosInvestDep.getFundosInvestimentos().getMeses()[i].clear();
                        }
                    }
                }
            }
        };
    }

    public Data obterDataLimiteParaCalculos() {
        Data dtLimite = new Data();
        dtLimite.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
        EspolioPartilha infoEspolio = this.obterInformacoEspolioParaCalculos();
        String inDecisaoJudicial = infoEspolio.getTipoJudicial().naoFormatado();
        if (!this.getIdentificadorDeclaracao().isAjuste()) {
            if (Logico.SIM.equals(inDecisaoJudicial) && !infoEspolio.getDecisaoJudicial().getDtDecisaoJud().isVazio()) {
                dtLimite.setConteudo(infoEspolio.getDecisaoJudicial().getDtDecisaoJud());
            } else if (Logico.NAO.equals(inDecisaoJudicial) && !infoEspolio.getEscrituracaoPublica().getDataLavratura().isVazio()) {
                dtLimite.setConteudo(infoEspolio.getEscrituracaoPublica().getDataLavratura());
            }
        }
        return dtLimite;
    }

    public Data obterDataTransitoJulgadoOuLavraturaParaCalculos() {
        String inDecisaoJudicial;
        Data dtLimite = new Data();
        dtLimite.setConteudo("01/01/" + ConstantesGlobais.ANO_BASE);
        if (this.ehFinalEspolioPartilha()) {
            EspolioPartilha partilha = this.getPartilha();
            inDecisaoJudicial = partilha.getTipoJudicial().naoFormatado();
            if (Logico.SIM.equals(inDecisaoJudicial) && !partilha.getDecisaoJudicial().getDtTransito().isVazio() && partilha.getDecisaoJudicial().getDtTransito().maisNova(dtLimite)) {
                dtLimite.setConteudo(partilha.getDecisaoJudicial().getDtTransito());
            } else if (Logico.NAO.equals(inDecisaoJudicial) && !partilha.getEscrituracaoPublica().getDataLavratura().isVazio() && partilha.getEscrituracaoPublica().getDataLavratura().maisNova(dtLimite)) {
                dtLimite.setConteudo(partilha.getEscrituracaoPublica().getDataLavratura());
            }
        }
        if (this.ehFinalEspolioSobrepartilha() || this.ehFinalEspolioPartilhaSobrepartilha()) {
            EspolioPartilha sobrepartilha = this.getSobrepartilha();
            inDecisaoJudicial = sobrepartilha.getTipoJudicial().naoFormatado();
            if (Logico.SIM.equals(inDecisaoJudicial) && !sobrepartilha.getDecisaoJudicial().getDtTransito().isVazio() && sobrepartilha.getDecisaoJudicial().getDtTransito().maisNova(dtLimite)) {
                dtLimite.setConteudo(sobrepartilha.getDecisaoJudicial().getDtTransito());
            } else if (Logico.NAO.equals(inDecisaoJudicial) && !sobrepartilha.getEscrituracaoPublica().getDataLavratura().isVazio() && sobrepartilha.getEscrituracaoPublica().getDataLavratura().maisNova(dtLimite)) {
                dtLimite.setConteudo(sobrepartilha.getEscrituracaoPublica().getDataLavratura());
            }
        }
        return dtLimite;
    }

    public EspolioPartilha obterInformacoEspolioParaCalculos() {
        if (this.ehFinalEspolioSobrepartilha() || this.ehFinalEspolioPartilhaSobrepartilha()) {
            return this.getSobrepartilha();
        }
        return this.getPartilha();
    }

    public EspolioPartilha obterInformacoEspolioCPFInventarianteHeader() {
        if (this.ehInicialPartilha() || this.ehFinalEspolioPartilha() || this.ehFinalEspolioPartilhaSobrepartilha()) {
            return this.getPartilha();
        }
        return this.getSobrepartilha();
    }

    public boolean isBensInventariarMarcado() {
        return this.indicadorBensInventariar.naoFormatado().equals("1");
    }

    public int getQtdMesesParaCalculos() {
        return this.obterInformacoEspolioParaCalculos().getQtdMesesParaCalculos();
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public boolean isVazio() {
        return this.getAnoObito().isVazio();
    }

    public String getClasseFicha() {
        return PainelEscolheEspolio.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Esp\u00f3lio";
    }

    public Alfa getAnoObito() {
        return this.anoObito;
    }

    public Alfa getIndicadorSobrepartilha() {
        return this.indicadorSobrepartilha;
    }

    public Alfa getIndicadorFinalEspolio() {
        return this.indicadorFinalEspolio;
    }

    public Alfa getIndicadorBensInventariar() {
        return this.indicadorBensInventariar;
    }

    public EspolioPartilha getPartilha() {
        return this.partilha;
    }

    public EspolioPartilha getSobrepartilha() {
        return this.sobrepartilha;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public void atualizarTipoFinalEspolio() {
        boolean habilitarPartilha = false;
        boolean habilitarSobrepartilha = false;
        if ("0".equals(this.getIndicadorFinalEspolio().naoFormatado()) || "3".equals(this.getIndicadorFinalEspolio().naoFormatado())) {
            habilitarPartilha = true;
        }
        if ("1".equals(this.getIndicadorFinalEspolio().naoFormatado()) || "3".equals(this.getIndicadorFinalEspolio().naoFormatado())) {
            habilitarSobrepartilha = true;
        }
        this.getPartilha().getConjugeMeeiro().setHabilitado(habilitarPartilha);
        this.getPartilha().getCpfInventariante().setHabilitado(habilitarPartilha);
        this.getPartilha().getInventarioConjunto().setHabilitado(habilitarPartilha);
        this.getPartilha().getMorteAmbosConjuges().setHabilitado(habilitarPartilha);
        this.getPartilha().getNomeInventariante().setHabilitado(habilitarPartilha);
        this.getPartilha().getTipoJudicial().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getComarca().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getDtTransito().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getIdVaraCivil().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getNumProcessoJudicial().setHabilitado(habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getUf().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getCnpjCartorio().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getDataLavratura().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getFolhas().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getLivro().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getMunicipio().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getNome().setHabilitado(habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getUf().setHabilitado(habilitarPartilha);
        this.getPartilha().getConjugeMeeiro().setReadOnly(!habilitarPartilha);
        this.getPartilha().getCpfInventariante().setReadOnly(!habilitarPartilha);
        this.getPartilha().getInventarioConjunto().setReadOnly(!habilitarPartilha);
        this.getPartilha().getMorteAmbosConjuges().setReadOnly(!habilitarPartilha);
        this.getPartilha().getNomeInventariante().setReadOnly(!habilitarPartilha);
        this.getPartilha().getTipoJudicial().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getComarca().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getDtDecisaoJud().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getDtTransito().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getIdVaraCivil().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getNumProcessoJudicial().setReadOnly(!habilitarPartilha);
        this.getPartilha().getDecisaoJudicial().getUf().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getCnpjCartorio().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getDataLavratura().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getFolhas().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getLivro().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getMunicipio().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getNome().setReadOnly(!habilitarPartilha);
        this.getPartilha().getEscrituracaoPublica().getUf().setReadOnly(!habilitarPartilha);
        this.getSobrepartilha().getConjugeMeeiro().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getCpfInventariante().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getInventarioConjunto().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getMorteAmbosConjuges().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getNomeInventariante().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getTipoJudicial().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getComarca().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getDtTransito().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getIdVaraCivil().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getNumProcessoJudicial().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getUf().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getCnpjCartorio().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getFolhas().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getLivro().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getMunicipio().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getNome().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getUf().setHabilitado(habilitarSobrepartilha);
        this.getSobrepartilha().getConjugeMeeiro().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getCpfInventariante().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getInventarioConjunto().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getMorteAmbosConjuges().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getNomeInventariante().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getTipoJudicial().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getComarca().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getDtTransito().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getIdVaraCivil().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getNumProcessoJudicial().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getDecisaoJudicial().getUf().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getCnpjCartorio().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getFolhas().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getLivro().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getMunicipio().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getNome().setReadOnly(!habilitarSobrepartilha);
        this.getSobrepartilha().getEscrituracaoPublica().getUf().setReadOnly(!habilitarSobrepartilha);
    }

    public boolean podeImprimirDARFDFE() {
        boolean retorno = true;
        for (Pendencia pendencia : FabricaUtilitarios.verificarPendencias((Object)((Object)this))) {
            if (pendencia.getSeveridade() <= 2) continue;
            retorno = false;
            break;
        }
        return retorno;
    }

    public EspolioPartilha getPartilhaSobrepartilhaMaisRecente() {
        String faseEspolio = this.obterFaseFinalEspolio();
        EspolioPartilha partilhaSobrepartilha = null;
        if ("0".equals(faseEspolio)) {
            partilhaSobrepartilha = this.getPartilha();
        } else if ("1".equals(faseEspolio)) {
            partilhaSobrepartilha = this.getSobrepartilha();
        } else if ("3".equals(faseEspolio)) {
            Data dataMaisRecentePartilha = this.getPartilha().isJudicial() ? this.getPartilha().getDecisaoJudicial().getDtTransito() : this.getPartilha().getEscrituracaoPublica().getDataLavratura();
            Data dataMaisRecenteSobrepartilha = this.getPartilha().isJudicial() ? this.getSobrepartilha().getDecisaoJudicial().getDtTransito() : this.getSobrepartilha().getEscrituracaoPublica().getDataLavratura();
            partilhaSobrepartilha = dataMaisRecentePartilha.maisNova(dataMaisRecenteSobrepartilha) ? this.getPartilha() : this.getSobrepartilha();
        }
        return partilhaSobrepartilha;
    }

    public boolean isPartilhaSobrepartilhaJudicial() {
        return this.getPartilhaSobrepartilhaMaisRecente().isJudicial();
    }

    public Data obterPeriodoApuracaoDFEJudicial() {
        Data dataApuracao = null;
        EspolioPartilha partilha = this.getPartilhaSobrepartilhaMaisRecente();
        if (partilha.isJudicial()) {
            dataApuracao = partilha.getDecisaoJudicial().getDtDecisaoJud();
        }
        return dataApuracao;
    }

    public Data obterTransitoJulgadoDFEJudicial() {
        Data dataApuracao = null;
        EspolioPartilha partilha = this.getPartilhaSobrepartilhaMaisRecente();
        if (partilha.isJudicial()) {
            dataApuracao = partilha.getDecisaoJudicial().getDtTransito();
        }
        return dataApuracao;
    }

    public String obterDataVencimentoDFE() throws AplicacaoException, BarramentoException {
        EspolioPartilha espolioPartilha = this.getPartilhaSobrepartilhaMaisRecente();
        Date periodoApuracao = espolioPartilha.getDecisaoJudicial().getDtDecisaoJud().asDate();
        Date transitoJulgado = espolioPartilha.getDecisaoJudicial().getDtTransito().asDate();
        String dataVencimentoDFE = BarramentoIRPFService.obterDataVencimentoDFE((String)((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado(), (Date)periodoApuracao, (Date)transitoJulgado);
        return dataVencimentoDFE.substring(6) + "/" + dataVencimentoDFE.substring(4, 6) + "/" + dataVencimentoDFE.substring(0, 4);
    }
}

