/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacaodeclaracao;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemLimiteDeducaoIncentivo;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorDoacoesIdoso
extends ValidadorDefault {
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private Valor imposto;
    private Valor totDoacoes = new Valor();
    private Valor limite = new Valor();
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public ValidadorDoacoesIdoso(DeclaracaoIRPF dec) {
        super((byte)3);
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public RetornoValidacao validarImplementado() {
        ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = null;
        String proximoConteudo = this.getInformacao().naoFormatado();
        if (proximoConteudo.indexOf(" ") != -1) {
            proximoConteudo = "0,00";
        }
        if (proximoConteudo != null && !proximoConteudo.trim().isEmpty() && !proximoConteudo.equals("0,00")) {
            String msg = null;
            this.totDoacoes.setConteudo(((DeclaracaoIRPF)((Object)this.weakDec.get())).getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto());
            this.imposto = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getModeloCompleta().getImposto();
            if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getColecaoEstatutoIdoso().getValorDisponivelDoacao().comparacao("<", "0,00")) {
                lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo((DeclaracaoIRPF)((DeclaracaoIRPF)((Object)this.weakDec.get())), (Valor)this.imposto);
                this.limite.setConteudo(this.totDoacoes);
                this.limite.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getColecaoEstatutoIdoso().getValorDisponivelDoacao());
                if (this.limite.comparacao("<", "0,00")) {
                    this.limite.clear();
                }
                Valor valorIncentivoMaisDesporto = new Valor();
                valorIncentivoMaisDesporto.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor());
                valorIncentivoMaisDesporto.append('+', TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncDesporto.getValor());
                String mensagem = MensagemUtil.getMensagem("doacoes_idoso_pendencia_excede_limite_doacao", new String[]{TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncECA.getValor().formatado(), TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor().formatado(), valorIncentivoMaisDesporto.formatado()});
                msg = "<html>" + mensagem + "</html>";
            }
            if (msg != null && !"".equals(msg)) {
                RetornoValidacao retorno = new RetornoValidacao(msg);
                return retorno;
            }
        }
        return null;
    }
}

