/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informerendimentos;

import java.util.List;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;

public class ItemPagamento
extends ObjetoNegocio {
    private Alfa codigo = new Alfa((ObjetoNegocio)this, "C\u00f3digo do Pagamento");
    private CPF cpfBeneficiario = new CPF((ObjetoNegocio)this, "CPF do benefici\u00e1rio");
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do benefici\u00e1rio", 60);
    private NI niPrestadorServico = new NI((ObjetoNegocio)this, "CPF ou CNPJ do prestador do servi\u00e7o");
    private Alfa nomePrestadorServico = new Alfa((ObjetoNegocio)this, "Nome do prestador do servi\u00e7o", 60);
    private ValorPositivo valorPago = new ValorPositivo(this, "Valor Pago");
    private ValorPositivo valorReembolsado = new ValorPositivo(this, "Valor reembolsado");
    private ValorPositivo valorContribuicaoPatrocinador = new ValorPositivo(this, "Valor Pago");
    private ValorPositivo valorDecimoTerceiro = new ValorPositivo(this, "Valor D\u00e9cimo Terceiro");
    private Alfa tipoResidencia = new Alfa((ObjetoNegocio)this, "Tipo de Resid\u00eancia (Brasil ou Exterior)", 1);
    private Alfa tipoPensaoAlimenticia = new Alfa((ObjetoNegocio)this, "Tipo de Pens\u00e3o Aliment\u00edcia", 1);
    private Alfa tipoBeneficiario = new Alfa((ObjetoNegocio)this, "Tipo de beneficiario", 1);
    private CPF cpfBeneficiarioSelecionado = new CPF((ObjetoNegocio)this, "CPF do beneficiario selecionado");
    private Alfa nomeBeneficiarioSelecionado = new Alfa((ObjetoNegocio)this, "Nome do beneficiario selecionado", 1);
    private boolean importar = true;
    public static final String TIPO_PENSAO_ALIMENTICIA_JUDICIAL = "1";
    public static final String TIPO_PENSAO_ALIMENTICIA_SEPARACAO_DIVORCIO = "2";
    public static final String TIPO_BENEFICIARIO_TITULAR = "1";
    public static final String TIPO_BENEFICIARIO_DEPENDENTE = "2";
    public static final String TIPO_BENEFICIARIO_ALIMENTANDO = "3";
    public static final int PAGAMENTO_PREVIPRIVADA = 1;
    public static final int PAGAMENTO_FAPI = 2;
    public static final int PAGAMENTO_FUNPRESP = 3;

    public Alfa getCodigo() {
        return this.codigo;
    }

    public CPF getCpfBeneficiario() {
        return this.cpfBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public NI getNiPrestadorServico() {
        return this.niPrestadorServico;
    }

    public Alfa getNomePrestadorServico() {
        return this.nomePrestadorServico;
    }

    public ValorPositivo getValorPago() {
        return this.valorPago;
    }

    public ValorPositivo getValorReembolsado() {
        return this.valorReembolsado;
    }

    public Alfa getTipoResidencia() {
        return this.tipoResidencia;
    }

    public Alfa getTipoPensaoAlimenticia() {
        return this.tipoPensaoAlimenticia;
    }

    public ValorPositivo getValorContribuicaoPatrocinador() {
        return this.valorContribuicaoPatrocinador;
    }

    public ValorPositivo getValorDecimoTerceiro() {
        return this.valorDecimoTerceiro;
    }

    public String obterCodigoMaisDescricaoPagamento(String cod) {
        Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoPagamentos());
        codigo.setConteudo(cod);
        return codigo.getConteudoAtual(1);
    }

    public String obterCodigoMaisDescricaoPagamentoPrevidencia() {
        return this.obterCodigoMaisDescricaoPagamento(this.obterCodigoPagamentoPrevidencia());
    }

    public String obterCodigoPagamentoPrevidencia() {
        int codigo = -1;
        try {
            codigo = Integer.parseInt(this.getCodigo().naoFormatado());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (codigo) {
            case 1: {
                return "36";
            }
            case 3: {
                return "37";
            }
            case 2: {
                return "36";
            }
        }
        return null;
    }

    public boolean isImportar() {
        return this.importar;
    }

    public void setImportar(boolean importar) {
        this.importar = importar;
    }

    public Alfa getTipoBeneficiario() {
        return this.tipoBeneficiario;
    }

    public CPF getCpfBeneficiarioSelecionado() {
        return this.cpfBeneficiarioSelecionado;
    }

    public Alfa getNomeBeneficiarioSelecionado() {
        return this.nomeBeneficiarioSelecionado;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = super.recuperarListaCamposPendencia();
        campos.add(this.codigo);
        campos.add(this.tipoBeneficiario);
        campos.add(this.nomeBeneficiarioSelecionado);
        return campos;
    }
}

