/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.anoanterior;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.declaracao.anoanterior.FiltroDeclaracaoAnoAnterior;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.PainelResultadoImportacao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProgressMonitor;
import serpro.ppgd.irpf.gui.util.ProgressUtil;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.PreferenciasGlobais;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class ProcessoImportacaoAnoAnterior {
    public static String obterDiretorioInicial() {
        Object dir = PreferenciasGlobais.get((String)ConstantesGlobaisIRPF.IRPF_PATH_TRANSMITIDAS_ANTERIOR);
        if (dir == null) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("windows") && !os.startsWith("windows 98") && !os.startsWith("windows vista")) {
                String arqProgramas = "C:\\Arquivos de Programas RFB";
                dir = arqProgramas + File.separator + "irpf" + ConstantesGlobais.EXERCICIO_ANTERIOR + File.separator + "transmitidas";
            } else {
                dir = System.getProperty("user.home") + File.separator + "ProgramasRFB" + File.separator + "IRPF" + ConstantesGlobais.EXERCICIO_ANTERIOR + File.separator + "transmitidas";
            }
        }
        return dir;
    }

    public File[] selecionarArquivoImportacao() {
        File[] arquivos = null;
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Importa\u00e7\u00e3o de dados da Declara\u00e7\u00e3o do IRPF " + ConstantesGlobais.EXERCICIO_ANTERIOR);
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText("Importa dados da declara\u00e7\u00e3o do IRPF " + ConstantesGlobais.EXERCICIO_ANTERIOR);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(new File(ProcessoImportacaoAnoAnterior.obterDiretorioInicial()));
        fc.setFileFilter((FileFilter)new FiltroDeclaracaoAnoAnterior());
        FileChooserResponse ret = fc.showOpenDialog((Component)ControladorGui.getJanelaPrincipal());
        if (ret == FileChooserResponse.APPROVE_OPTION) {
            arquivos = fc.getSelectedFiles();
        }
        return arquivos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importar(File[] arquivosImportados, final TipoDeclaracaoAES tipoDeclaracaoAES) {
        final StringBuffer arquivosComSucesso = new StringBuffer();
        final StringBuffer arquivosComErro = new StringBuffer();
        IdentificadorDeclaracao idDeclaracao = null;
        try {
            if (arquivosImportados != null) {
                final File[] selectedFiles = arquivosImportados;
                int retorno = 0;
                Object msgConfirmacao = null;
                int indexDecRepetida = this.contemDeclaracaoRepetida(selectedFiles);
                if (indexDecRepetida > -1) {
                    msgConfirmacao = "<html>Voc\u00ea selecionou duas declara\u00e7\u00f5es para o mesmo CPF ,<br>uma original e outra retificadora, e tem duas alternativas: <br><br>1) Cancelar a opera\u00e7\u00e3o, desmarcar a declara\u00e7\u00e3o original e manter a retificadora, por ser a \u00faltima <br>entregue (recomend\u00e1vel); OU<br><br>2) Continuar. Nesse caso, o programa importar\u00e1 a 1\u00aa declara\u00e7\u00e3o e logo em seguida, <br>na 2\u00aa importa\u00e7\u00e3o para o mesmo CPF, verificar\u00e1 que j\u00e1 existe declara\u00e7\u00e3o na base. <br>O aplicativo perguntar\u00e1 se deseja sobrepor os dados. O risco dessa op\u00e7\u00e3o \u00e9 <br>a declara\u00e7\u00e3o original ser a segunda e n\u00e3o ser recuperado o dado mais atualizado.</html>";
                    retorno = JOptionPane.showOptionDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msgConfirmacao, "Aten\u00e7\u00e3o", 0, 3, null, new Object[]{"Continuar", "Cancelar"}, "Continuar");
                }
                if (retorno == 0) {
                    final ArrayList<File> arquivosAImportar = new ArrayList<File>();
                    for (int i = 0; i < selectedFiles.length; ++i) {
                        try {
                            ImportadorTxt importador = new ImportadorTxt();
                            idDeclaracao = importador.restaurarIdDeclaracaoNaoPersistidoAnoAnterior(selectedFiles[i], false);
                            idDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracaoAES.getTipo());
                            if (importador.existeDeclaracaoExercicioAtual(selectedFiles[i], true, false)) {
                                msgConfirmacao = "<html>J\u00e1 existe declara\u00e7\u00e3o do exerc\u00edcio de " + ConstantesGlobais.EXERCICIO + " para o CPF " + idDeclaracao.getCpf().formatado() + " em sua base de dados.<br>Se importar os dados de " + ConstantesGlobais.EXERCICIO_ANTERIOR + ", as informa\u00e7\u00f5es existentes ser\u00e3o substitu\u00eddas<br>integralmente.<br><br>Deseja importar os dados da declara\u00e7\u00e3o de " + ConstantesGlobais.EXERCICIO_ANTERIOR + "?</html>";
                                if (JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msgConfirmacao, "Confirma\u00e7\u00e3o", 0, 3) != 0) continue;
                                arquivosAImportar.add(selectedFiles[i]);
                                ArrayList<IdentificadorDeclaracao> listaIds = new ArrayList<IdentificadorDeclaracao>(1);
                                listaIds.add(idDeclaracao);
                                ControladorGui.excluirDemonstrativo(listaIds);
                                continue;
                            }
                            arquivosAImportar.add(selectedFiles[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            arquivosComErro.append(selectedFiles[i].getName() + "\n");
                        }
                    }
                    IRPFFacade.setCacheIdDeclaracao(true);
                    new Thread(){

                        @Override
                        public void run() {
                            IdentificadorDeclaracao idDeclaracao = null;
                            int qtdTotal = arquivosAImportar.size();
                            ProgressMonitor monitor = ProgressUtil.createProgressMonitor((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (int)qtdTotal, (boolean)false, (int)1000, (String)"Importando");
                            monitor.start("Importando 1 de " + qtdTotal);
                            monitor.setCurrent("Importando 1 de " + qtdTotal, 1);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!arquivosAImportar.isEmpty()) {
                                int counter = 0;
                                for (File arquivoImportar : arquivosAImportar) {
                                    ++counter;
                                    try {
                                        ImportadorTxt importador = new ImportadorTxt();
                                        idDeclaracao = importador.restaurarIdDeclaracaoNaoPersistidoAnoAnterior(arquivoImportar, false);
                                        idDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracaoAES.getTipo());
                                        if (!TipoDeclaracaoAES.AJUSTE.getTipo().equals(tipoDeclaracaoAES.getTipo())) {
                                            idDeclaracao.getTipoDeclaracao().setConteudo("0");
                                        }
                                        if (importador.existeDeclaracaoExercicioAtual(arquivoImportar, true, false)) {
                                            ArrayList<IdentificadorDeclaracao> listaIds = new ArrayList<IdentificadorDeclaracao>(1);
                                            listaIds.add(idDeclaracao);
                                            ControladorGui.excluirDemonstrativo(listaIds);
                                        }
                                        if (counter > 1) {
                                            monitor.setCurrent("Importando " + counter + " de " + qtdTotal, counter);
                                        }
                                        boolean temRec = false;
                                        String nomeDec = arquivoImportar.toString();
                                        temRec = new File((nomeDec = nomeDec.substring(0, nomeDec.length() - ".DEC".length())) + ".REC").exists() || new File(nomeDec + ".rec").exists() || new File(nomeDec.substring(0, 8) + ".REC").exists() || new File(nomeDec.substring(0, 8) + ".rec").exists();
                                        idDeclaracao.getInNovaDeclaracao().setConteudo(Logico.NAO);
                                        IRPFFacade.criarDeclaracao(idDeclaracao);
                                        idDeclaracao = importador.importarDeclaracaoAnoAnterior(arquivoImportar, temRec, tipoDeclaracaoAES, false);
                                        arquivosComSucesso.append(arquivoImportar.getName() + "\n");
                                        DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDeclaracao.getCpf().naoFormatado(), "0000000000");
                                        CacheNI.getInstancia().importarNIs((ObjetoNegocio)dec, false);
                                    }
                                    catch (Exception e) {
                                        arquivosComErro.append(arquivoImportar.getName() + "\n");
                                        LogPPGD.erro((String)e.getMessage());
                                        if (idDeclaracao == null) continue;
                                        IRPFFacade.excluirDeclaracao(idDeclaracao);
                                    }
                                }
                            }
                            if (selectedFiles.length == 1) {
                                if (arquivosComErro.toString().isEmpty()) {
                                    if (arquivosAImportar.isEmpty()) {
                                        GuiUtil.mostrarInfo((String)"importar_ano_anterior_cancelado");
                                    } else {
                                        GuiUtil.mostrarInfo((String)"importar_ano_anterior_ok");
                                        try {
                                            ControladorGui.abrirDemonstrativo(idDeclaracao, (boolean)true);
                                        }
                                        catch (HashInvalidoException e) {
                                            ControladorGui.tratarException((Exception)((Object)e));
                                        }
                                    }
                                } else {
                                    GuiUtil.mostrarInfo((String)"importar_ano_anterior_erro");
                                }
                            } else if (arquivosAImportar.isEmpty()) {
                                GuiUtil.mostrarInfo((String)"importar_ano_anterior_cancelado");
                            } else {
                                PainelResultadoImportacao painelResultadoImportacaoAnoAnterior = new PainelResultadoImportacao();
                                if (arquivosComSucesso.toString().length() > 0) {
                                    painelResultadoImportacaoAnoAnterior.setListaDeclaracoesImportadasOK(arquivosComSucesso.toString());
                                }
                                if (arquivosComErro.toString().length() > 0) {
                                    painelResultadoImportacaoAnoAnterior.setListaDeclaracoesImportadasErro(arquivosComErro.toString());
                                }
                                GuiUtil.exibeDialog((JComponent)painelResultadoImportacaoAnoAnterior, (boolean)true, (String)MensagemUtil.getMensagem("importar_ano_anterior_titulo", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)}), (boolean)false, (int)460, (int)320);
                            }
                            if (monitor != null) {
                                monitor.setCurrent("Importando " + qtdTotal + " de " + qtdTotal, qtdTotal);
                            }
                            ControladorGui.atualizarNumeroDemonstrativos();
                        }
                    }.start();
                }
            }
        }
        catch (Exception e) {
            GuiUtil.mostrarInfo((String)"importar_ano_anterior_erro");
            ControladorGui.tratarException((Exception)e);
        }
        finally {
            IRPFFacade.setCacheIdDeclaracao(false);
        }
    }

    private int contemDeclaracaoRepetida(File[] selectedFiles) {
        int i;
        class ItemDec
        implements Comparable<ItemDec> {
            private String ni;

            public ItemDec(String aNi) {
                this.ni = aNi;
            }

            @Override
            public int compareTo(ItemDec outro) {
                int result = outro == null ? 1 : (Integer.parseInt(this.toString()) > Integer.parseInt(outro.toString()) ? 1 : (Integer.parseInt(this.toString()) < Integer.parseInt(outro.toString()) ? -1 : 0));
                return result;
            }

            public boolean equals(Object o) {
                boolean result;
                if (o == null || !(o instanceof ItemDec)) {
                    result = false;
                } else {
                    ItemDec outro = (ItemDec)o;
                    result = this.toString().equals(outro.toString());
                }
                return result;
            }

            public String toString() {
                return this.ni;
            }

            public int hashCode() {
                return this.toString().hashCode();
            }
        }
        HashSet<ItemDec> set = new HashSet<ItemDec>();
        boolean semDuplicatas = true;
        for (i = 0; i < selectedFiles.length && semDuplicatas; ++i) {
            semDuplicatas = set.add(new ItemDec(selectedFiles[i].getName().substring(0, 11)));
        }
        int result = -1;
        if (!semDuplicatas) {
            result = --i;
        }
        return result;
    }
}

