/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.negocio.Observador;

public class ObservadorAtualizadorRendimentos
extends Observador {
    private Bem bem = null;
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public ObservadorAtualizadorRendimentos(Bem bem, DeclaracaoIRPF dec) {
        this.bem = bem;
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if ("CNPJ do Fundo".equals(nomePropriedade) || "CPF/CNPJ da fonte pagadora".equals(nomePropriedade) || "CNPJ".equals(nomePropriedade) || "Titular ou dependente".equals(nomePropriedade) || "CPF do dependente".equals(nomePropriedade)) {
            String codigoRendimentoExclusivo;
            String codigoRendimentoIsento = this.bem.buscarTipoRendimentoIsento(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
            if (codigoRendimentoIsento != null) {
                ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().atualizarRendIsento(this.bem, codigoRendimentoIsento);
            }
            if ((codigoRendimentoExclusivo = this.bem.buscarTipoRendimentoExclusivo(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado())) != null) {
                ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendTributacaoExclusiva().atualizarRendExclusivo(this.bem, codigoRendimentoExclusivo);
            }
        }
    }
}

