/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.bens.ObservadorAtualizadorRendimentos;
import serpro.ppgd.irpf.bens.RendimentoAplicacoesFinanceiras;
import serpro.ppgd.irpf.bens.ValidadorNumeroProcessoLei14793;
import serpro.ppgd.irpf.gui.bens.PainelBensLista;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class Bens
extends Colecao<Bem>
implements ObjetoFicha {
    private Valor totalExercicioAnterior = new Valor((ObjetoNegocio)this, "Total exercicio Anterior");
    private Valor totalExercicioAtual = new Valor((ObjetoNegocio)this, "Total exercicio Atual");
    private transient IdentificadorDeclaracao idDec;
    private WeakReference<DeclaracaoIRPF> weakDec = null;
    private Alfa ultimoIndiceGerado = new Alfa();
    private Alfa totalItens = new Alfa();
    private Logico existeAtualizacaoValorBem = new Logico((ObjetoNegocio)this, "Houve atualiza\u00e7\u00e3o de algum bem de acordo com a Lei n\u00ba 14.973/2024?");
    private Alfa numeroProcessoAtualizacaoValorBem = new Alfa((ObjetoNegocio)this, "N\u00famero do Processo", 17);
    private static long geradorIndices = 1L;
    private Alfa bensSemValorDummy = new Alfa();
    private Alfa bensSemMarcacaoBemInventariar = new Alfa();
    private static String RENAVAM_CORROMPIDO = "0000000TRUE";

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (Bem bem : this.itens()) {
            String cpfBem = bem.getCPFBeneficiario().naoFormatado();
            if (!cpfBem.equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            Bem item = (Bem)it.next();
            if (!cpf.equals(item.getCPFBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public Bens(IdentificadorDeclaracao idDec, DeclaracaoIRPF dec) {
        this.idDec = idDec;
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Bens e Direitos");
        this.totalExercicioAnterior.setReadOnly(true);
        this.totalExercicioAtual.setReadOnly(true);
        this.existeAtualizacaoValorBem.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.existeAtualizacaoValorBem.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.bensSemValorDummy.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                boolean temValorInformado = false;
                for (Bem bem : Bens.this.itens()) {
                    if (bem.getValorExercicioAtual().isVazio()) continue;
                    temValorInformado = true;
                    break;
                }
                if (!Bens.this.itens().isEmpty() && !temValorInformado) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bens_sem_valor"), 2);
                }
                return null;
            }
        });
        this.bensSemMarcacaoBemInventariar.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                boolean bemInventariarMarcado = false;
                for (Bem bem : Bens.this.itens()) {
                    if (!bem.getIndicadorBemInventariar().naoFormatado().equals("1")) continue;
                    bemInventariarMarcado = true;
                    break;
                }
                if (((DeclaracaoIRPF)((Object)Bens.this.weakDec.get())).getEspolio().isBensInventariarMarcado() && !bemInventariarMarcado) {
                    return new RetornoValidacao(CadastroTabelasIRPF.recuperarMensagem(CodigoTabelaMensagens.CODIGO_00504), 3);
                }
                return null;
            }
        });
        this.numeroProcessoAtualizacaoValorBem.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bens.this.getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.numeroProcessoAtualizacaoValorBem.addValidador((ValidadorIf)new ValidadorNumeroProcessoLei14793(3, (DeclaracaoIRPF)((Object)this.weakDec.get())));
        this.existeAtualizacaoValorBem.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bens.this.existeAtualizacaoValorBem.naoFormatado().equals(Logico.SIM)) {
                    boolean existe = false;
                    for (Bem bem : Bens.this.itens()) {
                        if (!bem.getAtualizadoValorBem().naoFormatado().equals(Logico.SIM)) continue;
                        existe = true;
                        break;
                    }
                    if (!existe) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("sem_bem_com_atualizacao_valor"), 3);
                    }
                }
                return null;
            }
        });
    }

    public void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.naoFormatado().trim().equals("") ? 1L : Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        Object indiceSTR;
        long indiceGerado = 1L;
        do {
            ++geradorIndices;
            indiceSTR = "00000" + indiceGerado;
        } while (this.isIndiceUtilizado((String)(indiceSTR = ((String)indiceSTR).substring(((String)indiceSTR).length() - 5, ((String)indiceSTR).length()))));
        this.ultimoIndiceGerado.setConteudo((String)indiceSTR);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    private boolean isIndiceUtilizado(String indice) {
        boolean emUso = false;
        for (Bem bem : this.itens()) {
            if (!bem.getIndice().naoFormatado().equals(indice)) continue;
            emUso = true;
            break;
        }
        return emUso;
    }

    public void reordenaPorCodigo() {
        Collections.sort(this.itens(), new Comparator<Bem>(){

            @Override
            public int compare(Bem o1, Bem o2) {
                if (o1.getCodigo().asInteger() < o2.getCodigo().asInteger()) {
                    return -1;
                }
                if (o1.getCodigo().asInteger() > o2.getCodigo().asInteger()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public Bem instanciaNovoObjeto() {
        Bem bem = new Bem(this.idDec, (DeclaracaoIRPF)((Object)this.weakDec.get()));
        if (IRPFUtil.getEstadoSistema() != 3) {
            bem.getIndice().setConteudo(this.proximoIndice());
        }
        bem.getIndicadorReclassificar().setConteudo("0");
        return bem;
    }

    public void objetoInserido(Bem bem) {
        this.setFicha(this.getFicha());
        ObservadorAtualizadorRendimentos observadorAtualizadorRendimentos = new ObservadorAtualizadorRendimentos(bem, (DeclaracaoIRPF)((Object)this.weakDec.get()));
        bem.getTipo().addObservador((Observador)observadorAtualizadorRendimentos);
        bem.getCPFBeneficiario().addObservador((Observador)observadorAtualizadorRendimentos);
        bem.getNiEmpresa().addObservador((Observador)observadorAtualizadorRendimentos);
        Observador obsRecalcularLei14754 = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Bens.this.recalcularDemonstrativoAplicacoesFinanceirasExterior((DeclaracaoIRPF)((Object)Bens.this.weakDec.get()));
            }
        };
        bem.getLucroPrejuizo().addObservador(obsRecalcularLei14754);
        bem.getImpostoPagoExterior().addObservador(obsRecalcularLei14754);
        bem.getValorRecebido().addObservador(obsRecalcularLei14754);
        bem.getImpostoPagoExteriorIRRF().addObservador(obsRecalcularLei14754);
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            bem.getTipo().setConteudo("T");
        }
        this.totalItens.setConteudo(String.valueOf(this.itens().size()));
    }

    public void objetoRemovido(Object o) {
        this.recalcularDemonstrativoAplicacoesFinanceirasExterior((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public Valor getTotalExercicioAnterior() {
        return this.totalExercicioAnterior;
    }

    public Valor getTotalExercicioAtual() {
        return this.totalExercicioAtual;
    }

    public Logico getExisteAtualizacaoValorBem() {
        return this.existeAtualizacaoValorBem;
    }

    public Alfa getNumeroProcessoAtualizacaoValorBem() {
        return this.numeroProcessoAtualizacaoValorBem;
    }

    public boolean totalAlto() {
        return this.totalExercicioAtual.comparacao(">", "5.000.000,00");
    }

    public boolean existeBensComHerdeiro(String niHerdeiro) {
        for (Bem bem : this.itens()) {
            if (!bem.getParticipacoesInventario().existeHerdeiro(niHerdeiro)) continue;
            return true;
        }
        return false;
    }

    public void excluirBensComHerdeiro(String niHerdeiro) {
        for (Bem bem : this.itens()) {
            bem.getParticipacoesInventario().excluirHerdeiro(niHerdeiro);
        }
    }

    public void limparDependente(String cpfDependente) {
        for (Bem bem : this.itens()) {
            if (!bem.getCPFBeneficiario().naoFormatado().equals(cpfDependente)) continue;
            bem.getCPFBeneficiario().clear();
            bem.getTipo().clear();
        }
    }

    public void limparReferenciasInvalidasDependente(DeclaracaoIRPF dec) {
        for (Bem bem : this.itens()) {
            if (!bem.isBemComBeneficiario() || !"D".equals(bem.getTipo().naoFormatado()) || bem.getCPFBeneficiario().isVazio() || dec.getDependentes().isExisteCpf(bem.getCPFBeneficiario().naoFormatado())) continue;
            bem.getCPFBeneficiario().clear();
            bem.getTipo().clear();
        }
    }

    public void limparReferenciasInvalidasParticipacaoInventario(DeclaracaoIRPF dec) {
        Herdeiros colHerdeiros = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getHerdeiros();
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            for (Bem bem : this.itens()) {
                Iterator it = bem.getParticipacoesInventario().itens().iterator();
                while (it.hasNext()) {
                    ItemPercentualParticipacaoInventario item = (ItemPercentualParticipacaoInventario)((Object)it.next());
                    if (colHerdeiros.existeHerdeiro(item.getNi().naoFormatado())) continue;
                    it.remove();
                }
            }
        }
    }

    public Bem obterBemPorIndice(String indice) {
        Bem retorno = null;
        for (Bem bem : this.itens()) {
            if (!bem.getIndice().naoFormatado().equals(indice)) continue;
            retorno = bem;
            break;
        }
        return retorno;
    }

    public Bem obterBemPorDadosBancarios(String banco, String agencia, String conta, String dvConta) {
        Bem retorno = null;
        for (Bem bem : this.itens()) {
            if (!bem.getBanco().naoFormatado().equals(banco) || !bem.getAgencia().naoFormatado().equals(agencia) || !bem.getConta().naoFormatado().equals(conta) || !bem.getDVConta().naoFormatado().equals(dvConta)) continue;
            retorno = bem;
            break;
        }
        return retorno;
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Bens e Direitos";
    }

    public String getClasseFicha() {
        return PainelBensLista.class.getName();
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.bensSemValorDummy);
        retorno.add(this.bensSemMarcacaoBemInventariar);
        retorno.add(this.numeroProcessoAtualizacaoValorBem);
        retorno.add(this.existeAtualizacaoValorBem);
        return retorno;
    }

    public Alfa getBensSemValorDummy() {
        return this.bensSemValorDummy;
    }

    public Alfa getBensSemMarcacaoBemInventariar() {
        return this.bensSemMarcacaoBemInventariar;
    }

    public void reordenarBens() {
        Collections.sort(this.itens(), new Comparator<Bem>(){

            @Override
            public int compare(Bem b1, Bem b2) {
                String b1keyStr = b1.getCodigo().naoFormatado() + b1.getIndice().naoFormatado();
                String b2keyStr = b2.getCodigo().naoFormatado() + b2.getIndice().naoFormatado();
                int b1key = 0;
                int b2key = 0;
                try {
                    b1key = Integer.parseInt(b1keyStr);
                    b2key = Integer.parseInt(b2keyStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return b1key < b2key ? -1 : (b1key > b2key ? 1 : 0);
            }
        });
    }

    public void corrigirCorrupcaoRenavam(DeclaracaoIRPF decAberto, DeclaracaoIRPF decTransmitido) {
        for (Bem bem : this.itens()) {
            if (!"02".equals(bem.getGrupo().naoFormatado()) || !"01".equals(bem.getCodigo().naoFormatado()) || !RENAVAM_CORROMPIDO.equals(bem.getRegistroBem().naoFormatado().toUpperCase())) continue;
            Bem bemModelo = decTransmitido.getBens().obterBemPorIndice(bem.getIndice().naoFormatado());
            bem.getRegistroBem().setConteudo(bemModelo.getRegistroBem());
        }
    }

    public void recalcularDemonstrativoAplicacoesFinanceirasExterior(DeclaracaoIRPF dec) {
        ArrayList<RendimentoAplicacoesFinanceiras> aplicacoesFinanceiras = new ArrayList<RendimentoAplicacoesFinanceiras>();
        ArrayList<RendimentoAplicacoesFinanceiras> lucrosDividendos = new ArrayList<RendimentoAplicacoesFinanceiras>();
        Valor ganhoTotal = new Valor();
        Valor impostoPagoTotal = new Valor();
        Valor resultadoLiquido = new Valor();
        for (Bem bem : this.itens()) {
            RendimentoAplicacoesFinanceiras rendimento;
            Iterator chaveStr = "00000" + bem.getChave();
            chaveStr = ((String)((Object)chaveStr)).substring(((String)((Object)chaveStr)).length() - 5);
            if (!(!bem.isBemComAplicacaoFinanceira() || bem.getLucroPrejuizo().isVazio() && bem.getImpostoPagoExterior().isVazio())) {
                rendimento = new RendimentoAplicacoesFinanceiras();
                rendimento.getTipoRendimento().setConteudo("1");
                rendimento.getChaveBem().setConteudo(chaveStr);
                rendimento.getGanhoPrejuizo().setConteudo(bem.getLucroPrejuizo());
                rendimento.getImpostoPagoExterior().setConteudo((Valor)bem.getImpostoPagoExterior());
                rendimento.getGrupo().setConteudo(bem.getGrupo().getConteudoAtual(0));
                rendimento.getCodigo().setConteudo(bem.getCodigo().getConteudoAtual(0));
                aplicacoesFinanceiras.add(rendimento);
            }
            if (!(!bem.isBemComLucrosDividendos() || bem.getValorRecebido().isVazio() && bem.getImpostoPagoExteriorIRRF().isVazio())) {
                rendimento = new RendimentoAplicacoesFinanceiras();
                rendimento.getTipoRendimento().setConteudo("2");
                rendimento.getChaveBem().setConteudo(chaveStr);
                rendimento.getGanhoPrejuizo().setConteudo((Valor)bem.getValorRecebido());
                rendimento.getImpostoPagoExterior().setConteudo((Valor)bem.getImpostoPagoExteriorIRRF());
                rendimento.getGrupo().setConteudo(bem.getGrupo().getConteudoAtual(0));
                rendimento.getCodigo().setConteudo(bem.getCodigo().getConteudoAtual(0));
                lucrosDividendos.add(rendimento);
            }
            ganhoTotal.append('+', bem.getLucroPrejuizo());
            ganhoTotal.append('+', (Valor)bem.getValorRecebido());
            impostoPagoTotal.append('+', (Valor)bem.getImpostoPagoExterior());
            impostoPagoTotal.append('+', (Valor)bem.getImpostoPagoExteriorIRRF());
        }
        dec.getColecaoRendimentoAplicacoesFinanceiras().clear();
        dec.getColecaoRendimentoAplicacoesFinanceiras().itens().addAll(aplicacoesFinanceiras);
        dec.getColecaoRendimentoAplicacoesFinanceiras().itens().addAll(lucrosDividendos);
        int ordem = 0;
        Valor saldoAnterior = new Valor();
        saldoAnterior.setConteudo((Valor)dec.getContribuinte().getPrejuizoAnoAnteriorLei14754());
        for (RendimentoAplicacoesFinanceiras rendimento : dec.getColecaoRendimentoAplicacoesFinanceiras().itens()) {
            rendimento.getNumeroOrdem().setConteudo("" + ++ordem);
            if (rendimento.getGanhoPrejuizo().comparacao(">", "0,00")) {
                rendimento.getImpostoDevido().setConteudo(rendimento.getGanhoPrejuizo());
                rendimento.getImpostoDevido().append('*', "0,15");
                if (rendimento.getImpostoPagoExterior().comparacao(">", rendimento.getImpostoDevido())) {
                    rendimento.getBaseCalculo().clear();
                } else {
                    ValorPositivo baseCalculoParte1 = new ValorPositivo((ObjetoNegocio)this, "baseCalculoParte1", 11, 4);
                    ValorPositivo baseCalculoParte2 = new ValorPositivo((ObjetoNegocio)this, "baseCalculoParte2", 11, 4);
                    baseCalculoParte1.setConteudo(rendimento.getGanhoPrejuizo());
                    baseCalculoParte2.setConteudo(rendimento.getImpostoPagoExterior().formatado());
                    baseCalculoParte2.append('/', "0,15");
                    baseCalculoParte1.append('-', baseCalculoParte2.naoFormatado());
                    baseCalculoParte1.converteQtdCasasDecimais(2);
                    rendimento.getBaseCalculo().setConteudo((Valor)baseCalculoParte1);
                }
            } else {
                rendimento.getBaseCalculo().setConteudo(rendimento.getGanhoPrejuizo());
            }
            rendimento.getSaldo().setConteudo(rendimento.getBaseCalculo());
            rendimento.getSaldo().append('+', saldoAnterior);
            saldoAnterior.setConteudo(rendimento.getSaldo());
        }
        if (dec.getColecaoRendimentoAplicacoesFinanceiras().itens().isEmpty()) {
            dec.getContribuinte().getBaseCalculoFinalLei14754().clear();
            dec.getContribuinte().getImpostoDevidoLei14754().clear();
        } else {
            RendimentoAplicacoesFinanceiras rendimento = (RendimentoAplicacoesFinanceiras)((Object)dec.getColecaoRendimentoAplicacoesFinanceiras().itens().get(dec.getColecaoRendimentoAplicacoesFinanceiras().itens().size() - 1));
            dec.getContribuinte().getBaseCalculoFinalLei14754().setConteudo(rendimento.getSaldo());
            if (dec.getContribuinte().getBaseCalculoFinalLei14754().comparacao(">", "0,00")) {
                Valor impostoDevido = new Valor((ObjetoNegocio)this, "impostoDevido", 11, 4);
                impostoDevido.setConteudo(rendimento.getSaldo());
                impostoDevido.append('*', "0,15");
                impostoDevido.converteQtdCasasDecimais(2);
                dec.getContribuinte().getImpostoDevidoLei14754().setConteudo(impostoDevido);
            } else {
                dec.getContribuinte().getImpostoDevidoLei14754().clear();
            }
        }
        resultadoLiquido.setConteudo(ganhoTotal);
        resultadoLiquido.append('-', impostoPagoTotal);
        if (resultadoLiquido.comparacao(">", "0,00")) {
            dec.getRendTributacaoExclusiva().getLei14754().setConteudo(resultadoLiquido);
        } else {
            dec.getRendTributacaoExclusiva().getLei14754().clear();
        }
    }

    public Map<String, String> obterListaChavesRepetidas() {
        HashMap<String, String> chavesProcessadas = new HashMap<String, String>();
        HashMap<String, String> chavesRepetidas = new HashMap<String, String>();
        for (Bem bem : this.itens()) {
            if (chavesProcessadas.containsKey(bem.getIndice().naoFormatado())) {
                chavesRepetidas.put(bem.getIndice().naoFormatado(), bem.getIndice().naoFormatado());
                continue;
            }
            chavesProcessadas.put(bem.getIndice().naoFormatado(), bem.getIndice().naoFormatado());
        }
        if (chavesRepetidas.isEmpty()) {
            return null;
        }
        return chavesRepetidas;
    }
}

