/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.atividaderural.ValidadorCIB;
import serpro.ppgd.irpf.bens.ColecaoItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.bens.ProprietarioUsufrutuarioBem;
import serpro.ppgd.irpf.bens.ProprietariosUsufrutuariosBem;
import serpro.ppgd.irpf.bens.ValidadorDataAquisicao;
import serpro.ppgd.irpf.bens.ValidadorRenavam;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.bens.PainelBensLista;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.resumo.ValidadorDvContaCorrente;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class Bem
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    public static final String CODIGO_INDEFINIDO = "00";
    public static final String GRUPO_IMOVEIS = "01";
    public static final String GRUPO_MOVEIS = "02";
    public static final String GRUPO_PARTICIPACOES_SOCIETARIAS = "03";
    public static final String GRUPO_APLICACOES_INVESTIMENTOS = "04";
    public static final String GRUPO_CREDITOS = "05";
    public static final String GRUPO_DEPOSITOS_VISTA_NUMERARIO = "06";
    public static final String GRUPO_FUNDOS = "07";
    public static final String GRUPO_CRIPTOATIVOS = "08";
    public static final String GRUPO_OUTROS_BENS_DIREITOS = "99";
    public static final int GRUPO_IMOVEIS_INT = 1;
    public static final int GRUPO_MOVEIS_INT = 2;
    public static final int GRUPO_PARTICIPACOES_SOCIETARIAS_INT = 3;
    public static final int GRUPO_APLICACOES_INVESTIMENTOS_INT = 4;
    public static final int GRUPO_CREDITOS_INT = 5;
    public static final int GRUPO_DEPOSITOS_VISTA_NUMERARIO_INT = 6;
    public static final int GRUPO_FUNDOS_INT = 7;
    public static final int GRUPO_CRIPTOATIVOS_INT = 8;
    public static final int GRUPO_OUTROS_BENS_DIREITOS_INT = 99;
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    public static final String NOME_CAMPO_LOCAL_PAIS = "Localiza\u00e7\u00e3o(Pa\u00eds)";
    public static final String NOME_CAMPO_NOME_PAIS = "Nome Pa\u00eds";
    public static final String NOME_CAMPO_DISCRIMINACAO = "Discrimina\u00e7\u00e3o";
    public static final String NOME_CAMPO_LOGRADOURO = "Logradouro";
    public static final String NOME_CAMPO_NUMERO = "N\u00famero";
    public static final String NOME_CAMPO_COMPLEMENTO = "Complemento";
    public static final String NOME_CAMPO_BAIRRO = "Bairro";
    public static final String NOME_CAMPO_UF = "UF";
    public static final String NOME_CAMPO_MUNICIPIO = "Munic\u00edpio";
    public static final String NOME_CAMPO_NOME_MUNICIPIO = "Nome Munic\u00edpio";
    public static final String NOME_CAMPO_CIDADE = "Cidade";
    public static final String NOME_CAMPO_REGISTRADO = "Registrado";
    public static final String NOME_CAMPO_CEP = "CEP";
    public static final String NOME_CAMPO_MATRICULA = "Matr\u00edcula";
    public static final String NOME_CAMPO_REGISTRO = "Registro";
    public static final String NOME_CAMPO_AREA_TOTAL = "\u00c1rea Total";
    public static final String NOME_CAMPO_UNIDADE = "Unidade";
    public static final String NOME_CAMPO_NOME_CARTORIO = "Nome do Cart\u00f3rio";
    public static final String NOME_CAMPO_GRUPO = "Grupo";
    public static final String NOME_CAMPO_CODIGO = "C\u00f3digo";
    public static final String NOME_CAMPO_INDICE = "Indice";
    public static final String NOME_CAMPO_INDICE_ANTERIOR = "Indice Anterior";
    public static final String NOME_CAMPO_REGISTRO_BEM = "Registro do Bem";
    public static final String NOME_CAMPO_DATA_AQUISICAO = "Data de Aquisi\u00e7\u00e3o";
    public static final String NOME_CAMPO_CNPJ = "CNPJ";
    public static final String NOME_CAMPO_CNPJ_FUNDO = "CNPJ do Fundo";
    public static final String NOME_CAMPO_CNPJ_CUSTODIANTE = "CNPJ Custodiante";
    public static final String NOME_CAMPO_CPF_CNPJ = "CPF/CNPJ";
    public static final String NOME_CAMPO_NI_EMPRESA = "CPF/CNPJ da fonte pagadora";
    public static final String NOME_CAMPO_TIPO = "Titular ou dependente";
    public static final String NOME_CAMPO_CODIGO_ALTCOIN = "C\u00f3digo Altcoin";
    public static final String NOME_CAMPO_CODIGO_STABLECOIN = "C\u00f3digo Stablecoin";
    public static final String NOME_CAMPO_CPF_BENEFICIARIO = "CPF do dependente";
    public static final String NOME_CAMPO_REGISTRO_BEM_IPTU = "Inscri\u00e7\u00e3o Municipal (IPTU)";
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_IPTU = 30;
    public static final String NOME_CAMPO_REGISTRO_BEM_NIRF = "CIB (Nirf)";
    public static final String NOME_CAMPO_REGISTRO_BEM_CEICNO = "CEI/CNO";
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_NIRF = 8;
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_CEICNO = 12;
    public static final String NOME_CAMPO_REGISTRO_BEM_RENAVAM = "Renavam";
    public static final String NOME_CAMPO_REGISTRO_BEM_RENAVAM_EXTERIOR = "Registro de Ve\u00edculo";
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_RENAVAM = 11;
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_RENAVAM_EXTERIOR = 30;
    public static final String NOME_CAMPO_REGISTRO_BEM_REG_AVIACAO = "Registro de Aeronave";
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_REG_AVIACAO = 30;
    public static final String NOME_CAMPO_REGISTRO_BEM_REG_PORTOS = "Registro de Embarca\u00e7\u00e3o";
    public static final int TAMANHO_CAMPO_REGISTRO_BEM_REG_PORTOS = 30;
    public static final String NOME_PROPRIEDADE_TIPO_CONTA_CEF = "TipoContaCEF";
    public static final String NOME_PROPRIEDADE_TIPO_CONTA = "Tipo de Conta";
    public static final String BEM_INVENTARIAR_NAO_MARCADO = "0";
    public static final String BEM_INVENTARIAR_MARCADO = "1";
    public static final String AUTO_CUSTODIANTE_NAO = "0";
    public static final String AUTO_CUSTODIANTE_SIM = "1";
    public static final String BEM_COM_USUFRUTO_NAO_MARCADO = "0";
    public static final String BEM_COM_USUFRUTO_MARCADO = "1";
    public static final String CONTA_PAGAMENTO_NAO_MARCADO = "0";
    public static final String CONTA_PAGAMENTO_MARCADO = "1";
    public static final String CHAVE_BEM_VAZIA = "00000";
    private Codigo grupo = new Codigo((ObjetoNegocio)this, "Grupo", CadastroTabelasIRPF.recuperarGrupoBens());
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBens(this.grupo.naoFormatado()));
    private Codigo pais = new Codigo((ObjetoNegocio)this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises());
    private Alfa nomePais = new Alfa((ObjetoNegocio)this, "Nome Pa\u00eds", 200);
    private Alfa discriminacao = new Alfa(this, "Discrimina\u00e7\u00e3o", 512){

        public void setConteudo(String conteudo) {
            if (conteudo != null) {
                conteudo = conteudo.replaceAll("[^(\\w|\\s|[\u00c7\u00e7\u00a2\u00c9\u00c8\u00ca\u00cb\u00e9\u00e8\u00ea\u00eb\u00c1\u00c0\u00c2\u00c3\u00c4\u00c5\u00c6\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u00e6\u00aa\u00d3\u00d2\u00d4\u00d5\u00d6\u00f3\u00f2\u00f4\u00f5\u00f6\u00ba\u00cd\u00cc\u00ce\u00cf\u00ed\u00ec\u00ee\u00ef\u00da\u00d9\u00db\u00dc\u00fa\u00f9\u00fb\u00fc\u00dd\u00ff\u00fd\u00d1\u00f1]|[\\\\\\{\\}\\[\\]\\(\\)\\|\\/\\-\\=\\$\\%\\&\\-\\,\\.\\!\\#\\*\\:\\;\\+\\<\\>\\?\\@\\_\\\"\\']|[\n\t])]", " ").trim();
            }
            super.setConteudo(conteudo);
        }
    };
    private ValorPositivo valorExercicioAnterior = new ValorPositivo(this, "Situa\u00e7\u00e3o Valor Anterior");
    private transient ValorPositivo valorExercicioAnteriorAssociadoJButton = new ValorPositivo(this, "gambiarra");
    private ValorPositivo valorExercicioAtual = new ValorPositivo(this, "Situa\u00e7\u00e3o Valor Atual");
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa numero = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa complemento = new Alfa((ObjetoNegocio)this, "Complemento", 40);
    private Alfa bairro = new Alfa((ObjetoNegocio)this, "Bairro", 40);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa nomeMunicipio = new Alfa((ObjetoNegocio)this, "Nome Munic\u00edpio", 200);
    private Alfa cidade = new Alfa((ObjetoNegocio)this, "Cidade", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private Alfa registrado = new Alfa((ObjetoNegocio)this, "Registrado", 1);
    private Alfa matricula = new Alfa((ObjetoNegocio)this, "Matr\u00edcula", 40);
    private Valor areaTotal = new Valor((ObjetoNegocio)this, "\u00c1rea Total");
    private Alfa unidade = new Alfa((ObjetoNegocio)this, "Unidade", 1);
    private Alfa nomeCartorio = new Alfa((ObjetoNegocio)this, "Nome do Cart\u00f3rio", 60);
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");
    private Alfa indiceAnterior = new Alfa((ObjetoNegocio)this, "Indice Anterior");
    private Alfa registroBem = new Alfa((ObjetoNegocio)this, "Registro do Bem", 30);
    private Data dataAquisicao = new Data((ObjetoNegocio)this, "Data de Aquisi\u00e7\u00e3o");
    private ColecaoItemPercentualParticipacaoInventario participacoesInventario = new ColecaoItemPercentualParticipacaoInventario();
    private NI niEmpresa = new NI((ObjetoNegocio)this, "CPF/CNPJ da fonte pagadora");
    private Codigo agencia = new Codigo((ObjetoNegocio)this, "Ag\u00eancia", null);
    private Alfa conta = new Alfa((ObjetoNegocio)this, "Conta");
    private Alfa dvConta = new Alfa((ObjetoNegocio)this, "D\u00edgito verificador");
    private Codigo banco = new Codigo((ObjetoNegocio)this, "Banco", CadastroTabelasIRPF.recuperarBancosBens());
    private Alfa operacao = new Alfa((ObjetoNegocio)this, "Opera\u00e7\u00e3o");
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Titular ou dependente");
    private CPF cpfBeneficiario = new CPF((ObjetoNegocio)this, "CPF do dependente");
    private Alfa indicadorBemInventariar = new Alfa((ObjetoNegocio)this, "Bem a inventariar");
    private Alfa negociadoBolsa = new Alfa((ObjetoNegocio)this, "Negociados em Bolsa", 1);
    private Alfa codigoNegociacao = new Alfa((ObjetoNegocio)this, "C\u00f3digo de Negocia\u00e7\u00e3o", 13);
    private Alfa indicadorAutoCustodiante = new Alfa((ObjetoNegocio)this, "\u00c9 autocustodiante?");
    private Codigo codigoAltcoin = new Codigo((ObjetoNegocio)this, "C\u00f3digo Altcoin", CadastroTabelasIRPF.recuperarAlticoins());
    private Codigo codigoStablecoin = new Codigo((ObjetoNegocio)this, "C\u00f3digo Stablecoin", CadastroTabelasIRPF.recuperarStablecoins());
    private Valor lucroPrejuizo = new Valor((ObjetoNegocio)this, "Lucro ou preju\u00edzo");
    private ValorPositivo impostoPagoExterior = new ValorPositivo(this, "Imposto pago exterior");
    private ValorPositivo valorRecebido = new ValorPositivo(this, "Valor recebido");
    private ValorPositivo impostoPagoExteriorIRRF = new ValorPositivo(this, "Imposto pago exterior IRRF");
    private Alfa indicadorBemComUsufruto = new Alfa((ObjetoNegocio)this, "Bem com usufruto?");
    private Alfa indicadorProprietarioUsufrutuario = new Alfa((ObjetoNegocio)this, "Propriet\u00e1rio ou usufrutu\u00e1rio");
    private ProprietariosUsufrutuariosBem proprietariosUsufrutuariosBem = new ProprietariosUsufrutuariosBem();
    private Logico atualizadoValorBem = new Logico((ObjetoNegocio)this, "Houve atualiza\u00e7\u00e3o no valor do bem de acordo com a Lei n\u00ba 14.973/2024?");
    private Alfa indicadorContaPagamento = new Alfa((ObjetoNegocio)this, "Esta \u00e9 uma conta pagamento?");
    private Alfa indicadorReclassificar = new Alfa((ObjetoNegocio)this, "indicador se houve reclassifica\u00e7\u00e3o?");
    public static final String RECLASSIFICAR_NAO = "0";
    public static final String RECLASSIFICAR = "1";
    public static final String RECLASSIFICADO = "2";
    private String chave = null;
    public static final String IMOVEL_REGISTRADO_SIM = "1";
    public static final String IMOVEL_REGISTRADO_NAO = "0";
    public static final String IMOVEL_REGISTRADO_VAZIO = "2";
    public static final String UNIDADE_M2 = "0";
    public static final String UNIDADE_HA = "1";
    public static final String UNIDADE_VAZIO = "2";
    public static final String CONTA_CORRENTE = "0";
    public static final String CONTA_POUPANCA = "1";
    public static final String TIPO_TITULAR = "T";
    public static final String TIPO_DEPENDENTE = "D";
    public static final String TIPO_PADRAO = "";
    public static final String NEGOCIADO_BOLSA_SIM = "1";
    public static final String NEGOCIADO_BOLSA_NAO = "0";
    public static final String NEGOCIADO_BOLSA_VAZIO = "2";
    public static final String CRIPTOMOEDA_ALTCOIN = "02";
    public static final String CRIPTOMOEDA_STABLECOIN = "03";
    public static final String CRIPTOMOEDA_NFT = "10";
    public static final String NAO_POSSUI = "0";
    public static final String PROPRIETARIO = "1";
    public static final String USUFRUTUARIO = "2";
    private transient IdentificadorDeclaracao id = null;
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public Alfa getRegistroBem() {
        return this.registroBem;
    }

    public void setRegistroBem(Alfa registroBem) {
        this.registroBem = registroBem;
    }

    public final Data getDataAquisicao() {
        return this.dataAquisicao;
    }

    public void setDataAquisicao(Data dataAquisicao) {
        this.dataAquisicao = dataAquisicao;
    }

    public Codigo getBanco() {
        return this.banco;
    }

    public Codigo getAgencia() {
        return this.agencia;
    }

    public Alfa getConta() {
        return this.conta;
    }

    public Alfa getDVConta() {
        return this.dvConta;
    }

    public Alfa getOperacao() {
        return this.operacao;
    }

    public Bem(IdentificadorDeclaracao idDec, DeclaracaoIRPF dec) {
        this.id = idDec;
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.atualizadoValorBem.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.atualizadoValorBem.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getAreaTotal().setMaximoDigitosParteInteira(10);
        this.getAreaTotal().converteQtdCasasDecimais(1);
        this.getUnidade().setConteudo("2");
        this.getRegistrado().setConteudo("2");
        this.getCodigo().setColunaFiltro(1);
        this.getUf().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        this.getGrupo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getGrupo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("bem_codigo_branco_invalido")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.this.getIndicadorReclassificar().naoFormatado().equals("1")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_precisa_reclassificar"), 3);
                }
                return super.validarImplementado();
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("bem_codigo_branco_invalido")));
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("bem_discriminacao_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao ret = super.validarImplementado();
                this.setMensagemValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}));
                if (ret != null && ret.getSeveridade() != 0 && !Bem.this.id.isEspolio() && Bem.GRUPO_IMOVEIS.equals(Bem.this.getGrupo().naoFormatado()) && (Bem.this.getCodigo().naoFormatado().equals(Bem.GRUPO_IMOVEIS) || Bem.this.getCodigo().naoFormatado().equals("02") || Bem.this.getCodigo().naoFormatado().equals("03") || Bem.this.getCodigo().naoFormatado().equals("11") || Bem.this.getCodigo().naoFormatado().equals("12") || Bem.this.getCodigo().naoFormatado().equals("13") || Bem.this.getCodigo().naoFormatado().equals("14") || Bem.this.getCodigo().naoFormatado().equals("15") || Bem.this.getCodigo().naoFormatado().equals("16") || Bem.this.getCodigo().naoFormatado().equals("17") || Bem.this.getCodigo().naoFormatado().equals("18") || Bem.this.getCodigo().naoFormatado().equals("19")) && (!Bem.this.getLogradouro().isVazio() || !Bem.this.getNumero().isVazio() || !Bem.this.getComplemento().isVazio() || !Bem.this.getCep().isVazio() || !Bem.this.getBairro().isVazio() || !Bem.this.getMatricula().isVazio() || !Bem.this.getNomeCartorio().isVazio() || !Bem.this.getAreaTotal().isVazio() || !Bem.this.getUnidade().naoFormatado().equals("2") || !Bem.this.getUf().isVazio())) {
                    ret = null;
                }
                return ret;
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getPais().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.getPais().formatado().equals("105") ? Bem.this.getCodigo().getConteudoAtual(0).equals("62") : Bem.this.getCodigo().getConteudoAtual(0).equals("61")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_pais_incompativel"), 3);
                }
                return null;
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("bem_pais_branco")));
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Bem.this.getNomePais().setConteudo(Bem.this.getPais().getConteudoAtual(1));
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.getPais().naoFormatado().equals("105") && !Bem.this.getIndicadorReclassificar().naoFormatado().equals("1") && Bem.isBemApenasExterior(Bem.this.getGrupo().naoFormatado(), Bem.this.getCodigo().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_brasil_nao_permitido"), 3);
                }
                return null;
            }
        });
        if (this.getPais().isVazio()) {
            this.getPais().setConteudo("105");
        }
        this.getMunicipio().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals(Bem.NOME_CAMPO_MUNICIPIO) && Bem.this.municipio.getIndiceElementoTabela() > -1) {
                    List municipios = Bem.this.municipio.getColecaoElementoTabela();
                    ElementoTabela oMunicipio = (ElementoTabela)municipios.get(Bem.this.municipio.getIndiceElementoTabela());
                    Bem.this.nomeMunicipio.setConteudo(oMunicipio.getConteudo(1));
                }
            }
        });
        this.getRegistroBem().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("bem_discriminacao_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao ret = super.validarImplementado();
                this.setMensagemValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}));
                if ("02".equals(Bem.this.getGrupo().naoFormatado()) && Bem.this.getCodigo().naoFormatado().equals(Bem.GRUPO_IMOVEIS) && Bem.this.getPais().naoFormatado().equals("105")) {
                    return ret;
                }
                return null;
            }
        });
        this.getRegistroBem().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2, MensagemUtil.getMensagem("bem_discriminacao_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}));
                if ("02".equals(Bem.this.getGrupo().naoFormatado()) && (Bem.this.getCodigo().naoFormatado().equals("02") || Bem.this.getCodigo().naoFormatado().equals("03")) && Bem.this.getPais().naoFormatado().equals("105")) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getRegistroBem().addValidador((ValidadorIf)new ValidadorRenavam(3, this.id, this));
        this.getRegistroBem().addValidador((ValidadorIf)new ValidadorCIB(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.GRUPO_IMOVEIS.equals(Bem.this.getGrupo().naoFormatado()) && Bem.this.getCodigo().naoFormatado().equals("14") && Bem.this.getPais().naoFormatado().equals("105")) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("bem_nirf_invalido"));
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getRegistroBem().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals(Bem.this.getRegistroBem().getNomeCampo()) && "02".equals(Bem.this.getGrupo().naoFormatado()) && Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && valorNovo.toString().trim().length() < 11 && valorNovo.toString().trim().length() > 0 && !Bem.NOME_CAMPO_REGISTRO_BEM_RENAVAM.equals(valorNovo.toString())) {
                    String renavam = "00000000000" + valorNovo.toString().trim();
                    Bem.this.getRegistroBem().setConteudo(renavam.substring(renavam.length() - 11));
                }
            }
        });
        this.getDataAquisicao().addValidador((ValidadorIf)new ValidadorDataAquisicao(3));
        final ValidadorCNPJ validadorCnpj = new ValidadorCNPJ(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.isBemComNI()) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{Bem.this.tituloCampoNI()}));
                    return super.validarImplementado();
                }
                return null;
            }
        };
        final ValidadorNI validadorNI = new ValidadorNI(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.isBemComNI()) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{Bem.this.tituloCampoNI()}));
                    return super.validarImplementado();
                }
                return null;
            }
        };
        this.getNiEmpresa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.this.isBemComNI() && Bem.this.getNiEmpresa().isVazio()) {
                    int grupoInt = -1;
                    try {
                        grupoInt = Integer.parseInt(Bem.this.getGrupo().naoFormatado());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    switch (grupoInt) {
                        case 3: {
                            if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                            break;
                        }
                        case 4: {
                            if (Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) || "02".equals(Bem.this.getCodigo().naoFormatado())) {
                                super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                                break;
                            }
                            if (!Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            return null;
                        }
                        case 5: {
                            if (!Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                            break;
                        }
                        case 6: {
                            if (!Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                            break;
                        }
                        case 7: {
                            if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !"03".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                            break;
                        }
                        case 99: {
                            if (!Bem.GRUPO_CREDITOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_FUNDOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                            super.setMensagemValidacao(MensagemUtil.getMensagem("bem_cnpj_branco"));
                        }
                    }
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNiEmpresa().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                int grupoInt = -1;
                try {
                    grupoInt = Integer.parseInt(Bem.this.getGrupo().naoFormatado());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                switch (grupoInt) {
                    case 3: {
                        if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !"03".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                        break;
                    }
                    case 4: {
                        if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !"03".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                        break;
                    }
                    case 5: {
                        if (!Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorNI);
                        break;
                    }
                    case 6: {
                        if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                        break;
                    }
                    case 7: {
                        if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !"03".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_APLICACOES_INVESTIMENTOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_CREDITOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_FUNDOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_CRIPTOATIVOS.equals(Bem.this.getCodigo().naoFormatado()) && !"09".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.CRIPTOMOEDA_NFT.equals(Bem.this.getCodigo().naoFormatado()) && !"11".equals(Bem.this.getCodigo().naoFormatado()) && !"12".equals(Bem.this.getCodigo().naoFormatado()) && !"13".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_OUTROS_BENS_DIREITOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                        break;
                    }
                    case 8: {
                        if (!Bem.GRUPO_IMOVEIS.equals(Bem.this.getCodigo().naoFormatado()) && !"02".equals(Bem.this.getCodigo().naoFormatado()) && !"03".equals(Bem.this.getCodigo().naoFormatado()) && !Bem.CRIPTOMOEDA_NFT.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                        break;
                    }
                    case 99: {
                        if (!Bem.GRUPO_CREDITOS.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(Bem.this.getCodigo().naoFormatado()) && !Bem.GRUPO_FUNDOS.equals(Bem.this.getCodigo().naoFormatado())) break;
                        Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorCnpj);
                    }
                }
                if (Bem.GRUPO_CREDITOS.equals(Bem.this.getGrupo().naoFormatado()) && (Bem.this.getCodigo().naoFormatado().equals(Bem.GRUPO_IMOVEIS) || Bem.this.getCodigo().naoFormatado().equals("02"))) {
                    Bem.this.getNiEmpresa().addValidador((ValidadorIf)validadorNI);
                }
                Bem.this.getNiEmpresa().validar();
            }
        });
        this.getBanco().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComDadosBancarios() ? super.validarImplementado() : null;
            }
        });
        this.getAgencia().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComDadosBancarios() && "105".equals(Bem.this.pais.toString()) ? super.validarImplementado() : null;
            }
        });
        this.getConta().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComDadosBancarios() && "105".equals(Bem.this.pais.toString()) ? super.validarImplementado() : null;
            }
        });
        this.getDVConta().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComDadosBancarios() && "105".equals(Bem.this.pais.toString()) ? super.validarImplementado() : null;
            }
        });
        this.getDVConta().addValidador((ValidadorIf)new ValidadorDvContaCorrente(2, this.getBanco(), this.getAgencia(), this.getConta(), this.getDVConta(), this.getGrupo(), this.getCodigo(), this.getIndicadorContaPagamento()){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComDadosBancarios() ? super.validarImplementado() : null;
            }
        });
        this.getTipo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComBeneficiario() ? super.validarImplementado() : null;
            }
        });
        this.getCPFBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                return Bem.this.isBemComBeneficiario() && Bem.TIPO_DEPENDENTE.equals(Bem.this.getTipo().naoFormatado()) ? super.validarImplementado() : null;
            }
        });
        this.getIndice().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                String cnpjRendimento;
                String codigoRendimento = Bem.this.buscarTipoRendimentoIsento(Bem.this.getGrupo().naoFormatado(), Bem.this.getCodigo().naoFormatado());
                ItemQuadroAuxiliarAb rendimento = Bem.this.buscarRendimentoIsentoAssociado(codigoRendimento, (DeclaracaoIRPF)((Object)Bem.this.weakDec.get()));
                String cnpjBem = Bem.this.getNiEmpresa().formatado();
                if (rendimento != null && !cnpjBem.equals(cnpjRendimento = rendimento.getNIFontePagadora().formatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_ni_diferente_bem_associado", new String[]{cnpjBem, cnpjRendimento}));
                }
                codigoRendimento = Bem.this.buscarTipoRendimentoExclusivo(Bem.this.getGrupo().naoFormatado(), Bem.this.getCodigo().naoFormatado());
                rendimento = Bem.this.buscarRendimentoExclusivoAssociado(codigoRendimento, (DeclaracaoIRPF)((Object)Bem.this.weakDec.get()));
                if (rendimento != null && !cnpjBem.equals(cnpjRendimento = rendimento.getNIFontePagadora().formatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_ni_diferente_bem_associado", new String[]{cnpjBem, cnpjRendimento}));
                }
                return null;
            }
        });
        this.getUf().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Bem.this.uf.isVazio() || Bem.this.uf.naoFormatado().equals("EX")) {
                    Bem.this.municipio.setColecaoElementoTabela(new ArrayList());
                } else {
                    String strUf = Bem.this.uf.getConteudoAtual(0);
                    Bem.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipios(strUf, 1));
                }
            }
        });
        this.getGrupo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Bem.this.grupo.naoFormatado().isEmpty()) {
                    Bem.this.codigo.setColecaoElementoTabela(new ArrayList());
                } else {
                    Bem.this.codigo.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarTipoBens(Bem.this.grupo.naoFormatado()));
                }
            }
        });
        this.getCodigo().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Bem.this.habilitaCamposBemImovel();
                Bem.this.habilitaCamposLocalizacaoImovel();
            }
        });
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Bem.this.habilitaCamposLocalizacaoImovel();
            }
        });
        this.getRegistrado().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Bem.this.habilitaCamposRegistroImovel();
            }
        });
        if (this.id.isEspolio()) {
            this.getValorExercicioAnteriorAssociadoJButton().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!(Bem.this.valorExercicioAnterior.isVazio() && Bem.this.valorExercicioAtual.isVazio() || !Bem.this.participacoesInventario.itens().isEmpty() || !Bem.this.indicadorBemInventariar.naoFormatado().equals("0") && !Bem.this.indicadorBemInventariar.isVazio())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("bem_participacao_nao_informada"), this.getSeveridade());
                    }
                    if (!Bem.this.participacoesInventario.itens().isEmpty() && Bem.this.participacoesInventario.getTotais().comparacao("!=", new Valor(Long.valueOf(100L)))) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("bem_percentual_total_diferente_100"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.getValorExercicioAnteriorAssociadoJButton().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    Iterator it = Bem.this.participacoesInventario.itens().iterator();
                    int indice = 1;
                    while (it.hasNext()) {
                        ItemPercentualParticipacaoInventario item = (ItemPercentualParticipacaoInventario)((Object)it.next());
                        if (item.getNi().isVazio()) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("cpf_cnpj_branco") + " - Item " + indice, this.getSeveridade());
                        }
                        ++indice;
                    }
                    return null;
                }
            });
            this.getValorExercicioAtual().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2, MensagemUtil.getMensagem("bem_ausencia_valor_transferencia")){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!Bem.this.isBemInventariarMarcado()) {
                        return super.validarImplementado();
                    }
                    return null;
                }
            });
        }
        this.getNegociadoBolsa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.isBemNegociadoBolsa(Bem.this.getGrupo().naoFormatado(), Bem.this.getCodigo().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCodigoNegociacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.isBemNegociadoBolsa(Bem.this.getGrupo().naoFormatado(), Bem.this.getCodigo().naoFormatado()) && Bem.this.getNegociadoBolsa().naoFormatado().equals("1")) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCodigoAltcoin().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.GRUPO_CRIPTOATIVOS.equals(Bem.this.getGrupo().naoFormatado()) && "02".equals(Bem.this.getCodigo().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCodigoStablecoin().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.GRUPO_CRIPTOATIVOS.equals(Bem.this.getGrupo().naoFormatado()) && "03".equals(Bem.this.getCodigo().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getIndicadorAutoCustodiante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Bem.GRUPO_CRIPTOATIVOS.equals(Bem.this.getGrupo().naoFormatado()) && (Bem.this.getCodigo().naoFormatado().equals(Bem.GRUPO_IMOVEIS) || Bem.this.getCodigo().naoFormatado().equals("02") || Bem.this.getCodigo().naoFormatado().equals("03"))) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.habilitaCamposBemImovel();
        this.habilitaCamposLocalizacaoImovel();
    }

    public static String obterTipoContaBem(String indicadorContaPagamento, String grupoBem, String codigoBem) {
        if ("1".equals(indicadorContaPagamento)) {
            return "3";
        }
        if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupoBem) && GRUPO_IMOVEIS.equals(codigoBem)) {
            return "2";
        }
        if (GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(grupoBem) && GRUPO_IMOVEIS.equals(codigoBem)) {
            return "1";
        }
        return TIPO_PADRAO;
    }

    public static String obterDescricaoTipoContaBem(String indicadorContaPagamento, String grupoBem, String codigoBem) {
        Codigo tipoConta = new Codigo(null, NOME_PROPRIEDADE_TIPO_CONTA, CadastroTabelasIRPF.recuperarTipoConta());
        tipoConta.setConteudo(Bem.obterTipoContaBem(indicadorContaPagamento, grupoBem, codigoBem));
        return tipoConta.getConteudoAtual(1);
    }

    protected void habilitaCamposLocalizacaoImovel() {
        boolean localizacaoExterior;
        boolean bemImovel = this.isBemImovel();
        boolean localizacaoBrasil = bemImovel && this.getPais().naoFormatado().equals("105");
        boolean bl = localizacaoExterior = bemImovel && !this.getPais().naoFormatado().equals("105");
        if (!localizacaoBrasil) {
            this.getUf().clear();
            this.getMunicipio().clear();
            this.getCep().clear();
        }
        if (!localizacaoExterior) {
            this.getCidade().clear();
        }
    }

    protected void habilitaCamposRegistroImovel() {
        if (!this.isBemImovelRegistravel()) {
            this.getMatricula().clear();
            this.getUnidade().setConteudo("2");
            this.getNomeCartorio().clear();
        } else if (this.isBemImovelRegistravel() && !this.getRegistrado().naoFormatado().equals("1") && this.getPais().naoFormatado().equals("105")) {
            this.getMatricula().clear();
            this.getNomeCartorio().clear();
        }
    }

    protected void habilitaCamposBemImovel() {
        if (!this.isBemImovel()) {
            this.getLogradouro().clear();
            this.getNumero().clear();
            this.getComplemento().clear();
            this.getBairro().clear();
        }
        if (!this.isBemImovelRegistravel()) {
            this.getRegistrado().setConteudo("2");
        }
    }

    public boolean isBemImovel() {
        return Bem.isBemImovel(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemImovel(String grupo, String codBem) {
        return GRUPO_IMOVEIS.equals(grupo) && !codBem.isEmpty() && !codBem.equals("-1");
    }

    public boolean isBemFundosInvestimentos() {
        return Bem.isBemFundosInvestimentos(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemFundosInvestimentos(String grupo, String codBem) {
        return GRUPO_FUNDOS.equals(grupo) && !codBem.isEmpty() && !codBem.equals("-1");
    }

    public boolean isBemRegistravel() {
        boolean localizacaoBrasil = this.getPais().naoFormatado().equals("105");
        return Bem.isBemRegistravel(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado(), localizacaoBrasil);
    }

    public static boolean isBemRegistravel(String grupo, String codigo, boolean localizacaoBrasil) {
        String[] codBens = new String[]{GRUPO_IMOVEIS, "02", "03"};
        for (int i = 0; i < codBens.length; ++i) {
            if (!"02".equals(grupo) || !codigo.equals(codBens[i])) continue;
            return true;
        }
        if (GRUPO_IMOVEIS.equals(grupo) && codigo.equals("16") && localizacaoBrasil) {
            return true;
        }
        return Bem.isBemImovelRegistravel(grupo, codigo) && localizacaoBrasil;
    }

    public boolean isPermitidoArtigo8Lei14754(String pais, String grupo, String codigo) {
        boolean retorno = false;
        if (!("105".equals(pais) || codigo.isEmpty() || "-1".equals(codigo))) {
            int grupoInt = -1;
            try {
                grupoInt = Integer.parseInt(grupo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (grupoInt) {
                case 3: {
                    retorno = true;
                    break;
                }
                case 4: {
                    if (!codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                    break;
                }
                case 7: {
                    if (!codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                    break;
                }
                case 99: {
                    if (!codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public boolean isPermitidoArtigo14Lei14754(String pais, String grupo, String codigo) {
        boolean retorno = false;
        if (!("105".equals(pais) || codigo.isEmpty() || "-1".equals(codigo))) {
            int grupoInt = -1;
            try {
                grupoInt = Integer.parseInt(grupo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (grupoInt) {
                case 1: {
                    retorno = true;
                    break;
                }
                case 2: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                    break;
                }
                case 3: {
                    retorno = true;
                    break;
                }
                case 4: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                    break;
                }
                case 5: {
                    retorno = true;
                    break;
                }
                case 6: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                    break;
                }
                case 7: {
                    retorno = true;
                    break;
                }
                case 8: {
                    retorno = true;
                    break;
                }
                case 99: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public boolean isBemComNI() {
        boolean localizacaoBrasil = this.getPais().naoFormatado().equals("105");
        return Bem.isBemComNI(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado(), localizacaoBrasil, this.getIndicadorAutoCustodiante().naoFormatado());
    }

    public static boolean isBemComNI(String grupo, String codigo, boolean localizacaoBrasil, String autoCustodiante) {
        if (localizacaoBrasil && !Bem.isBemApenasExterior(grupo, codigo)) {
            int grupoInt = -1;
            try {
                grupoInt = Integer.parseInt(grupo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (grupoInt) {
                case 3: {
                    return true;
                }
                case 4: {
                    if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 7: {
                    if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_CRIPTOATIVOS) && !codigo.equals("09") && !codigo.equals(CRIPTOMOEDA_NFT) && !codigo.equals("12") && !codigo.equals("13") && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 8: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(CRIPTOMOEDA_NFT) || !autoCustodiante.equals("0")) break;
                    return true;
                }
                case 99: {
                    if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBemComDadosBancarios() {
        return Bem.isBemComDadosBancarios(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemComDadosBancarios(String grupo, String codigo) {
        if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupo) && codigo.equals(GRUPO_IMOVEIS)) {
            return true;
        }
        return GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(grupo) && codigo.equals(GRUPO_IMOVEIS);
    }

    public boolean isBemNegociadoBolsa() {
        return Bem.isBemNegociadoBolsa(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemNegociadoBolsa(String grupo, String codigo) {
        if ("03".equals(grupo) && codigo.equals(GRUPO_IMOVEIS)) {
            return true;
        }
        if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupo) && codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS)) {
            return true;
        }
        return GRUPO_FUNDOS.equals(grupo) && (codigo.equals("02") || codigo.equals("03") || codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS) || codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) || codigo.equals(GRUPO_FUNDOS) || codigo.equals(GRUPO_CRIPTOATIVOS) || codigo.equals("09") || codigo.equals(CRIPTOMOEDA_NFT) || codigo.equals("12") || codigo.equals("13") || codigo.equals(GRUPO_OUTROS_BENS_DIREITOS));
    }

    public boolean isCriptoativos() {
        return Bem.isCriptoativos(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isCriptoativos(String grupo, String codigo) {
        return GRUPO_CRIPTOATIVOS.equals(grupo) && (codigo.equals(GRUPO_IMOVEIS) || codigo.equals("02") || codigo.equals("03") || codigo.equals(CRIPTOMOEDA_NFT));
    }

    public boolean isBemComBeneficiario() {
        return Bem.isBemComBeneficiario(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemComBeneficiario(String grupo, String codigo) {
        int grupoInt = -1;
        try {
            grupoInt = Integer.parseInt(grupo);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (grupoInt) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 99: {
                if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_CRIPTOATIVOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                return true;
            }
        }
        return false;
    }

    public boolean isBemComAplicacaoFinanceira() {
        boolean localizacaoExterior = !this.getPais().naoFormatado().equals("105");
        return Bem.isBemComAplicacaoFinanceira(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado(), localizacaoExterior);
    }

    public static boolean isBemComAplicacaoFinanceira(String grupo, String codigo, boolean localizacaoExterior) {
        if (localizacaoExterior) {
            int grupoInt = -1;
            try {
                grupoInt = Integer.parseInt(grupo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (grupoInt) {
                case 3: {
                    return true;
                }
                case 4: {
                    if (!codigo.equals("02") && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 7: {
                    if (!codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 8: {
                    return true;
                }
                case 99: {
                    if (!codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_CRIPTOATIVOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBemComLucrosDividendos() {
        boolean localizacaoExterior = !this.getPais().naoFormatado().equals("105");
        return Bem.isBemComLucrosDividendos(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado(), localizacaoExterior);
    }

    public static boolean isBemComLucrosDividendos(String grupo, String codigo, boolean localizacaoExterior) {
        if (localizacaoExterior) {
            int grupoInt = -1;
            try {
                grupoInt = Integer.parseInt(grupo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (grupoInt) {
                case 3: {
                    return true;
                }
                case 4: {
                    if (!codigo.equals("02") && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 5: {
                    return true;
                }
                case 7: {
                    if (!codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
                case 8: {
                    return true;
                }
                case 99: {
                    if (!codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_CRIPTOATIVOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static int tamanhoCampoRegistro(String grupo, String codigo, boolean localizacaoBrasil) {
        String[] codBens = new String[]{GRUPO_IMOVEIS, "02", "03", "11", "12", "13", "15", "18", GRUPO_OUTROS_BENS_DIREITOS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_IMOVEIS.equals(grupo) || !codigo.equals(codBens[i])) continue;
            return 30;
        }
        if (GRUPO_IMOVEIS.equals(grupo) && codigo.equals("14")) {
            return 8;
        }
        if (GRUPO_IMOVEIS.equals(grupo) && codigo.equals("16")) {
            return 12;
        }
        if ("02".equals(grupo) && codigo.equals(GRUPO_IMOVEIS)) {
            if (localizacaoBrasil) {
                return 11;
            }
            return 30;
        }
        if ("02".equals(grupo) && codigo.equals("02")) {
            return 30;
        }
        if ("02".equals(grupo) && codigo.equals("03")) {
            return 30;
        }
        return 30;
    }

    public String tituloCampoRegistro() {
        boolean localizacaoBrasil = this.getPais().naoFormatado().equals("105");
        return Bem.tituloCampoRegistro(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado(), localizacaoBrasil);
    }

    public static String tituloCampoRegistro(String grupo, String codigo, boolean localizacaoBrasil) {
        String[] codBens = new String[]{GRUPO_IMOVEIS, "02", "03", "11", "12", "13", "15", "18", "19", GRUPO_OUTROS_BENS_DIREITOS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_IMOVEIS.equals(grupo) || !codigo.equals(codBens[i])) continue;
            return NOME_CAMPO_REGISTRO_BEM_IPTU;
        }
        if (GRUPO_IMOVEIS.equals(grupo)) {
            if (codigo.equals("14")) {
                return NOME_CAMPO_REGISTRO_BEM_NIRF;
            }
            if (codigo.equals("16")) {
                return NOME_CAMPO_REGISTRO_BEM_CEICNO;
            }
        }
        if ("02".equals(grupo) && codigo.equals(GRUPO_IMOVEIS)) {
            if (localizacaoBrasil) {
                return NOME_CAMPO_REGISTRO_BEM_RENAVAM;
            }
            return NOME_CAMPO_REGISTRO_BEM_RENAVAM_EXTERIOR;
        }
        if ("02".equals(grupo) && codigo.equals("02")) {
            return NOME_CAMPO_REGISTRO_BEM_REG_AVIACAO;
        }
        if ("02".equals(grupo) && codigo.equals("03")) {
            return NOME_CAMPO_REGISTRO_BEM_REG_PORTOS;
        }
        return TIPO_PADRAO;
    }

    public boolean possuiDadosContaPoupanca() {
        String[] codBens = new String[]{GRUPO_IMOVEIS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_APLICACOES_INVESTIMENTOS.equals(this.getGrupo().naoFormatado()) || !this.getCodigo().naoFormatado().equals(codBens[i])) continue;
            return true;
        }
        return false;
    }

    public boolean possuiDadosContaCorrente() {
        String[] codBens = new String[]{GRUPO_IMOVEIS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(this.getGrupo().naoFormatado()) || !this.getCodigo().naoFormatado().equals(codBens[i])) continue;
            return true;
        }
        return false;
    }

    public boolean possuiValorIPTU() {
        String[] codBens = new String[]{GRUPO_IMOVEIS, "02", "03", "11", "12", "13", "15", "18", "19", GRUPO_OUTROS_BENS_DIREITOS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_IMOVEIS.equals(this.getGrupo().naoFormatado()) || !this.getCodigo().naoFormatado().equals(codBens[i])) continue;
            return true;
        }
        return false;
    }

    public boolean possuiValorCIB() {
        return GRUPO_IMOVEIS.equals(this.getGrupo().naoFormatado()) && this.getCodigo().naoFormatado().equals("14");
    }

    public boolean possuiValorRENAVAM() {
        return "02".equals(this.getGrupo().naoFormatado()) && this.getCodigo().naoFormatado().equals(GRUPO_IMOVEIS);
    }

    public boolean possuiValorRegistroAviacao() {
        return "02".equals(this.getGrupo().naoFormatado()) && this.getCodigo().naoFormatado().equals("02");
    }

    public boolean possuiValorRegistroPortos() {
        return "02".equals(this.getGrupo().naoFormatado()) && this.getCodigo().naoFormatado().equals("03");
    }

    public String getValorIPTU() {
        String[] codBens = new String[]{GRUPO_IMOVEIS, "02", "03", "11", "12", "13", "15", "18", "19", GRUPO_OUTROS_BENS_DIREITOS};
        for (int i = 0; i < codBens.length; ++i) {
            if (!GRUPO_IMOVEIS.equals(this.getGrupo().naoFormatado()) || !this.getCodigo().naoFormatado().equals(codBens[i])) continue;
            return this.getRegistroBem().naoFormatado();
        }
        return null;
    }

    public String getValorCIB() {
        return GRUPO_IMOVEIS.equals(this.grupo.naoFormatado()) && this.getCodigo().naoFormatado().equals("14") ? this.getRegistroBem().naoFormatado() : null;
    }

    public String getValorRENAVAM() {
        return "02".equals(this.grupo.naoFormatado()) && this.getCodigo().naoFormatado().equals(GRUPO_IMOVEIS) ? this.getRegistroBem().naoFormatado() : null;
    }

    public String getValorRegistroAviacao() {
        return "02".equals(this.grupo.naoFormatado()) && this.getCodigo().naoFormatado().equals("02") ? this.getRegistroBem().naoFormatado() : null;
    }

    public String getValorRegistroPortos() {
        return "02".equals(this.grupo.naoFormatado()) && this.getCodigo().naoFormatado().equals("03") ? this.getRegistroBem().naoFormatado() : null;
    }

    public String tituloCampoNI() {
        return Bem.tituloCampoNI(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static String tituloCampoNI(String grupo, String codigo) {
        int grupoInt = -1;
        try {
            grupoInt = Integer.parseInt(grupo);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (grupoInt) {
            case 3: {
                if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                return NOME_CAMPO_CNPJ;
            }
            case 4: {
                if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                return NOME_CAMPO_CNPJ;
            }
            case 5: {
                return NOME_CAMPO_CPF_CNPJ;
            }
            case 6: {
                if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals(CRIPTOMOEDA_NFT) && !codigo.equals("11") && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                return NOME_CAMPO_CNPJ;
            }
            case 7: {
                return NOME_CAMPO_CNPJ_FUNDO;
            }
            case 8: {
                if (!codigo.equals(GRUPO_IMOVEIS) && !codigo.equals("02") && !codigo.equals("03") && !codigo.equals(CRIPTOMOEDA_NFT)) break;
                return NOME_CAMPO_CNPJ_CUSTODIANTE;
            }
            case 99: {
                if (!codigo.isEmpty() && !codigo.equals("-1") && !codigo.equals(CODIGO_INDEFINIDO) && !codigo.equals(GRUPO_CREDITOS) && !codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) && !codigo.equals(GRUPO_FUNDOS) && !codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) break;
                return NOME_CAMPO_CNPJ;
            }
        }
        return TIPO_PADRAO;
    }

    public boolean isBemImovelRegistravel() {
        return Bem.isBemImovelRegistravel(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
    }

    public static boolean isBemImovelRegistravel(String grupo, String codigo) {
        String[] codBensImoveis = new String[]{GRUPO_IMOVEIS, "02", "03", "11", "12", "13", "14", "15", "18", "19", GRUPO_OUTROS_BENS_DIREITOS};
        for (int i = 0; i < codBensImoveis.length; ++i) {
            if (!GRUPO_IMOVEIS.equals(grupo) || !codigo.equals(codBensImoveis[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isImovelEmConstrucaoNoBrasil(String grupo, String codigo, String pais) {
        return GRUPO_IMOVEIS.equals(grupo) && codigo.equals("16") && pais.equals("105");
    }

    public boolean isImovelImovelRuralNoBrasil(String grupo, String codigo, String pais) {
        return GRUPO_IMOVEIS.equals(grupo) && codigo.equals("14") && pais.equals("105");
    }

    public boolean isBemInventariarMarcado() {
        return this.indicadorBemInventariar.naoFormatado().equals("1");
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals(NOME_CAMPO_INDICE) || informacao.getNomeCampo().equals(NOME_CAMPO_LOCAL_PAIS) || informacao.getNomeCampo().equals(NOME_CAMPO_NOME_PAIS) || informacao.getNomeCampo().equals(NOME_CAMPO_REGISTRADO) && informacao.formatado().equals("2") || informacao.getNomeCampo().equals(NOME_CAMPO_UNIDADE) && informacao.formatado().equals("2")) continue;
            return false;
        }
        return true;
    }

    public Codigo getGrupo() {
        return this.grupo;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.codigo);
        retorno.add(this.pais);
        if (!this.id.isEspolio()) {
            retorno.add(this.tipo);
            retorno.add(this.cpfBeneficiario);
        }
        this.registroBem.setNomeCampo(Bem.tituloCampoRegistro(this.grupo.naoFormatado(), this.codigo.naoFormatado(), this.pais.formatado().equals("105")));
        retorno.add(this.registroBem);
        retorno.add(this.dataAquisicao);
        retorno.add(this.discriminacao);
        retorno.add(this.valorExercicioAtual);
        retorno.add(this.valorExercicioAnterior);
        retorno.add(this.valorExercicioAnteriorAssociadoJButton);
        retorno.add(this.logradouro);
        retorno.add(this.numero);
        retorno.add(this.complemento);
        retorno.add(this.bairro);
        retorno.add(this.uf);
        retorno.add(this.municipio);
        retorno.add(this.cep);
        retorno.add(this.cidade);
        retorno.add(this.registrado);
        retorno.add(this.matricula);
        retorno.add(this.areaTotal);
        retorno.add(this.nomeCartorio);
        retorno.add(this.unidade);
        if ("105".equals(this.pais.toString())) {
            retorno.add(this.banco);
            retorno.add(this.agencia);
            retorno.add(this.conta);
            retorno.add(this.dvConta);
        }
        this.niEmpresa.setNomeCampo(Bem.tituloCampoNI(this.grupo.naoFormatado(), this.codigo.naoFormatado()));
        retorno.add(this.niEmpresa);
        retorno.add(this.indice);
        retorno.add(this.negociadoBolsa);
        retorno.add(this.codigoNegociacao);
        retorno.add(this.codigoAltcoin);
        retorno.add(this.codigoStablecoin);
        retorno.add(this.indicadorAutoCustodiante);
        return retorno;
    }

    public String getContaFormatadaTxt() throws AplicacaoException {
        if (!this.getBanco().isVazio() && this.getBanco().naoFormatado().equals("104")) {
            Integer tamanhoConta = this.temOperacao() ? Integer.valueOf(8) : Integer.valueOf(12);
            String strConta = this.getConta().isVazio() ? " ".repeat(tamanhoConta) : IRPFUtil.formatarZerosEsquerda(this.getConta().naoFormatado().trim(), tamanhoConta);
            String strOperacao = this.getOperacao().isVazio() ? "   " : IRPFUtil.formatarZerosEsquerda(this.getOperacao().naoFormatado().trim(), 3);
            return strOperacao + strConta;
        }
        return this.getConta().naoFormatado().trim();
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia p = new Pendencia(2, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), MensagemUtil.getMensagem("bem_valor_nao_informado"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            retorno.add(p);
        } else if (this.id.isEspolio() && !this.isBemInventariarMarcado() && this.getValorExercicioAtual().isVazio() != this.getValorExercicioAnterior().isVazio()) {
            Pendencia p = new Pendencia(3, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), MensagemUtil.getMensagem("bem_ambos_valores_preenchidos"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            retorno.add(p);
        }
        return retorno;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public int compareTo(Object o) {
        Bem bem = (Bem)o;
        int cod = bem.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public Alfa getIndiceAnterior() {
        return this.indiceAnterior;
    }

    public Alfa getNomePais() {
        return this.nomePais;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Alfa getRegistrado() {
        return this.registrado;
    }

    public Alfa getMatricula() {
        return this.matricula;
    }

    public Alfa getUnidade() {
        return this.unidade;
    }

    public Alfa getNomeCartorio() {
        return this.nomeCartorio;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Valor getAreaTotal() {
        return this.areaTotal;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public NI getNiEmpresa() {
        return this.niEmpresa;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public CPF getCPFBeneficiario() {
        return this.cpfBeneficiario;
    }

    public String getClasseFicha() {
        return PainelBensLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public ColecaoItemPercentualParticipacaoInventario getParticipacoesInventario() {
        return this.participacoesInventario;
    }

    public ValorPositivo getValorExercicioAnteriorAssociadoJButton() {
        return this.valorExercicioAnteriorAssociadoJButton;
    }

    public void setValorExercicioAnteriorAssociadoJButton(ValorPositivo valorExercicioAnteriorAssociadoJButton) {
        this.valorExercicioAnteriorAssociadoJButton = valorExercicioAnteriorAssociadoJButton;
    }

    public String getTituloFichaDashboard() {
        return "Bens e Direitos";
    }

    public Alfa getIndicadorBemInventariar() {
        return this.indicadorBemInventariar;
    }

    public Bem obterCopia() {
        ObjetoNegocio novo;
        Bem copia = new Bem(IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao(), (DeclaracaoIRPF)((Object)this.weakDec.get()));
        copia.getGrupo().setConteudo(this.getGrupo());
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getPais().setConteudo(this.getPais());
        copia.getNomePais().setConteudo(this.getNomePais());
        copia.getDiscriminacao().setConteudo(this.getDiscriminacao());
        copia.getValorExercicioAnterior().setConteudo(this.getValorExercicioAnterior());
        copia.getValorExercicioAnteriorAssociadoJButton().setConteudo(this.getValorExercicioAnteriorAssociadoJButton());
        copia.getValorExercicioAtual().setConteudo(this.getValorExercicioAtual());
        copia.getLogradouro().setConteudo(this.getLogradouro());
        copia.getNumero().setConteudo(this.getNumero());
        copia.getComplemento().setConteudo(this.getComplemento());
        copia.getBairro().setConteudo(this.getBairro());
        copia.getUf().setConteudo(this.getUf());
        copia.getMunicipio().setConteudo(this.getMunicipio());
        copia.getNomeMunicipio().setConteudo(this.getNomeMunicipio());
        copia.getCidade().setConteudo(this.getCidade());
        copia.getCep().setConteudo(this.getCep());
        copia.getRegistrado().setConteudo(this.getRegistrado());
        copia.getMatricula().setConteudo(this.getMatricula());
        copia.getAreaTotal().setConteudo(this.getAreaTotal());
        copia.getUnidade().setConteudo(this.getUnidade());
        copia.getNomeCartorio().setConteudo(this.getNomeCartorio());
        copia.getIndice().setConteudo(this.getIndice());
        copia.getRegistroBem().setConteudo(this.getRegistroBem());
        copia.getDataAquisicao().setConteudo(this.getDataAquisicao());
        copia.getNiEmpresa().setConteudo(this.getNiEmpresa());
        copia.getAgencia().setConteudo(this.getAgencia());
        copia.getConta().setConteudo(this.getConta());
        copia.getDVConta().setConteudo(this.getDVConta());
        copia.getBanco().setConteudo(this.getBanco());
        copia.getOperacao().setConteudo(this.getOperacao());
        copia.getTipo().setConteudo(this.getTipo());
        copia.getCPFBeneficiario().setConteudo(this.getCPFBeneficiario());
        copia.getIndicadorBemInventariar().setConteudo(this.getIndicadorBemInventariar());
        copia.getNegociadoBolsa().setConteudo(this.getNegociadoBolsa());
        copia.getCodigoNegociacao().setConteudo(this.getCodigoNegociacao());
        copia.getIndicadorAutoCustodiante().setConteudo(this.getIndicadorAutoCustodiante());
        copia.getCodigoAltcoin().setConteudo(this.getCodigoAltcoin());
        copia.getCodigoStablecoin().setConteudo(this.getCodigoStablecoin());
        copia.getLucroPrejuizo().setConteudo(this.getLucroPrejuizo());
        copia.getImpostoPagoExterior().setConteudo(this.getImpostoPagoExterior());
        copia.getValorRecebido().setConteudo(this.getValorRecebido());
        copia.getImpostoPagoExteriorIRRF().setConteudo(this.getImpostoPagoExteriorIRRF());
        copia.getIndicadorBemComUsufruto().setConteudo(this.getIndicadorBemComUsufruto());
        copia.getIndicadorProprietarioUsufrutuario().setConteudo(this.getIndicadorProprietarioUsufrutuario());
        copia.getIndicadorContaPagamento().setConteudo(this.getIndicadorContaPagamento());
        copia.getIndicadorReclassificar().setConteudo(this.getIndicadorReclassificar());
        for (ObjetoNegocio item : this.getParticipacoesInventario().itens()) {
            novo = new ItemPercentualParticipacaoInventario();
            novo.getNi().setConteudo(item.getNi());
            novo.getNome().setConteudo(item.getNome());
            novo.getPercentual().setConteudo(item.getPercentual());
            copia.getParticipacoesInventario().add(novo);
        }
        for (ObjetoNegocio item : this.getProprietariosUsufrutuariosBem().itens()) {
            novo = new ProprietarioUsufrutuarioBem();
            novo.getNi().setConteudo(item.getNi());
            copia.getProprietariosUsufrutuariosBem().add(novo);
        }
        return copia;
    }

    public boolean temOperacao() {
        if ("104".equals(this.banco.naoFormatado())) {
            return !this.operacao.isVazio();
        }
        return false;
    }

    public Alfa getNegociadoBolsa() {
        return this.negociadoBolsa;
    }

    public Alfa getCodigoNegociacao() {
        return this.codigoNegociacao;
    }

    public Alfa getIndicadorAutoCustodiante() {
        return this.indicadorAutoCustodiante;
    }

    public Codigo getCodigoAltcoin() {
        return this.codigoAltcoin;
    }

    public Codigo getCodigoStablecoin() {
        return this.codigoStablecoin;
    }

    public Valor getLucroPrejuizo() {
        return this.lucroPrejuizo;
    }

    public ValorPositivo getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public ValorPositivo getValorRecebido() {
        return this.valorRecebido;
    }

    public ValorPositivo getImpostoPagoExteriorIRRF() {
        return this.impostoPagoExteriorIRRF;
    }

    public Alfa getIndicadorBemComUsufruto() {
        return this.indicadorBemComUsufruto;
    }

    public Alfa getIndicadorProprietarioUsufrutuario() {
        return this.indicadorProprietarioUsufrutuario;
    }

    public ProprietariosUsufrutuariosBem getProprietariosUsufrutuariosBem() {
        return this.proprietariosUsufrutuariosBem;
    }

    public Logico getAtualizadoValorBem() {
        return this.atualizadoValorBem;
    }

    public Alfa getIndicadorContaPagamento() {
        return this.indicadorContaPagamento;
    }

    public void atualizarBemAnoAnterior() {
        if (AplicacaoPropertiesUtil.getExercicioAsInt() == 2022) {
            boolean alterado = false;
            String codigoOriginal = this.getCodigo().naoFormatado();
            int codigo = -1;
            try {
                codigo = Integer.parseInt(this.getCodigo().naoFormatado());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (codigo != -1) {
                switch (codigo) {
                    case 26: {
                        this.getGrupo().setConteudo("02");
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 47: {
                        this.getGrupo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                        this.getCodigo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                        alterado = true;
                        break;
                    }
                    case 53: {
                        this.getGrupo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 54: {
                        this.getGrupo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 62: {
                        this.getGrupo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                        this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                        alterado = true;
                        break;
                    }
                    case 71: {
                        this.getGrupo().setConteudo(GRUPO_FUNDOS);
                        this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                        alterado = true;
                        break;
                    }
                    case 72: {
                        this.getGrupo().setConteudo(GRUPO_FUNDOS);
                        this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                        alterado = true;
                        break;
                    }
                    case 74: {
                        this.getGrupo().setConteudo(GRUPO_FUNDOS);
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 79: {
                        this.getGrupo().setConteudo(GRUPO_FUNDOS);
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 80: {
                        this.getGrupo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                        this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                        alterado = true;
                        break;
                    }
                    case 95: {
                        this.getGrupo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                        this.getCodigo().setConteudo(GRUPO_CREDITOS);
                        alterado = true;
                        break;
                    }
                    case 96: {
                        this.getGrupo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                        this.getCodigo().setConteudo(CODIGO_INDEFINIDO);
                        alterado = true;
                        break;
                    }
                    case 97: {
                        this.getGrupo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                        this.getCodigo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                        alterado = true;
                    }
                }
                if (!alterado) {
                    if (codigo >= 1 && codigo < 20) {
                        this.getGrupo().setConteudo(GRUPO_IMOVEIS);
                        if (codigo == 19) {
                            this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                        } else {
                            this.getCodigo().setConteudo(codigoOriginal);
                        }
                    } else if (codigo >= 21 && codigo < 30) {
                        this.getGrupo().setConteudo("02");
                        this.setCodigoPorFaixa(codigo, 29, 20);
                    } else if (codigo >= 31 && codigo < 40) {
                        this.getGrupo().setConteudo("03");
                        this.setCodigoPorFaixa(codigo, 39, 30);
                    } else if (codigo >= 41 && codigo < 50) {
                        this.getGrupo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                        switch (codigo) {
                            case 41: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 45: {
                                this.getCodigo().setConteudo("02");
                                break;
                            }
                            case 46: {
                                this.getCodigo().setConteudo(GRUPO_CREDITOS);
                                break;
                            }
                            case 49: {
                                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                            }
                        }
                    } else if (codigo >= 51 && codigo < 60) {
                        this.getGrupo().setConteudo(GRUPO_CREDITOS);
                        this.setCodigoPorFaixa(codigo, 59, 50);
                    } else if (codigo >= 61 && codigo < 70) {
                        this.getGrupo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                        switch (codigo) {
                            case 61: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 62: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 63: {
                                this.getCodigo().setConteudo(CRIPTOMOEDA_NFT);
                                break;
                            }
                            case 64: {
                                this.getCodigo().setConteudo("11");
                                break;
                            }
                            case 69: {
                                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                            }
                        }
                    } else if (codigo >= 71 && codigo < 80) {
                        this.getGrupo().setConteudo(GRUPO_FUNDOS);
                        switch (codigo) {
                            case 71: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 73: {
                                this.getCodigo().setConteudo("03");
                                break;
                            }
                            case 79: {
                                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                            }
                        }
                    } else if (codigo >= 81 && codigo < 90) {
                        this.getGrupo().setConteudo(GRUPO_CRIPTOATIVOS);
                        switch (codigo) {
                            case 81: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 82: {
                                this.getCodigo().setConteudo("02");
                                break;
                            }
                            case 89: {
                                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                            }
                        }
                    } else if (codigo >= 91) {
                        this.getGrupo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                        switch (codigo) {
                            case 91: {
                                this.getCodigo().setConteudo(GRUPO_IMOVEIS);
                                break;
                            }
                            case 92: {
                                this.getCodigo().setConteudo("02");
                                break;
                            }
                            case 93: {
                                this.getCodigo().setConteudo("03");
                                break;
                            }
                            case 94: {
                                this.getCodigo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                                break;
                            }
                            case 95: {
                                this.getCodigo().setConteudo(GRUPO_CREDITOS);
                                break;
                            }
                            case 97: {
                                this.getCodigo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                            }
                        }
                    }
                }
            }
        }
    }

    private void setCodigoPorFaixa(int codigo, int codOutro, int grupoAntigo) {
        if (codigo == codOutro) {
            this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
        } else {
            this.getCodigo().setConteudo("0" + (codigo -= grupoAntigo));
        }
    }

    public String buscarTipoRendimentoIsento(String grupo, String codigo) {
        String codigoRendimento = null;
        if ("03".equals(grupo)) {
            if (GRUPO_IMOVEIS.equals(codigo)) {
                codigoRendimento = "09";
            }
        } else if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupo)) {
            if (GRUPO_IMOVEIS.equals(codigo) || "03".equals(codigo)) {
                codigoRendimento = "12";
            }
        } else if (GRUPO_FUNDOS.equals(grupo) && ("02".equals(codigo) || "03".equals(codigo) || GRUPO_CREDITOS.equals(codigo))) {
            codigoRendimento = "26";
        }
        return codigoRendimento;
    }

    public String buscarTipoRendimentoExclusivo(String grupo, String codigo) {
        String codigoRendimento = null;
        if ("03".equals(grupo)) {
            if (GRUPO_IMOVEIS.equals(codigo)) {
                codigoRendimento = CRIPTOMOEDA_NFT;
            }
        } else if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupo)) {
            if ("02".equals(codigo)) {
                codigoRendimento = GRUPO_DEPOSITOS_VISTA_NUMERARIO;
            }
        } else if (GRUPO_FUNDOS.equals(grupo) && (GRUPO_IMOVEIS.equals(codigo) || "02".equals(codigo) || "03".equals(codigo) || GRUPO_APLICACOES_INVESTIMENTOS.equals(codigo) || GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(codigo) || GRUPO_FUNDOS.equals(codigo) || GRUPO_CRIPTOATIVOS.equals(codigo) || CRIPTOMOEDA_NFT.equals(codigo) || "11".equals(codigo))) {
            codigoRendimento = GRUPO_DEPOSITOS_VISTA_NUMERARIO;
        }
        return codigoRendimento;
    }

    public ItemQuadroAuxiliarAb buscarRendimentoIsentoAssociado(String tipoRendimento, DeclaracaoIRPF dec) {
        ItemQuadroAuxiliar rendimento;
        block3: {
            block5: {
                block4: {
                    rendimento = null;
                    if (!"09".equals(tipoRendimento)) break block4;
                    for (ItemQuadroTransporteDetalhado item : dec.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens()) {
                        if (this.getIndice().isVazio() || !this.getIndice().naoFormatado().equals(item.getCodBem().naoFormatado())) continue;
                        rendimento = item;
                        break block3;
                    }
                    break block3;
                }
                if (!"12".equals(tipoRendimento)) break block5;
                for (ItemQuadroTransporteDetalhado item : dec.getRendIsentos().getPoupancaQuadroAuxiliar().itens()) {
                    if (this.getIndice().isVazio() || !this.getIndice().naoFormatado().equals(item.getCodBem().naoFormatado())) continue;
                    rendimento = item;
                    break block3;
                }
                break block3;
            }
            if (!RendIsentos.TIPO_RENDISENTO_26.equals(tipoRendimento) && !RendIsentos.TIPO_RENDISENTO_OUTROS_TELA.equals(tipoRendimento)) break block3;
            dec.getRendIsentos().getOutrosQuadroAuxiliar();
            for (ItemQuadroOutrosRendimentos item : dec.getRendIsentos().getOutrosQuadroAuxiliar().itens()) {
                if (this.getIndice().isVazio() || !this.getIndice().naoFormatado().equals(item.getCodBem().naoFormatado())) continue;
                rendimento = item;
                break;
            }
        }
        return rendimento;
    }

    public ItemQuadroAuxiliarAb buscarRendimentoIsentoVazio(DeclaracaoIRPF dec) {
        ItemQuadroAuxiliar rendimento;
        block4: {
            block6: {
                block5: {
                    rendimento = null;
                    if (!"03".equals(this.getGrupo().naoFormatado()) || !GRUPO_IMOVEIS.equals(this.getCodigo().naoFormatado())) break block5;
                    for (ItemQuadroTransporteDetalhado item : dec.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens()) {
                        if (!item.getCodBem().isVazio() && !CHAVE_BEM_VAZIA.equals(item.getCodBem().naoFormatado()) || !item.getCnpjEmpresa().naoFormatado().equals(this.getNiEmpresa().naoFormatado()) || !item.getCpfBeneficiario().naoFormatado().equals(this.getCPFBeneficiario().naoFormatado()) && (!dec.getIdentificadorDeclaracao().isEspolio() || !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpfBeneficiario().naoFormatado())) || !item.getValor().isVazio()) continue;
                        item.getCodBem().setConteudo(this.getIndice());
                        rendimento = item;
                        break block4;
                    }
                    break block4;
                }
                if (!GRUPO_APLICACOES_INVESTIMENTOS.equals(this.getGrupo().naoFormatado()) || !GRUPO_IMOVEIS.equals(this.getCodigo().naoFormatado()) && !"03".equals(this.getCodigo().naoFormatado())) break block6;
                for (ItemQuadroTransporteDetalhado item : dec.getRendIsentos().getPoupancaQuadroAuxiliar().itens()) {
                    if (!item.getCodBem().isVazio() && !CHAVE_BEM_VAZIA.equals(item.getCodBem().naoFormatado()) || !item.getCnpjEmpresa().naoFormatado().equals(this.getNiEmpresa().naoFormatado()) || !item.getCpfBeneficiario().naoFormatado().equals(this.getCPFBeneficiario().naoFormatado()) && (!dec.getIdentificadorDeclaracao().isEspolio() || !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpfBeneficiario().naoFormatado())) || !item.getValor().isVazio()) continue;
                    item.getCodBem().setConteudo(this.getIndice());
                    rendimento = item;
                    break block4;
                }
                break block4;
            }
            if (!GRUPO_FUNDOS.equals(this.getGrupo().naoFormatado()) || !"02".equals(this.getCodigo().naoFormatado()) && !"03".equals(this.getCodigo().naoFormatado()) && !GRUPO_CREDITOS.equals(this.getCodigo().naoFormatado())) break block4;
            dec.getRendIsentos().getOutrosQuadroAuxiliar();
            for (ItemQuadroOutrosRendimentos item : dec.getRendIsentos().getOutrosQuadroAuxiliar().itens()) {
                if (!item.getCodBem().isVazio() && !CHAVE_BEM_VAZIA.equals(item.getCodBem().naoFormatado()) || !item.getCnpjEmpresa().naoFormatado().equals(this.getNiEmpresa().naoFormatado()) || !item.getCpfBeneficiario().naoFormatado().equals(this.getCPFBeneficiario().naoFormatado()) && (!dec.getIdentificadorDeclaracao().isEspolio() || !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpfBeneficiario().naoFormatado())) || !item.getValor().isVazio()) continue;
                item.getCodBem().setConteudo(this.getIndice());
                if (item.getDescricaoRendimento().isVazio()) {
                    item.getDescricaoRendimento().setConteudo(this.getGrupo().getConteudoAtual(1) + " - " + this.getCodigo().getConteudoAtual(1));
                }
                rendimento = item;
                break;
            }
        }
        return rendimento;
    }

    public ItemQuadroAuxiliarAb buscarRendimentoExclusivoAssociado(String tipoRendimento, DeclaracaoIRPF dec) {
        ItemQuadroTransporteDetalhado rendimento;
        block2: {
            block3: {
                rendimento = null;
                if (!GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(tipoRendimento)) break block3;
                for (ItemQuadroTransporteDetalhado item : dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().itens()) {
                    if (this.getIndice().isVazio() || !this.getIndice().naoFormatado().equals(item.getCodBem().naoFormatado())) continue;
                    rendimento = item;
                    break block2;
                }
                break block2;
            }
            if (!CRIPTOMOEDA_NFT.equals(tipoRendimento)) break block2;
            for (ItemQuadroTransporteDetalhado item : dec.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().itens()) {
                if (this.getIndice().isVazio() || !this.getIndice().naoFormatado().equals(item.getCodBem().naoFormatado())) continue;
                rendimento = item;
                break;
            }
        }
        return rendimento;
    }

    public ItemQuadroAuxiliarAb buscarRendimentoExclusivoVazio(DeclaracaoIRPF dec) {
        ItemQuadroTransporteDetalhado rendimento;
        block2: {
            block3: {
                rendimento = null;
                if (!"03".equals(this.getGrupo().naoFormatado()) || !GRUPO_IMOVEIS.equals(this.getCodigo().naoFormatado())) break block3;
                for (ItemQuadroTransporteDetalhado item : dec.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().itens()) {
                    if (!item.getCodBem().isVazio() && !CHAVE_BEM_VAZIA.equals(item.getCodBem().naoFormatado()) || !item.getCnpjEmpresa().naoFormatado().equals(this.getNiEmpresa().naoFormatado()) || !item.getCpfBeneficiario().naoFormatado().equals(this.getCPFBeneficiario().naoFormatado()) && (!dec.getIdentificadorDeclaracao().isEspolio() || !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpfBeneficiario().naoFormatado())) || !item.getValor().isVazio()) continue;
                    item.getCodBem().setConteudo(this.getIndice());
                    rendimento = item;
                    break block2;
                }
                break block2;
            }
            if ((!GRUPO_APLICACOES_INVESTIMENTOS.equals(this.getGrupo().naoFormatado()) || !"02".equals(this.getCodigo().naoFormatado())) && (!GRUPO_FUNDOS.equals(this.getGrupo().naoFormatado()) || !GRUPO_IMOVEIS.equals(this.getCodigo().naoFormatado()) && !"02".equals(this.getCodigo().naoFormatado()) && !"03".equals(this.getCodigo().naoFormatado()) && !GRUPO_APLICACOES_INVESTIMENTOS.equals(this.getCodigo().naoFormatado()) && !GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(this.getCodigo().naoFormatado()) && !GRUPO_FUNDOS.equals(this.getCodigo().naoFormatado()) && !GRUPO_CRIPTOATIVOS.equals(this.getCodigo().naoFormatado()) && !CRIPTOMOEDA_NFT.equals(this.getCodigo().naoFormatado()) && !"11".equals(this.getCodigo().naoFormatado()))) break block2;
            for (ItemQuadroTransporteDetalhado item : dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().itens()) {
                if (!item.getCodBem().isVazio() && !CHAVE_BEM_VAZIA.equals(item.getCodBem().naoFormatado()) || !item.getCnpjEmpresa().naoFormatado().equals(this.getNiEmpresa().naoFormatado()) || !item.getCpfBeneficiario().naoFormatado().equals(this.getCPFBeneficiario().naoFormatado()) && (!dec.getIdentificadorDeclaracao().isEspolio() || !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpfBeneficiario().naoFormatado())) || !item.getValor().isVazio()) continue;
                item.getCodBem().setConteudo(this.getIndice());
                rendimento = item;
                break;
            }
        }
        return rendimento;
    }

    public boolean podePerguntarTrocaGrupoCodigoPais(String valorAntigo, String nomeCampo) {
        boolean tem = false;
        if (ControladorGui.getDemonstrativoAberto() != null) {
            String codigoRendimentoIsento = this.buscarTipoRendimentoIsento(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendIsento = this.buscarRendimentoIsentoAssociado(codigoRendimentoIsento, ControladorGui.getDemonstrativoAberto());
            String codigoRendimentoExclusivo = this.buscarTipoRendimentoExclusivo(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendExclusivo = this.buscarRendimentoExclusivoAssociado(codigoRendimentoExclusivo, ControladorGui.getDemonstrativoAberto());
            if ((rendIsento != null || rendExclusivo != null) && (NOME_CAMPO_GRUPO.equals(nomeCampo) || NOME_CAMPO_CODIGO.equals(nomeCampo) || NOME_CAMPO_LOCAL_PAIS.equals(nomeCampo) && "105".equals(valorAntigo))) {
                tem = true;
            }
        }
        return tem;
    }

    public boolean processarTrocaGrupoCodigoPais(String valorAntigo, String nomeCampo) {
        boolean estado = true;
        if (ControladorGui.getDemonstrativoAberto() != null) {
            String codigoRendimentoIsento = this.buscarTipoRendimentoIsento(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendIsento = this.buscarRendimentoIsentoAssociado(codigoRendimentoIsento, ControladorGui.getDemonstrativoAberto());
            String codigoRendimentoExclusivo = this.buscarTipoRendimentoExclusivo(this.getGrupo().naoFormatado(), this.getCodigo().naoFormatado());
            ItemQuadroAuxiliarAb rendExclusivo = this.buscarRendimentoExclusivoAssociado(codigoRendimentoExclusivo, ControladorGui.getDemonstrativoAberto());
            if (rendIsento != null || rendExclusivo != null) {
                boolean confirma = false;
                try {
                    confirma = GuiUtil.mostrarConfirmaSemQuebraDeLinha((String)"bem_alterar_grupo_codigo_pais", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (confirma) {
                    if (rendIsento != null) {
                        ControladorGui.getDemonstrativoAberto().getRendIsentos().excluirRendimento(codigoRendimentoIsento, rendIsento);
                    }
                    if (rendExclusivo != null) {
                        ControladorGui.getDemonstrativoAberto().getRendTributacaoExclusiva().excluirRendimento(codigoRendimentoExclusivo, rendExclusivo);
                    }
                } else {
                    if (null != nomeCampo) {
                        switch (nomeCampo) {
                            case "Grupo": {
                                this.getGrupo().setConteudo(valorAntigo);
                                break;
                            }
                            case "C\u00f3digo": {
                                this.getCodigo().setConteudo(valorAntigo);
                                break;
                            }
                            case "Localiza\u00e7\u00e3o(Pa\u00eds)": {
                                this.getPais().setConteudo("105");
                                break;
                            }
                        }
                    }
                    estado = false;
                }
            }
        }
        return estado;
    }

    public static void main(String[] args) {
        System.out.println("123AB\u00c7 .{}\u00b4`?[]><;:,~^|\\/''''\"\"!@#$%\u00a8&*()-\u0002\u009f\u00b0_\u00a7=+".replaceAll("(\\w|\\s|[\u00c7\u00e7\u00a2\u00c9\u00c8\u00ca\u00cb\u00e9\u00e8\u00ea\u00eb\u00c1\u00c0\u00c2\u00c3\u00c4\u00c5\u00c6\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u00e6\u00aa\u00d3\u00d2\u00d4\u00d5\u00d6\u00f3\u00f2\u00f4\u00f5\u00f6\u00ba\u00cd\u00cc\u00ce\u00cf\u00ed\u00ec\u00ee\u00ef\u00da\u00d9\u00db\u00dc\u00fa\u00f9\u00fb\u00fc\u00dd\u00ff\u00fd\u00d1\u00f1]|[\\\\\\{\\}\\[\\]\\(\\)\\|\\/\\-\\=\\$\\%\\&\\,\\.\\!\\#\\*\\:\\;\\<\\>\\?\\@\\_\\\"\\'\\+])", TIPO_PADRAO));
    }

    public Alfa getIndicadorReclassificar() {
        return this.indicadorReclassificar;
    }

    public void reclassificar(String grupo, String codigo, String pais) {
        String reclassificar = "0";
        if (grupo.equals(GRUPO_APLICACOES_INVESTIMENTOS) && !pais.equals("105")) {
            if (codigo.equals(GRUPO_IMOVEIS) || codigo.equals("03") || codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS)) {
                this.getGrupo().setConteudo(grupo);
                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                reclassificar = "2";
            }
        } else if (grupo.equals(GRUPO_FUNDOS)) {
            if (!pais.equals("105") && (codigo.equals(GRUPO_IMOVEIS) || codigo.equals("02") || codigo.equals("03") || codigo.equals(GRUPO_APLICACOES_INVESTIMENTOS) || codigo.equals(GRUPO_CREDITOS) || codigo.equals(GRUPO_DEPOSITOS_VISTA_NUMERARIO) || codigo.equals(GRUPO_FUNDOS) || codigo.equals(GRUPO_CRIPTOATIVOS) || codigo.equals("09") || codigo.equals(CRIPTOMOEDA_NFT))) {
                this.getGrupo().setConteudo(grupo);
                this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                reclassificar = "2";
            } else if (codigo.equals(GRUPO_CREDITOS) && pais.equals("105")) {
                this.getGrupo().setConteudo(grupo);
                this.getCodigo().setConteudo(GRUPO_APLICACOES_INVESTIMENTOS);
                reclassificar = "2";
            } else if (codigo.equals("09") && pais.equals("105")) {
                this.getGrupo().setConteudo(grupo);
                this.getCodigo().setConteudo(GRUPO_DEPOSITOS_VISTA_NUMERARIO);
                reclassificar = "2";
            } else if (codigo.equals(GRUPO_OUTROS_BENS_DIREITOS) && pais.equals("105")) {
                this.getGrupo().setConteudo(grupo);
                this.getCodigo().setConteudo(codigo);
                reclassificar = "1";
            } else if (codigo.equals("11")) {
                if (pais.equals("105")) {
                    this.getGrupo().setConteudo(grupo);
                    this.getCodigo().clear();
                    reclassificar = "1";
                } else {
                    this.getGrupo().setConteudo(grupo);
                    this.getCodigo().setConteudo(GRUPO_OUTROS_BENS_DIREITOS);
                    reclassificar = "2";
                }
            }
        } else if (grupo.equals(GRUPO_OUTROS_BENS_DIREITOS) && codigo.equals(GRUPO_OUTROS_BENS_DIREITOS)) {
            this.getGrupo().setConteudo(grupo);
            this.getCodigo().setConteudo(codigo);
            reclassificar = "1";
        }
        if (reclassificar.equals("0")) {
            this.getGrupo().setConteudo(grupo);
            this.getCodigo().setConteudo(codigo);
        }
        this.getIndicadorReclassificar().setConteudo(reclassificar);
    }

    public boolean isBemApenasBrasil(String grupo, String codigo) {
        boolean retorno = false;
        if (GRUPO_APLICACOES_INVESTIMENTOS.equals(grupo)) {
            if (GRUPO_IMOVEIS.equals(codigo) || "03".equals(codigo) || GRUPO_APLICACOES_INVESTIMENTOS.equals(codigo)) {
                retorno = true;
            }
        } else if (GRUPO_FUNDOS.equals(grupo) && (GRUPO_IMOVEIS.equals(codigo) || "02".equals(codigo) || "03".equals(codigo) || GRUPO_APLICACOES_INVESTIMENTOS.equals(codigo) || GRUPO_DEPOSITOS_VISTA_NUMERARIO.equals(codigo) || GRUPO_FUNDOS.equals(codigo) || GRUPO_CRIPTOATIVOS.equals(codigo) || CRIPTOMOEDA_NFT.equals(codigo) || "12".equals(codigo) || "13".equals(codigo))) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean isBemApenasExterior(String grupo, String codigo) {
        boolean retorno = false;
        if (GRUPO_FUNDOS.equals(grupo) && GRUPO_OUTROS_BENS_DIREITOS.equals(codigo)) {
            retorno = true;
        }
        return retorno;
    }
}

