/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.exterior;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ColecaoDividasARExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ColecaoReceitasDespesas;
import serpro.ppgd.irpf.atividaderural.exterior.IdentificacaoImovelARExterior;
import serpro.ppgd.irpf.gui.atividaderural.PainelDadosImovel;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;

public class ARExterior
extends ObjetoNegocio
implements ObjetoFicha {
    private IdentificacaoImovelARExterior identificacaoImovel = new IdentificacaoImovelARExterior();
    private ColecaoReceitasDespesas receitasDespesas = new ColecaoReceitasDespesas();
    private ApuracaoResultadoExterior apuracaoResultado;
    private MovimentacaoRebanho movimentacaoRebanho = new MovimentacaoRebanho();
    private ColecaoDividasARExterior dividas = new ColecaoDividasARExterior();

    public ARExterior(IdentificadorDeclaracao identificadorDeclaracao) {
        this.getMovimentacaoRebanho().setFicha("Movimenta\u00e7\u00e3o do Rebanho - EXTERIOR");
        this.apuracaoResultado = new ApuracaoResultadoExterior(identificadorDeclaracao);
    }

    public ApuracaoResultadoExterior getApuracaoResultado() {
        return this.apuracaoResultado;
    }

    public ColecaoDividasARExterior getDividas() {
        return this.dividas;
    }

    public IdentificacaoImovelARExterior getIdentificacaoImovel() {
        return this.identificacaoImovel;
    }

    public MovimentacaoRebanho getMovimentacaoRebanho() {
        return this.movimentacaoRebanho;
    }

    public ColecaoReceitasDespesas getReceitasDespesas() {
        return this.receitasDespesas;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        boolean temAlgumaOutraFichaPreenchida;
        List retorno = super.verificarPendencias(numeroItem);
        boolean bl = temAlgumaOutraFichaPreenchida = !this.getReceitasDespesas().isVazio() || !this.getApuracaoResultado().isVazio() || !this.getMovimentacaoRebanho().isVazio() || !this.getDividas().isVazio();
        if (this.getIdentificacaoImovel().isVazio() && temAlgumaOutraFichaPreenchida) {
            this.getIdentificacaoImovel().novoObjeto();
            ImovelAR imovel = (ImovelAR)this.getIdentificacaoImovel().itens().get(0);
            Pendencia p = new Pendencia(3, (Informacao)imovel.getCodigo(), imovel.getCodigo().getNomeCampo(), MensagemUtil.getMensagem("ar_imovel_nao_preenchido"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            p.setNomeAba(this.getNomeAba());
            retorno.add(p);
        }
        return retorno;
    }

    public String getClasseFicha() {
        return PainelDadosImovel.class.getName();
    }

    public String getNomeAba() {
        return "Exterior";
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

