/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.brasil;

import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.brasil.ColecaoDividasARBrasil;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosDividasARBrasil
extends Observador {
    ColecaoDividasARBrasil colecao;

    public CalculosDividasARBrasil(ColecaoDividasARBrasil colecao) {
        this.colecao = colecao;
    }

    public void totalizarAnterior() {
        Valor totalAnterior = new Valor();
        for (DividaAR divida : this.colecao.itens()) {
            totalAnterior.append('+', (Valor)divida.getContraidasAteExercicioAnterior());
        }
        this.colecao.getTotalAnterior().setConteudo(totalAnterior);
    }

    public void totalizarAtual() {
        Valor totalAtual = new Valor();
        for (DividaAR divida : this.colecao.itens()) {
            totalAtual.append('+', (Valor)divida.getContraidasAteExercicioAtual());
        }
        this.colecao.getTotalAtual().setConteudo(totalAtual);
    }

    public void totalizarValorPagamentoAnual() {
        Valor totalPagamentoAnual = new Valor();
        for (DividaAR divida : this.colecao.itens()) {
            totalPagamentoAnual.append('+', (Valor)divida.getValorPagamentoAnual());
        }
        this.colecao.getValorPagamentoAnual().setConteudo(totalPagamentoAnual);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                DividaAR divida = (DividaAR)((Object)valorNovo);
                divida.addObservador(this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                DividaAR divida = (DividaAR)((Object)valorNovo);
                divida.removeObservador(this);
            }
            this.totalizarAnterior();
            this.totalizarAtual();
            this.totalizarValorPagamentoAnual();
        }
    }
}

