/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.brasil;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.atividaderural.PainelApuracaoResultado;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ApuracaoResultadoBrasil
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_CAMPO_RESULTADO_TRIBUTAVEL_BR = "Resultado Tribut\u00e1vel - Brasil";
    public static final String PELO_LIMITE_20_POR_CENTO = "1";
    public static final String PELO_RESULTADO = "2";
    private Valor receitaBrutaTotal = new Valor((ObjetoNegocio)this, "Receita Bruta Total");
    private Valor despesaCusteio = new Valor((ObjetoNegocio)this, "Despesa Custeio e Investimento");
    private Valor resultadoI = new Valor((ObjetoNegocio)this, "Resultado I");
    private ValorPositivo prejuizoExercicioAnterior = new ValorPositivo(this, "Preju\u00edzo Exerc\u00edcio Anterior");
    private ValorPositivo compensacaoPrejuizoExerciciosAnteriores = new ValorPositivo(this, "Compensa\u00e7\u00e3o de Preju\u00edzo(s) de Exerc\u00edcio(s) Anterior(es)");
    private Valor limiteVintePorCentoReceitaBruta = new Valor((ObjetoNegocio)this, "Limite de 20% sobre a Receita Bruta");
    private Alfa opcaoFormaApuracao = new Alfa((ObjetoNegocio)this, "Op\u00e7\u00e3o pela forma de apura\u00e7\u00e3o do resultado tribut\u00e1vel");
    private ValorPositivo resultadoTributavel = new ValorPositivo(this, "Resultado Tribut\u00e1vel - Brasil");
    private Valor prejuizoCompensar = new Valor((ObjetoNegocio)this, "Saldo Preju\u00edzo a Compensar");
    private ValorPositivo receitaRecebidaContaVenda = new ValorPositivo(this, "Receita Recebida Adiantamento");
    private ValorPositivo valorAdiantamento = new ValorPositivo(this, "Adiantamentos Recebidos por Venda Entrega Futura");
    private Valor resultadoNaoTributavel = new Valor((ObjetoNegocio)this, "Resultado N\u00e3o Tribut\u00e1vel");

    public ApuracaoResultadoBrasil() {
        this.setFicha("Apura\u00e7\u00e3o do Resultado Tribut\u00e1vel - BRASIL");
        this.receitaBrutaTotal.setReadOnly(true);
        this.despesaCusteio.setReadOnly(true);
        this.resultadoI.setReadOnly(true);
        this.compensacaoPrejuizoExerciciosAnteriores.setReadOnly(true);
        this.limiteVintePorCentoReceitaBruta.setReadOnly(true);
        this.resultadoTributavel.setReadOnly(true);
        this.prejuizoCompensar.setReadOnly(true);
        this.resultadoNaoTributavel.setReadOnly(true);
        this.opcaoFormaApuracao.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!(ApuracaoResultadoBrasil.this.prejuizoExercicioAnterior.isVazio() && ApuracaoResultadoBrasil.this.receitaBrutaTotal.isVazio() && ApuracaoResultadoBrasil.this.despesaCusteio.isVazio() || ApuracaoResultadoBrasil.this.opcaoFormaApuracao.naoFormatado().equals(ApuracaoResultadoBrasil.PELO_LIMITE_20_POR_CENTO) || ApuracaoResultadoBrasil.this.opcaoFormaApuracao.naoFormatado().equals(ApuracaoResultadoBrasil.PELO_RESULTADO))) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.compensacaoPrejuizoExerciciosAnteriores.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ApuracaoResultadoBrasil.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", "0,00") && ApuracaoResultadoBrasil.this.getResultadoI().comparacao(">", "0,00")) {
                    if (ApuracaoResultadoBrasil.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", ApuracaoResultadoBrasil.this.getResultadoI())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ar_apuracao_comp_prejuizo_excede_resultado_br"), this.getSeveridade());
                    }
                    if (ApuracaoResultadoBrasil.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", ApuracaoResultadoBrasil.this.getPrejuizoExercicioAnterior())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ar_apuracao_comp_prejuizo_excede_saldo_prejuizo_br"), this.getSeveridade());
                    }
                }
                return null;
            }
        });
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = super.recuperarListaCamposPendencia();
        listaCamposPendencia.add(this.opcaoFormaApuracao);
        listaCamposPendencia.add(this.compensacaoPrejuizoExerciciosAnteriores);
        listaCamposPendencia.add(this.resultadoTributavel);
        listaCamposPendencia.add(this.resultadoNaoTributavel);
        return listaCamposPendencia;
    }

    public boolean isVazio() {
        return this.receitaBrutaTotal.isVazio() && this.despesaCusteio.isVazio() && this.resultadoI.isVazio() && this.prejuizoExercicioAnterior.isVazio() && this.compensacaoPrejuizoExerciciosAnteriores.isVazio() && this.limiteVintePorCentoReceitaBruta.isVazio() && this.resultadoTributavel.isVazio() && this.prejuizoCompensar.isVazio() && this.receitaRecebidaContaVenda.isVazio() && this.valorAdiantamento.isVazio() && this.resultadoNaoTributavel.isVazio();
    }

    public Valor getDespesaCusteio() {
        return this.despesaCusteio;
    }

    public Valor getLimiteVintePorCentoReceitaBruta() {
        return this.limiteVintePorCentoReceitaBruta;
    }

    public Alfa getOpcaoFormaApuracao() {
        return this.opcaoFormaApuracao;
    }

    public Valor getPrejuizoCompensar() {
        return this.prejuizoCompensar;
    }

    public ValorPositivo getPrejuizoExercicioAnterior() {
        return this.prejuizoExercicioAnterior;
    }

    public Valor getReceitaBrutaTotal() {
        return this.receitaBrutaTotal;
    }

    public ValorPositivo getReceitaRecebidaContaVenda() {
        return this.receitaRecebidaContaVenda;
    }

    public ValorPositivo getCompensacaoPrejuizoExerciciosAnteriores() {
        return this.compensacaoPrejuizoExerciciosAnteriores;
    }

    public Valor getResultadoI() {
        return this.resultadoI;
    }

    public Valor getResultadoNaoTributavel() {
        return this.resultadoNaoTributavel;
    }

    public ValorPositivo getResultadoTributavel() {
        return this.resultadoTributavel;
    }

    public ValorPositivo getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    public String getClasseFicha() {
        return PainelApuracaoResultado.class.getName();
    }

    public String getNomeAba() {
        return "Brasil";
    }

    public String getTituloFichaDashboard() {
        return "Atividade Rural - Apura\u00e7\u00e3o do Resultado";
    }
}

