/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.atividaderural.PainelDadosImovel;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ParticipanteImovelAR
extends ObjetoNegocio
implements ObjetoFicha {
    private NI ni = new NI((ObjetoNegocio)this, "CPF/CNPJ");
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private Alfa estrangeiro = new Alfa((ObjetoNegocio)this, "Estrangeiro?", 1);
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public ParticipanteImovelAR() {
        CacheNI.getInstancia().registrarNINome(this.ni, this.nome);
        this.getNi().addValidador((ValidadorIf)new ValidadorNI(3));
        this.getNi().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_ni_participante")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ParticipanteImovelAR.this.isEstrangeiro()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_nome_participante")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!ParticipanteImovelAR.this.isEstrangeiro() || ParticipanteImovelAR.this.isEstrangeiro() && !ParticipanteImovelAR.this.getNi().isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
    }

    public NI getNi() {
        return this.ni;
    }

    public void setNi(NI ni) {
        this.ni = ni;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public void setNome(Alfa nome) {
        this.nome = nome;
    }

    public boolean isEstrangeiro() {
        return this.getEstrangeiro().naoFormatado().equals(Logico.SIM);
    }

    public Alfa getEstrangeiro() {
        return this.estrangeiro;
    }

    public void setEstrangeiro(Alfa estrangeiro) {
        this.estrangeiro = estrangeiro;
    }

    public Alfa getIndice() {
        return this.indice;
    }

    public boolean isVazio() {
        return this.ni.isVazio() && this.nome.isVazio();
    }

    public ParticipanteImovelAR obterCopia() {
        ParticipanteImovelAR copia = new ParticipanteImovelAR();
        copia.getNi().setConteudo(this.getNi());
        copia.getNome().setConteudo(this.getNome());
        copia.getEstrangeiro().setConteudo(this.getEstrangeiro());
        copia.getIndice().setConteudo(this.getIndice());
        return copia;
    }

    public String getClasseFicha() {
        return PainelDadosImovel.class.getName();
    }

    public String getTituloFichaDashboard() {
        return "Atividade Rural - Dados do Im\u00f3vel Explorado";
    }

    public String getNomeAba() {
        return null;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getNi());
        retorno.add(this.getNome());
        return retorno;
    }

    public ParticipanteImovelAR getCopia() {
        ParticipanteImovelAR copia = new ParticipanteImovelAR();
        copia.getNi().setConteudo(this.ni);
        copia.getNome().setConteudo(this.nome);
        return copia;
    }
}

