/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.atividaderural.ParticipantesImovelAR;
import serpro.ppgd.irpf.gui.atividaderural.PainelDadosImovel;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class ImovelAR
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    protected Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoAtividadesRural());
    protected Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do Im\u00f3vel", 60);
    protected Alfa localizacao = new Alfa((ObjetoNegocio)this, "Localiza\u00e7\u00e3o do Im\u00f3vel", 55);
    protected Valor area = new Valor((ObjetoNegocio)this, "\u00c1rea(ha)");
    protected Valor participacao = new Valor((ObjetoNegocio)this, "Participa\u00e7\u00e3o(%)");
    protected Codigo condicaoExploracao = new Codigo((ObjetoNegocio)this, "Condi\u00e7\u00e3o de Explora\u00e7\u00e3o", CadastroTabelasIRPF.recuperarCondicoesExploracao());
    protected ParticipantesImovelAR participantesImovelAR = new ParticipantesImovelAR();
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public ImovelAR() {
        this.getParticipacao().setMaximoDigitosParteInteira(3);
        this.getArea().setMaximoDigitosParteInteira(9);
        this.getArea().converteQtdCasasDecimais(1);
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_codigo_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("ar_imovel_codigo_branco")));
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_nome_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String codigo = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (codigo.trim().equals("13") || codigo.trim().equals("14") || codigo.trim().equals("15") || codigo.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else if (codigo.trim().equals("10") || codigo.trim().equals("11") || codigo.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getLocalizacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_localizacao_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String codigo = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (codigo.trim().equals("10") || codigo.trim().equals("11") || codigo.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else if (codigo.trim().equals("13") || codigo.trim().equals("14") || codigo.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getArea().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_area_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String codigo = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (codigo.trim().equals("10") || codigo.trim().equals("11") || codigo.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else if (codigo.trim().equals("13") || codigo.trim().equals("14") || codigo.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getParticipacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_1")){

            @Override
            public RetornoValidacao validarImplementado() {
                String codCondExploracao = ImovelAR.this.getCondicaoExploracao().getConteudoAtual(0);
                if (ImovelAR.this.getParticipacao().isVazio() && !codCondExploracao.equals("1")) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_4"));
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_4"), 3);
                }
                if (codCondExploracao.equals("1")) {
                    if (ImovelAR.this.getParticipacao().comparacao("=", "100,00")) {
                        return null;
                    }
                    super.setMensagemValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_1"));
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_1"), 3);
                }
                if ((codCondExploracao.equals("2") || codCondExploracao.equals("3")) && ImovelAR.this.getParticipacao().comparacao("=", "100,00")) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_2"));
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_2"), 3);
                }
                if (ImovelAR.this.getParticipacao().comparacao("<", "100,00") && ImovelAR.this.getParticipantesImovelAR().isVazio()) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_5"));
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_5"), 3);
                }
                if (ImovelAR.this.getParticipacao().comparacao(">", "100,00")) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_3"));
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_imovel_participacao_exploracao_3"), 3);
                }
                if (ImovelAR.this.getCondicaoExploracao().isVazio()) {
                    return null;
                }
                return null;
            }
        });
        this.getCondicaoExploracao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_imovel_condicao_exploracao_invalida")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCondicaoExploracao().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("ar_imovel_condicao_exploracao_invalida")));
        this.getParticipacao().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (ImovelAR.this.getParticipacao().comparacao("=", "100,00")) {
                    ImovelAR.this.getParticipantesImovelAR().clear();
                }
            }
        });
    }

    public Valor getArea() {
        return this.area;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Codigo getCondicaoExploracao() {
        return this.condicaoExploracao;
    }

    public Alfa getLocalizacao() {
        return this.localizacao;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Valor getParticipacao() {
        return this.participacao;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Indice")) continue;
            return false;
        }
        return true;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        for (Informacao informacao : this.getParticipantesImovelAR().recuperarListaCamposPendencia()) {
            retorno.add(informacao);
        }
        return retorno;
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    public int compareTo(Object o) {
        ImovelAR imovel = (ImovelAR)o;
        int cod = imovel.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public String getClasseFicha() {
        return PainelDadosImovel.class.getName();
    }

    public String getNomeAba() {
        return "Exterior";
    }

    public String getTituloFichaDashboard() {
        return "Atividade Rural - Dados e Identifica\u00e7\u00e3o do Im\u00f3vel Rural";
    }

    public ImovelAR obterCopia() {
        ImovelAR copia = new ImovelAR();
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getNome().setConteudo(this.getNome());
        copia.getLocalizacao().setConteudo(this.getLocalizacao());
        copia.getArea().setConteudo(this.getArea());
        copia.getParticipacao().setConteudo(this.getParticipacao());
        copia.getCondicaoExploracao().setConteudo(this.getCondicaoExploracao());
        copia.getIndice().setConteudo(this.getIndice());
        copia.setParticipantesImovelAR(this.getParticipantesImovelAR().obterCopia());
        return copia;
    }

    public ParticipantesImovelAR getParticipantesImovelAR() {
        return this.participantesImovelAR;
    }

    public void setParticipantesImovelAR(ParticipantesImovelAR participantesImovelAR) {
        this.participantesImovelAR = participantesImovelAR;
    }
}

