/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.atividaderural.PainelDividasAR;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;

public class DividaAR
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_DIVIDAS_VALOR_PGTO_ANUAL = "Valor Pago em " + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static String NOME_DIVIDAS_ANO_ANTERIOR = "D\u00edvidas at\u00e9 " + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static String NOME_DIVIDAS_ATUAL = "D\u00edvidas at\u00e9 " + ConstantesGlobais.EXERCICIO;
    private Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 150);
    private ValorPositivo contraidasAteExercicioAnterior = new ValorPositivo(this, NOME_DIVIDAS_ANO_ANTERIOR);
    private ValorPositivo contraidasAteExercicioAtual = new ValorPositivo(this, NOME_DIVIDAS_ATUAL);
    private ValorPositivo valorPagamentoAnual = new ValorPositivo(this, NOME_DIVIDAS_VALOR_PGTO_ANUAL);

    public DividaAR() {
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_divida_discriminacao")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (DividaAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
    }

    public ValorPositivo getContraidasAteExercicioAnterior() {
        return this.contraidasAteExercicioAnterior;
    }

    public ValorPositivo getContraidasAteExercicioAtual() {
        return this.contraidasAteExercicioAtual;
    }

    public ValorPositivo getValorPagamentoAnual() {
        return this.valorPagamentoAnual;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public DividaAR obterCopia() {
        DividaAR copia = new DividaAR();
        copia.getDiscriminacao().setConteudo(this.getDiscriminacao());
        copia.getContraidasAteExercicioAtual().setConteudo(this.getContraidasAteExercicioAtual());
        copia.getContraidasAteExercicioAnterior().setConteudo(this.getContraidasAteExercicioAnterior());
        copia.getValorPagamentoAnual().setConteudo(this.getValorPagamentoAnual());
        return copia;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public String getClasseFicha() {
        return PainelDividasAR.class.getName();
    }

    public String getNomeAba() {
        if (this.ficha.contains("BRASIL")) {
            return "Brasil";
        }
        return "Exterior";
    }

    public void addObservador(Observador obj) {
        this.contraidasAteExercicioAnterior.addObservador(obj);
        this.contraidasAteExercicioAtual.addObservador(obj);
        this.valorPagamentoAnual.addObservador(obj);
    }

    public void removeObservador(Observador obj) {
        this.contraidasAteExercicioAnterior.removeObservador(obj);
        this.contraidasAteExercicioAtual.removeObservador(obj);
        this.valorPagamentoAnual.removeObservador(obj);
    }

    public String getTituloFichaDashboard() {
        return "D\u00edvidas Vinculadas \u00e0 Atividade Rural";
    }
}

