/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.impressao.Relatorio;
import serpro.ppgd.negocio.ConstantesGlobais;

public class PreenchedorFichasImpressao {
    public static void preencheRelatorioGeral(Relatorio novaImpressao, DeclaracaoIRPF dec) {
        String decEspolio = dec.getIdentificadorDeclaracao().isEspolio() ? "true" : "false";
        String decSaida = dec.getIdentificadorDeclaracao().isSaida() ? "true" : "false";
        String decAjuste = dec.getIdentificadorDeclaracao().isAjuste() ? "true" : "false";
        novaImpressao.addParametro("cpfContribuinte", dec.getIdentificadorDeclaracao().getCpf().formatado());
        novaImpressao.addParametro("nomeContribuinte", dec.getIdentificadorDeclaracao().getNome().formatado());
        novaImpressao.addParametro("anobase", ConstantesGlobais.ANO_BASE);
        novaImpressao.addParametro("exercicio", ConstantesGlobais.EXERCICIO);
        novaImpressao.addParametro("DEC_ESPOLIO", decEspolio);
        novaImpressao.addParametro("DEC_SAIDA", decSaida);
        novaImpressao.addParametro("DEC_AJUSTE", decAjuste);
    }

    public static void preencheContribuinte(Relatorio novaImpressao, DeclaracaoIRPF dec, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("tipoLogradouro", dec.getContribuinte().getTipoLogradouro().getConteudoAtual(1));
        if (dec.getContribuinte().getExterior().naoFormatado().equals("1")) {
            novaImpressao.addParametro("municipio", dec.getContribuinte().getCidade().formatado());
        } else {
            novaImpressao.addParametro("municipio", dec.getContribuinte().getMunicipio().getConteudoAtual(1));
        }
        novaImpressao.addParametro("descNaturezaOcupacao", dec.getContribuinte().getNaturezaOcupacao().getConteudoAtual(1));
        novaImpressao.addParametro("descOcupacaoPrincipal", dec.getContribuinte().getOcupacaoPrincipal().getConteudoAtual(3));
        novaImpressao.addParametro("registroProfissional", dec.getContribuinte().getRegistroProfissional().naoFormatado());
        if (dec.getContribuinte().isOcupacaoComRegistroProfissionalObrigatorio(dec.getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado())) {
            novaImpressao.addParametro("mostrarRegistroProfissional", "1");
        } else {
            novaImpressao.addParametro("mostrarRegistroProfissional", "0");
        }
        boolean ehRetif = false;
        if (dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1")) {
            ehRetif = true;
        }
        novaImpressao.addParametro("retificadora", Boolean.toString(ehRetif));
        if (!dec.getContribuinte().getEnderecoDiferente().isVazio()) {
            novaImpressao.addParametro("endDiferente", dec.getContribuinte().getEnderecoDiferente().formatado().equals("0") ? "N\u00e3o" : "Sim");
        }
        if (dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1")) {
            novaImpressao.addParametro("txtRecibo", "N\u00ba do recibo da declara\u00e7\u00e3o anterior do exerc\u00edcio de " + ConstantesGlobais.EXERCICIO + ":");
            novaImpressao.addParametro("numeroRecibo", dec.getContribuinte().getNumReciboDecRetif().formatado());
        } else {
            novaImpressao.addParametro("txtRecibo", "N\u00ba do recibo da \u00faltima declara\u00e7\u00e3o entregue do exerc\u00edcio de " + ConstantesGlobais.EXERCICIO_ANTERIOR + ":");
            novaImpressao.addParametro("numeroRecibo", dec.getContribuinte().getNumeroReciboDecAnterior().formatado());
        }
    }

    public static void preencheRendPJTitular(Relatorio novaImpressao, DeclaracaoIRPF dec, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendPJComExigibilidadeTitular(Relatorio novaImpressao, DeclaracaoIRPF dec, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendAcumuladamenteTitular(Relatorio novaImpressao, DeclaracaoIRPF dec, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendaVariavel(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheARBrasil(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("ARLocal", "BRASIL");
    }

    public static void preencheARApuracaoBrasil(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("ARLocal", "BRASIL");
        novaImpressao.addParametro("ANO_RECEITA_RECEBIDA", ConstantesGlobais.ANO_BASE);
        novaImpressao.addParametro("ANO_ADIANTAMENTO", ConstantesGlobais.ANO_BASE_ANTERIOR);
        novaImpressao.addParametro("ANO_PRODUTOS_ENTREGUES", ConstantesGlobais.ANO_BASE);
    }

    public static void preencheARExterior(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("ARLocal", "EXTERIOR");
    }

    public static void preencheARApuracaoExterior(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("ARLocal", "EXTERIOR");
        novaImpressao.addParametro("ANO_RECEITA_RECEBIDA", ConstantesGlobais.ANO_BASE);
        novaImpressao.addParametro("ANO_ADIANTAMENTO", ConstantesGlobais.ANO_BASE_ANTERIOR);
        novaImpressao.addParametro("ANO_PRODUTOS_ENTREGUES", ConstantesGlobais.ANO_BASE);
    }

    public static void preencheGCAP(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheResumo(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("ANO_BASE_ANTERIOR", ConstantesGlobais.ANO_BASE_ANTERIOR);
        novaImpressao.addParametro("ANO_BASE", ConstantesGlobais.ANO_BASE);
    }

    public static void preencheDividasOnus(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheInventariante(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheSaida(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheDoacoesCampanha(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheBensDireitos(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preenchePagamentos(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("PENSAO_ALIMENTICIA_BR", "30");
        novaImpressao.addParametro("PENSAO_ALIMENTICIA_EX", "31");
        novaImpressao.addParametro("PENSAO_DIVORCIO_BR", "33");
        novaImpressao.addParametro("PENSAO_DIVORCIO_EX", "34");
        novaImpressao.addParametro("FUNPRESP", "37");
    }

    public static void preencheDoacoes(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheDependentes(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
        novaImpressao.addParametro("totDeducoesDependentes", dec.getDependentes().getTotalDeducaoDependentes().formatado());
    }

    public static void preencheAlimentandos(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheHerdeiros(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheImpostoPago(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendTribExcl(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendIsentos(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendPFDependente(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendPFTitular(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendPJDependente(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendPJComExigibilidadeDependente(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheRendAcumuladamenteDependente(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }

    public static void preencheGCME(DeclaracaoIRPF dec, Relatorio novaImpressao, boolean primeiroRelatorio) {
        if (primeiroRelatorio) {
            PreenchedorFichasImpressao.preencheRelatorioGeral(novaImpressao, dec);
        }
    }
}

