/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import serpro.ppgd.irpf.FontePagadora;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ImpostoDevidoPorDeclarante;
import serpro.ppgd.irpf.ObservadorTipoDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.CalculosBensAR;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.CalculosDividasARBrasil;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.CalculosDividasARExterior;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.bens.ColecaoRendimentoAplicacoesFinanceiras;
import serpro.ppgd.irpf.calculos.CalculosApuracaoResultadoARBrasil;
import serpro.ppgd.irpf.calculos.CalculosApuracaoResultadoARExterior;
import serpro.ppgd.irpf.calculos.CalculosBens;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.calculos.CalculosDividas;
import serpro.ppgd.irpf.calculos.CalculosDoacoes;
import serpro.ppgd.irpf.calculos.CalculosDoacoesECA;
import serpro.ppgd.irpf.calculos.CalculosDoacoesIdoso;
import serpro.ppgd.irpf.calculos.CalculosFundosInvestimentos;
import serpro.ppgd.irpf.calculos.CalculosFundosInvestimentosDependentes;
import serpro.ppgd.irpf.calculos.CalculosGanhosRendaVar;
import serpro.ppgd.irpf.calculos.CalculosItemRendPF;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.calculos.CalculosReceitaDespesaARExterior;
import serpro.ppgd.irpf.calculos.CalculosReceitasDespesasARBrasil;
import serpro.ppgd.irpf.calculos.CalculosRendAcmDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendAcmTitular;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.irpf.calculos.CalculosRendPFDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendPJComExigibilidadeDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.calculos.CalculosRendPJDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendPJTitular;
import serpro.ppgd.irpf.calculos.CalculosRendTributacaoExclusiva;
import serpro.ppgd.irpf.calculos.CalculosRendaVariavelDependentes;
import serpro.ppgd.irpf.calculos.CalculosResumo;
import serpro.ppgd.irpf.calculos.CalculosTotaisFundosInvestimentos;
import serpro.ppgd.irpf.calculos.CalculosTotaisLivroCaixa;
import serpro.ppgd.irpf.calculos.CalculosTotaisRendaVariavel;
import serpro.ppgd.irpf.calculos.CalculosTotalRendRecebidosMaisExterior;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dependentes.ValidadorCpfDepDuplicado;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.doacaodeclaracao.ValidadorDoacoesECA;
import serpro.ppgd.irpf.doacaodeclaracao.ValidadorDoacoesIdoso;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.doacoes.ValidadorDeducoesDoacoes;
import serpro.ppgd.irpf.eleicoes.CalculosDoacoesEleitorais;
import serpro.ppgd.irpf.eleicoes.DoacoesEleitorais;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.espolio.EspolioPartilha;
import serpro.ppgd.irpf.espolio.ValidadorAnoTransito;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gcap.GCAP;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.herdeiros.ValidadorNiHerdeiroDuplicado;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.pagamentos.ObservadorAlimentando;
import serpro.ppgd.irpf.pagamentos.ObservadorCPFDependente;
import serpro.ppgd.irpf.pagamentos.ObservadorCodigoPagamento;
import serpro.ppgd.irpf.pagamentos.ObservadorNomeDependente;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.ObservadorRecuperacaoPrejuizoBolsaDeValores;
import serpro.ppgd.irpf.rendIsentos.ObservadorResultadoNaoTributavel;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.ObservadorCalculosJurosRra;
import serpro.ppgd.irpf.rendacm.RendAcm;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJ;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpj.ValidadorDuplicidadeRendPJMolestiaGrave;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidade;
import serpro.ppgd.irpf.resumo.ModeloCompleta;
import serpro.ppgd.irpf.resumo.ModeloDeclaracao;
import serpro.ppgd.irpf.resumo.ModeloSimplificada;
import serpro.ppgd.irpf.resumo.ObservadorCalcImpostoHabilitaDesabilita;
import serpro.ppgd.irpf.resumo.ObservadorDebitoAutomatico;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class DeclaracaoIRPF
extends ObjetoNegocio
implements DeclaracaoComIdentificador {
    protected transient IdentificadorDeclaracao identificadorDeclaracao;
    private Contribuinte contribuinte;
    private Dependentes dependentes;
    private Alimentandos alimentandos;
    private RendPJ rendPJ;
    private RendPJComExigibilidade rendPJComExigibilidade;
    private RendPF rendPFTitular;
    private ColecaoRendPFDependente rendPFDependente;
    private RendAcm rendAcm;
    private RendIsentos rendIsentos;
    private RendTributacaoExclusiva rendTributacaoExclusiva;
    private ImpostoPago impostoPago;
    private Herdeiros herdeiros;
    private Pagamentos pagamentos;
    private Doacoes doacoes;
    private Bens bens;
    private ColecaoRendimentoAplicacoesFinanceiras rendimentosAplicacoesFinanceiras;
    private Dividas dividas;
    private Espolio espolio;
    private Resumo resumo;
    private ColecaoEstatutoCriancaAdolescente colecaoEstatutoCriancaAdolescente;
    private ColecaoEstatutoIdoso colecaoEstatutoIdoso;
    private Comparativo comparativo;
    private DoacoesEleitorais doacoesEleitorais;
    private Saida saida;
    private RendaVariavel rendaVariavel;
    private ColecaoRendaVariavelDependente rendaVariavelDependente;
    private FundosInvestimentos fundosInvestimentos;
    private ColecaoFundosInvestimentosDependente fundosInvestimentosDependente;
    private AtividadeRural atividadeRural;
    private GCAP gcap;
    private transient ModeloCompleta modeloCompleta;
    private transient ModeloSimplificada modeloSimplificada;
    private transient ModeloDeclaracao modelo;
    private IdentificadorDeclaracao copiaIdentificador = new IdentificadorDeclaracao();
    private DataHora dataHoraSalvamento = new DataHora((ObjetoNegocio)this, "dataHoraSalvamento");
    private CPF utlimoCPFAutenticado = new CPF((ObjetoNegocio)this, "Ultimo CPF Autenticado");
    private Boolean emCalamidade = Boolean.FALSE;

    public DeclaracaoIRPF(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.instanciaAtributos();
        this.adicionaObservadoresCalculos();
        this.adicionaObservadoresNegocio();
        this.adicionaValidadoresEspeciais();
    }

    private void instanciaAtributos() {
        this.contribuinte = new Contribuinte(this.identificadorDeclaracao);
        this.pagamentos = new Pagamentos(this);
        this.doacoes = new Doacoes(this);
        this.rendPJ = new RendPJ(this);
        this.rendPJComExigibilidade = new RendPJComExigibilidade(this);
        this.espolio = new Espolio(this);
        this.impostoPago = new ImpostoPago();
        this.dependentes = new Dependentes(this);
        this.rendaVariavel = new RendaVariavel(this, false);
        this.rendaVariavelDependente = new ColecaoRendaVariavelDependente(this);
        this.fundosInvestimentos = new FundosInvestimentos();
        this.fundosInvestimentosDependente = new ColecaoFundosInvestimentosDependente(this);
        this.alimentandos = new Alimentandos(this);
        this.herdeiros = new Herdeiros(this);
        this.bens = new Bens(this.identificadorDeclaracao, this);
        this.rendimentosAplicacoesFinanceiras = new ColecaoRendimentoAplicacoesFinanceiras(this);
        this.dividas = new Dividas();
        this.atividadeRural = new AtividadeRural(this.identificadorDeclaracao);
        this.gcap = new GCAP();
        this.rendPFTitular = new RendPF();
        this.rendPFDependente = new ColecaoRendPFDependente(this);
        this.rendAcm = new RendAcm(this);
        this.rendIsentos = new RendIsentos(this);
        this.rendTributacaoExclusiva = new RendTributacaoExclusiva(this);
        this.comparativo = new Comparativo();
        this.resumo = new Resumo(this.identificadorDeclaracao, this.contribuinte, this);
        this.colecaoEstatutoCriancaAdolescente = new ColecaoEstatutoCriancaAdolescente(this);
        this.colecaoEstatutoIdoso = new ColecaoEstatutoIdoso(this);
        this.doacoesEleitorais = new DoacoesEleitorais();
        this.saida = new Saida(this);
        this.modeloSimplificada = new ModeloSimplificada(this);
        this.modeloCompleta = new ModeloCompleta(this);
        this.modelo = this.modeloCompleta;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public boolean permiteInformarRendimento(int mes) {
        if (this.getIdentificadorDeclaracao().isEspolio() && !IRPFFacade.getInstancia().getDeclaracao().getEspolio().isBensInventariarMarcado()) {
            String mesDecisaoJudicial;
            Data dtLimite = this.getEspolio().obterDataLimiteParaCalculos();
            if (!dtLimite.isVazio() && !(mesDecisaoJudicial = dtLimite.getMes()).isEmpty() && mes > Integer.valueOf(mesDecisaoJudicial)) {
                return false;
            }
        } else if (this.getIdentificadorDeclaracao().isSaida()) {
            String mesCondicaoNaoResidente;
            Saida saida = IRPFFacade.getInstancia().getSaida();
            String mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
            String string = mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
            if (mes < Integer.valueOf(mesCondicaoResidente) || mes > Integer.valueOf(mesCondicaoNaoResidente)) {
                return false;
            }
        }
        return true;
    }

    private Boolean saoIguaisCpfsInventarianteConjuge(EspolioPartilha infoEspolio) {
        if (infoEspolio.getInventarioConjunto().naoFormatado().equals(Logico.SIM) && infoEspolio.getMorteAmbosConjuges().naoFormatado().equals(Logico.SIM) && infoEspolio.getCpfInventariante().naoFormatado().equals(this.getContribuinte().getCpfConjuge().naoFormatado())) {
            return true;
        }
        return false;
    }

    public void adicionaValidadoresEspeciais() {
        this.getContribuinte().getRegistroProfissional().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!(!DeclaracaoIRPF.this.getContribuinte().isOcupacaoComRegistroProfissionalObrigatorio(DeclaracaoIRPF.this.getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado()) || DeclaracaoIRPF.this.getRendPFTitular().getTotalPessoaFisica().isVazio() && DeclaracaoIRPF.this.getRendPFDependente().getTotalPessoaFisica().isVazio())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getContribuinte().getConjuge().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO) && (DeclaracaoIRPF.this.getEspolio().getPartilha().getMorteAmbosConjuges().naoFormatado().equals(Logico.SIM) || DeclaracaoIRPF.this.getEspolio().getSobrepartilha().getMorteAmbosConjuges().naoFormatado().equals(Logico.SIM))) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("contribuinte_conjuge_morto_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getContribuinte().getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                String codigoNaturezaOcupacaoAtual = DeclaracaoIRPF.this.getContribuinte().getNaturezaOcupacao().naoFormatado();
                if (!codigoNaturezaOcupacaoAtual.equals("81") && DeclaracaoIRPF.this.getGCAP().existeOperacaoTransmissaoCausaMortis()) {
                    if (DeclaracaoIRPF.this.getIdentificadorDeclaracao().isSaida()) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("gcap_tcm_sem_declaracao_espolio_com_saida"), this.getSeveridade());
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("gcap_tcm_sem_declaracao_espolio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEspolio().getPartilha().getMorteAmbosConjuges().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getEspolio().ehFinalEspolioPartilha() && DeclaracaoIRPF.this.getEspolio().getPartilha().getMorteAmbosConjuges().naoFormatado().equals(Logico.SIM) && DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_conjuge_morto_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEspolio().getSobrepartilha().getMorteAmbosConjuges().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getEspolio().ehFinalEspolioSobrepartilha() && DeclaracaoIRPF.this.getEspolio().getSobrepartilha().getMorteAmbosConjuges().naoFormatado().equals(Logico.SIM) && DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_conjuge_morto_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEspolio().getPartilha().getConjugeMeeiro().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getEspolio().ehFinalEspolioPartilha() && DeclaracaoIRPF.this.getEspolio().getPartilha().getConjugeMeeiro().naoFormatado().equals(Logico.SIM) && DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_conjuge_meeiro_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEspolio().getSobrepartilha().getConjugeMeeiro().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getEspolio().ehFinalEspolioSobrepartilha() && DeclaracaoIRPF.this.getEspolio().getSobrepartilha().getConjugeMeeiro().naoFormatado().equals(Logico.SIM) && DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_conjuge_meeiro_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getContribuinte().getConjuge().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.NAO) && DeclaracaoIRPF.this.getEspolio().obterInformacoEspolioParaCalculos().getConjugeMeeiro().naoFormatado().equals(Logico.SIM)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("contribuinte_conjuge_meeiro_obrigatorio"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getContribuinte().getCpfConjuge().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getContribuinte().getConjuge().naoFormatado().equals(Logico.SIM)) {
                    if (DeclaracaoIRPF.this.getEspolio().getPartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM) || DeclaracaoIRPF.this.getEspolio().getPartilha().getConjugeMeeiro().naoFormatado().equals(Logico.SIM) || DeclaracaoIRPF.this.getEspolio().getSobrepartilha().getInventarioConjunto().naoFormatado().equals(Logico.SIM) || DeclaracaoIRPF.this.getEspolio().getSobrepartilha().getConjugeMeeiro().naoFormatado().equals(Logico.SIM)) {
                        this.setSeveridade((byte)3);
                    } else {
                        this.setSeveridade((byte)2);
                    }
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getEspolio().getPartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if ((DeclaracaoIRPF.this.getEspolio().ehInicialPartilha() || DeclaracaoIRPF.this.getEspolio().ehFinalEspolioPartilha()) && DeclaracaoIRPF.this.saoIguaisCpfsInventarianteConjuge(DeclaracaoIRPF.this.getEspolio().getPartilha()).booleanValue()) {
                    String[] args = new String[]{"CPF do Inventariante", "campo indicativo \"CPF do C\u00f4njuge ou Companheiro(a)\""};
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_iguais", args), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEspolio().getSobrepartilha().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if ((DeclaracaoIRPF.this.getEspolio().ehInicialSobrepartilha() || DeclaracaoIRPF.this.getEspolio().ehFinalEspolioSobrepartilha()) && DeclaracaoIRPF.this.saoIguaisCpfsInventarianteConjuge(DeclaracaoIRPF.this.getEspolio().getSobrepartilha()).booleanValue()) {
                    String[] args = new String[]{"CPF do Inventariante", "campo indicativo \"CPF do C\u00f4njuge ou Companheiro(a)\""};
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_iguais", args), this.getSeveridade());
                }
                return null;
            }
        });
        this.getContribuinte().getCpfConjuge().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if ((DeclaracaoIRPF.this.getEspolio().ehInicialSobrepartilha() || DeclaracaoIRPF.this.getEspolio().ehFinalEspolioSobrepartilha()) && DeclaracaoIRPF.this.saoIguaisCpfsInventarianteConjuge(DeclaracaoIRPF.this.getEspolio().getSobrepartilha()).booleanValue() || (DeclaracaoIRPF.this.getEspolio().ehInicialPartilha() || DeclaracaoIRPF.this.getEspolio().ehFinalEspolioPartilha()) && DeclaracaoIRPF.this.saoIguaisCpfsInventarianteConjuge(DeclaracaoIRPF.this.getEspolio().getPartilha()).booleanValue()) {
                    String[] args = new String[]{"CPF do C\u00f4njuge ou Companheiro(a)", DeclaracaoIRPF.this.getHerdeiros().isExisteNi(DeclaracaoIRPF.this.getContribuinte().getCpfConjuge().naoFormatado()) ? "campo indicativo \"CPF do Inventariante\" e do campo indicativo \"CPF do Herdeiro\"" : "campo indicativo \"CPF do Inventariante\""};
                    return new RetornoValidacao(MensagemUtil.getMensagem("espolio_cpf_iguais", args), this.getSeveridade());
                }
                return null;
            }
        });
        this.getRendPJ().getColecaoRendPJTitular().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    RendPJTitular item = (RendPJTitular)((Object)valorNovo);
                    String cpf = DeclaracaoIRPF.this.getIdentificadorDeclaracao().getCpf().naoFormatado();
                    item.getContribuicaoPrevOficial().addValidador((ValidadorIf)new ValidadorDuplicidadeRendPJMolestiaGrave(cpf, item, DeclaracaoIRPF.this.getRendIsentos().getPensaoQuadroAuxiliar()));
                }
            }
        });
        this.getRendPJ().getColecaoRendPJDependente().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    RendPJDependente item = (RendPJDependente)((Object)valorNovo);
                    String cpf = item.getCpfDependente().naoFormatado();
                    item.getContribuicaoPrevOficial().addValidador((ValidadorIf)new ValidadorDuplicidadeRendPJMolestiaGrave(cpf, item, DeclaracaoIRPF.this.getRendIsentos().getPensaoQuadroAuxiliar()));
                }
            }
        });
        this.getDoacoes().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((Doacao)valorNovo).getValorPago().addValidador((ValidadorIf)new ValidadorDeducoesDoacoes(1, DeclaracaoIRPF.this, (Doacao)valorNovo));
                }
            }
        });
        this.getGCAP().getIds().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((IdDemonstrativoGCAP)valorNovo).getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

                        public RetornoValidacao validarImplementado() {
                            boolean achou = false;
                            if (!this.getInformacao().naoFormatado().equals(DeclaracaoIRPF.this.getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                                for (Dependente dependente : DeclaracaoIRPF.this.getDependentes().itens()) {
                                    if (!this.getInformacao().naoFormatado().equals(dependente.getCpfDependente().naoFormatado())) continue;
                                    achou = true;
                                    break;
                                }
                            } else {
                                achou = true;
                            }
                            if (achou) {
                                return null;
                            }
                            return new RetornoValidacao(MensagemUtil.getMensagem("gcap_contribuinte_inexistente", new String[]{this.getInformacao().formatado()}), 3);
                        }
                    });
                }
            }
        });
        this.getImpostoPago().getImpostoRetidoFonte().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF.this.setFicha("Imposto Pago");
                boolean temIRRF = DeclaracaoIRPF.this.getRendaVariavel().temIRRF() || DeclaracaoIRPF.this.getRendaVariavelDependente().temIRRF() || DeclaracaoIRPF.this.getFundosInvestimentos().temIRRF() || DeclaracaoIRPF.this.getFundosInvestimentosDependente().temIRRF();
                boolean temAlienacaoAcoes = DeclaracaoIRPF.this.getGCAP().temAlienacaoDeAcoes();
                if (!(DeclaracaoIRPF.this.getImpostoPago().isVazio() || temIRRF || temAlienacaoAcoes)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("imposto_retido_rendvar_vazio"), 3);
                }
                return null;
            }
        });
        this.getDependentes().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((Dependente)((Object)valorNovo)).getCpfDependente().addValidador((ValidadorIf)new ValidadorCpfDepDuplicado(3, (Object)DeclaracaoIRPF.this.getDependentes(), valorNovo));
                    ((Dependente)((Object)valorNovo)).getCpfDependente().addValidador((ValidadorIf)new ValidadorDefault(2){

                        public RetornoValidacao validarImplementado() {
                            for (Alimentando alim : DeclaracaoIRPF.this.getAlimentandos().itens()) {
                                CPF cpfInfo = (CPF)this.getInformacao();
                                if (!cpfInfo.naoFormatado().equals(alim.getCpf().naoFormatado())) continue;
                                return new RetornoValidacao(MensagemUtil.getMensagem("dependente_cpf_igual_alimentando", new String[]{ConstantesGlobais.ANO_BASE}), this.getSeveridade());
                            }
                            return null;
                        }
                    });
                }
            }
        });
        this.getDependentes().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, final Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((Dependente)((Object)valorNovo)).getDummy().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                        public RetornoValidacao validarImplementado() {
                            Valor deducoes;
                            Dependente dependente = (Dependente)((Object)valorNovo);
                            if (!Dependente.CODIGO_DEPENDENTE_DEFICIENTE.equals(dependente.getCodigo().naoFormatado())) {
                                return null;
                            }
                            Valor rendimentos = DeclaracaoIRPF.this.getDependentes().obterTotalRendimentosPorDependenteDeficiente(dependente.getCpfDependente());
                            if (rendimentos.comparacao(">", deducoes = DeclaracaoIRPF.this.getDependentes().obterTotalDeducoesPorDependenteDeficiente(dependente.getCpfDependente(), rendimentos))) {
                                return new RetornoValidacao(MensagemUtil.getMensagem("dependente_deficiente_excedeu_limite_rendimentos", new String[]{rendimentos.formatado(), deducoes.formatado()}), this.getSeveridade());
                            }
                            return null;
                        }
                    });
                }
            }
        });
        this.getAlimentandos().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((Alimentando)((Object)valorNovo)).getNome().addValidador((ValidadorIf)new ValidadorDefault(2){

                        public RetornoValidacao validarImplementado() {
                            if (DeclaracaoIRPF.this.getAlimentandos().isNomeDuplicado(this.getInformacao().naoFormatado())) {
                                return new RetornoValidacao(MensagemUtil.getMensagem("alimentando_nome_duplicado"), this.getSeveridade());
                            }
                            return null;
                        }
                    });
                }
            }
        });
        this.getHerdeiros().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((Herdeiro)((Object)valorNovo)).getNiHerdeiro().addValidador((ValidadorIf)new ValidadorNiHerdeiroDuplicado(3, (Object)DeclaracaoIRPF.this.getHerdeiros(), valorNovo));
                }
            }
        });
        this.getColecaoEstatutoCriancaAdolescente().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((EstatutoCriancaAdolescente)((Object)valorNovo)).getValor().addValidador((ValidadorIf)new ValidadorDoacoesECA(DeclaracaoIRPF.this));
                }
            }
        });
        this.getColecaoEstatutoIdoso().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("ObjetoInserido")) {
                    ((EstatutoIdoso)((Object)valorNovo)).getValor().addValidador((ValidadorIf)new ValidadorDoacoesIdoso(DeclaracaoIRPF.this));
                }
            }
        });
        if (this.getIdentificadorDeclaracao().isAjuste()) {
            this.getContribuinte().getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorDefault(2){

                public RetornoValidacao validarImplementado() {
                    if (DeclaracaoIRPF.this.getContribuinte().getNaturezaOcupacao().naoFormatado().equals("81") && (DeclaracaoIRPF.this.getEspolio().ehInicialPartilha() && DeclaracaoIRPF.this.getEspolio().getPartilha().isVazio() || DeclaracaoIRPF.this.getEspolio().ehInicialSobrepartilha() && DeclaracaoIRPF.this.getEspolio().getSobrepartilha().isVazio())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("natureza_espolio_sem_ficha_espolio"), this.getSeveridade());
                    }
                    return null;
                }
            });
        }
        this.getRendPFTitular().getNITPISPASEP().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getRendPFTitular().getNITPISPASEP().isVazio() && DeclaracaoIRPF.this.contribuinte.getNaturezaOcupacao().naoFormatado().equals("11") && DeclaracaoIRPF.this.rendPFTitular.getContasAno().existeLancamento()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("contribuinte_autonomo"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getRendPFTitular().getNITPISPASEP().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoIRPF.this.getRendPFTitular().getNITPISPASEP().isVazio() && DeclaracaoIRPF.this.getRendPFTitular().getTotalPrevidencia().comparacao(">", "0,00")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("contribuinte_previdencia_pf_sem_nit_pis_pasep"), this.getSeveridade());
                }
                return null;
            }
        });
        final Observador obsNovaContaRendPF = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo instanceof Conta) {
                    Conta item = (Conta)((Object)valorNovo);
                    item.getCpfDeclaranteIRPF().setConteudo(DeclaracaoIRPF.this.getIdentificadorDeclaracao().getCpf());
                }
            }
        };
        this.getRendPFDependente().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo instanceof ItemRendPFDependente) {
                    ItemRendPFDependente item = (ItemRendPFDependente)((Object)valorNovo);
                    for (int i = 0; i < 11; ++i) {
                        MesRendPF mes = item.getRendimentos().getMesRendPFPorIndice(i);
                        for (Conta conta : mes.getContasMes().itens()) {
                            obsNovaContaRendPF.notifica((Object)mes.getContasMes(), "ObjetoInserido", null, (Object)conta);
                        }
                        mes.getContasMes().addObservador("ObjetoInserido", obsNovaContaRendPF);
                    }
                }
            }
        });
        for (int i = 0; i < 11; ++i) {
            this.getRendPFTitular().getMesRendPFPorIndice(i).getContasMes().addObservador("ObjetoInserido", obsNovaContaRendPF);
        }
        this.getResumo().getCalculoImposto().getBanco().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                boolean flagDebito;
                boolean impostoAPagar = DeclaracaoIRPF.this.getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00");
                boolean bl = flagDebito = impostoAPagar;
                if (!DeclaracaoIRPF.this.getResumo().getCalculoImposto().validarContaBancaria(CadastroTabelasIRPF.obterBensComContasCadastradas(DeclaracaoIRPF.this.getBens(), flagDebito))) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_info_bancarias_vazia"), 3);
                }
                return null;
            }
        });
        if (this.getIdentificadorDeclaracao().isEspolio()) {
            this.getEspolio().getPartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorAnoTransito("partilha"));
            this.getEspolio().getSobrepartilha().getDecisaoJudicial().getDtTransito().addValidador((ValidadorIf)new ValidadorAnoTransito("sobrepartilha"));
        }
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        this.verificaLivroCaixa(numeroItem, retorno);
        return retorno;
    }

    protected void verificaLivroCaixa(int numeroItem, List<Pendencia> retorno) {
        Valor infoPendencia = null;
        if (!this.getRendPFTitular().isVazio()) {
            infoPendencia = this.getRendPFTitular().getTotalPessoaFisica();
            infoPendencia.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
        } else if (!this.getRendPFDependente().itens().isEmpty()) {
            infoPendencia = ((ItemRendPFDependente)((Object)this.getRendPFDependente().itens().get(0))).getRendimentos().getTotalPessoaFisica();
            infoPendencia.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        } else {
            infoPendencia = this.getRendPFTitular().getTotalPessoaFisica();
            infoPendencia.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
        }
        if (!this.identificadorDeclaracao.getTipoDeclaracao().naoFormatado().equals("1") && this.getModelo().getTotalLimiteLivroCaixa().comparacao("<", this.getModelo().getTotalLivroCaixa())) {
            Pendencia p = new Pendencia(3, (Informacao)infoPendencia, "Livro Caixa", MensagemUtil.getMensagem("rend_maior_livro_caixa"), -1);
            p.setClassePainel(NavegacaoIf.PAINEL_REND_TRIB_RECEB_PF_EXT);
            p.setNomeAba(infoPendencia.getFicha().equals("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular") ? "Titular" : "Dependentes");
            retorno.add(p);
        }
    }

    public void adicionaObservadoresCalculos() {
        CalculosItemRendPF calculosRendPFTitular = new CalculosItemRendPF(this.getRendPFTitular());
        this.getRendPFTitular().addObservador((Observador)calculosRendPFTitular);
        this.getRendPFDependente().addObservador((Observador)new CalculosRendPFDependentes(this.getRendPFDependente()));
        CalculosRendPJTitular calculosRendPJTitular = new CalculosRendPJTitular(this.getColecaoRendPJTitular(), this);
        CalculosRendPJDependentes calculosRendPJDependente = new CalculosRendPJDependentes((ColecaoRendPJTitular)this.getColecaoRendPJDependente(), this);
        this.getColecaoRendPJTitular().addObservador((Observador)calculosRendPJTitular);
        this.getColecaoRendPJDependente().addObservador((Observador)calculosRendPJDependente);
        CalculosRendPJComExigibilidadeTitular calculosRendPJComExigibilidadeTitular = new CalculosRendPJComExigibilidadeTitular(this.getColecaoRendPJComExigibilidadeTitular());
        CalculosRendPJComExigibilidadeDependentes calculosRendPJComExigibilidadeDependentes = new CalculosRendPJComExigibilidadeDependentes((ColecaoRendPJComExigibilidadeTitular)this.getColecaoRendPJComExigibilidadeDependente());
        this.getColecaoRendPJComExigibilidadeTitular().addObservador((Observador)calculosRendPJComExigibilidadeTitular);
        this.getColecaoRendPJComExigibilidadeDependente().addObservador((Observador)calculosRendPJComExigibilidadeDependentes);
        CalculosRendAcmTitular calculosRendAcmTitular = new CalculosRendAcmTitular(this.getColecaoRendAcmTitular(), this);
        CalculosRendAcmDependentes calculosRendAcmDependentes = new CalculosRendAcmDependentes(this.getColecaoRendAcmDependente(), this);
        this.getColecaoRendAcmTitular().addObservador((Observador)calculosRendAcmTitular);
        this.getColecaoRendAcmDependente().addObservador((Observador)calculosRendAcmDependentes);
        CalculosTotalRendRecebidosMaisExterior calculosTotalRendimentosTributaveis = new CalculosTotalRendRecebidosMaisExterior(this);
        this.getColecaoRendPJTitular().getTotaisRendRecebidoPJ().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getColecaoRendPJDependente().getTotaisRendRecebidoPJ().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFTitular().getTotalPessoaFisica().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFTitular().getTotalAlugueis().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFTitular().getTotalOutros().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFTitular().getTotalExterior().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFDependente().getTotalPessoaFisica().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFDependente().getTotalAlugueis().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFDependente().getTotalOutros().addObservador((Observador)calculosTotalRendimentosTributaveis);
        this.getRendPFDependente().getTotalExterior().addObservador((Observador)calculosTotalRendimentosTributaveis);
        CalculosTotaisLivroCaixa calculosTotaisLivroCaixa = new CalculosTotaisLivroCaixa(this);
        this.getRendPFTitular().getTotalLivroCaixa().addObservador((Observador)calculosTotaisLivroCaixa);
        this.getRendPFDependente().getTotalLivroCaixa().addObservador((Observador)calculosTotaisLivroCaixa);
        CalculosRendIsentos calculosRendIsentos = new CalculosRendIsentos(this.getRendIsentos());
        this.getRendIsentos().addObservador(calculosRendIsentos);
        CalculosRendTributacaoExclusiva calcRendTributacaoExclusiva = new CalculosRendTributacaoExclusiva(this);
        this.getRendTributacaoExclusiva().addObservador((Observador)calcRendTributacaoExclusiva);
        this.getColecaoRendPJTitular().getTotaisDecimoTerceiro().addObservador((Observador)calcRendTributacaoExclusiva);
        this.getColecaoRendPJDependente().getTotaisDecimoTerceiro().addObservador((Observador)calcRendTributacaoExclusiva);
        this.getBens().addObservador((Observador)new CalculosBens(this.getBens()));
        this.getDividas().addObservador((Observador)new CalculosDividas(this.getDividas()));
        this.getPagamentos().addObservador((Observador)new CalculosPagamentos(this));
        this.getDoacoes().addObservador((Observador)new CalculosDoacoes(this));
        this.getColecaoEstatutoCriancaAdolescente().addObservador((Observador)new CalculosDoacoesECA(this));
        this.getColecaoEstatutoIdoso().addObservador((Observador)new CalculosDoacoesIdoso(this));
        CalculosDeducoesIncentivos calculosDeducoesIncentivos = new CalculosDeducoesIncentivos(this);
        this.getModeloCompleta().getImposto().addObservador((Observador)calculosDeducoesIncentivos);
        this.getDoacoesEleitorais().addObservador(new CalculosDoacoesEleitorais(this));
        this.getAtividadeRural().getBrasil().getReceitasDespesas().addObservadorCalculosTotais((Observador)new CalculosReceitasDespesasARBrasil(this));
        this.getAtividadeRural().getExterior().getReceitasDespesas().addObservador((Observador)new CalculosReceitaDespesaARExterior(this));
        this.getRendaVariavel().adicionarObservadorCalculosTotaisRendaVariavel((Observador)new CalculosTotaisRendaVariavel(this.getRendaVariavel()));
        CalculosFundosInvestimentos calFundInvest = null;
        for (int i = 0; i < 12; ++i) {
            calFundInvest = new CalculosFundosInvestimentos(this.getFundosInvestimentos().getMeses()[i], this.getFundosInvestimentos());
            this.getFundosInvestimentos().getMeses()[i].getResultLiquidoMes().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getResultNegativoAnterior().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getBaseCalcImposto().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getImpostoRetidoMesesAnteriores().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getImpostoRetidoFonte().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getImpostoDevido().addObservador((Observador)calFundInvest);
            this.getFundosInvestimentos().getMeses()[i].getImpostoPago().addObservador((Observador)calFundInvest);
            if (i <= 0) continue;
            this.getFundosInvestimentos().getMeses()[i - 1].getPrejuizoCompensar().addObservador((Observador)calFundInvest);
        }
        this.getFundosInvestimentos().adicionarCalculosTotaisFundInvest((Observador)new CalculosTotaisFundosInvestimentos(this.getFundosInvestimentos()));
        CalculosGanhosRendaVar calcGanhosRendaVar = new CalculosGanhosRendaVar(this.getRendaVariavel(), this.getRendaVariavelDependente(), this.getFundosInvestimentos(), this.getFundosInvestimentosDependente(), this.getRendTributacaoExclusiva());
        this.getFundosInvestimentos().adicionarObservGanhosFundInvest((Observador)calcGanhosRendaVar);
        this.getRendaVariavel().adicionarObservGanhosRendaVar((Observador)calcGanhosRendaVar);
        this.getRendaVariavelDependente().addObservador((Observador)new CalculosRendaVariavelDependentes(this.getRendaVariavelDependente()));
        this.getRendaVariavelDependente().adicionarObservGanhosRendaVar((Observador)calcGanhosRendaVar);
        this.getFundosInvestimentosDependente().addObservador((Observador)new CalculosFundosInvestimentosDependentes(this.getFundosInvestimentosDependente()));
        this.getFundosInvestimentosDependente().adicionarObservGanhosFundInvest((Observador)calcGanhosRendaVar);
    }

    public void adicionaObservadoresCalculosLate() {
        CalculosResumo calculosResumo = new CalculosResumo(this);
        this.identificadorDeclaracao.getTipoDeclaracao().addObservador((Observador)calculosResumo);
        this.getContribuinte().getImpostoDevidoLei14754().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalPessoaFisica().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalAlugueis().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalOutros().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalExterior().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalPrevidencia().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalDependentes().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalPensao().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalLivroCaixa().addObservador((Observador)calculosResumo);
        this.getRendPFDependente().getTotalDarfPago().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalPessoaFisica().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalAlugueis().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalOutros().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalExterior().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalPrevidencia().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalDependentes().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalPensao().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalLivroCaixa().addObservador((Observador)calculosResumo);
        this.getRendPFTitular().getTotalDarfPago().addObservador((Observador)calculosResumo);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().addObservador((Observador)calculosResumo);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisRendRecebidoPJ().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisRendRecebidoPJ().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFTitular().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFDependentes().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioTitular().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioDependentes().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialTitular().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialDependentes().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getLucroRecebidoQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getLucroRecebido().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getParcIsentaAposentadoria().setConteudo((String)valorNovo);
                DeclaracaoIRPF.this.getRendIsentos().getParcIsentaAposentadoria().append('+', (Valor)((DeclaracaoIRPF)((Object)DeclaracaoIRPF.this.getRendIsentos().getOutrosQuadroAuxiliar().getDec().get())).getRendAcm().obterTotalParcela65AnosAjuste());
            }
        });
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getPensao().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getPoupancaQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getPoupanca().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getRendSocioQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getRendSocio().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getTransferenciasQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getTransferencias().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getRendAssalariadosMoedaEstrangeira().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getIncorporacaoReservaCapital().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getMedicosResidentesQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getMedicosResidentes().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getVoluntariosCopaQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getVoluntariosCopa().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getMeacaoDissolucao().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getGanhosLiquidosAcoes().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getGanhosCapitalOuro().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getBolsaEstudosQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getBolsaEstudos().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getIndenizacoesQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getIndenizacoes().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmente().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getOutrosQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getOutros().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getPensaoAlimenticiaQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendIsentos().getPensaoAlimenticia().setConteudo((String)valorNovo);
            }
        });
        this.getRendIsentos().getLucroRecebidoQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getPensaoQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getPoupancaQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getRendSocioQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getTransferenciasQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getMedicosResidentesQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getVoluntariosCopaQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getBolsaEstudosQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getIndenizacoesQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getOutrosQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendIsentos().getPensaoAlimenticiaQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendTributacaoExclusiva().getRendAplicacoes().setConteudo((String)valorNovo);
            }
        });
        this.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendTributacaoExclusiva().getJurosCapitalProprio().setConteudo((String)valorNovo);
            }
        });
        this.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendTributacaoExclusiva().getParticipacaoLucrosResultados().setConteudo((String)valorNovo);
            }
        });
        this.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getRendTributacaoExclusiva().getOutros().setConteudo((String)valorNovo);
            }
        });
        this.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar().getTotais().forcaDisparoObservadores();
        this.getRendAcm().getColecaoRendAcmTitular().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisContribuicaoPrevOficialAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisContribuicaoPrevOficialAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoDevidoRRA().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoDevidoRRA().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteExclusiva().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteExclusiva().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisPensaoAlimenticia().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisPensaoAlimenticia().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisJuros().addObservador((Observador)calculosResumo);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisJuros().addObservador((Observador)calculosResumo);
        ObservadorCalculosJurosRra jurosRra = new ObservadorCalculosJurosRra(this);
        this.getRendAcm().getColecaoRendAcmTitular().getTotaisJuros().addObservador((Observador)jurosRra);
        this.getRendAcm().getColecaoRendAcmDependente().getTotaisJuros().addObservador((Observador)jurosRra);
        this.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().getTotaisRendPJExigSuspensa().addObservador((Observador)calculosResumo);
        this.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().getTotaisRendPJExigSuspensa().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoComplementar().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoRetidoFonte().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoPagoExterior().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoRetidoFonteTitular().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoRetidoFonteDependentes().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getCarneLeaoTitular().addObservador((Observador)calculosResumo);
        this.getRendIsentos().getTotal().addObservador((Observador)calculosResumo);
        this.getRendTributacaoExclusiva().getTotal().addObservador((Observador)calculosResumo);
        this.getBens().addObservador((Observador)calculosResumo);
        this.getBens().getTotalExercicioAnterior().addObservador((Observador)calculosResumo);
        this.getBens().getTotalExercicioAtual().addObservador((Observador)calculosResumo);
        Observador obsRecalcularLei14754 = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DeclaracaoIRPF.this.getBens().recalcularDemonstrativoAplicacoesFinanceirasExterior(DeclaracaoIRPF.this);
            }
        };
        for (Bem bem : this.getBens().itens()) {
            bem.getLucroPrejuizo().addObservador(obsRecalcularLei14754);
            bem.getImpostoPagoExterior().addObservador(obsRecalcularLei14754);
            bem.getValorRecebido().addObservador(obsRecalcularLei14754);
            bem.getImpostoPagoExteriorIRRF().addObservador(obsRecalcularLei14754);
        }
        this.getDividas().addObservador((Observador)calculosResumo);
        this.getDividas().getTotalExercicioAnterior().addObservador((Observador)calculosResumo);
        this.getDividas().getTotalExercicioAtual().addObservador((Observador)calculosResumo);
        this.getEspolio().getIndicadorSobrepartilha().addObservador((Observador)calculosResumo);
        this.getEspolio().getPartilha().getDecisaoJudicial().getDtDecisaoJud().addObservador((Observador)calculosResumo);
        this.getEspolio().getSobrepartilha().getDecisaoJudicial().getDtDecisaoJud().addObservador((Observador)calculosResumo);
        this.getEspolio().getPartilha().getEscrituracaoPublica().getDataLavratura().addObservador((Observador)calculosResumo);
        this.getEspolio().getSobrepartilha().getEscrituracaoPublica().getDataLavratura().addObservador((Observador)calculosResumo);
        this.getSaida().getDtCondicaoNaoResidente().addObservador((Observador)calculosResumo);
        this.getSaida().getDtCondicaoResidente().addObservador((Observador)calculosResumo);
        this.getPagamentos().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalDeducoesInstrucao().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalContribuicaoPreviPrivada().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalContribuicaoFunpresp().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalDespesasMedicas().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalPensao().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalPensaoCartoral().addObservador((Observador)calculosResumo);
        this.getPagamentos().getTotalContribEmpregadoDomestico().addObservador((Observador)calculosResumo);
        this.getDoacoes().addObservador((Observador)calculosResumo);
        this.getDoacoes().getTotalDeducaoIncentivo().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoCriancaAdolescente().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoLiquido().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoIdoso().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoLiquido().addObservador((Observador)calculosResumo);
        this.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto().addObservador((Observador)calculosResumo);
        this.getRendaVariavel().getTotalImpostoRetidoFonteLei11033().addObservador((Observador)calculosResumo);
        this.getRendaVariavel().getTotalImpostoAPagar().addObservador((Observador)calculosResumo);
        this.getRendaVariavel().getTotalImpostoPago().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentos().getTotalImpostoPago().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentos().getTotalImpostoDevido().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033().addObservador((Observador)calculosResumo);
        this.getRendaVariavelDependente().getTotalImpostoRetidoFonteLei11033().addObservador((Observador)calculosResumo);
        this.getRendaVariavelDependente().getTotalImpostoAPagar().addObservador((Observador)calculosResumo);
        this.getRendaVariavelDependente().getTotalImpostoPago().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentosDependente().getTotalImpostoPago().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentosDependente().getTotalImpostoDevido().addObservador((Observador)calculosResumo);
        this.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033().addObservador((Observador)calculosResumo);
        this.getDependentes().getTotalDeducaoDependentes().addObservador((Observador)calculosResumo);
        this.getDoacoesEleitorais().getTotalDoacoes().addObservador((Observador)calculosResumo);
        this.getGCAP().getConsolidacaoGeralBrasil().getValorIRF().addObservador((Observador)calculosResumo);
        this.getImpostoPago().getImpostoComplementar().forcaDisparoObservadores();
        CalculosApuracaoResultadoARBrasil apuracaoResultadoARBrasil = new CalculosApuracaoResultadoARBrasil(this);
        this.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalReceita().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalDespesas().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getPrejuizoExercicioAnterior().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getReceitaRecebidaContaVenda().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getValorAdiantamento().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getOpcaoFormaApuracao().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getCompensacaoPrejuizoExerciciosAnteriores().addObservador((Observador)apuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getPrejuizoExercicioAnterior().forcaDisparoObservadores();
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getReceitaRecebidaContaVenda().forcaDisparoObservadores();
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getValorAdiantamento().forcaDisparoObservadores();
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getOpcaoFormaApuracao().forcaDisparoObservadores();
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getCompensacaoPrejuizoExerciciosAnteriores().forcaDisparoObservadores();
        CalculosApuracaoResultadoARExterior calculosApuracaoResultadoARExterior = new CalculosApuracaoResultadoARExterior(this);
        this.getAtividadeRural().getExterior().getReceitasDespesas().getTotais().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoI_EmReais().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getPrejuizoExercicioAnterior().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getLimiteVintePorCentoReceitaBruta().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getReceitaRecebidaContaVenda().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getValorAdiantamento().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getOpcaoFormaApuracao().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getCompensacaoPrejuizoExerciciosAnteriores().addObservador((Observador)calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoI_EmReais().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getPrejuizoExercicioAnterior().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getLimiteVintePorCentoReceitaBruta().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getReceitaRecebidaContaVenda().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getValorAdiantamento().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getOpcaoFormaApuracao().forcaDisparoObservadores();
        this.getAtividadeRural().getExterior().getApuracaoResultado().getCompensacaoPrejuizoExerciciosAnteriores().forcaDisparoObservadores();
        if (this.getIdentificadorDeclaracao().getNumReciboTransmitido().naoFormatado().equals("0000000000")) {
            this.getAtividadeRural().getBens().addObservador(new CalculosBensAR(this.getAtividadeRural().getBens()));
            this.getAtividadeRural().getBrasil().getDividas().addObservador(new CalculosDividasARBrasil(this.getAtividadeRural().getBrasil().getDividas()));
            this.getAtividadeRural().getExterior().getDividas().addObservador(new CalculosDividasARExterior(this.getAtividadeRural().getExterior().getDividas()));
            for (BemAR bemAR : this.getAtividadeRural().getBens().itens()) {
                bemAR.addObservador(new CalculosBensAR(this.getAtividadeRural().getBens()));
            }
            if (!this.getAtividadeRural().getBens().isVazio()) {
                ((BemAR)this.getAtividadeRural().getBens().itens().get(0)).getValorExercicioAnterior().forcaDisparoObservadores();
                ((BemAR)this.getAtividadeRural().getBens().itens().get(0)).getValorExercicioAtual().forcaDisparoObservadores();
            }
            for (DividaAR dividaAR : this.getAtividadeRural().getBrasil().getDividas().itens()) {
                dividaAR.addObservador(new CalculosDividasARBrasil(this.getAtividadeRural().getBrasil().getDividas()));
            }
            if (!this.getAtividadeRural().getBrasil().getDividas().isVazio()) {
                ((DividaAR)((Object)this.getAtividadeRural().getBrasil().getDividas().itens().get(0))).getContraidasAteExercicioAnterior().forcaDisparoObservadores();
                ((DividaAR)((Object)this.getAtividadeRural().getBrasil().getDividas().itens().get(0))).getContraidasAteExercicioAtual().forcaDisparoObservadores();
                ((DividaAR)((Object)this.getAtividadeRural().getBrasil().getDividas().itens().get(0))).getValorPagamentoAnual().forcaDisparoObservadores();
            }
            for (DividaAR dividaAR : this.getAtividadeRural().getExterior().getDividas().itens()) {
                dividaAR.addObservador(new CalculosDividasARExterior(this.getAtividadeRural().getExterior().getDividas()));
            }
            if (!this.getAtividadeRural().getExterior().getDividas().isVazio()) {
                ((DividaAR)((Object)this.getAtividadeRural().getExterior().getDividas().itens().get(0))).getContraidasAteExercicioAnterior().forcaDisparoObservadores();
                ((DividaAR)((Object)this.getAtividadeRural().getExterior().getDividas().itens().get(0))).getContraidasAteExercicioAtual().forcaDisparoObservadores();
                ((DividaAR)((Object)this.getAtividadeRural().getExterior().getDividas().itens().get(0))).getValorPagamentoAnual().forcaDisparoObservadores();
            }
        }
        ObservadorDebitoAutomatico observadorDebitoAutomatico = new ObservadorDebitoAutomatico(this.getResumo().getCalculoImposto());
        ObservadorCalcImpostoHabilitaDesabilita observadorCalcImpostoHabilitaDesabilita = new ObservadorCalcImpostoHabilitaDesabilita(this.getResumo().getCalculoImposto());
        this.getResumo().getCalculoImposto().getDebitoAutomatico().addObservador((Observador)observadorDebitoAutomatico);
        this.getIdentificadorDeclaracao().getDeclaracaoRetificadora().addObservador((Observador)observadorDebitoAutomatico);
        this.getContribuinte().getExterior().addObservador((Observador)observadorDebitoAutomatico);
        observadorDebitoAutomatico.habilitaDesabilitaDadosBancarios();
        this.getResumo().getCalculoImposto().getSaldoImpostoPagar().addObservador((Observador)observadorCalcImpostoHabilitaDesabilita);
        this.getResumo().getCalculoImposto().getSaldoImpostoPagar().addObservador((Observador)observadorDebitoAutomatico);
        observadorCalcImpostoHabilitaDesabilita.habilitadesabilitaDados();
        this.getResumo().getCalculoImposto().getImpostoRestituir().addObservador((Observador)observadorCalcImpostoHabilitaDesabilita);
        this.getResumo().getCalculoImposto().getImpostoRestituir().addObservador((Observador)observadorDebitoAutomatico);
        this.getContribuinte().getDeclaracaoRetificadora().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                try {
                    if (DeclaracaoIRPF.this.getContribuinte().getDeclaracaoRetificadora().naoFormatado().equals(Logico.SIM) && !ControladorGui.emFaseEntrega((boolean)DeclaracaoIRPF.this.getEmCalamidade())) {
                        DeclaracaoIRPF.this.getContribuinte().getEnderecoDiferente().setConteudo(Logico.NAO);
                    }
                }
                catch (AplicacaoException aplicacaoException) {
                    // empty catch block
                }
            }
        });
        this.getContribuinte().getDeclaracaoRetificadora().forcaDisparoObservadores();
    }

    public void adicionaObservadoresNegocio() {
        ObservadorTipoDeclaracao observadorTipoDeclaracao = new ObservadorTipoDeclaracao(this);
        this.identificadorDeclaracao.getTipoDeclaracao().addObservador((Observador)observadorTipoDeclaracao);
        this.getPagamentos().addObservador(new ObservadorCodigoPagamento());
        this.getDependentes().addObservador(new ObservadorNomeDependente(this));
        this.getDependentes().addObservador(new ObservadorCPFDependente(this));
        this.getAlimentandos().addObservador(new ObservadorAlimentando(this));
        ObservadorResultadoNaoTributavel observadorResultadoNaoTributavel = new ObservadorResultadoNaoTributavel(this);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoNaoTributavel().addObservador((Observador)observadorResultadoNaoTributavel);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoNaoTributavel().addObservador((Observador)observadorResultadoNaoTributavel);
        ObservadorRecuperacaoPrejuizoBolsaDeValores observadorRecuperacaoPrejuizoBolsaDeValores = new ObservadorRecuperacaoPrejuizoBolsaDeValores(this);
        this.getRendaVariavel().getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().addObservador(observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getRendaVariavel().getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().addObservador(observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getRendaVariavel().getDezembro().getOperacoesComuns().getPrejuizoCompensar().addObservador((Observador)observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getRendaVariavel().getDezembro().getOperacoesDayTrade().getPrejuizoCompensar().addObservador((Observador)observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getFundosInvestimentos().getJan().getResultNegativoAnterior().addObservador((Observador)observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getFundosInvestimentos().getDez().getPrejuizoCompensar().addObservador((Observador)observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getRendaVariavelDependente().addObservador(observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getRendaVariavelDependente().adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getFundosInvestimentosDependente().addObservador(observadorRecuperacaoPrejuizoBolsaDeValores);
        this.getFundosInvestimentosDependente().adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public ModeloCompleta getModeloCompleta() {
        return this.modeloCompleta;
    }

    public ModeloSimplificada getModeloSimplificada() {
        return this.modeloSimplificada;
    }

    public ModeloDeclaracao getModelo() {
        this.modelo = this.identificadorDeclaracao.getTipoDeclaracao().naoFormatado().equals("0") ? this.getModeloCompleta() : this.getModeloSimplificada();
        return this.modelo;
    }

    public void setModeloCompleta() {
        this.modelo = this.getModeloCompleta();
    }

    public void setModeloSimplificada() {
        this.modelo = this.getModeloSimplificada();
    }

    public Alimentandos getAlimentandos() {
        return this.alimentandos;
    }

    public Herdeiros getHerdeiros() {
        return this.herdeiros;
    }

    public DoacoesEleitorais getDoacoesEleitorais() {
        return this.doacoesEleitorais;
    }

    public AtividadeRural getAtividadeRural() {
        return this.atividadeRural;
    }

    public Bens getBens() {
        return this.bens;
    }

    public ColecaoRendimentoAplicacoesFinanceiras getColecaoRendimentoAplicacoesFinanceiras() {
        return this.rendimentosAplicacoesFinanceiras;
    }

    public RendPJ getRendPJ() {
        return this.rendPJ;
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return this.rendPJ.getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return this.rendPJ.getColecaoRendPJTitular();
    }

    public RendAcm getRendAcm() {
        return this.rendAcm;
    }

    public ColecaoRendAcmTitular getColecaoRendAcmTitular() {
        return this.rendAcm.getColecaoRendAcmTitular();
    }

    public ColecaoRendAcmDependente getColecaoRendAcmDependente() {
        return this.rendAcm.getColecaoRendAcmDependente();
    }

    public Comparativo getComparativo() {
        return this.comparativo;
    }

    public Contribuinte getContribuinte() {
        return this.contribuinte;
    }

    public Dependentes getDependentes() {
        return this.dependentes;
    }

    public Dividas getDividas() {
        return this.dividas;
    }

    public Espolio getEspolio() {
        return this.espolio;
    }

    public ImpostoPago getImpostoPago() {
        return this.impostoPago;
    }

    public GCAP getGCAP() {
        return this.gcap;
    }

    public Pagamentos getPagamentos() {
        return this.pagamentos;
    }

    public Doacoes getDoacoes() {
        return this.doacoes;
    }

    public RendaVariavel getRendaVariavel() {
        return this.rendaVariavel;
    }

    public ColecaoRendaVariavelDependente getRendaVariavelDependente() {
        return this.rendaVariavelDependente;
    }

    public ColecaoRendPFDependente getRendPFDependente() {
        return this.rendPFDependente;
    }

    public RendPF getRendPFTitular() {
        return this.rendPFTitular;
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return this.rendTributacaoExclusiva;
    }

    public Resumo getResumo() {
        return this.resumo;
    }

    public NI recuperarPrincipalFontePagadora() {
        FontePagadora fontePagadora;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependentes = this.getColecaoRendPJDependente();
        HashMap<String, FontePagadora> fontesPagadoras = new HashMap<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (RendPJTitular rendPJTitularAtual : colecaoRendPJTitular.itens()) {
            if (!fontesPagadoras.containsKey(rendPJTitularAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJTitularAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJTitularAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJTitularAtual.getRendRecebidoPJ());
        }
        colecaoRendPJDependentes.excluirRegistrosEmBranco();
        for (RendPJDependente rendPJDependenteAtual : colecaoRendPJDependentes.itens()) {
            if (!fontesPagadoras.containsKey(rendPJDependenteAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJDependenteAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJDependenteAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJDependenteAtual.getRendRecebidoPJ());
        }
        Iterator<Object> itCol = fontesPagadoras.values().iterator();
        FontePagadora maiorFonte = null;
        while (itCol.hasNext()) {
            fontePagadora = (FontePagadora)((Object)itCol.next());
            if (maiorFonte != null && !fontePagadora.getValorTotal().comparacao(">", maiorFonte.getValorTotal())) continue;
            maiorFonte = fontePagadora;
        }
        if (maiorFonte == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return maiorFonte.getRendimento().getNIFontePagadora();
    }

    public void excluirRegistrosEmBrancoTodasColecoes() {
        this.getColecaoRendPJComExigibilidadeTitular().excluirRegistrosEmBranco();
        this.getColecaoRendPJComExigibilidadeDependente().excluirRegistrosEmBranco();
        this.getColecaoRendPJTitular().excluirRegistrosEmBranco();
        this.getColecaoRendPJDependente().excluirRegistrosEmBranco();
        this.getDependentes().excluirRegistrosEmBranco();
        this.getAlimentandos().excluirRegistrosEmBranco();
        this.getPagamentos().excluirRegistrosEmBranco();
        this.getBens().excluirRegistrosEmBranco();
        this.getDividas().excluirRegistrosEmBranco();
        this.getAtividadeRural().getBrasil().getIdentificacaoImovel().excluirRegistrosEmBranco();
        this.getAtividadeRural().getExterior().getIdentificacaoImovel().excluirRegistrosEmBranco();
        this.getAtividadeRural().getExterior().getReceitasDespesas().excluirRegistrosEmBranco();
        this.getAtividadeRural().getBrasil().getDividas().excluirRegistrosEmBranco();
        this.getAtividadeRural().getExterior().getDividas().excluirRegistrosEmBranco();
        this.getAtividadeRural().getBens().excluirRegistrosEmBranco();
    }

    public NI recuperarSegundaMaiorFontePagadora() {
        FontePagadora fontePagadora;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependentes = this.getColecaoRendPJDependente();
        HashMap<String, FontePagadora> fontesPagadoras = new HashMap<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (RendPJTitular rendPJTitularAtual : colecaoRendPJTitular.itens()) {
            if (!fontesPagadoras.containsKey(rendPJTitularAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJTitularAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJTitularAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJTitularAtual.getRendRecebidoPJ());
        }
        colecaoRendPJDependentes.excluirRegistrosEmBranco();
        for (RendPJDependente rendPJDependenteAtual : colecaoRendPJDependentes.itens()) {
            if (!fontesPagadoras.containsKey(rendPJDependenteAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJDependenteAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJDependenteAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJDependenteAtual.getRendRecebidoPJ());
        }
        Iterator<Object> itCol = fontesPagadoras.values().iterator();
        FontePagadora maiorFonte = null;
        FontePagadora segundaMaiorFonte = null;
        while (itCol.hasNext()) {
            FontePagadora fontePagadora2 = (FontePagadora)((Object)itCol.next());
            if (maiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", maiorFonte.getValorTotal())) {
                segundaMaiorFonte = maiorFonte;
                maiorFonte = fontePagadora2;
                continue;
            }
            if (segundaMaiorFonte != null && !fontePagadora2.getValorTotal().comparacao(">", segundaMaiorFonte.getValorTotal())) continue;
            segundaMaiorFonte = fontePagadora2;
        }
        if (segundaMaiorFonte == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return segundaMaiorFonte.getRendimento().getNIFontePagadora();
    }

    public NI recuperarTerceiraMaiorFontePagadora() {
        FontePagadora fontePagadora;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependentes = this.getColecaoRendPJDependente();
        HashMap<String, FontePagadora> fontesPagadoras = new HashMap<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (RendPJTitular rendPJTitularAtual : colecaoRendPJTitular.itens()) {
            if (!fontesPagadoras.containsKey(rendPJTitularAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJTitularAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJTitularAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJTitularAtual.getRendRecebidoPJ());
        }
        colecaoRendPJDependentes.excluirRegistrosEmBranco();
        for (RendPJDependente rendPJDependenteAtual : colecaoRendPJDependentes.itens()) {
            if (!fontesPagadoras.containsKey(rendPJDependenteAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJDependenteAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJDependenteAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJDependenteAtual.getRendRecebidoPJ());
        }
        Iterator<Object> itCol = fontesPagadoras.values().iterator();
        FontePagadora maiorFonte = null;
        FontePagadora segundaMaiorFonte = null;
        FontePagadora terceiraMaiorFonte = null;
        while (itCol.hasNext()) {
            FontePagadora fontePagadora2 = (FontePagadora)((Object)itCol.next());
            if (maiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", maiorFonte.getValorTotal())) {
                terceiraMaiorFonte = segundaMaiorFonte;
                segundaMaiorFonte = maiorFonte;
                maiorFonte = fontePagadora2;
                continue;
            }
            if (segundaMaiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", segundaMaiorFonte.getValorTotal())) {
                terceiraMaiorFonte = segundaMaiorFonte;
                segundaMaiorFonte = fontePagadora2;
                continue;
            }
            if (terceiraMaiorFonte != null && !fontePagadora2.getValorTotal().comparacao(">", terceiraMaiorFonte.getValorTotal())) continue;
            terceiraMaiorFonte = fontePagadora2;
        }
        if (terceiraMaiorFonte == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return terceiraMaiorFonte.getRendimento().getNIFontePagadora();
    }

    public NI recuperarQuartaMaiorFontePagadora() {
        FontePagadora fontePagadora;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependentes = this.getColecaoRendPJDependente();
        HashMap<String, FontePagadora> fontesPagadoras = new HashMap<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (RendPJTitular rendPJTitularAtual : colecaoRendPJTitular.itens()) {
            if (!fontesPagadoras.containsKey(rendPJTitularAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJTitularAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJTitularAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJTitularAtual.getRendRecebidoPJ());
        }
        colecaoRendPJDependentes.excluirRegistrosEmBranco();
        for (RendPJDependente rendPJDependenteAtual : colecaoRendPJDependentes.itens()) {
            if (!fontesPagadoras.containsKey(rendPJDependenteAtual.getNIFontePagadora().naoFormatado())) {
                fontePagadora = new FontePagadora(rendPJDependenteAtual);
                fontesPagadoras.put(fontePagadora.getRendimento().getNIFontePagadora().naoFormatado(), fontePagadora);
            }
            fontePagadora = (FontePagadora)((Object)fontesPagadoras.get(rendPJDependenteAtual.getNIFontePagadora().naoFormatado()));
            fontePagadora.getValorTotal().append('+', rendPJDependenteAtual.getRendRecebidoPJ());
        }
        Iterator<Object> itCol = fontesPagadoras.values().iterator();
        FontePagadora maiorFonte = null;
        FontePagadora segundaMaiorFonte = null;
        FontePagadora terceiraMaiorFonte = null;
        FontePagadora quartaMaiorFonte = null;
        while (itCol.hasNext()) {
            FontePagadora fontePagadora2 = (FontePagadora)((Object)itCol.next());
            if (maiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", maiorFonte.getValorTotal())) {
                quartaMaiorFonte = terceiraMaiorFonte;
                terceiraMaiorFonte = segundaMaiorFonte;
                segundaMaiorFonte = maiorFonte;
                maiorFonte = fontePagadora2;
                continue;
            }
            if (segundaMaiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", segundaMaiorFonte.getValorTotal())) {
                quartaMaiorFonte = terceiraMaiorFonte;
                terceiraMaiorFonte = segundaMaiorFonte;
                segundaMaiorFonte = fontePagadora2;
                continue;
            }
            if (terceiraMaiorFonte == null || fontePagadora2.getValorTotal().comparacao(">", terceiraMaiorFonte.getValorTotal())) {
                quartaMaiorFonte = terceiraMaiorFonte;
                terceiraMaiorFonte = fontePagadora2;
                continue;
            }
            if (quartaMaiorFonte != null && !fontePagadora2.getValorTotal().comparacao(">", quartaMaiorFonte.getValorTotal())) continue;
            quartaMaiorFonte = fontePagadora2;
        }
        if (quartaMaiorFonte == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return quartaMaiorFonte.getRendimento().getNIFontePagadora();
    }

    public List<String[]> maioresBeneficiariosPJ(int qtd) {
        List<String> tiposPagamentos = List.of("36", "37");
        List<String> tiposDoacoes = List.of("40", "41", "42", "43", "44", "45", "46", "47");
        Stream stPagamentos = this.getPagamentos().itens().stream().filter(pagamento -> tiposPagamentos.contains(pagamento.getCodigo().naoFormatado())).collect(Collectors.toMap(pagamento -> "01|" + pagamento.getCodigo().naoFormatado() + "|" + pagamento.getNiBeneficiario().naoFormatado(), Pagamento::getValorPago, (valorPago1, valorPago2) -> valorPago1.operacao('+', valorPago2))).entrySet().stream();
        Stream stDoacoes = this.getDoacoes().itens().stream().filter(doacao -> tiposDoacoes.contains(doacao.getCodigo().naoFormatado())).collect(Collectors.toMap(doacao -> "02|" + doacao.getCodigo().naoFormatado() + "|" + doacao.getNiBeneficiario().naoFormatado(), Doacao::getValorPago, (valorPago1, valorPago2) -> valorPago1.operacao('+', valorPago2))).entrySet().stream();
        return Stream.concat(stPagamentos, stDoacoes).sorted(Comparator.comparing(item -> ((Valor)item.getValue()).getConteudo()).reversed()).limit(qtd).map(item -> ((String)item.getKey()).split("\\|")).collect(Collectors.toList());
    }

    private CPFDependente recuperarDependentesPorOrdemValor(int numOrdem) {
        CPFDependente cpfDependente;
        ColecaoRendPJDependente colRendPJDependentes = this.getColecaoRendPJDependente();
        ArrayList<CPFDependente> cpfDependentes = new ArrayList<CPFDependente>();
        colRendPJDependentes.excluirRegistrosEmBranco();
        for (RendPJDependente rendPJDependenteAtual : colRendPJDependentes.itens()) {
            cpfDependente = new CPFDependente(rendPJDependenteAtual.getCpfDependente(), new Data());
            int ind = cpfDependentes.indexOf((Object)cpfDependente);
            if (ind < 0) {
                cpfDependentes.add(cpfDependente);
            } else {
                cpfDependente = (CPFDependente)((Object)cpfDependentes.get(ind));
            }
            cpfDependente.getValorTotal().append('+', rendPJDependenteAtual.getRendRecebidoPJ());
        }
        Dependentes colDependentes = this.getDependentes();
        colDependentes.excluirRegistrosEmBranco();
        for (Dependente dependenteAtual : colDependentes.itens()) {
            cpfDependente = new CPFDependente(dependenteAtual.getCpfDependente(), dependenteAtual.getDataNascimento());
            if (cpfDependente.getCpf().isVazio() || cpfDependentes.contains((Object)cpfDependente)) continue;
            cpfDependentes.add(cpfDependente);
        }
        CPFDependente maiorDependente = null;
        for (int i = 0; i < numOrdem; ++i) {
            Iterator itCol = cpfDependentes.iterator();
            maiorDependente = null;
            while (itCol.hasNext()) {
                cpfDependente = (CPFDependente)((Object)itCol.next());
                if (maiorDependente != null && !cpfDependente.getValorTotal().comparacao(">", maiorDependente.getValorTotal())) continue;
                maiorDependente = cpfDependente;
            }
            cpfDependentes.remove((Object)maiorDependente);
        }
        if (maiorDependente == null) {
            return new CPFDependente(new CPF(), new Data());
        }
        for (Dependente dep : this.getDependentes().itens()) {
            if (!dep.getCpfDependente().naoFormatado().equals(maiorDependente.getCpf().naoFormatado())) continue;
            maiorDependente.getDataNascimento().setConteudo(dep.getDataNascimento().naoFormatado());
        }
        return maiorDependente;
    }

    public CPF recuperarMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(1).getCpf();
    }

    public CPF recuperarSegundoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(2).getCpf();
    }

    public CPF recuperarTerceiroMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(3).getCpf();
    }

    public CPF recuperarQuartoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(4).getCpf();
    }

    public CPF recuperarQuintoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(5).getCpf();
    }

    public CPF recuperarSextoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(6).getCpf();
    }

    public Data recuperarDataNascimentoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(1).getDataNascimento();
    }

    public Data recuperarDataNascimentoSegundoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(2).getDataNascimento();
    }

    public Data recuperarDataNascimentoTerceiroMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(3).getDataNascimento();
    }

    public Data recuperarDataNascimentoQuartoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(4).getDataNascimento();
    }

    public Data recuperarDataNascimentoQuintoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(5).getDataNascimento();
    }

    public Data recuperarDataNascimentoSextoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(6).getDataNascimento();
    }

    public String verificaObrigatoriedadeEntrega(String inCriticaEntrega) {
        if (this.getIdentificadorDeclaracao().isEspolio()) {
            return this.verificaObrigatoriedadeEspolio();
        }
        if (inCriticaEntrega != null) {
            if (Integer.parseInt(inCriticaEntrega) > 0) {
                return "1";
            }
            return "0";
        }
        return null;
    }

    public String detalhaObrigatoriedadeEntregaAjusteOuEspolio() {
        if (this.getIdentificadorDeclaracao().isEspolio()) {
            return this.verificaObrigatoriedadeEspolio();
        }
        if (this.getIdentificadorDeclaracao().isSaida()) {
            return this.verificaObrigatoriedadeSaida();
        }
        return this.detalhaObrigatoriedadeEntregaAjuste();
    }

    private String verificaObrigatoriedadeSaida() {
        return "1";
    }

    private String verificaObrigatoriedadeEspolio() {
        return "1";
    }

    private String detalhaObrigatoriedadeEntregaAjuste() {
        Valor totalRendTributaveis;
        int soma = 0;
        Valor valor = totalRendTributaveis = this.getModelo() instanceof ModeloCompleta ? new Valor(this.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().formatado()) : new Valor(this.getResumo().getCalculoImposto().getTotalResultadosTributaveis().formatado());
        if (totalRendTributaveis.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.limiteIsencao.getValor())) {
            ++soma;
        }
        Valor valRendIsentos = new Valor();
        valRendIsentos.setConteudo(this.getRendIsentos().getTotal());
        Valor valRendTribut = new Valor();
        valRendTribut.setConteudo(this.getRendTributacaoExclusiva().getTotal());
        if (valRendIsentos.operacao('+', valRendTribut).comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.limiteRendimentosIsentosTributExclusiva.getValor())) {
            soma += 2;
        }
        boolean achou04 = false;
        for (int i = 0; i <= 11; ++i) {
            Object ganhoAtual = this.getRendaVariavel().getGanhosPorIndice(i);
            if (!ganhoAtual.getOperacoesComuns().getResultadoLiquidoMes().isVazio()) {
                soma += 4;
                achou04 = true;
                break;
            }
            if (!ganhoAtual.getOperacoesDayTrade().getResultadoLiquidoMes().isVazio()) {
                soma += 4;
                achou04 = true;
                break;
            }
            FundosInvestimentos fundosInvestimentos = this.getFundosInvestimentos();
            if (fundosInvestimentos.getMeses()[i].getResultLiquidoMes().isVazio()) continue;
            soma += 4;
            achou04 = true;
            break;
        }
        if (!achou04) {
            ColecaoRendaVariavelDependente rendaVariavelDependente = this.getRendaVariavelDependente();
            block1: for (Object itemRendaVariavelDependente : rendaVariavelDependente.itens()) {
                for (int i = 0; i <= 11; ++i) {
                    GanhosLiquidosOuPerdas ganhoAtual = ((ItemRendaVariavelDependente)((Object)itemRendaVariavelDependente)).getRendaVariavel().getGanhosPorIndice(i);
                    if (!ganhoAtual.getOperacoesComuns().getResultadoLiquidoMes().isVazio()) {
                        soma += 4;
                        achou04 = true;
                        continue block1;
                    }
                    if (ganhoAtual.getOperacoesDayTrade().getResultadoLiquidoMes().isVazio()) continue;
                    soma += 4;
                    achou04 = true;
                    continue block1;
                }
            }
            ColecaoFundosInvestimentosDependente fundosInvestimentosDependente = this.getFundosInvestimentosDependente();
            block3: for (ItemFundosInvestimentosDependente itemFundosInvestDependente : fundosInvestimentosDependente.itens()) {
                for (int i = 0; i <= 11; ++i) {
                    FundosInvestimentos fundosInvestimentos = itemFundosInvestDependente.getFundosInvestimentos();
                    if (fundosInvestimentos.getMeses()[i].getResultLiquidoMes().isVazio()) continue;
                    soma += 4;
                    achou04 = true;
                    continue block3;
                }
            }
        }
        if (!achou04) {
            Valor soma20e21Isentos = new Valor();
            soma20e21Isentos.append('+', (Valor)this.rendIsentos.getGanhosLiquidosAcoes());
            soma20e21Isentos.append('+', (Valor)this.rendIsentos.getGanhosCapitalOuro());
            if (soma20e21Isentos.comparacao(">", "40.000,00")) {
                soma += 4;
            }
        }
        boolean achou08 = false;
        if (!this.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual().isVazio()) {
            soma += 8;
            achou08 = true;
        }
        if (!achou08 && !this.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME().isVazio()) {
            soma += 8;
            achou08 = true;
        }
        if (!achou08 && !this.getGCAP().getConsolidacaoGeralEspecie().getImpostoDevido().isVazio()) {
            soma += 8;
            achou08 = true;
        }
        for (AlienacaoBemImovel item : this.getGCAP().getBensImoveis().itens()) {
            if (!item.getPerguntas().isValorReaplicado()) continue;
            soma += 16;
            break;
        }
        if (this.getBens().getTotalExercicioAtual().comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.limiteBensDireitos.getValor())) {
            soma += 32;
        }
        Valor recBrutaTotalBR = new Valor();
        ApuracaoResultadoBrasil apuracaoResultadoBR = this.getAtividadeRural().getBrasil().getApuracaoResultado();
        recBrutaTotalBR.setConteudo(apuracaoResultadoBR.getReceitaBrutaTotal());
        Valor resultadoIExt = new Valor();
        ApuracaoResultadoExterior apuracaoResultadoEXT = this.getAtividadeRural().getExterior().getApuracaoResultado();
        resultadoIExt.setConteudo(apuracaoResultadoEXT.getResultadoI_EmReais());
        if (recBrutaTotalBR.operacao('+', resultadoIExt).comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.limiteReceitaBrutaAtividadeRural.getValor())) {
            soma += 64;
        } else if (!apuracaoResultadoBR.getPrejuizoExercicioAnterior().isVazio()) {
            soma += 64;
        } else if (!apuracaoResultadoBR.getPrejuizoCompensar().isVazio()) {
            soma += 64;
        } else if (!apuracaoResultadoEXT.getPrejuizoExercicioAnterior().isVazio()) {
            soma += 64;
        } else if (!apuracaoResultadoEXT.getPrejuizoCompensar().isVazio()) {
            soma += 64;
        }
        if (Logico.SIM.equals(this.getContribuinte().getRetornoPais().naoFormatado())) {
            soma += 128;
        }
        if (this.getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM)) {
            soma += 256;
        }
        return String.valueOf(soma);
    }

    public RendIsentos getRendIsentos() {
        return this.rendIsentos;
    }

    public int getChaveDependenteOuAlimentando(Pagamento pag) {
        block5: {
            int ret;
            block4: {
                ret = 1;
                if (!pag.getTipo().naoFormatado().equals("D")) break block4;
                for (Dependente dep : this.getDependentes().itens()) {
                    if (dep.getNome().naoFormatado().toUpperCase().equals(pag.getDependenteOuAlimentando().naoFormatado().toUpperCase())) {
                        return ret;
                    }
                    ++ret;
                }
                break block5;
            }
            if (!pag.getTipo().naoFormatado().equals("A")) break block5;
            for (Alimentando alim : this.getAlimentandos().itens()) {
                if (alim.getNome().naoFormatado().toUpperCase().equals(pag.getDependenteOuAlimentando().naoFormatado().toUpperCase())) {
                    return ret;
                }
                ++ret;
            }
        }
        return 0;
    }

    public String getNomeDependenteOuAlimentandoPorChave(Pagamento pgto, String chave) {
        block3: {
            block2: {
                if (!pgto.getTipo().naoFormatado().equals("D")) break block2;
                for (Dependente dep : this.getDependentes().itens()) {
                    if (!dep.getChave().equals(chave)) continue;
                    return dep.getNome().formatado();
                }
                break block3;
            }
            if (!pgto.getTipo().naoFormatado().equals("A")) break block3;
            for (Alimentando alim : this.getAlimentandos().itens()) {
                if (!alim.getChave().equals(chave)) continue;
                return alim.getNome().formatado();
            }
        }
        return "";
    }

    public Valor recuperarSubTotalExclusivoTransporteRendTribExclusiva() {
        RendTributacaoExclusiva rendTributacaoExclusiva = this.getRendTributacaoExclusiva();
        Valor result = new Valor();
        result.append('+', rendTributacaoExclusiva.getGanhosCapital());
        result.append('+', rendTributacaoExclusiva.getGanhosCapitalEstrangeira());
        result.append('+', rendTributacaoExclusiva.getGanhosCapitalEmEspecie());
        result.append('+', this.recuperarRendaVariavelTribtExclusiva());
        return result;
    }

    public Valor recuperarRendaVariavelTribtExclusiva() {
        return this.rendTributacaoExclusiva.getGanhosRendaVariavel();
    }

    public boolean simplesEhMelhor() {
        Valor valImpostoRestituirSimpl = new Valor(this.getModeloSimplificada().getImpostoRestituir().formatado());
        Valor valImpostoRestituirCompl = new Valor(this.getModeloCompleta().getImpostoRestituir().formatado());
        Valor valImpostoPagarSimpl = new Valor(this.getModeloSimplificada().getSaldoImpostoPagar().formatado());
        Valor valImpostoPagarCompl = new Valor(this.getModeloCompleta().getSaldoImpostoPagar().formatado());
        return valImpostoRestituirSimpl.comparacao(">", valImpostoRestituirCompl) || valImpostoPagarSimpl.comparacao("<", valImpostoPagarCompl);
    }

    public boolean simplesIgualCompleta() {
        Valor valImpostoRestituirSimpl = new Valor(this.getModeloSimplificada().getImpostoRestituir().formatado());
        Valor valImpostoRestituirCompl = new Valor(this.getModeloCompleta().getImpostoRestituir().formatado());
        Valor valImpostoPagarSimpl = new Valor(this.getModeloSimplificada().getSaldoImpostoPagar().formatado());
        Valor valImpostoPagarCompl = new Valor(this.getModeloCompleta().getSaldoImpostoPagar().formatado());
        return valImpostoRestituirSimpl.comparacao("=", valImpostoRestituirCompl) && valImpostoPagarSimpl.comparacao("=", valImpostoPagarCompl);
    }

    public boolean temImpostoAPagar() {
        return this.getIdentificadorDeclaracao().isAjuste() && this.getModelo().getSaldoImpostoPagar().comparacao(">=", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor());
    }

    public boolean temImpostoARestituir() {
        return this.getModelo().getImpostoRestituir().comparacao(">", "0,00");
    }

    public boolean entrouSaiuNoMesmoAno() {
        boolean retorno = false;
        if (this.identificadorDeclaracao.isSaida()) {
            Saida saida = IRPFFacade.getInstancia().getSaida();
            Data dtCondicaoNaoResidente = saida.getDtCondicaoNaoResidente();
            Data dtCondicaoResidente = saida.getDtCondicaoResidente();
            Data aux = new Data();
            aux.setConteudo("31/12" + ConstantesGlobais.ANO_BASE_ANTERIOR);
            if (!dtCondicaoNaoResidente.isVazio() && !dtCondicaoResidente.isVazio() && dtCondicaoResidente.maisNova(aux) && dtCondicaoResidente.maisAntiga(dtCondicaoNaoResidente)) {
                retorno = true;
            }
        }
        return retorno;
    }

    public List<String> obterDeclarantesRendaVariavelEmOrdemDecrescenteDeImpostoDevido() {
        ArrayList<String> retorno = new ArrayList<String>();
        HashMap<String, ImpostoDevidoPorDeclarante> mapa = new HashMap<String, ImpostoDevidoPorDeclarante>();
        ImpostoDevidoPorDeclarante declarante = new ImpostoDevidoPorDeclarante();
        declarante.getCpfDeclarante().setConteudo(this.getIdentificadorDeclaracao().getCpf());
        declarante.getImpostoDevido().append('+', this.rendaVariavel.getTotalImpostoAPagar());
        mapa.put(this.getIdentificadorDeclaracao().getCpf().naoFormatado(), declarante);
        this.rendaVariavelDependente.excluirRegistrosEmBranco();
        for (ItemRendaVariavelDependente itemRendaVariavelDependenteAtual : this.rendaVariavelDependente.itens()) {
            declarante = new ImpostoDevidoPorDeclarante();
            declarante.getCpfDeclarante().setConteudo(itemRendaVariavelDependenteAtual.getCpf());
            declarante.getImpostoDevido().append('+', itemRendaVariavelDependenteAtual.getRendaVariavel().getTotalImpostoAPagar());
            mapa.put(itemRendaVariavelDependenteAtual.getCpf().naoFormatado(), declarante);
        }
        declarante = (ImpostoDevidoPorDeclarante)mapa.get(this.getIdentificadorDeclaracao().getCpf().naoFormatado());
        declarante.getImpostoDevido().append('+', this.fundosInvestimentos.getTotalImpostoDevido());
        this.fundosInvestimentosDependente.excluirRegistrosEmBranco();
        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependenteAtual : this.fundosInvestimentosDependente.itens()) {
            if (!mapa.containsKey(itemFundosInvestimentosDependenteAtual.getCpf().naoFormatado())) {
                declarante = new ImpostoDevidoPorDeclarante();
                declarante.getCpfDeclarante().setConteudo(itemFundosInvestimentosDependenteAtual.getCpf());
                mapa.put(itemFundosInvestimentosDependenteAtual.getCpf().naoFormatado(), declarante);
            }
            declarante = (ImpostoDevidoPorDeclarante)mapa.get(itemFundosInvestimentosDependenteAtual.getCpf().naoFormatado());
            declarante.getImpostoDevido().append('+', itemFundosInvestimentosDependenteAtual.getFundosInvestimentos().getTotalImpostoDevido());
            mapa.put(itemFundosInvestimentosDependenteAtual.getCpf().naoFormatado(), declarante);
        }
        ArrayList listaOrdenadaDeclarantes = new ArrayList(mapa.values());
        Collections.sort(listaOrdenadaDeclarantes, new Comparator<ImpostoDevidoPorDeclarante>(){

            @Override
            public int compare(ImpostoDevidoPorDeclarante o1, ImpostoDevidoPorDeclarante o2) {
                return o2.getImpostoDevido().comparacao(">", o1.getImpostoDevido()) ? 1 : (o2.getImpostoDevido().comparacao("=", o1.getImpostoDevido()) ? 0 : -1);
            }
        });
        for (ImpostoDevidoPorDeclarante f : listaOrdenadaDeclarantes) {
            if (f.getImpostoDevido().isVazio()) continue;
            retorno.add(f.getCpfDeclarante().naoFormatado() + "#" + f.getImpostoDevido().naoFormatado());
        }
        return retorno;
    }

    public boolean apenasTitular() {
        return this.dependentes.itens().isEmpty() && this.alimentandos.itens().isEmpty();
    }

    public IdentificadorDeclaracao getCopiaIdentificador() {
        return this.copiaIdentificador;
    }

    public IdentificadorDeclaracaoXML getIdentificador() {
        return this.identificadorDeclaracao;
    }

    public RendPJComExigibilidade getRendPJComExigibilidade() {
        return this.rendPJComExigibilidade;
    }

    public ColecaoRendPJComExigibilidadeDependente getColecaoRendPJComExigibilidadeDependente() {
        return this.rendPJComExigibilidade.getColecaoRendPJComExigibilidadeDependente();
    }

    public ColecaoRendPJComExigibilidadeTitular getColecaoRendPJComExigibilidadeTitular() {
        return this.rendPJComExigibilidade.getColecaoRendPJComExigibilidadeTitular();
    }

    public Saida getSaida() {
        return this.saida;
    }

    public DataHora getDataHoraSalvamento() {
        return this.dataHoraSalvamento;
    }

    public FundosInvestimentos getFundosInvestimentos() {
        return this.fundosInvestimentos;
    }

    public ColecaoFundosInvestimentosDependente getFundosInvestimentosDependente() {
        return this.fundosInvestimentosDependente;
    }

    public ColecaoEstatutoCriancaAdolescente getColecaoEstatutoCriancaAdolescente() {
        return this.colecaoEstatutoCriancaAdolescente;
    }

    public ColecaoEstatutoIdoso getColecaoEstatutoIdoso() {
        return this.colecaoEstatutoIdoso;
    }

    public void limparTrabalhoNaoAssalariadoSemLancamento() {
        this.getRendPFTitular().limparTrabalhoNaoAssalariadoSemLancamento();
        for (ItemRendPFDependente item : this.getRendPFDependente().itens()) {
            item.getRendimentos().limparTrabalhoNaoAssalariadoSemLancamento();
        }
    }

    public void atribuirFichaLancamentosTrabalhoNaoAssalariado() {
        for (ContasMes mes : this.getRendPFTitular().getContasAno().getMeses()) {
            for (Conta conta : mes.itens()) {
                conta.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
            }
        }
        for (ItemRendPFDependente itemDependente : this.getRendPFDependente().itens()) {
            for (ContasMes mes : itemDependente.getRendimentos().getContasAno().getMeses()) {
                for (Conta conta : mes.itens()) {
                    conta.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
                }
            }
        }
    }

    public boolean temDoacoesDiretamenteDeclaracao() {
        return this.getIdentificadorDeclaracao().isCompleta() && (!this.getColecaoEstatutoCriancaAdolescente().itens().isEmpty() || !this.getColecaoEstatutoIdoso().itens().isEmpty());
    }

    public void lmparDoacoesDiretamenteDeclaracao() {
        this.getColecaoEstatutoCriancaAdolescente().clear();
        this.getColecaoEstatutoIdoso().clear();
    }

    public List<Integer> obterMesesTabelaProgressivaMensal() {
        ArrayList<Integer> meses;
        block18: {
            block19: {
                block17: {
                    meses = new ArrayList<Integer>();
                    if (!this.identificadorDeclaracao.isAjuste()) break block17;
                    for (int i = 1; i <= 12; ++i) {
                        meses.add(i);
                    }
                    break block18;
                }
                if (!this.identificadorDeclaracao.isEspolio()) break block19;
                if (this.getEspolio().isBensInventariarMarcado()) {
                    for (int i = 1; i <= 12; ++i) {
                        meses.add(i);
                    }
                } else {
                    Data dataConsiderada = this.getEspolio().obterDataLimiteParaCalculos();
                    byte retornoValidacao = dataConsiderada.validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade();
                    if (retornoValidacao >= 3) {
                        meses.add(1);
                    } else {
                        int limite = 1;
                        try {
                            limite = Integer.valueOf(dataConsiderada.getMes());
                            if (limite > 12) {
                                limite = 12;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        for (int i = 1; i <= limite; ++i) {
                            meses.add(i);
                        }
                    }
                }
                break block18;
            }
            if (!this.identificadorDeclaracao.isSaida()) break block18;
            Data dataChegada = this.getSaida().getDtCondicaoResidente();
            Data dataPartida = this.getSaida().getDtCondicaoNaoResidente();
            int mesChegadaConsiderado = 1;
            int mesPartidaConsiderado = 12;
            byte retornoChegada = dataChegada.validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade();
            byte retornoPartida = dataPartida.validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade();
            if (retornoChegada < 3 && !dataChegada.isVazio()) {
                try {
                    mesChegadaConsiderado = Integer.valueOf(dataChegada.formatado().substring(3, 5));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (retornoPartida < 3) {
                try {
                    mesPartidaConsiderado = Integer.valueOf(dataPartida.formatado().substring(3, 5));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (int i = mesChegadaConsiderado; i <= mesPartidaConsiderado; ++i) {
                meses.add(i);
            }
        }
        return meses;
    }

    public RendPJTitular limiteAposentadoriaExcedido(ItemQuadroAuxiliarAb pensao) {
        RendPJTitular rendPJ = null;
        boolean isTitular = this.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(pensao.getCpfBeneficiario().naoFormatado());
        Valor rendimentosOutros = new Valor();
        Valor decimoTerceiroOutros = new Valor();
        Valor limiteRendimentos = new Valor("22.847,76");
        Valor limiteDecimoTerceiro = new Valor("1.903,98");
        Valor limiteRendimentosRestante = new Valor();
        Valor limiteDecimoTerceiroRestante = new Valor();
        if (isTitular) {
            rendPJ = new RendPJTitular(this.identificadorDeclaracao);
            for (RendAcmTitular rendAcm : this.rendAcm.getColecaoRendAcmTitular().itens()) {
                if (!rendAcm.getOpcaoTributacao().naoFormatado().equals("A")) continue;
                rendimentosOutros.append('+', (Valor)rendAcm.getParcIsenta65Anos());
            }
        } else {
            rendPJ = new RendPJDependente(this);
            ((RendPJDependente)rendPJ).getCpfDependente().setConteudo(pensao.getCpfBeneficiario().naoFormatado());
            for (RendAcmTitular rendAcm : this.rendAcm.getColecaoRendAcmDependente().itens()) {
                RendAcmDependente rendAcmDependente = (RendAcmDependente)rendAcm;
                if (!rendAcmDependente.getOpcaoTributacao().naoFormatado().equals("A") || !rendAcmDependente.getCpfDependente().naoFormatado().equals(pensao.getCpfBeneficiario().naoFormatado())) continue;
                rendimentosOutros.append('+', (Valor)rendAcm.getParcIsenta65Anos());
            }
        }
        rendPJ.getNIFontePagadora().setConteudo(pensao.getNIFontePagadora());
        rendPJ.getNomeFontePagadora().setConteudo(pensao.getNomeFontePagadora());
        for (ItemQuadroTransporteDetalhado item : this.rendIsentos.getParcIsentaAposentadoriaQuadroAuxiliar().itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(pensao.getCpfBeneficiario().naoFormatado())) continue;
            rendimentosOutros.append('+', item.getValor());
            decimoTerceiroOutros.append('+', (Valor)item.getValor13Salario());
        }
        rendimentosOutros.append('-', pensao.getValor());
        decimoTerceiroOutros.append('-', (Valor)pensao.getValor13Salario());
        limiteRendimentosRestante.setConteudo(limiteRendimentos.operacao('-', rendimentosOutros));
        limiteDecimoTerceiroRestante.setConteudo(limiteDecimoTerceiro.operacao('-', decimoTerceiroOutros));
        if (limiteRendimentosRestante.comparacao(">", "0,00")) {
            if (limiteRendimentosRestante.comparacao(">=", pensao.getValor())) {
                rendPJ.getRendRecebidoPJ().clear();
            } else {
                rendPJ.getRendRecebidoPJ().setConteudo(pensao.getValor().operacao('-', limiteRendimentosRestante));
            }
        } else {
            rendPJ.getRendRecebidoPJ().setConteudo(pensao.getValor());
        }
        if (limiteDecimoTerceiroRestante.comparacao(">", "0,00")) {
            if (limiteDecimoTerceiroRestante.comparacao(">=", (Valor)pensao.getValor13Salario())) {
                rendPJ.getDecimoTerceiro().clear();
            } else {
                rendPJ.getDecimoTerceiro().setConteudo(pensao.getValor13Salario().operacao('-', limiteDecimoTerceiroRestante));
            }
        } else {
            rendPJ.getDecimoTerceiro().setConteudo((Valor)pensao.getValor13Salario());
        }
        if (rendPJ.getRendRecebidoPJ().isVazio() && rendPJ.getDecimoTerceiro().isVazio()) {
            rendPJ = null;
        }
        return rendPJ;
    }

    public Valor limiteAposentadoriaRRAExcedido(String cpf) {
        boolean isTitular = this.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpf);
        Valor rendimentos = new Valor();
        Valor limiteRendimentos = new Valor("22.847,76");
        if (isTitular) {
            for (RendAcmTitular rendAcm : this.rendAcm.getColecaoRendAcmTitular().itens()) {
                if (!rendAcm.getOpcaoTributacao().naoFormatado().equals("A")) continue;
                rendimentos.append('+', (Valor)rendAcm.getParcIsenta65Anos());
            }
        } else {
            for (RendAcmTitular rendAcm : this.rendAcm.getColecaoRendAcmDependente().itens()) {
                RendAcmDependente rendAcmDependente = (RendAcmDependente)rendAcm;
                if (!rendAcmDependente.getOpcaoTributacao().naoFormatado().equals("A") || !rendAcmDependente.getCpfDependente().naoFormatado().equals(cpf)) continue;
                rendimentos.append('+', (Valor)rendAcm.getParcIsenta65Anos());
            }
        }
        for (ItemQuadroTransporteDetalhado item : this.rendIsentos.getParcIsentaAposentadoriaQuadroAuxiliar().itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(cpf)) continue;
            rendimentos.append('+', item.getValor());
        }
        if (rendimentos.comparacao(">", limiteRendimentos)) {
            rendimentos.append('-', limiteRendimentos);
        } else {
            rendimentos.clear();
        }
        return rendimentos;
    }

    public boolean existeContribuinteExcedeLimiteFaixa1() {
        boolean existe;
        block1: {
            Dependente dependente;
            existe = false;
            existe = this.contribuinteExcedeLimiteFaixa1(this.getIdentificadorDeclaracao().getCpf());
            if (existe) break block1;
            Iterator iterator = this.getDependentes().itens().iterator();
            while (iterator.hasNext() && !(existe = this.contribuinteExcedeLimiteFaixa1((dependente = (Dependente)((Object)iterator.next())).getCpfDependente()))) {
            }
        }
        return existe;
    }

    public String usouImportacaoCarneLeaoWeb() {
        String retorno = !this.getIdentificadorDeclaracao().getInCLWeb().naoFormatado().isEmpty() ? this.getIdentificadorDeclaracao().getInCLWeb().naoFormatado() : Logico.NAO;
        boolean titular = this.getRendPFTitular().getUsouImportacaoCarneLeaoWeb().naoFormatado().equals(Logico.SIM);
        boolean dependente = this.getRendPFDependente().getUsouImportacaoCarneLeaoWeb().naoFormatado().equals(Logico.SIM);
        if (titular && !dependente) {
            retorno = "1";
        } else if (!titular && dependente) {
            retorno = "2";
        } else if (titular && dependente) {
            retorno = "3";
        }
        this.getIdentificadorDeclaracao().getInCLWeb().setConteudo(retorno);
        return retorno;
    }

    public boolean contribuinteExcedeLimiteFaixa1(CPF cpf) {
        Valor faixa1 = TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa1.getValor();
        Valor rendimentos = new Valor();
        boolean excede = false;
        if (cpf.naoFormatado().equals(this.getIdentificadorDeclaracao().getCpf().naoFormatado())) {
            rendimentos.append('+', this.getColecaoRendPJTitular().obterTotalRendPJSemAuxilioEmergencial());
            rendimentos.append('+', this.getRendPFTitular().getTotalPessoaFisica());
            rendimentos.append('+', this.getRendPFTitular().getTotalAlugueis());
            rendimentos.append('+', this.getRendPFTitular().getTotalOutros());
            rendimentos.append('+', this.getRendPFTitular().getTotalExterior());
            rendimentos.append('+', this.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
            rendimentos.append('+', (Valor)this.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
            rendimentos.append('+', (Valor)this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        } else {
            rendimentos.append('+', this.getColecaoRendPJDependente().obterTotalRendPJPorDependenteSemAuxilioEmergencial(cpf));
            rendimentos.append('+', this.getRendPFDependente().obterRendimentosRecebidosPorDependente(cpf));
            rendimentos.append('+', this.getColecaoRendAcmDependente().obterRendimentosRecebidosAjustePorDependente(cpf));
        }
        if (rendimentos.comparacao(">", faixa1)) {
            excede = true;
        }
        return excede;
    }

    public void setarConfiabilidade() {
        UsuarioLogado usuarioGovBr = BarramentoIRPFService.getUsuarioLogado();
        int confiabilidade = usuarioGovBr != null ? usuarioGovBr.getIntNivelAcessoGov() : 0;
        this.getIdentificadorDeclaracao().getInConfiabilidade().setConteudo(String.valueOf(confiabilidade));
    }

    public void setarCpfTransmissaoEPerfilCpfTransmissao() {
        String cpfLogado = null;
        String espacoEmBranco = "           ";
        String naoDefinido = "0";
        String proprio = "1";
        UsuarioLogado usuarioGovBr = BarramentoIRPFService.getUsuarioLogado();
        String cpfDeclaracao = this.getIdentificadorDeclaracao().getCpf().naoFormatado();
        if (usuarioGovBr != null) {
            cpfLogado = usuarioGovBr.getCpf();
            if (!cpfLogado.equals(cpfDeclaracao)) {
                this.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(cpfLogado);
                this.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(naoDefinido);
            } else {
                this.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(espacoEmBranco);
                this.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(proprio);
            }
        } else {
            this.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(espacoEmBranco);
            this.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(naoDefinido);
        }
    }

    public CPF getUtlimoCPFAutenticado() {
        return this.utlimoCPFAutenticado;
    }

    public Boolean getEmCalamidade() {
        return this.emCalamidade;
    }

    public void recalcularDeclaracao() {
        this.getModeloCompleta().resumoRendimentosTributaveis();
        this.getModeloCompleta().resumoCalculoImposto();
        this.getModeloCompleta().resumoOutrasInformacoes();
        this.getModeloSimplificada().resumoRendimentosTributaveis();
        this.getModeloSimplificada().resumoCalculoImposto();
        this.getModeloSimplificada().resumoOutrasInformacoes();
        this.getModelo().aplicaValoresNaDeclaracao();
        this.getComparativo().getTotalRendTribCompleta().setConteudo(this.getModeloCompleta().getTotalRendimentos());
        this.getComparativo().getBaseCalcCompleta().setConteudo(this.getModeloCompleta().getBaseCalculo());
        this.getComparativo().getSaldoPagarCompleta().setConteudo(this.getModeloCompleta().getSaldoImpostoPagar());
        this.getComparativo().getImpRestituirCompleta().setConteudo(this.getModeloCompleta().getImpostoRestituir());
        this.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes().setConteudo(this.getModeloCompleta().getTotalDeducoes());
        this.getComparativo().getTotalRendTribSimplificada().setConteudo(this.getModeloSimplificada().getTotalResultadosTributaveis());
        this.getComparativo().getBaseCalcSimplificada().setConteudo(this.getModeloSimplificada().getBaseCalculo());
        this.getComparativo().getSaldoPagarSimplificada().setConteudo(this.getModeloSimplificada().getSaldoImpostoPagar());
        this.getComparativo().getImpRestituirSimplificada().setConteudo(this.getModeloSimplificada().getImpostoRestituir());
        this.getResumo().getCalculoImposto().getDescontoSimplificado().setConteudo(this.getModeloSimplificada().getDescontoSimplificado());
        CalculosPagamentos.calculaTotalContribuicaoEstatico((DeclaracaoIRPF)this);
    }

    public void atualizarIndicesBens(Map<String, String> chavesRepetidas) {
        int counter = 1;
        for (Bem bem : this.getBens().itens()) {
            String indice = "00000" + counter;
            bem.getIndiceAnterior().setConteudo(bem.getIndice());
            bem.getIndice().setConteudo(indice.substring(indice.length() - 5));
            if (chavesRepetidas.containsKey(bem.getIndiceAnterior().naoFormatado())) {
                this.getRendIsentos().atualizarIndiceBem(bem.getIndiceAnterior().naoFormatado(), "00000");
                this.getRendTributacaoExclusiva().atualizarIndiceBem(bem.getIndiceAnterior().naoFormatado(), "00000");
            } else {
                this.getRendIsentos().atualizarIndiceBem(bem.getIndiceAnterior().naoFormatado(), bem.getIndice().naoFormatado());
                this.getRendTributacaoExclusiva().atualizarIndiceBem(bem.getIndiceAnterior().naoFormatado(), bem.getIndice().naoFormatado());
            }
            ++counter;
        }
    }

    private class CPFDependente
    extends ObjetoNegocio {
        private CPF cpf = new CPF();
        private Valor valorTotal = new Valor((ObjetoNegocio)this, "");
        private Data dataNascimento = new Data();

        public CPFDependente(CPF cpf, Data dataNascimento) {
            this.cpf.setConteudo(cpf.naoFormatado());
            this.dataNascimento.setConteudo(dataNascimento.naoFormatado());
        }

        public boolean equals(Object obj) {
            return obj instanceof CPFDependente && this.cpf.naoFormatado().equals(((CPFDependente)((Object)obj)).cpf.naoFormatado());
        }

        public int hashCode() {
            return Objects.hash(this.cpf.naoFormatado(), this.dataNascimento);
        }

        public CPF getCpf() {
            return this.cpf;
        }

        public Valor getValorTotal() {
            return this.valorTotal;
        }

        public Data getDataNascimento() {
            return this.dataNascimento;
        }
    }
}

