/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf.nuvem;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;

public class ImportacaoModel
extends ObjetoNegocio {
    protected Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo");
    public static final String TIPO_TITULAR = "T";
    public static final String TIPO_DEPENDENTE = "D";
    public static final String TIPO_PADRAO = "V";
    protected Alfa dependente = new Alfa((ObjetoNegocio)this, "Nome do dependente", 60);
    protected CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF Dependente");
    protected CPF cpfSolicitante = new CPF((ObjetoNegocio)this, "CPF do Solicitante");
    protected Alfa codigoAcesso = new Alfa((ObjetoNegocio)this, "C\u00f3digo de acesso");
    protected char[] senha;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = new WeakReference<DeclaracaoIRPF>(ControladorGui.getDemonstrativoAberto());

    public ImportacaoModel() {
        this.tipo.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.dependente.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.dependente.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)ImportacaoModel.this.declaracaoRef.get();
                if (!declaracaoIRPF.getDependentes().isExisteNome(ImportacaoModel.this.dependente.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem((String)"pagamento_dependente_nao_existe"), 3);
                }
                return null;
            }
        });
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public Alfa getDependente() {
        return this.dependente;
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    public CPF getCpfSolicitante() {
        return this.cpfSolicitante;
    }

    public Alfa getCodigoAcesso() {
        return this.codigoAcesso;
    }

    public char[] getSenha() {
        return this.senha;
    }

    public void setSenha(char[] senha) {
        this.senha = senha;
    }
}

