/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JIRPFToolbarCustom;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.listener.CustomToolBarListener;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.rendpf.CarneLeaoTableDecorator;
import serpro.ppgd.irpf.gui.rendpf.EscrituracaoTableCellRenderer;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaSelecaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoMensalDependentes;
import serpro.ppgd.irpf.gui.rendpf.TableModelRendPFDependentes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaSelecaoEscrituracaoDependentes
extends PainelDemonstrativoAb
implements PainelAbaIf,
CustomToolBarListener {
    public static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes";
    private PainelDemonstrativoIf painelPai;
    private JIRPFToolbarCustom irpfToolbar;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelAbaSelecaoEscrituracaoDependentes(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        CarneLeaoTableDecorator.decorate(this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbar);
        this.irpfToolbar.addToolBarListener((CustomToolBarListener)this);
        this.irpfToolbar.getBtnCustom().setPreferredSize(new Dimension(160, 25));
        this.irpfToolbar.getBtnCustom().setText("Informar Rendimentos");
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(1, 0);
        }
        this.getTabela().setDefaultRenderer(Informacao.class, (TableCellRenderer)((Object)new EscrituracaoTableCellRenderer(1)));
        this.jScrollPane1.getViewport().setBackground(Color.white);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.jLabel1 = new JLabel();
        this.irpfToolbar = new JIRPFToolbarCustom("Novo Lan\u00e7amento", false, false);
        this.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jScrollPane1.setViewportView((Component)this.tableLista);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 673, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 309, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_MAIOR);
        this.jLabel1.setForeground(new Color(26, 135, 191));
        this.jLabel1.setText("Rendimentos do Trabalho  N\u00e3o Assalariado");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent((Component)this.irpfToolbar, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.irpfToolbar, -2, -1, -2).addContainerGap()));
    }

    public TableListaModel getTableModel() {
        return new TableModelRendPFDependentes(IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente());
    }

    public int getColunaOrdenacao() {
        return 0;
    }

    public Integer[] getColunasOrdenaveis() {
        return null;
    }

    public void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setPreferredWidth(100);
    }

    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    public TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "CPF do Dependente", "Nome do Dependente"};
        return tableLista;
    }

    public void aposCriarAbas() {
    }

    public String getNomeAba() {
        return "Dependentes";
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public JComponent getDefaultFocus() {
        return this.irpfToolbar.getBtnNovo();
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public String getTituloPainel() {
        return "Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes";
    }

    public void onBtnNovoClick(ActionEvent e) {
        TableModelRendPFDependentes lModel = (TableModelRendPFDependentes)((Object)this.getTabela().getModel());
        ItemRendPFDependente lItem = new ItemRendPFDependente();
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAbaSelecaoDependente(lItem, true));
        lModel.refresh();
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            ColecaoRendPFDependente colecao = (ColecaoRendPFDependente)model.getObjetoNegocio();
            ItemRendPFDependente rendPf = (ItemRendPFDependente)colecao.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAbaSelecaoDependente(rendPf, false));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirma((String)"ConfirmaExcluirItens1", (String[])new String[]{"rendimento(s)"})) {
                ArrayList<ObjetoNegocio> listaRemocao = new ArrayList<ObjetoNegocio>(linhasTabela.length);
                Colecao<ObjetoNegocio> colecao = new Colecao<ObjetoNegocio>(){};
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    TableListaModel model = (TableListaModel)tabela.getModel();
                    colecao = (Colecao)model.getObjetoNegocio();
                    ObjetoNegocio objetoNegocio = (ObjetoNegocio)colecao.itens().get(indiceVetor);
                    listaRemocao.add(objetoNegocio);
                }
                colecao.itens().removeAll(listaRemocao);
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnCustomClick(ActionEvent e) {
        TableModelRendPFDependentes lModel = (TableModelRendPFDependentes)((Object)this.getTabela().getModel());
        int nLinha = this.getTabela().getSelectedRow();
        int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
        IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
        ColecaoRendPFDependente colecao = (ColecaoRendPFDependente)model.getObjetoNegocio();
        ItemRendPFDependente rendPf = (ItemRendPFDependente)colecao.itens().get(indiceVetor);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDadosEscrituracaoMensalDependentes("Dependentes", rendPf));
        lModel.refresh();
    }
}

