/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaSelecaoDependente
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    public static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes";
    private ItemRendPFDependente itemRendPFDependente;
    private boolean isNovo;
    private JAutoCompleteEditCPF cmbDependente;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblDependente;

    public PainelAbaSelecaoDependente(ItemRendPFDependente itemRendPFDependente, boolean isNovo) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.itemRendPFDependente = itemRendPFDependente;
        this.isNovo = isNovo;
        this.associarInformacao();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblDependente = new JLabel();
        this.cmbDependente = new JAutoCompleteEditCPF();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblDependente.setText("Dependente:");
        this.lblDependente.setVerticalAlignment(3);
        this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentes());
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblDependente).addPreferredGap(0).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.cmbDependente, -2, 424, -2).addContainerGap(286, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDependente, -2, 29, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2))).addPreferredGap(0).add((Component)this.cmbDependente, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.cmbDependente.getAccessibleContext().setAccessibleName("Dependente");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void associarInformacao() {
        this.cmbDependente.setInformacao((Informacao)this.itemRendPFDependente.getCpf());
    }

    public void executaVoltar() {
        String cpf = this.cmbDependente.getConteudo().replaceAll("[.]", "").replaceAll("[-]", "");
        if (cpf.length() == 11) {
            ColecaoRendPFDependente colecao = IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente();
            boolean rendPFComDependenteJaCadastrado = colecao.possuiDependenteComCPF(cpf);
            if (rendPFComDependenteJaCadastrado && this.isNovo) {
                GuiUtil.mostrarAviso((String)"rendpf_dependente_duplicado");
            }
            if (this.isNovo && !rendPFComDependenteJaCadastrado) {
                this.itemRendPFDependente.getCpf().setConteudo(cpf);
                colecao.add((ObjetoNegocio)this.itemRendPFDependente);
            }
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_REND_TRIB_RECEB_PF_EXT);
    }

    public JComponent getDefaultFocus() {
        return this.cmbDependente;
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_rend_pf.png");
    }

    public String getTituloPainel() {
        return "Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelo Titular";
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

