/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaLancamentosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.rendpf.TableModelEscrituracao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelAbaEscrituracaoDetalheTitular
extends PainelAbaAb {
    private PainelDemonstrativoIf painelPai;
    private Conta conta = null;
    private Conta contaAntiga = null;
    private String siglaMes;
    private boolean isNovoItem = false;
    private boolean isCancelar = false;
    private JButton btnIncluirNovo;
    private JCheckBox cbxBeneficarioNaoPossuiCPF;
    private JCheckBox cbxTitularEhBeneficiario;
    private JEditCPF edtCPFBeneficiarioServ;
    private JEditCPF edtCPFTitularPagamento;
    private JEditValor edtValor;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblBeneficiarioServico;
    private JLabel lblCPFBeneficiario;
    private JLabel lblCPFTitularPagamento;
    private JLabel lblTitularPagamento;

    public PainelAbaEscrituracaoDetalheTitular(PainelDemonstrativoIf painelPai, Conta conta, String mes, boolean isNovoItem) {
        super(painelPai);
        this.painelPai = painelPai;
        this.conta = conta;
        this.siglaMes = mes;
        this.isNovoItem = isNovoItem;
        this.initComponents();
        this.associarInformacao();
        this.cbxTitularEhBeneficiario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String novoValor = PainelAbaEscrituracaoDetalheTitular.this.cbxTitularEhBeneficiario.isSelected() ? Logico.SIM : Logico.NAO;
                PainelAbaEscrituracaoDetalheTitular.this.cbxTitularEhBeneficiarioAlterado(novoValor);
            }
        });
        this.cbxBeneficarioNaoPossuiCPF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String novoValor;
                String string = novoValor = PainelAbaEscrituracaoDetalheTitular.this.cbxBeneficarioNaoPossuiCPF.isSelected() ? Logico.SIM : Logico.NAO;
                if (PainelAbaEscrituracaoDetalheTitular.this.cbxBeneficarioNaoPossuiCPF.isSelected() && !PainelAbaEscrituracaoDetalheTitular.this.edtCPFBeneficiarioServ.getInformacao().isVazio()) {
                    if (GuiUtil.mostrarConfirma((String)"400000")) {
                        PainelAbaEscrituracaoDetalheTitular.this.cbxBeneficarioNaoPossuiCPFAlterado(novoValor);
                    } else {
                        PainelAbaEscrituracaoDetalheTitular.this.cbxBeneficarioNaoPossuiCPF.setSelected(false);
                    }
                } else {
                    PainelAbaEscrituracaoDetalheTitular.this.cbxBeneficarioNaoPossuiCPFAlterado(novoValor);
                }
            }
        });
        if (!isNovoItem) {
            this.contaAntiga = conta.obterCopia();
        }
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelo Titular");
    }

    private void cbxTitularEhBeneficiarioAlterado(String novoValor) {
        if (this.cbxTitularEhBeneficiario.isSelected()) {
            this.edtCPFBeneficiarioServ.getInformacao().setConteudo(this.edtCPFTitularPagamento.getInformacao().naoFormatado());
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(false);
            this.cbxBeneficarioNaoPossuiCPF.setSelected(false);
            this.getConta().getIndBeneficiarioNaoPossuiCPF().setConteudo(Logico.NAO);
            this.cbxBeneficarioNaoPossuiCPF.setEnabled(false);
        } else {
            this.edtCPFBeneficiarioServ.getInformacao().clear();
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(true);
            this.cbxBeneficarioNaoPossuiCPF.setSelected(false);
            this.getConta().getIndBeneficiarioNaoPossuiCPF().setConteudo(Logico.NAO);
            this.cbxBeneficarioNaoPossuiCPF.setEnabled(true);
        }
        this.getConta().getIndTitularEhBeneficiario().setConteudo(novoValor);
    }

    private void cbxBeneficarioNaoPossuiCPFAlterado(String novoValor) {
        if (this.cbxBeneficarioNaoPossuiCPF.isSelected()) {
            this.edtCPFBeneficiarioServ.getInformacao().clear();
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(false);
        } else {
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(true);
        }
        this.getConta().getIndBeneficiarioNaoPossuiCPF().setConteudo(novoValor);
    }

    public String getHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior/Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelo Titular";
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.edtValor = new JEditValor();
        this.lblTitularPagamento = new JLabel();
        this.lblCPFTitularPagamento = new JLabel();
        this.edtCPFTitularPagamento = new JEditCPF();
        this.lblBeneficiarioServico = new JLabel();
        this.lblCPFBeneficiario = new JLabel();
        this.edtCPFBeneficiarioServ = new JEditCPF();
        this.cbxTitularEhBeneficiario = new JCheckBox();
        this.cbxBeneficarioNaoPossuiCPF = new JCheckBox();
        this.btnIncluirNovo = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados do Lan\u00e7amento");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel7.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel7.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel7.setText("Valor");
        this.lblTitularPagamento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTitularPagamento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTitularPagamento.setText("Titular do Pagamento");
        this.lblCPFTitularPagamento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCPFTitularPagamento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCPFTitularPagamento.setText("CPF");
        this.lblBeneficiarioServico.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBeneficiarioServico.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBeneficiarioServico.setText("Benefici\u00e1rio do Servi\u00e7o");
        this.lblCPFBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCPFBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCPFBeneficiario.setText("CPF");
        this.cbxTitularEhBeneficiario.setBackground(new Color(255, 255, 255));
        this.cbxTitularEhBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.cbxTitularEhBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.cbxTitularEhBeneficiario.setText("Titular do pagamento \u00e9 o pr\u00f3prio benefici\u00e1rio do servi\u00e7o");
        this.cbxBeneficarioNaoPossuiCPF.setBackground(new Color(255, 255, 255));
        this.cbxBeneficarioNaoPossuiCPF.setFont(FontesUtil.FONTE_NORMAL);
        this.cbxBeneficarioNaoPossuiCPF.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.cbxBeneficarioNaoPossuiCPF.setText("CPF n\u00e3o informado");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.lblTitularPagamento).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblCPFTitularPagamento).addPreferredGap(0).add((Component)this.edtCPFTitularPagamento, -2, 135, -2).addPreferredGap(0).add((Component)this.cbxTitularEhBeneficiario)).add((Component)this.lblBeneficiarioServico).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.edtValor, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblCPFBeneficiario).addPreferredGap(0).add((Component)this.edtCPFBeneficiarioServ, -2, 135, -2))).addPreferredGap(0).add((Component)this.cbxBeneficarioNaoPossuiCPF))).addContainerGap(181, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitularPagamento).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblCPFTitularPagamento).add((Component)this.edtCPFTitularPagamento, -2, -1, -2).add((Component)this.cbxTitularEhBeneficiario)).add(18, 18, 18).add((Component)this.lblBeneficiarioServico).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblCPFBeneficiario).add((Component)this.edtCPFBeneficiarioServ, -2, -1, -2).add((Component)this.cbxBeneficarioNaoPossuiCPF)).addPreferredGap(1).add((Component)this.jLabel7).add(5, 5, 5).add((Component)this.edtValor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtValor.getAccessibleContext().setAccessibleName("Valor");
        this.edtCPFTitularPagamento.getAccessibleContext().setAccessibleName("CPF do T\u00edtular do Pagamento");
        this.edtCPFBeneficiarioServ.getAccessibleContext().setAccessibleName("CPF do Benefici\u00e1rio do Servi\u00e7o");
        this.btnIncluirNovo.setMnemonic('i');
        this.btnIncluirNovo.setText("Incluir Novo");
        this.btnIncluirNovo.setToolTipText("");
        this.btnIncluirNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbaEscrituracaoDetalheTitular.this.btnIncluirNovoActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.btnIncluirNovo))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.btnIncluirNovo).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnIncluirNovoActionPerformed(ActionEvent evt) {
        boolean salvou;
        this.isCancelar = false;
        if (this.isPodeSair() && (salvou = this.salvar())) {
            Conta lItem = new Conta();
            lItem.getCpfContribuinte().setConteudo(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado());
            lItem.getDataMesAno().setConteudo(ContasMes.obterIndiceAsString((String)this.siglaMes) + AplicacaoPropertiesUtil.getExercicio());
            IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens().add(lItem);
            this.setConta(lItem);
            this.edtCPFTitularPagamento.requestFocus();
        }
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (!this.isNovoItem) {
            if (ehTransmitida) {
                return "Detalhe Rendimento Recebido de Pessoa F\u00edsica e do Exterior";
            }
            return "Editar Rendimento Recebido de Pessoa F\u00edsica e do Exterior";
        }
        return "Novo Rendimento Recebido de Pessoa F\u00edsica e do Exterior";
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_rend_pf.png");
    }

    private boolean salvar() {
        this.isCancelar = false;
        List contas = IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens();
        boolean achouIgual = false;
        boolean confirmar = true;
        if (this.conta.isEmpty()) {
            IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens().remove(this.conta);
        } else {
            for (Conta c : contas) {
                if (c == this.conta || !c.getValor().naoFormatado().equals(this.conta.getValor().naoFormatado()) || !c.getCpfBeneficiarioServico().naoFormatado().equals(this.conta.getCpfBeneficiarioServico().naoFormatado()) || !c.getCpfTitularPagamento().naoFormatado().equals(this.conta.getCpfTitularPagamento().naoFormatado())) continue;
                achouIgual = true;
                break;
            }
            if (achouIgual && !(confirmar = GuiUtil.mostrarConfirma((String)"200006"))) {
                IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens().remove(this.conta);
            }
        }
        return confirmar;
    }

    public void executaVoltar() {
        this.isCancelar = false;
        boolean salvou = this.salvar();
        if (salvou) {
            PainelDadosEscrituracao painel = (PainelDadosEscrituracao)((Object)PainelCacher.getInstancia().obtemUrgentemente(PainelDadosEscrituracao.class.getName()));
            ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
            ((PainelDadosEscrituracaoTitular)painel.getAbas()[0]).acionarAba(this.siglaMes, true);
            PainelDemonstrativoIf painelTitular = (PainelDemonstrativoIf)painel.getAbas()[0];
            PainelDemonstrativoIf painelTitularMensal = (PainelDemonstrativoIf)painelTitular.getAbas()[0];
            painelTitularMensal.acionarAba(this.siglaMes, true);
            try {
                PainelAbaLancamentosEscrituracaoTitular aba = (PainelAbaLancamentosEscrituracaoTitular)painelTitularMensal.getAbas()[painelTitularMensal.getIndiceAbaPorNome(this.siglaMes)];
                ((TableModelEscrituracao)((Object)aba.getTabela().getModel())).refresh();
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public void executaCancelar() {
        if (this.isNovoItem) {
            IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens().remove(this.conta);
        } else {
            List contas = IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes).itens();
            contas.set(contas.indexOf(this.conta), this.contaAntiga);
        }
        PainelDadosEscrituracao painel = new PainelDadosEscrituracao("Titular");
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
        ((PainelDadosEscrituracaoTitular)painel.getAbas()[0]).acionarAba(this.siglaMes, true);
        PainelDemonstrativoIf painelTitular = (PainelDemonstrativoIf)painel.getAbas()[0];
        PainelDemonstrativoIf painelTitularMensal = (PainelDemonstrativoIf)painelTitular.getAbas()[0];
        painelTitularMensal.acionarAba(this.siglaMes, true);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public JComponent getDefaultFocus() {
        return this.edtCPFTitularPagamento;
    }

    private void associarInformacao() {
        this.jLabel1.setText("Dados do Lan\u00e7amento - M\u00eas: " + ContasMes.obterNomeMesExtenso((String)this.siglaMes));
        this.edtValor.setInformacao((Informacao)this.getConta().getValor());
        this.edtCPFTitularPagamento.setInformacao((Informacao)this.getConta().getCpfTitularPagamento());
        this.edtCPFBeneficiarioServ.setInformacao((Informacao)this.getConta().getCpfBeneficiarioServico());
        this.cbxTitularEhBeneficiario.setSelected(this.getConta().getIndTitularEhBeneficiario().naoFormatado().equals(Logico.SIM));
        this.cbxBeneficarioNaoPossuiCPF.setSelected(this.getConta().getIndBeneficiarioNaoPossuiCPF().naoFormatado().equals(Logico.SIM));
        if (this.cbxBeneficarioNaoPossuiCPF.isSelected()) {
            this.edtCPFBeneficiarioServ.getInformacao().clear();
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(false);
        }
        if (this.cbxTitularEhBeneficiario.isSelected()) {
            this.edtCPFBeneficiarioServ.getInformacao().setHabilitado(false);
            this.cbxBeneficarioNaoPossuiCPF.setEnabled(false);
        }
    }

    public boolean isPodeSair() {
        boolean podeSair = false;
        if (!this.isCancelar) {
            podeSair = true;
        }
        return podeSair;
    }

    public Conta getConta() {
        return this.conta;
    }

    public void setConta(Conta c) {
        this.conta = c;
        this.associarInformacao();
        if (!this.conta.getIndTitularEhBeneficiario().naoFormatado().equals(Logico.SIM)) {
            this.cbxBeneficarioNaoPossuiCPF.setEnabled(true);
        }
    }

    public String getNomeAba() {
        return this.siglaMes;
    }
}

