/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DescricaoCampoAdabas;
import br.gov.serpro.midas.xmlada.DimCampoAdabas;
import br.gov.serpro.midas.xmlada.DocConfig;
import br.gov.serpro.midas.xmlada.DocTipos;
import br.gov.serpro.midas.xmlada.DomDocument;
import br.gov.serpro.midas.xmlada.TextBuffer;
import br.gov.serpro.midas.xmlada.Util;
import br.gov.serpro.midas.xmlada.XMLAdaJ;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocFileEstrutura
extends DomDocument {
    private int tamtipo = 0;

    public DocFileEstrutura(String doc) {
        super(doc);
    }

    public String GeraSelect(String comando) {
        String tmp = "SELECT ";
        String periodoCampo = "";
        Element raiz = this.getDomDoc().getDocumentElement();
        NodeList filhosEstrutura = raiz.getChildNodes();
        int k = 0;
        while (k < filhosEstrutura.getLength()) {
            Element filho;
            if (filhosEstrutura.item(k).getNodeType() == 1 && (filho = (Element)filhosEstrutura.item(k)).getNodeName().equals("campo")) {
                String id;
                periodoCampo = "";
                boolean binario = false;
                if (filho.getAttribute("periodo").length() > 0) {
                    periodoCampo = filho.getAttribute("periodo");
                }
                if (filho.getAttribute("bin").length() > 0 && filho.getAttribute("bin").equalsIgnoreCase("true")) {
                    binario = true;
                }
                if ((id = filho.getAttribute("id")).length() > 0) {
                    if (periodoCampo.length() > 0) {
                        if (binario) {
                            DimCampoAdabas dimensaoCampo = new DimCampoAdabas(periodoCampo);
                            int i = dimensaoCampo.getInicioX();
                            while (i < dimensaoCampo.getFimX()) {
                                int j = dimensaoCampo.getInicioY();
                                while (j < dimensaoCampo.getFimY()) {
                                    tmp = String.valueOf(tmp) + id + (j + i - 1) + "/X";
                                    ++j;
                                }
                                ++i;
                            }
                        } else {
                            tmp = String.valueOf(tmp) + id + periodoCampo + " ";
                        }
                    } else {
                        tmp = String.valueOf(tmp) + id + " ";
                    }
                }
            }
            ++k;
        }
        return String.valueOf(tmp) + comando.substring(8).trim();
    }

    public String GeraRetornoDebug(XMLAdaJ owner) {
        DomDocument docTemplate = new DomDocument(String.valueOf(Util.nomePasta(this.getXml())) + "\\Template.xml");
        Element raizTemplate = docTemplate.getDomDoc().getDocumentElement();
        return raizTemplate.getAttribute("area_retorno_select").length() <= 0 ? "" : raizTemplate.getAttribute("area_retorno_select");
    }

    public String FormataTexto2Xml(String Texto, DocConfig docConfig) throws IOException {
        String fileTipos;
        DocTipos docTipos = null;
        String linha = "";
        Element raizEstrutura = this.getDomDoc().getDocumentElement();
        String strRaiz = raizEstrutura.getAttribute("raiz");
        if (strRaiz.length() == 0) {
            strRaiz = "result";
        }
        if ((fileTipos = raizEstrutura.getAttribute("xmltipos")).length() == 0) {
            fileTipos = docConfig == null ? fileTipos : docConfig.getTipoDefault();
        } else {
            if (!Util.isFullPath(fileTipos)) {
                fileTipos = String.valueOf(XMLAdaJ.getAppPath()) + "\\" + fileTipos;
            }
            docTipos = new DocTipos(fileTipos);
        }
        if (Util.isNumeric(raizEstrutura.getAttribute("tamtipo"))) {
            this.tamtipo = Integer.parseInt(raizEstrutura.getAttribute("tamtipo"));
        }
        DomDocument xmldocSaida = new DomDocument("");
        xmldocSaida.setRaiz(xmldocSaida.criaElemento(strRaiz));
        this.insereAtributos(raizEstrutura, xmldocSaida.getRaiz(), docTipos, linha);
        BufferedReader strReader = new TextBuffer(Texto, false, true).getInFile();
        boolean contTemp = false;
        while ((linha = strReader.readLine()) != null) {
            if (linha.length() <= 0) continue;
            this.FormataLinha(xmldocSaida, docTipos, linha);
            if (XMLAdaJ.getCodigoErro() <= 0) continue;
            System.out.println(XMLAdaJ.getDescricaoErro());
            if (XMLAdaJ.getCodigoErro() != 1001) {
                return xmldocSaida.getTexto();
            }
            XMLAdaJ.setErro(0, "");
        }
        String xsl = raizEstrutura.getAttribute("xsl");
        if (xsl.length() == 0) {
            return xmldocSaida.getTexto();
        }
        if (!Util.isFullPath(fileTipos)) {
            fileTipos = String.valueOf(docConfig.getCaminhoXSL()) + "\\" + fileTipos;
        }
        try {
            return xmldocSaida.transform(fileTipos, ".html");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void FormataRegistroSelect(String linha, DomDocument docxml, DocTipos docTipos, Vector descricaoCampos) {
        String valorCampo = "";
        String nomeCampo = "";
        String formato = "";
        String attrDec = "";
        String getvalue = "";
        String valorCampoFmt = "";
        String nome = "";
        String getadaname = "";
        String adaname = "";
        String attrPosEQ = "";
        String bin = "";
        int pos = 0;
        Element registro = docxml.criaElemento("row");
        docxml.getRaiz().appendChild(registro);
        for (DescricaoCampoAdabas descricaoCampo : descricaoCampos) {
            Element nodeCampo;
            valorCampo = linha.substring(pos, pos + descricaoCampo.getTamanho());
            valorCampoFmt = valorCampo = new String(Util.TrocaCaracteresEspeciais(new StringBuffer(valorCampo)));
            adaname = descricaoCampo.getNome().equals("ISN") ? descricaoCampo.getNome() : descricaoCampo.getNome().substring(0, 2);
            Element element = nodeCampo = this.getOk() ? this.getSingleNode("campo", this.getRaiz(), "id=" + adaname) : null;
            if (nodeCampo != null) {
                formato = nodeCampo.getAttribute("formato");
                getvalue = nodeCampo.getAttribute("getvalue");
                nome = nodeCampo.getAttribute("nome");
                getadaname = nodeCampo.getAttribute("getadaname");
                bin = nodeCampo.getAttribute("bin");
                valorCampoFmt = !docTipos.getOk() || formato.length() <= 0 ? valorCampo : docTipos.formataCampo(formato, valorCampo);
            }
            nomeCampo = nome.length() <= 0 ? adaname : nome;
            Element campo = docxml.criaElemento(nomeCampo);
            docxml.insereAtributos(nodeCampo, campo, docTipos, linha);
            if (descricaoCampo.getCoord().length() > 0) {
                campo.setAttribute("coord", descricaoCampo.getCoord());
            }
            if (getadaname.equalsIgnoreCase("TRUE")) {
                campo.setAttribute("adaname", adaname);
            }
            if (getvalue.equalsIgnoreCase("TRUE")) {
                campo.setAttribute("valor", valorCampo);
            }
            if (bin.equalsIgnoreCase("TRUE")) {
                campo.setAttribute("bin", "true");
            }
            valorCampoFmt = String.valueOf(this.verAfixos(nodeCampo, "prefixo", docTipos, linha)) + valorCampoFmt + this.verAfixos(nodeCampo, "sufixo", docTipos, linha);
            campo.appendChild(docxml.criaNoTexto(valorCampoFmt));
            registro.appendChild(campo);
            pos += descricaoCampo.getTamanho();
        }
    }

    private void FormataLinha(DomDocument xmldocSaida, DocTipos docTipos, String linha) {
        try {
            Element raizSaida;
            String tipoReg = "";
            Element atualSaida = raizSaida = xmldocSaida.getRaiz();
            Element campoPaiEstrutura = this.getDomDoc().getDocumentElement();
            if (this.tamtipo > 0 && Util.isNumeric(tipoReg = linha.substring(0, this.tamtipo))) {
                tipoReg = "_" + tipoReg;
            }
            if (tipoReg.length() > 0) {
                atualSaida = xmldocSaida.criaElemento(tipoReg);
                raizSaida.appendChild(atualSaida);
                campoPaiEstrutura = this.getSingleNode("tipo", campoPaiEstrutura, "nome=" + tipoReg);
                if (campoPaiEstrutura == null) {
                    XMLAdaJ.setCodigoErro(1001);
                    XMLAdaJ.setDescricaoErro("Especifica\u00e7\u00e3o de Tipo <" + tipoReg + "> n\u00e3o encontrado!");
                    return;
                }
                this.insereAtributos(campoPaiEstrutura, atualSaida, docTipos, linha);
            }
            int inicio = 0;
            int tamanho = 0;
            NodeList nosFilhos = campoPaiEstrutura.getChildNodes();
            int i = 0;
            while (i < nosFilhos.getLength()) {
                String nome;
                Element child;
                if (nosFilhos.item(i).getNodeType() == 1 && (child = (Element)nosFilhos.item(i)).getNodeName() == "campo" && (nome = child.getAttribute("nome")).length() > 0) {
                    String valorFormatado;
                    inicio += tamanho;
                    tamanho = child.getAttribute("tam").length() <= 0 ? 0 : Integer.parseInt(child.getAttribute("tam"));
                    String formato = child.getAttribute("formato");
                    String valor = child.getAttribute("valor");
                    try {
                        String string = valor = valor.length() != 0 ? valor : linha.substring(inicio, inicio + tamanho).trim();
                        valorFormatado = docTipos == null ? valor : (docTipos.getOk() ? docTipos.formataCampo(formato, valor) : valor);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        valorFormatado = valor = e.getLocalizedMessage();
                    }
                    valorFormatado = String.valueOf(this.verAfixos(child, "prefixo", docTipos, linha)) + valorFormatado + this.verAfixos(child, "sufixo", docTipos, linha);
                    Element elCampo = xmldocSaida.criaElemento(nome);
                    if (valorFormatado.length() > 0) {
                        elCampo.appendChild(xmldocSaida.criaNoTexto(valorFormatado));
                    }
                    this.insereAtributos(child, elCampo, docTipos, linha);
                    if (child.getAttribute("getvalue").equalsIgnoreCase("true")) {
                        elCampo.setAttribute("valor", valor);
                    }
                    atualSaida.appendChild(elCampo);
                }
                ++i;
            }
        }
        catch (Exception e) {
            XMLAdaJ.setErro(e.hashCode(), "(FormataLinha) " + e.getLocalizedMessage());
        }
    }
}

