/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.repositorioXML.AdaptadorXMLAtributo;

class AdaptadorXMLObjeto {
    private String elementoXML;
    private String classeJava;
    private String conteiner;
    private String metodoAcesso;
    private List<AdaptadorXMLAtributo> atributos;
    private boolean marshalling = true;
    private boolean unmarshalling = true;

    public AdaptadorXMLObjeto(Element nodeXmlMapeamento) {
        String nomeElementoRaiz = nodeXmlMapeamento.getOwnerDocument().getDocumentElement().getAttribute("ElementoXML");
        if (nodeXmlMapeamento.getNodeName().compareTo("Classe") != 0 && nodeXmlMapeamento.getNodeName().compareTo("Mapeamento") != 0) {
            LogPPGD.erro((String)"Mapeamento: Par\u00e2metro inv\u00e1lido - elemento XML n\u00e3o \u00e9 TClasse");
            throw new IllegalArgumentException("Mapeamento: N\u00e3o \u00e9 Classe");
        }
        this.elementoXML = nodeXmlMapeamento.getAttribute("ElementoXML");
        if (this.elementoXML.length() == 0) {
            LogPPGD.erro((String)"Mapeamento inv\u00e1lido");
            throw new DOMException(12, "Mapeamento: ElementoXML n\u00e3o pode ser vazio");
        }
        this.classeJava = nodeXmlMapeamento.getAttribute("ClasseJava");
        if (this.classeJava.length() == 0) {
            this.classeJava = this.elementoXML;
        }
        if (nodeXmlMapeamento.getAttribute("Marshalling").toLowerCase().compareTo("false") == 0) {
            this.marshalling = false;
        }
        if (nodeXmlMapeamento.getAttribute("Unmarshalling").toLowerCase().compareTo("false") == 0) {
            this.unmarshalling = false;
        }
        this.conteiner = "";
        this.metodoAcesso = "get" + this.elementoXML;
        if (nodeXmlMapeamento.hasChildNodes()) {
            NodeList filhos = nodeXmlMapeamento.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                if (filhos.item(i).getNodeType() != 1) continue;
                Element nodeFilho = (Element)filhos.item(i);
                if (nodeFilho.getNodeName().compareTo("PertenceA") == 0) {
                    String nomeConteiner = nodeFilho.getAttribute("ElementoXML");
                    this.conteiner = nomeConteiner.length() == 0 || nomeConteiner.compareTo(nomeElementoRaiz) == 0 ? "" : nomeConteiner;
                    this.metodoAcesso = nodeFilho.getAttribute("MetodoAcesso");
                    continue;
                }
                if (nodeFilho.getNodeName().compareTo("Atributo") != 0) continue;
                if (this.atributos == null) {
                    this.atributos = new ArrayList<AdaptadorXMLAtributo>();
                }
                this.atributos.add(new AdaptadorXMLAtributo(nodeFilho));
            }
        }
    }

    public Class<?> getClasseJava() throws ClassNotFoundException {
        return Class.forName(this.classeJava);
    }

    public String getConteiner() {
        return this.conteiner;
    }

    public String getMetodoAcesso() {
        return this.metodoAcesso;
    }

    public String toString() {
        String resultado = "ElementoXML: " + this.getElementoXML() + ", ClasseJava: " + this.classeJava + ", Conteiner: " + this.getConteiner() + ", MetodoAcesso: " + this.getMetodoAcesso();
        if (this.atributos != null) {
            resultado = resultado + ". Atributos: ";
            Iterator<AdaptadorXMLAtributo> iterator = this.atributos.iterator();
            while (iterator.hasNext()) {
                resultado = resultado + iterator.next();
            }
        }
        return resultado;
    }

    public boolean isMarshalling() {
        return this.marshalling;
    }

    public String getElementoXML() {
        return this.elementoXML;
    }

    public List<AdaptadorXMLAtributo> getAtributos() {
        return this.atributos;
    }

    public boolean isUnmarshalling() {
        return this.unmarshalling;
    }
}

