/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.util.ArrayList;
import serpro.ppgd.formatosexternos.txt.CampoReg;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.MapeamentoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ConversorObjetoParaRegistros {
    public void preencheDocumentoTXT(ObjetoNegocio pObj, DocumentoTXT pDoc) throws GeracaoTxtException {
        pDoc.clear();
        for (String tipoRegAtual : MapeamentoTXT.getInstance().getTiposDeRegistrosArquivo(pDoc.getTipoArquivo())) {
            String colecaoRegistros = MapeamentoTXT.getInstance().getColecaoRegistroMultipo(pDoc.getTipoArquivo(), tipoRegAtual);
            Colecao col = null;
            if (colecaoRegistros.trim().length() != 0) {
                if (colecaoRegistros.toUpperCase().equals("THIS")) {
                    col = (Colecao)pObj;
                } else {
                    int posicaoLasanha = colecaoRegistros.indexOf("#");
                    if (posicaoLasanha == -1) {
                        col = (Colecao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)colecaoRegistros);
                    } else {
                        ObjetoNegocio obj = null;
                        obj = posicaoLasanha == 0 ? pObj : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)colecaoRegistros.substring(0, posicaoLasanha));
                        String nomeMetodo = colecaoRegistros.substring(posicaoLasanha + 1, colecaoRegistros.length());
                        col = (Colecao)FabricaUtilitarios.invocaMetodo((String)nomeMetodo, (Object)obj, (Class[])new Class[0], (Object[])new Object[0]);
                    }
                }
                col.excluirRegistrosEmBranco();
                this.setaRegistroMultiplo(col, tipoRegAtual, pObj, pDoc);
                continue;
            }
            this.setaRegistroComum(tipoRegAtual, pObj, pDoc);
        }
    }

    protected boolean antesDeSetarRegistro(ObjetoNegocio pObj, RegistroTxt pReg, DocumentoTXT pDoc) throws GeracaoTxtException {
        return true;
    }

    private void setaRegistroComum(String pTipoReg, ObjetoNegocio pObj, DocumentoTXT pDoc) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt(pDoc.getTipoArquivo(), pTipoReg);
        ArrayList<RegistroTxt> listaReg = new ArrayList<RegistroTxt>();
        if (reg.isParticipaGravacao() && this.antesDeSetarRegistro(pObj, reg, pDoc)) {
            for (CampoReg campoAtual : reg.objListaCampos) {
                if (!campoAtual.isParticipaGravacao()) continue;
                if (campoAtual.getConteudoEstatico() != null && campoAtual.getConteudoEstatico().trim().length() != 0) {
                    campoAtual.getCampoTXT().set(campoAtual.getConteudoEstatico());
                    continue;
                }
                if (campoAtual.getAtributoObjetoNegocio().trim().length() != 0) {
                    String atributoObjetoNegocio = campoAtual.getAtributoObjetoNegocio();
                    int posicaoLasanha = atributoObjetoNegocio.indexOf("#");
                    if (posicaoLasanha == -1) {
                        Informacao info = (Informacao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)atributoObjetoNegocio);
                        this.setaCampoTXT(campoAtual.getCampoTXT(), info);
                        continue;
                    }
                    ObjetoNegocio obj = null;
                    obj = posicaoLasanha == 0 ? pObj : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)pObj, (String)atributoObjetoNegocio.substring(0, posicaoLasanha));
                    String nomeMetodo = atributoObjetoNegocio.substring(posicaoLasanha + 1, atributoObjetoNegocio.length());
                    Object retornoMetodo = FabricaUtilitarios.invocaMetodo((String)nomeMetodo, (Object)obj, (Class[])new Class[]{String.class}, (Object[])new Object[]{null});
                    if (retornoMetodo == null) continue;
                    campoAtual.getCampoTXT().set(retornoMetodo.toString());
                    continue;
                }
                this.setaOutrosCampos(pObj, campoAtual.getCampoTXT(), reg);
            }
            listaReg.add(reg);
            pDoc.setFicha(listaReg);
        }
    }

    protected void setaOutrosCampos(ObjetoNegocio pDec, CampoTXT pCampoTxt, RegistroTxt pReg) throws GeracaoTxtException {
    }

    private void setaRegistroMultiplo(Colecao pCol, String pTipoReg, ObjetoNegocio pDec, DocumentoTXT pDoc) throws GeracaoTxtException {
        ArrayList<RegistroTxt> listaReg = new ArrayList<RegistroTxt>();
        for (ObjetoNegocio objAtual : pCol.recuperarLista()) {
            RegistroTxt reg = new RegistroTxt(pDoc.getTipoArquivo(), pTipoReg);
            if (!reg.isParticipaGravacao() || !this.antesDeSetarRegistro(pDec, reg, pDoc)) continue;
            for (CampoReg campoAtual : reg.objListaCampos) {
                if (!campoAtual.isParticipaGravacao()) continue;
                if (campoAtual.getConteudoEstatico() != null && campoAtual.getConteudoEstatico().trim().length() != 0) {
                    campoAtual.getCampoTXT().set(campoAtual.getConteudoEstatico());
                    continue;
                }
                if (campoAtual.getAtributoObjetoNegocio().trim().length() != 0) {
                    String atributoObjetoNegocio = campoAtual.getAtributoObjetoNegocio();
                    int posicaoLasanha = atributoObjetoNegocio.indexOf("#");
                    if (posicaoLasanha == -1) {
                        Informacao info = (Informacao)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)objAtual, (String)atributoObjetoNegocio);
                        this.setaCampoTXT(campoAtual.getCampoTXT(), info);
                        continue;
                    }
                    ObjetoNegocio obj = null;
                    obj = posicaoLasanha == 0 ? objAtual : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo((ObjetoNegocio)objAtual, (String)atributoObjetoNegocio.substring(0, posicaoLasanha));
                    String nomeMetodo = atributoObjetoNegocio.substring(posicaoLasanha + 1, atributoObjetoNegocio.length());
                    Object retornoMetodo = FabricaUtilitarios.invocaMetodo((String)nomeMetodo, (Object)obj, (Class[])new Class[]{String.class}, (Object[])new Object[]{null});
                    if (retornoMetodo == null) continue;
                    campoAtual.getCampoTXT().set(retornoMetodo.toString());
                    continue;
                }
                this.setaOutrosCampos(pDec, campoAtual.getCampoTXT(), reg);
            }
            listaReg.add(reg);
        }
        pDoc.setFicha(listaReg);
    }

    protected void setaCampoTXT(CampoTXT pCampoTxt, Informacao pInfo) throws GeracaoTxtException {
        if (pInfo.isVazio()) {
            return;
        }
        if (pInfo instanceof Valor) {
            pCampoTxt.set((Valor)pInfo);
        } else if (pInfo instanceof Codigo) {
            pCampoTxt.set(((Codigo)pInfo).getConteudoAtual(0));
        } else {
            pCampoTxt.set(pInfo.asString());
        }
    }
}

