/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.barcode.util;

import java.util.Date;
import java.util.GregorianCalendar;

public class JulianDate {
    private int year;
    private int month;
    private int day;
    private GregorianCalendar calendar;

    public JulianDate() {
        this.calendar = new GregorianCalendar();
        this.calendar.setGregorianChange(new Date());
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        ++this.month;
        this.day = this.calendar.get(5);
    }

    public JulianDate(Date date) {
        this.calendar = new GregorianCalendar();
        this.calendar.setGregorianChange(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        ++this.month;
        this.day = this.calendar.get(5);
    }

    public JulianDate(String date) throws Exception {
        if (date.length() == 8) {
            this.day = Integer.parseInt(date.substring(0, 2));
            this.month = Integer.parseInt(date.substring(2, 4));
            this.year = Integer.parseInt(date.substring(4));
        } else if (date.length() == 10) {
            this.day = Integer.parseInt(date.substring(0, 2));
            this.month = Integer.parseInt(date.substring(3, 5));
            this.year = Integer.parseInt(date.substring(6));
        } else {
            throw new Exception("Invalid format.");
        }
        this.calendar = new GregorianCalendar(this.year, this.month - 1, this.day);
    }

    public JulianDate(int day, int month, int year) throws Exception {
        this.day = day;
        this.month = month;
        this.year = year;
        this.calendar = new GregorianCalendar(year, month - 1, day);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String getJulianDate7Digits() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int x = this.calendar.get(6);
        if (x < 10) {
            sb2.append("00").append(x);
        } else if (x >= 10 && x < 100) {
            sb2.append("0");
        }
        sb2.append(x);
        sb.append(this.year).append(sb2.toString());
        return sb.toString();
    }

    public String getJulianDate4Digits() {
        return this.getJulianDate7Digits().substring(3);
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }
}

