/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import serpro.ppgd.app.acoes.AtivarRecuperarNomesAction;
import serpro.ppgd.app.acoes.SairAction;
import serpro.ppgd.app.acoes.VerificarNovaVersaoAction;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.Toast;
import serpro.ppgd.irpf.gui.update.PainelAvisoVerificarAtualizacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.update.IRPFUpdateProperties;
import serpro.ppgd.irpf.util.update.IRPFUpdater;
import serpro.ppgd.negocio.util.LogPPGD;

public class PlataformaIRPFPGD
extends PlataformaPPGD {
    private SairAction fecharAction = new SairAction();

    public void carrega(Class<?> classJanelaPGD) {
        try {
            PlataformaIRPFPGD.setEmDesign((boolean)false);
            this.configuraFontes();
            this.setAplicativo((JanelaPrincipalPPGD)classJanelaPGD.newInstance());
            this.carregaHelp();
            this.getJanelaPrincipal().setDefaultCloseOperation(0);
            this.getJanelaPrincipal().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PlataformaIRPFPGD.this.fecharAction.actionPerformed(null);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    boolean cacheLigado = ControladorGui.getIRPFPreferences().getBoolean("CacheNILigado", false);
                    CacheNI.getInstancia().setLigado(cacheLigado);
                    try {
                        CacheNI.getInstancia().carregar();
                    }
                    catch (Exception ex) {
                        LogPPGD.erro((String)ex.getMessage());
                    }
                    new AtivarRecuperarNomesAction().confirmaAcaoMensagemInicial();
                    if (!PlataformaIRPFPGD.this.finalizouAtualizacao()) {
                        PlataformaIRPFPGD.this.verificarNovaVersao();
                    }
                }
            });
        }
        catch (Exception e) {
            ControladorGui.tratarException((Exception)e);
        }
    }

    private boolean finalizouAtualizacao() {
        boolean finalizouAtualizacao = false;
        IRPFUpdater irpfUpdater = IRPFUpdater.getInstance();
        if (irpfUpdater.temPermissaoEscritaPastaBase()) {
            IRPFUpdateProperties updateProperties = null;
            try {
                updateProperties = irpfUpdater.temAtualizacaoCompletada();
                if (updateProperties != null) {
                    Toast.makeText((JFrame)ControladorGui.getJanelaPrincipal(), (String)("IRPF Atualizado com sucesso. Vers\u00e3o " + updateProperties.getVersaoAtual() + ".")).display();
                    if (updateProperties.getMensagem() != null && !updateProperties.getMensagem().trim().isEmpty()) {
                        finalizouAtualizacao = true;
                        GuiUtil.exibeDialog((Object)this.getJanelaPrincipal(), (JComponent)new PainelAvisoVerificarAtualizacoes("Nova Vers\u00e3o Instalada", updateProperties.getMensagem(), null, "OK"), (boolean)true, (String)"Verificar Atualiza\u00e7\u00f5es", (boolean)false, null, null, (boolean)false, (int)0, (boolean)true, (boolean)false);
                    }
                }
            }
            catch (AplicacaoException aplicacaoException) {
                // empty catch block
            }
        }
        return finalizouAtualizacao;
    }

    private void verificarNovaVersao() {
        VerificarNovaVersaoAction action = new VerificarNovaVersaoAction();
        action.setExibirDicaAtualizar(true);
        action.setExibirPopups(false);
        action.verificarUltimaVersao();
    }

    public void aplicaArvore(String aFonteArvore) {
    }
}

