/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class UtilitariosArquivo {
    public static Properties loadProperties(String path, Class<?> baseClass) {
        InputStream in = baseClass.getResourceAsStream(path);
        Properties p = new Properties();
        try {
            if (in != null) {
                p.load(in);
                LogPPGD.debug("Propriedades carregadas do arquivo: " + path);
            } else {
                LogPPGD.aviso("Nao foi poss\u00edvel localizar o arquivo: " + path);
            }
        }
        catch (IOException ioe) {
            LogPPGD.aviso("N\u00e3o foi poss\u00edvel carregar arquivo: " + path);
            LogPPGD.erro("Erro ao carregar arquivo.");
            ioe.printStackTrace();
        }
        return p;
    }

    public static Properties saveProperties(String path, Properties prop) {
        return null;
    }

    public static InputStream getResource(String path, Class<?> baseClass) {
        InputStream in = baseClass.getResourceAsStream(path);
        if (in == null) {
            LogPPGD.aviso("Retornando um stream NULO para o arquivo: " + path);
        }
        return in;
    }

    public static void copiaArquivoDoJar(String fromJarPath, String toPath, Class<?> baseClass) {
        try {
            BufferedInputStream is = new BufferedInputStream(UtilitariosArquivo.getResource(fromJarPath, baseClass));
            FileOutputStream file = new FileOutputStream(toPath);
            BufferedOutputStream o = new BufferedOutputStream(file);
            int b = ((InputStream)is).read();
            while (b != -1) {
                ((OutputStream)o).write(b);
                b = ((InputStream)is).read();
            }
            ((OutputStream)o).flush();
            ((OutputStream)o).close();
        }
        catch (FileNotFoundException fnf) {
            LogPPGD.erro("Arquivo de saida n\u00e3o encontrado.");
        }
        catch (IOException ioe) {
            LogPPGD.erro("Erro na escrita do arquivo.");
        }
    }

    public static String extraiNomeArquivo(String nomeArquivoComPath) {
        return new File(nomeArquivoComPath).getName();
    }

    public static String extraiPath(String nomeArquivo) {
        int posjar;
        if (nomeArquivo.startsWith("file:")) {
            nomeArquivo = nomeArquivo.substring(5);
        }
        if ((posjar = nomeArquivo.indexOf(33)) != -1) {
            nomeArquivo = nomeArquivo.substring(0, posjar);
        }
        return nomeArquivo.substring(0, nomeArquivo.lastIndexOf(UtilitariosArquivo.extraiNomeArquivo(nomeArquivo)));
    }

    public static String extraiNomeAquivoSemExtensao(String nomeArquivo) {
        return nomeArquivo.substring(0, nomeArquivo.lastIndexOf("."));
    }

    public static String extraiExtensaoAquivo(String nomeArquivo) {
        return nomeArquivo.substring(nomeArquivo.lastIndexOf(".", nomeArquivo.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copiaArquivo(String in, String outPath) {
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            source = new File(in);
            int fileLength = (int)source.length();
            char[] charBuff = new char[fileLength];
            File flSaida = new File(outPath);
            if (!flSaida.exists()) {
                flSaida.mkdirs();
            }
            if (source.getParent().equals(flSaida.getPath())) {
                return;
            }
            outPath = outPath + "/" + source.getName();
            fr = new FileReader(in);
            fw = new FileWriter(outPath);
            br = new BufferedReader(fr);
            bw = new BufferedWriter(fw);
            while (br.read(charBuff, 0, fileLength) != -1) {
                bw.write(charBuff, 0, fileLength);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopiaArquivo(String in, String outPath) {
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            source = new File(in);
            int fileLength = (int)source.length();
            char[] charBuff = new char[fileLength];
            File flSaida = new File(outPath);
            if (!flSaida.exists()) {
                flSaida.mkdirs();
            }
            outPath = outPath + "/" + source.getName();
            fr = new FileReader(in);
            fw = new FileWriter(outPath);
            br = new BufferedReader(fr);
            bw = new BufferedWriter(fw);
            while (br.read(charBuff, 0, fileLength) != -1) {
                bw.write(charBuff, 0, fileLength);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean ehDisquete(File pFile) {
        return pFile.getPath().toUpperCase().indexOf("A:") != -1;
    }

    public static void apagaDiretorio(File pFile) throws IOException {
        File[] arquivos = pFile.listFiles();
        for (int i = 0; i < arquivos.length; ++i) {
            if (arquivos[i].isDirectory()) {
                UtilitariosArquivo.apagaDiretorio(arquivos[i]);
                continue;
            }
            arquivos[i].delete();
        }
        pFile.delete();
    }

    public static File getRECCorrespondente(File aDec) {
        File retVal = null;
        String arqDEC = aDec.getPath();
        int indiceUltimoSeparador = arqDEC.lastIndexOf(File.separator);
        String arqREC = arqDEC.substring(0, arqDEC.length() - 4) + ".REC";
        String cpf = arqDEC.substring(0, 11);
        File fileRec = new File(arqREC);
        if (!fileRec.exists()) {
            arqREC = arqDEC.substring(0, indiceUltimoSeparador + 1);
            arqREC = arqREC + cpf.substring(0, 8);
            arqREC = arqREC + ".REC";
            fileRec = new File(arqREC);
        }
        if (fileRec.exists()) {
            retVal = fileRec;
        }
        return retVal;
    }

    public static File getDisquete() {
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!UtilitariosArquivo.ehDisquete(roots[i])) continue;
            return roots[i];
        }
        return null;
    }

    public static void apagaDisquete() {
        try {
            File[] arquivosDisquete = UtilitariosArquivo.getDisquete().listFiles();
            for (int i = 0; i < arquivosDisquete.length; ++i) {
                if (arquivosDisquete[i].isDirectory()) {
                    UtilitariosArquivo.apagaDiretorio(arquivosDisquete[i]);
                    continue;
                }
                arquivosDisquete[i].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL localizaArquivoEmClasspath(String aRecurso) {
        return UtilitariosArquivo.class.getResource(aRecurso);
    }

    public static String getPathAplicacao() {
        String path;
        URL url = FabricaUtilitarios.class.getResource("/aplicacao.properties");
        if (url == null) {
            path = System.getProperty("user.dir");
        } else {
            URI uri = null;
            try {
                uri = new URI(url.getFile());
            }
            catch (URISyntaxException e) {
                path = System.getProperty("user.dir");
            }
            String s = uri.getPath();
            if (s == null) {
                s = url.getPath();
            }
            path = UtilitariosArquivo.extraiPath(s);
        }
        return path;
    }

    public static String getArquivoLog() throws FileNotFoundException {
        String path = null;
        String nomeArquivoLog = ConstantesGlobais.NOME_PROGRAMA + ConstantesGlobais.EXERCICIO + ".log";
        System.out.println("Redirecionando msgs de erro para '" + nomeArquivoLog + "'...");
        String pathArquivoLog = null;
        pathArquivoLog = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
        File diretorio = new File(pathArquivoLog);
        if (diretorio.exists() || !diretorio.mkdirs()) {
            // empty if block
        }
        path = pathArquivoLog + nomeArquivoLog;
        return path;
    }

    public static String getPathDados() {
        String dirDados = FabricaUtilitarios.getProperties().getProperty("aplicacao.diretorio.dados");
        if (dirDados.charAt(dirDados.length() - 1) != '/') {
            dirDados = dirDados + "/";
        }
        dirDados = dirDados + "aplicacao/dados";
        return dirDados;
    }

    public static String getPathUsuario() {
        String dirDados = FabricaUtilitarios.getProperties().getProperty("aplicacao.diretorio.dados");
        if (dirDados.charAt(dirDados.length() - 1) != '/') {
            dirDados = dirDados + "/";
        }
        return dirDados;
    }

    public static String getPathImpressao() {
        return UtilitariosArquivo.getPathAplicacao() + "impressao";
    }

    public static String getPathGravadas() {
        return UtilitariosArquivo.getPathUsuario() + "gravadas";
    }

    public static String getPathTransmitidas() {
        return UtilitariosArquivo.getPathUsuario() + "transmitidas";
    }

    public static String getPathLib() {
        return UtilitariosArquivo.getPathAplicacao() + "lib";
    }

    public static String getPathConfiguracoesRFB() {
        return new File(new File(System.getProperty("user.home")), ".rfb").toString();
    }

    public static void main(String[] args) {
        Properties prop = UtilitariosArquivo.loadProperties("/aplicacao.properties", UtilitariosArquivo.class);
        URL url = UtilitariosArquivo.localizaArquivoEmClasspath("/aplicacao.properties");
        if (url != null) {
            // empty if block
        }
        prop.setProperty("teste", "teste valor");
        UtilitariosArquivo.saveProperties("/aplicacao.properties", prop);
    }
}

