/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.impl.IdDeclaracaoImpl;
import serpro.ppgd.negocio.impl.IdUsuarioImpl;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.PreenchedorCodigo;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;

public class FabricaUtilitarios {
    private static Properties properties;
    public static String nomeClasseId;
    public static String nomeClasseIdDeclaracao;
    public static String nomeClasseDeclaracao;
    public static boolean usaCacheParaReflexao;
    private static Map<Class<?>, List<Field>> cacheTempToReflection;

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().indexOf("WIND") != -1;
    }

    public static boolean isWindowsVista() {
        return System.getProperty("os.name").toUpperCase().indexOf("VISTA") >= 0;
    }

    public static boolean isWindows7() {
        return System.getProperty("os.name").toUpperCase().indexOf("WINDOWS 7") >= 0;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toUpperCase().indexOf("LINUX") != -1;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toUpperCase().indexOf("MAC") != -1;
    }

    public static String getPathCompletoDirAplicacao() {
        String path;
        URL url = FabricaUtilitarios.class.getResource("/aplicacao.properties");
        if (url == null) {
            path = System.getProperty("user.dir");
        } else {
            URI uri = null;
            try {
                uri = new URI(url.getFile());
            }
            catch (URISyntaxException e) {
                path = System.getProperty("user.dir");
            }
            String s = uri.getPath();
            if (s == null) {
                s = url.getPath();
            }
            path = UtilitariosArquivo.extraiPath(s);
        }
        return path;
    }

    public static Properties getProperties() {
        String dirDados;
        if (properties == null && ((dirDados = (properties = UtilitariosArquivo.loadProperties("/aplicacao.properties", FabricaUtilitarios.class)).getProperty("aplicacao.diretorio.dados")) == null || dirDados.equals(""))) {
            if (FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac()) {
                String nomeAplicacao = properties.getProperty("nomeAplicacao");
                String exercicio = properties.getProperty("exercicio");
                dirDados = System.getProperty("user.home");
                if (FabricaUtilitarios.isMac()) {
                    dirDados = dirDados + File.separator + "Documents";
                }
                dirDados = dirDados + File.separator + "ProgramasRFB" + File.separator + nomeAplicacao + exercicio;
            } else {
                dirDados = UtilitariosArquivo.getPathAplicacao();
            }
            properties.setProperty("aplicacao.diretorio.dados", dirDados);
        }
        return properties;
    }

    public static void saveProperties() {
        if (properties != null) {
            UtilitariosArquivo.saveProperties("/aplicacao.properties", properties);
        }
    }

    public static String getPathCompletoDirDadosAplicacao() {
        String dirDados = FabricaUtilitarios.getProperties().getProperty("aplicacao.diretorio.dados");
        if (dirDados.charAt(dirDados.length() - 1) != '/') {
            dirDados = dirDados + "/";
        }
        dirDados = dirDados + "aplicacao/dados";
        return dirDados;
    }

    public static String getPathCompletoDirImpressao() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "impressao";
    }

    public static String getPathCompletoDirGravadas() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "gravadas";
    }

    public static String getPathCompletoDirTransmitidas() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "transmitidas";
    }

    public static String getPathCompletoDirLib() {
        return FabricaUtilitarios.getPathCompletoDirAplicacao() + "lib";
    }

    public static void criaDiretorioBasicos() {
        File flDados = new File(FabricaUtilitarios.getPathCompletoDirImpressao());
        flDados.mkdirs();
        flDados = new File(FabricaUtilitarios.getPathCompletoDirGravadas());
        flDados.mkdirs();
        flDados = new File(FabricaUtilitarios.getPathCompletoDirTransmitidas());
        flDados.mkdirs();
        flDados = new File(FabricaUtilitarios.getPathCompletoDirLib());
        flDados.mkdirs();
    }

    public static List<Field> getFieldsCamposInformacao(Class<?> pClass) {
        Field[] fields = pClass.getDeclaredFields();
        ArrayList<Field> retorno = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (!Informacao.class.isAssignableFrom(fields[i].getType())) continue;
            retorno.add(fields[i]);
        }
        if (pClass.getSuperclass() != null && !pClass.getSuperclass().equals(ObjetoNegocio.class)) {
            retorno.addAll(FabricaUtilitarios.getFieldsCamposInformacao(pClass.getSuperclass()));
        }
        return retorno;
    }

    public static List<Field> getAllFields(Class<?> pClass) {
        if (usaCacheParaReflexao && FabricaUtilitarios.getCacheTempToReflection().containsKey(pClass)) {
            return FabricaUtilitarios.getCacheTempToReflection().get(pClass);
        }
        Field[] fields = pClass.getDeclaredFields();
        ArrayList<Field> retorno = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            retorno.add(fields[i]);
        }
        if (pClass.getSuperclass() != null) {
            retorno.addAll(FabricaUtilitarios.getAllFields(pClass.getSuperclass()));
        }
        if (usaCacheParaReflexao) {
            FabricaUtilitarios.getCacheTempToReflection().put(pClass, retorno);
        }
        return retorno;
    }

    public static List<Field> getAllFieldsOfSpecificType(Class<?> pClass, Class<?> pTipoDesejado) {
        Field[] fields = pClass.getDeclaredFields();
        ArrayList<Field> retorno = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (!pTipoDesejado.isAssignableFrom(fields[i].getType())) continue;
            retorno.add(fields[i]);
        }
        if (pClass.getSuperclass() != null) {
            retorno.addAll(FabricaUtilitarios.getAllFieldsOfSpecificType(pClass.getSuperclass(), pTipoDesejado));
        }
        return retorno;
    }

    public static List<Field> getFieldsCamposObjetoNegocio(Class<?> pClass) {
        Field[] fields = pClass.getDeclaredFields();
        ArrayList<Field> retorno = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
            retorno.add(fields[i]);
        }
        if (pClass.getSuperclass() != null && !pClass.getSuperclass().equals(ObjetoNegocio.class)) {
            retorno.addAll(FabricaUtilitarios.getFieldsCamposObjetoNegocio(pClass.getSuperclass()));
        }
        return retorno;
    }

    public static Object getValorField(Field pField, Object pInstancia) {
        boolean isAcessible = pField.isAccessible();
        try {
            pField.setAccessible(true);
            Object retorno = pField.get(pInstancia);
            pField.setAccessible(isAcessible);
            return retorno;
        }
        catch (Exception e) {
            pField.setAccessible(isAcessible);
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo: " + e.getMessage());
        }
    }

    public static Object getValorField(String pField, Object pInstancia) {
        try {
            Field f = null;
            for (Field fieldAtual : FabricaUtilitarios.getFieldsCamposInformacao(pInstancia.getClass())) {
                if (!fieldAtual.getName().equals(pField)) continue;
                f = fieldAtual;
            }
            return FabricaUtilitarios.getValorField(f, pInstancia);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo: " + e.getMessage());
        }
    }

    public static Object getValorFieldGenerico(String pField, Object pInstancia) {
        try {
            if (pInstancia != null) {
                Iterator<Field> itFields = FabricaUtilitarios.getAllFields(pInstancia.getClass()).iterator();
                Field f = null;
                while (itFields.hasNext()) {
                    Field fieldAtual = itFields.next();
                    if (!fieldAtual.getName().equals(pField)) continue;
                    f = fieldAtual;
                    return FabricaUtilitarios.getValorField(f, pInstancia);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo :" + pField + " \nErro:\n" + e.getMessage());
        }
    }

    public static Object obtemAtributo(ObjetoNegocio pObj, String pSequenciaMetodos) {
        StringTokenizer atributos = new StringTokenizer(pSequenciaMetodos, ".");
        Object ultimoAtributoNegocioAcessado = pObj;
        while (atributos.hasMoreTokens()) {
            String atributoAtual = atributos.nextToken();
            ultimoAtributoNegocioAcessado = FabricaUtilitarios.getValorFieldGenerico(atributoAtual, ultimoAtributoNegocioAcessado);
        }
        return ultimoAtributoNegocioAcessado;
    }

    public static Object obtemAtributoComExcecao(ObjetoNegocio pObj, String pSequenciaMetodos) {
        StringTokenizer atributos = new StringTokenizer(pSequenciaMetodos, ".");
        Object ultimoAtributoNegocioAcessado = pObj;
        while (atributos.hasMoreTokens()) {
            String atributoAtual = atributos.nextToken();
            ultimoAtributoNegocioAcessado = FabricaUtilitarios.getValorFieldGenericoComExcecao(atributoAtual, ultimoAtributoNegocioAcessado);
        }
        return ultimoAtributoNegocioAcessado;
    }

    public static Object getValorFieldGenericoComExcecao(String pField, Object pInstancia) {
        try {
            Field f = null;
            for (Field fieldAtual : FabricaUtilitarios.getAllFields(pInstancia.getClass())) {
                if (!fieldAtual.getName().equals(pField)) continue;
                f = fieldAtual;
                return FabricaUtilitarios.getValorField(f, pInstancia);
            }
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo: " + pField);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do valor do atributo: " + pField + " \nErro:\n" + e.getMessage());
        }
    }

    public static Object invocaMetodo(String pNomeMetodo, Object pInstancia, Class<?>[] tiposParametros, Object[] parametros) {
        Object retorno = null;
        try {
            Method m = pInstancia.getClass().getMethod(pNomeMetodo, tiposParametros);
            retorno = m.invoke(pInstancia, parametros);
        }
        catch (Exception e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return retorno;
    }

    public static Field getField(Object pInstancia, Object pAtributo) {
        try {
            for (Field fieldAtual : FabricaUtilitarios.getFieldsCamposInformacao(pInstancia.getClass())) {
                Object valorObtido = FabricaUtilitarios.getValorField(fieldAtual, pInstancia);
                if (valorObtido == null || !valorObtido.getClass().isAssignableFrom(pAtributo.getClass()) || !valorObtido.equals(pAtributo)) continue;
                return fieldAtual;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Erro na obten\u00e7\u00e3o do Field referente ao atributo: " + e.getMessage());
        }
    }

    public static Field getFieldPorNome(Class<?> aClasseDoAtributo, String aAtributo) {
        Field retorno = null;
        for (Field f : FabricaUtilitarios.getAllFields(aClasseDoAtributo)) {
            if (!f.getName().equals(aAtributo)) continue;
            retorno = f;
            break;
        }
        return retorno;
    }

    public static void preencherObjetoComAtributosXml(Object pObj, Element pElemento) {
        for (Field field : FabricaUtilitarios.getAllFieldsOfSpecificType(pObj.getClass(), Informacao.class)) {
            Informacao valorAtributo = (Informacao)FabricaUtilitarios.getValorField(field, pObj);
            try {
                String valAtributo = pElemento.getAttribute(field.getName());
                if (valAtributo != null) {
                    valorAtributo.setConteudo(valAtributo);
                    continue;
                }
                valorAtributo.setConteudo("");
            }
            catch (Exception exception) {}
        }
    }

    public static void preencherXMLComAtributosDoObjeto(Object pObj, Element pElemento) {
        for (Field field : FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass())) {
            Informacao valorAtributo = (Informacao)FabricaUtilitarios.getValorField(field, pObj);
            try {
                String valAtributo = valorAtributo.asString();
                if (valAtributo != null) {
                    pElemento.setAttribute(field.getName(), valAtributo);
                    continue;
                }
                pElemento.setAttribute(field.getName(), "");
            }
            catch (Exception exception) {}
        }
    }

    public static List<Pendencia> verificarPendencias(Object pObj) {
        ArrayList<Pendencia> retorno = null;
        if (pObj == null) {
            return new ArrayList<Pendencia>(0);
        }
        if (pObj instanceof ObjetoNegocio) {
            if (pObj instanceof Colecao) {
                ((Colecao)pObj).excluirRegistrosEmBranco();
            }
        } else {
            return new ArrayList<Pendencia>(0);
        }
        retorno = new ArrayList<Pendencia>();
        retorno.addAll(((ObjetoNegocio)pObj).verificarPendencias(-1));
        List<Field> fields = FabricaUtilitarios.getFieldsCamposObjetoNegocio(pObj.getClass());
        Object valAtributo = null;
        for (Field field : fields) {
            valAtributo = null;
            try {
                valAtributo = FabricaUtilitarios.getValorField(field, pObj);
            }
            catch (Exception e) {
                LogPPGD.erro("N\u00e3o foi poss\u00edvel obter valor do atributo->" + field.getName());
            }
            if (valAtributo == null || Modifier.isTransient(field.getModifiers()) || !(valAtributo instanceof ObjetoNegocio) || valAtributo instanceof IdDeclaracao) continue;
            if (pObj instanceof Colecao) {
                ((Colecao)pObj).excluirRegistrosEmBranco();
            }
            if (retorno == null) {
                retorno = new ArrayList();
            }
            retorno.addAll(FabricaUtilitarios.verificarPendencias(valAtributo));
        }
        return retorno;
    }

    public static Document carregarDOM(String arquivoMapeamento) {
        Document mapeamentoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            mapeamentoDOM = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(arquivoMapeamento));
        }
        catch (SAXParseException e) {
            LogPPGD.erro("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage());
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro("Erro de parsing: " + x.getMessage());
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage());
        }
        catch (IOException e) {
            LogPPGD.erro("Erro de I/O: " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        return mapeamentoDOM;
    }

    public static void ordenarElementosPorColuna(final int pColuna, List<ElementoTabela> pColecao) {
        Collections.sort(pColecao, new Comparator<ElementoTabela>(){

            @Override
            public int compare(ElementoTabela elemento1, ElementoTabela elemento2) {
                if (pColuna >= elemento1.size()) {
                    return UtilitariosString.removeAcentos(elemento1.getConteudo(0)).compareTo(UtilitariosString.removeAcentos(elemento2.getConteudo(0)));
                }
                return UtilitariosString.removeAcentos(elemento1.getConteudo(pColuna)).compareTo(UtilitariosString.removeAcentos(elemento2.getConteudo(pColuna)));
            }
        });
    }

    public static ObjetoNegocio instanciaObjetoNegocio(Class<?> classeAInstanciar, IdDeclaracao id) {
        ObjetoNegocio retorno = null;
        try {
            Class[] argumentosFormais = new Class[]{IdDeclaracao.class};
            Object[] argumentosReais = new Object[]{id};
            Constructor<?> construtor = null;
            try {
                construtor = classeAInstanciar.getConstructor(argumentosFormais);
                retorno = (ObjetoNegocio)construtor.newInstance(argumentosReais);
            }
            catch (Exception e) {
                retorno = (ObjetoNegocio)classeAInstanciar.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        catch (InstantiationException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return retorno;
    }

    public static ObjetoNegocio instanciaObjetoNegocio(Class<?> classeAInstanciar) throws Exception {
        return (ObjetoNegocio)classeAInstanciar.newInstance();
    }

    public static void preencheObjetoNegocioComResultSet(ResultSet resultSet, Object pObj) {
        Iterator<Field> itCamposId = FabricaUtilitarios.getAllFieldsOfSpecificType(pObj.getClass(), Informacao.class).iterator();
        Field field = null;
        Informacao valorAtributo = null;
        while (itCamposId.hasNext()) {
            field = itCamposId.next();
            valorAtributo = (Informacao)FabricaUtilitarios.getValorField(field, pObj);
            if (valorAtributo instanceof Valor && ((Valor)valorAtributo).isCampoCalculado()) continue;
            try {
                valorAtributo.setConteudo(resultSet.getString(field.getName()));
            }
            catch (Exception exception) {}
        }
    }

    public static PreenchedorCodigo criaPreenchedorCodigo() {
        return new PreenchedorCodigo();
    }

    public static PreenchedorCodigo criaPreenchedorCodigo(Codigo aCod) {
        return new PreenchedorCodigo(aCod);
    }

    public static Map<Class<?>, List<Field>> getCacheTempToReflection() {
        if (cacheTempToReflection == null) {
            cacheTempToReflection = new Hashtable();
        }
        return cacheTempToReflection;
    }

    public static void printStackEmDesenvolvimento(Exception e) {
        if (Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("versao_testes")).booleanValue()) {
            e.printStackTrace();
        }
    }

    public static String getPPGDId() {
        return FabricaUtilitarios.getProperties().getProperty("ppgd.id", "GO!PPGD");
    }

    static {
        nomeClasseId = null;
        nomeClasseIdDeclaracao = null;
        nomeClasseDeclaracao = null;
        usaCacheParaReflexao = false;
        nomeClasseId = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.id", IdUsuarioImpl.class.getName());
        nomeClasseIdDeclaracao = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.iddeclaracao", IdDeclaracaoImpl.class.getName());
        nomeClasseDeclaracao = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.declaracao");
    }
}

