/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;

public class DataHora
extends Informacao<DataHora> {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public DataHora() {
        this(null, "");
    }

    public DataHora(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataDataHora(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        if (conteudo.indexOf("/") != -1) {
            conteudo = UtilitariosString.corrigeDataHoraFormatada(conteudo);
        }
        conteudo = UtilitariosString.retiraMascara(conteudo);
        super.setConteudo(conteudo);
    }

    @Override
    public void setConteudo(Date pData) {
        Calendar calendario = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        calendario.setTime(pData);
        this.setConteudo(calendario);
    }

    @Override
    public void setConteudo(Calendar conteudo) {
        String dia = String.valueOf(conteudo.get(5));
        String mes = String.valueOf(conteudo.get(2) + 1);
        String ano = String.valueOf(conteudo.get(1));
        String hora = String.valueOf(conteudo.get(11));
        String minutos = String.valueOf(conteudo.get(12));
        String segundos = String.valueOf(conteudo.get(13));
        if (dia.length() < 2) {
            dia = "0" + dia;
        }
        if (mes.length() < 2) {
            mes = "0" + mes;
        }
        if (hora.length() < 2) {
            hora = "0" + hora;
        }
        if (minutos.length() < 2) {
            minutos = "0" + minutos;
        }
        if (segundos.length() < 2) {
            segundos = "0" + segundos;
        }
        String stringConteudo = dia + mes + ano + hora + minutos + segundos;
        this.setConteudo(stringConteudo);
    }

    public Date asDate() {
        Date lData = null;
        try {
            lData = this.sdf.parse(this.getConteudoFormatado());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return lData;
    }

    public boolean maisAntiga(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return true;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().before(pDataAsDate);
    }

    public boolean maisNova(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return true;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().after(pDataAsDate);
    }

    public boolean igual(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return false;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().equals(pDataAsDate);
    }

    public String getDia() {
        return this.asString().substring(0, 2);
    }

    public String getMes() {
        return this.asString().substring(2, 4);
    }

    public String getAno() {
        return this.asString().substring(4, 8);
    }

    public String getHora() {
        return this.asString().substring(8, 10);
    }

    public String getMinuto() {
        return this.asString().substring(10, 12);
    }

    public String getSegundo() {
        return this.asString().substring(12, 14);
    }

    @Override
    public int compareTo(Data outraData) {
        if (this.asDate() == null || outraData == null || outraData.asDate() == null) {
            return -1;
        }
        return this.asDate().compareTo(outraData.asDate());
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        calendar.set(5, 20);
        calendar.set(2, 0);
        calendar.set(1, 1982);
        calendar.set(11, 15);
        calendar.set(12, 32);
        calendar.set(13, 40);
        DataHora lData = new DataHora(null, "Teste");
        lData.setConteudo(calendar);
        lData.setConteudo(calendar.getTime());
        lData.setConteudo("20/01/82 15:32:40");
    }

    @Override
    public void setConteudo(DataHora pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataDataHora(this.asString());
    }
}

