/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Data
extends Informacao<Data> {
    public Data() {
        this(null, "");
    }

    public Data(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataData(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        if (conteudo.indexOf("/") != -1) {
            super.setConteudo(UtilitariosString.corrigeDataFormatada(conteudo).replaceAll("[/]", ""));
        } else {
            super.setConteudo(conteudo.replaceAll("[/]", ""));
        }
    }

    @Override
    public void setConteudo(Date conteudo) {
        Calendar calendario = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        calendario.setTime(conteudo);
        this.setConteudo(calendario);
    }

    public Date asDate() {
        Calendar c = Calendar.getInstance();
        String data = this.getConteudoFormatado();
        StringTokenizer strTokens = new StringTokenizer(data, "/");
        int i = 0;
        int dia = 0;
        int mes = 1;
        int ano = 2;
        while (strTokens.hasMoreTokens()) {
            String tokenAtual = strTokens.nextToken().trim();
            switch (i) {
                case 0: {
                    try {
                        dia = Integer.parseInt(tokenAtual);
                    }
                    catch (Exception e) {
                        dia = 0;
                    }
                }
                case 1: {
                    try {
                        mes = Integer.parseInt(tokenAtual);
                    }
                    catch (Exception e) {
                        mes = 0;
                    }
                }
                case 2: {
                    try {
                        ano = Integer.parseInt(tokenAtual);
                        break;
                    }
                    catch (Exception e) {
                        ano = 0;
                    }
                }
            }
            ++i;
        }
        if (dia == 0 || ano == 0 || mes == 0) {
            return null;
        }
        c.set(ano, mes - 1, dia);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public boolean maisAntiga(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return true;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().before(pDataAsDate);
    }

    public boolean maisNova(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return true;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().after(pDataAsDate);
    }

    public boolean igual(Data pData) {
        Date pDataAsDate = pData.asDate();
        if (pDataAsDate == null) {
            return false;
        }
        if (this.asDate() == null) {
            return false;
        }
        return this.asDate().equals(pDataAsDate);
    }

    public String getDia() {
        return this.asString().substring(0, 2);
    }

    public String getMes() {
        return this.asString().substring(2, 4);
    }

    public String getAno() {
        return this.asString().substring(4, 8);
    }

    @Override
    public void setConteudo(Calendar conteudo) {
        String dia = String.valueOf(conteudo.get(5));
        String mes = String.valueOf(conteudo.get(2) + 1);
        String ano = String.valueOf(conteudo.get(1));
        if (dia.length() < 2) {
            dia = "0" + dia;
        }
        if (mes.length() < 2) {
            mes = "0" + mes;
        }
        String stringConteudo = dia + mes + ano;
        this.setConteudo(stringConteudo);
    }

    @Override
    public int compareTo(Data outraData) {
        if (this.asDate() == null || outraData == null || outraData.asDate() == null) {
            return -1;
        }
        return this.asDate().compareTo(outraData.asDate());
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance(ConstantesGlobais.LOCALIDADE);
        LogPPGD.debug(String.valueOf(calendar.get(2)));
    }

    @Override
    public void setConteudo(Data pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataData(this.naoFormatado());
    }
}

