/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.qrcode;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.api.sax.EXIResult;
import com.siemens.ct.exi.api.sax.EXISource;
import com.siemens.ct.exi.helpers.DefaultEXIFactory;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;
import org.apache.xerces.impl.dv.util.Base64;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class QRCodeUtil {
    public static Image gerarQRCode(InputSource isXml, String cpf, String exercicio) throws Exception {
        return QRCodeUtil.gerarQRCode(isXml, cpf, exercicio, 800);
    }

    public static Image gerarQRCode(InputSource isXml, String cpf, String exercicio, int size) throws Exception {
        String strQRCode = cpf + exercicio + QRCodeUtil.codificarXML(isXml);
        ByteArrayOutputStream qrCodeData = QRCode.from((String)strQRCode).to(ImageType.JPG).withSize(size, size).stream();
        ImageIcon qrCodeImage = new ImageIcon(qrCodeData.toByteArray());
        return qrCodeImage.getImage();
    }

    public static String codificarXML(InputSource isXml) throws Exception {
        EXIFactory exiFactory = DefaultEXIFactory.newInstance();
        exiFactory.setCodingMode(CodingMode.COMPRESSION);
        byte[] xmlComprimido = null;
        String strXmlComprimido = null;
        try (ByteArrayOutputStream outputEXI = new ByteArrayOutputStream();){
            EXIResult exiResult = new EXIResult(exiFactory);
            exiResult.setOutputStream((OutputStream)outputEXI);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(exiResult.getHandler());
            xmlReader.parse(isXml);
            xmlComprimido = outputEXI.toByteArray();
        }
        if (xmlComprimido != null) {
            strXmlComprimido = Base64.encode((byte[])xmlComprimido);
        }
        return strXmlComprimido;
    }

    public static SAXSource decodificarXML(String qrCode) throws Exception {
        EXIFactory exiFactory = DefaultEXIFactory.newInstance();
        exiFactory.setCodingMode(CodingMode.COMPRESSION);
        byte[] bytesEXI = Base64.decode((String)qrCode);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytesEXI);
        InputSource isXml = new InputSource(inputStream);
        EXISource exiSource = new EXISource(exiFactory);
        exiSource.setInputSource(isXml);
        return exiSource;
    }

    public static String decodificarXMLToString(String qrCode) throws Exception {
        SAXSource exiSource = QRCodeUtil.decodificarXML(qrCode);
        StringWriter outWriter = new StringWriter();
        StreamResult result = new StreamResult(outWriter);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(exiSource, result);
        StringBuffer sb = outWriter.getBuffer();
        String finalString = sb.toString();
        return finalString;
    }

    public static void main(String[] args) {
        try {
            File file = new File("src/informe_fontes_pagadoras_completo.xml");
            FileInputStream inputStream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "ISO-8859-1");
            InputSource is = new InputSource(reader);
            Image qrcode = QRCodeUtil.gerarQRCode(is, "88673772133", "2018");
            JFrame frame = new JFrame();
            ImageIcon image = new ImageIcon(qrcode);
            JLabel label = new JLabel(image);
            frame.getContentPane().add(label);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

