/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Iterator;
import serpro.ppgd.irpf.calculos.CalculosTotaisRendaVariavel;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendaVariavelDependentes
extends Observador {
    private ColecaoRendaVariavelDependente colecaoRendaVariavelDependente = null;

    public CalculosRendaVariavelDependentes(ColecaoRendaVariavelDependente colecao) {
        this.colecaoRendaVariavelDependente = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ItemRendaVariavelDependente item = (ItemRendaVariavelDependente)valorNovo;
                item.getRendaVariavel().adicionarObservadorCalculosTotaisRendaVariavel((Observador)new CalculosTotaisRendaVariavel(item.getRendaVariavel()));
                item.getRendaVariavel().addObservador((Observador)this);
                this.calculaTotaisBaseCalculo();
                this.calculaTotaisIRFonteDayTrade();
                this.calculaTotaisImpostoRetidoFonteLei11033();
                this.calculaTotaisImpostoAPagar();
                this.calculaTotaisImpostoPago();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ItemRendaVariavelDependente item = (ItemRendaVariavelDependente)valorNovo;
                item.getRendaVariavel().removeObservador((Observador)this);
                this.calculaTotaisBaseCalculo();
                this.calculaTotaisIRFonteDayTrade();
                this.calculaTotaisImpostoRetidoFonteLei11033();
                this.calculaTotaisImpostoAPagar();
                this.calculaTotaisImpostoPago();
            } else if (nomePropriedade.equals("Total Base C\u00e1lculo")) {
                this.calculaTotaisBaseCalculo();
            } else if (nomePropriedade.equals("Total Imposto a Pagar")) {
                this.calculaTotaisImpostoAPagar();
            } else if (nomePropriedade.equals("Total Imposto Pago")) {
                this.calculaTotaisImpostoPago();
            } else if (nomePropriedade.equals("Total IR Fonte Day Trade")) {
                this.calculaTotaisIRFonteDayTrade();
            } else if (nomePropriedade.equals("Total IR Fonte Lei 11.033")) {
                this.calculaTotaisImpostoRetidoFonteLei11033();
            }
        }
    }

    private void calculaTotaisImpostoRetidoFonteLei11033() {
        Valor total = new Valor();
        Iterator itRend = this.colecaoRendaVariavelDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendaVariavel rendaVariavel = ((ItemRendaVariavelDependente)itRend.next()).getRendaVariavel();
            total.append('+', rendaVariavel.getTotalImpostoRetidoFonteLei11033());
        }
        this.colecaoRendaVariavelDependente.getTotalImpostoRetidoFonteLei11033().setConteudo(total);
    }

    private void calculaTotaisImpostoAPagar() {
        Valor total = new Valor();
        Iterator itRend = this.colecaoRendaVariavelDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendaVariavel rendaVariavel = ((ItemRendaVariavelDependente)itRend.next()).getRendaVariavel();
            total.append('+', rendaVariavel.getTotalImpostoAPagar());
        }
        this.colecaoRendaVariavelDependente.getTotalImpostoAPagar().setConteudo(total);
    }

    private void calculaTotaisImpostoPago() {
        Valor total = new Valor();
        Iterator itRend = this.colecaoRendaVariavelDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendaVariavel rendaVariavel = ((ItemRendaVariavelDependente)itRend.next()).getRendaVariavel();
            total.append('+', rendaVariavel.getTotalImpostoPago());
        }
        this.colecaoRendaVariavelDependente.getTotalImpostoPago().setConteudo(total);
    }

    private void calculaTotaisIRFonteDayTrade() {
        Valor total = new Valor();
        Iterator itRend = this.colecaoRendaVariavelDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendaVariavel rendaVariavel = ((ItemRendaVariavelDependente)itRend.next()).getRendaVariavel();
            total.append('+', rendaVariavel.getTotalIRFonteDayTrade());
        }
        this.colecaoRendaVariavelDependente.getTotalIRFonteDayTrade().setConteudo(total);
    }

    private void calculaTotaisBaseCalculo() {
        Valor total = new Valor();
        Iterator itRend = this.colecaoRendaVariavelDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendaVariavel rendaVariavel = ((ItemRendaVariavelDependente)itRend.next()).getRendaVariavel();
            total.append('+', rendaVariavel.getTotalBaseCalculo());
        }
        this.colecaoRendaVariavelDependente.getTotalBaseCalculo().setConteudo(total);
    }
}

