/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeDependentes
extends Observador {
    private ColecaoRendPJComExigibilidadeTitular colecaoRendPJ = null;

    public CalculosRendPJComExigibilidadeDependentes(ColecaoRendPJComExigibilidadeTitular colecao) {
        this.colecaoRendPJ = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular)valorNovo;
                rendPJ.addObservador((Observador)this);
                this.calculaTotaisRendExigSusp();
                this.calculaTotaisDepositoJudiciario();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular)valorNovo;
                rendPJ.removeObservador((Observador)this);
                this.calculaTotaisRendExigSusp();
                this.calculaTotaisDepositoJudiciario();
            } else if (nomePropriedade.equals("Dep\u00f3sito Judicial")) {
                this.calculaTotaisDepositoJudiciario();
            } else if (nomePropriedade.equals("Rendimentos Tribut\u00e1veis (Imposto com Exigibilidade Suspensa)") || nomePropriedade.equals("CPF/CNPJ da Fonte Pagadora")) {
                this.calculaTotaisRendExigSusp();
            }
        }
    }

    private void calculaTotaisDepositoJudiciario() {
        Valor total = new Valor();
        for (RendPJComExigibilidadeTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', (Valor)rendAtual.getDepositoJudicial());
        }
        this.colecaoRendPJ.getTotaisDepositoJudicial().setConteudo(total);
    }

    private void calculaTotaisRendExigSusp() {
        Valor total = new Valor();
        for (RendPJComExigibilidadeTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', (Valor)rendAtual.getRendExigSuspensa());
        }
        this.colecaoRendPJ.getTotaisRendPJExigSuspensa().setConteudo(total);
    }
}

