/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendIsentos
extends Observador {
    private RendIsentos rendIsentos;

    public CalculosRendIsentos(RendIsentos aRendIsentos) {
        this.rendIsentos = aRendIsentos;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotalRendIsentos();
        this.calculaTotalGCAPInformadoMaisTransportado();
    }

    private void calculaTotalGCAPInformadoMaisTransportado() {
        this.rendIsentos.getSomaBensPequenoValor().setConteudo(this.rendIsentos.getBensPequenoValorInformado().operacao('+', this.rendIsentos.getBensPequenoValorTransportado()));
        this.rendIsentos.getSomaUnicoImovel().setConteudo(this.rendIsentos.getUnicoImovelInformado().operacao('+', (Valor)this.rendIsentos.getUnicoImovelTransportado()));
        this.rendIsentos.getSomaOutrosBensImoveis().setConteudo(this.rendIsentos.getOutrosBensImoveisInformado().operacao('+', this.rendIsentos.getOutrosBensImoveisTransportado()));
    }

    private void calculaTotalRendIsentos() {
        Valor total = new Valor(this.rendIsentos.getBolsaEstudos().naoFormatado());
        total.append('+', this.rendIsentos.getCapitalApolices());
        total.append('+', this.rendIsentos.getIndenizacoes());
        this.calculaAlienacaoGC();
        total.append('+', this.rendIsentos.getLucroAlienacao());
        total.append('+', this.rendIsentos.getLucroRecebido());
        total.append('+', this.rendIsentos.getOutros());
        total.append('+', this.rendIsentos.getParcIsentaAposentadoria());
        total.append('+', this.rendIsentos.getParcIsentaAtivRural());
        total.append('+', this.rendIsentos.getPensao());
        total.append('+', this.rendIsentos.getPoupanca());
        total.append('+', this.rendIsentos.getRendSocio());
        total.append('+', this.rendIsentos.getTransferencias());
        total.append('+', (Valor)this.rendIsentos.getImpostoRendasAnterioresCompensadoJudicialmente());
        total.append('+', (Valor)this.rendIsentos.getRendAssalariadosMoedaEstrangeira());
        total.append('+', (Valor)this.rendIsentos.getIncorporacaoReservaCapital());
        total.append('+', (Valor)this.rendIsentos.getMedicosResidentes());
        total.append('+', (Valor)this.rendIsentos.getVoluntariosCopa());
        total.append('+', (Valor)this.rendIsentos.getMeacaoDissolucao());
        total.append('+', (Valor)this.rendIsentos.getGanhosLiquidosAcoes());
        total.append('+', (Valor)this.rendIsentos.getGanhosCapitalOuro());
        total.append('+', (Valor)this.rendIsentos.getRecuperacaoPrejuizosBolsaValores());
        total.append('+', (Valor)this.rendIsentos.getTransportadorCargas());
        total.append('+', (Valor)this.rendIsentos.getTransportadorPassageiros());
        total.append('+', (Valor)this.rendIsentos.getRestituicaoImpostoRendaAnosAnteriores());
        total.append('+', this.rendIsentos.getPensaoAlimenticia());
        total.append('+', this.rendIsentos.getJurosRra());
        this.rendIsentos.getTotal().setConteudo(total);
    }

    private void calculaAlienacaoGC() {
        Valor totalInf = new Valor();
        Valor totalTransp = new Valor();
        totalInf.append('+', this.rendIsentos.getBensPequenoValorInformado());
        totalInf.append('+', this.rendIsentos.getUnicoImovelInformado());
        totalInf.append('+', this.rendIsentos.getOutrosBensImoveisInformado());
        totalInf.append('+', this.rendIsentos.getMoedaEstrangeiraEspecieInformado());
        totalTransp.append('+', this.rendIsentos.getBensPequenoValorTransportado());
        totalTransp.append('+', (Valor)this.rendIsentos.getUnicoImovelTransportado());
        totalTransp.append('+', this.rendIsentos.getOutrosBensImoveisTransportado());
        this.rendIsentos.getTotalInformado().setConteudo(totalInf);
        this.rendIsentos.getTotalTransportado().setConteudo(totalTransp);
        this.rendIsentos.getLucroAlienacao().setConteudo(totalInf.operacao('+', totalTransp));
    }
}

