/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Iterator;
import serpro.ppgd.irpf.calculos.CalculosFundosInvestimentos;
import serpro.ppgd.irpf.calculos.CalculosTotaisFundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosFundosInvestimentosDependentes
extends Observador {
    private ColecaoFundosInvestimentosDependente colecaoFundosInvestimentosDependente = null;

    public CalculosFundosInvestimentosDependentes(ColecaoFundosInvestimentosDependente colecao) {
        this.colecaoFundosInvestimentosDependente = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)valorNovo;
                item.getFundosInvestimentos().addObservador((Observador)this);
                CalculosFundosInvestimentos calFundInvest = null;
                for (int i = 0; i < 12; ++i) {
                    calFundInvest = new CalculosFundosInvestimentos(item.getFundosInvestimentos().getMeses()[i], item.getFundosInvestimentos());
                    item.getFundosInvestimentos().getMeses()[i].getResultLiquidoMes().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getResultNegativoAnterior().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getBaseCalcImposto().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getImpostoRetidoMesesAnteriores().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getImpostoRetidoFonte().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getImpostoDevido().addObservador((Observador)calFundInvest);
                    item.getFundosInvestimentos().getMeses()[i].getImpostoPago().addObservador((Observador)calFundInvest);
                    if (i <= 0) continue;
                    item.getFundosInvestimentos().getMeses()[i - 1].getPrejuizoCompensar().addObservador((Observador)calFundInvest);
                }
                item.getFundosInvestimentos().adicionarCalculosTotaisFundInvest((Observador)new CalculosTotaisFundosInvestimentos(item.getFundosInvestimentos()));
                this.calculaTotaisBaseCalculo();
                this.calculaTotaisImpostoDevido();
                this.calculaTotaisImpostoPago();
                this.calculaTotaisImpostoRetidoFonteLei11033();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)valorNovo;
                item.getFundosInvestimentos().removeObservador((Observador)this);
                this.calculaTotaisBaseCalculo();
                this.calculaTotaisImpostoDevido();
                this.calculaTotaisImpostoPago();
                this.calculaTotaisImpostoRetidoFonteLei11033();
            } else if (nomePropriedade.equals("Total Base C\u00e1lculo")) {
                this.calculaTotaisBaseCalculo();
            } else if (nomePropriedade.equals("Total Imposto Devido")) {
                this.calculaTotaisImpostoDevido();
            } else if (nomePropriedade.equals("Total Imposto Pago")) {
                this.calculaTotaisImpostoPago();
            } else if (nomePropriedade.equals("Total Imposto Retido Na Fonte")) {
                this.calculaTotaisImpostoRetidoFonteLei11033();
            }
        }
    }

    private void calculaTotaisImpostoDevido() {
        Valor total = new Valor();
        Iterator itFundInvest = this.colecaoFundosInvestimentosDependente.itens().iterator();
        while (itFundInvest.hasNext()) {
            FundosInvestimentos fundInvest = ((ItemFundosInvestimentosDependente)itFundInvest.next()).getFundosInvestimentos();
            total.append('+', fundInvest.getTotalImpostoDevido());
        }
        this.colecaoFundosInvestimentosDependente.getTotalImpostoDevido().setConteudo(total);
    }

    private void calculaTotaisImpostoPago() {
        Valor total = new Valor();
        Iterator itFundInvest = this.colecaoFundosInvestimentosDependente.itens().iterator();
        while (itFundInvest.hasNext()) {
            FundosInvestimentos fundInvest = ((ItemFundosInvestimentosDependente)itFundInvest.next()).getFundosInvestimentos();
            total.append('+', fundInvest.getTotalImpostoPago());
        }
        this.colecaoFundosInvestimentosDependente.getTotalImpostoPago().setConteudo(total);
    }

    private void calculaTotaisBaseCalculo() {
        Valor total = new Valor();
        Iterator itFundInvest = this.colecaoFundosInvestimentosDependente.itens().iterator();
        while (itFundInvest.hasNext()) {
            FundosInvestimentos fundInvest = ((ItemFundosInvestimentosDependente)itFundInvest.next()).getFundosInvestimentos();
            total.append('+', fundInvest.getTotalBaseCalcImposto());
        }
        this.colecaoFundosInvestimentosDependente.getTotalBaseCalculo().setConteudo(total);
    }

    private void calculaTotaisImpostoRetidoFonteLei11033() {
        Valor total = new Valor();
        Iterator itFundInvest = this.colecaoFundosInvestimentosDependente.itens().iterator();
        while (itFundInvest.hasNext()) {
            FundosInvestimentos fundInvest = ((ItemFundosInvestimentosDependente)itFundInvest.next()).getFundosInvestimentos();
            total.append('+', fundInvest.getTotalImpostoRetidoFonteLei11033());
        }
        this.colecaoFundosInvestimentosDependente.getTotalImpostoRetidoFonteLei11033().setConteudo(total);
    }
}

