/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemLimiteDeducaoIncentivo;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosDeducoesIncentivos
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosDeducoesIncentivos(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        CalculosDeducoesIncentivos.calculaDeducaoIncentivo(this.declaracaoIRPF);
    }

    public static ItemLimiteDeducaoIncentivo calculaDeducaoIncentivo(DeclaracaoIRPF declaracaoIRPF) {
        ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo(declaracaoIRPF, declaracaoIRPF.getModeloCompleta().getImposto());
        Valor auxTotalDeducaoIncentivo = new Valor();
        auxTotalDeducaoIncentivo.setCasasDecimais(4);
        auxTotalDeducaoIncentivo.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39());
        auxTotalDeducaoIncentivo.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45());
        auxTotalDeducaoIncentivo.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46());
        declaracaoIRPF.getDoacoes().getTotalDeducaoIncentivo().setConteudo(auxTotalDeducaoIncentivo);
        if (lItemLimiteDeducaoIncentivo.getSobraECADeducao().comparacao("<", "0,00")) {
            declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getValorDisponivelDoacaoExibido().clear();
        } else {
            declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getValorDisponivelDoacaoExibido().setConteudo(lItemLimiteDeducaoIncentivo.getSobraECADeducao());
        }
        declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getValorDisponivelDoacao().setConteudo(lItemLimiteDeducaoIncentivo.getSobraECADeducao());
        declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoLiquido().setConteudo(lItemLimiteDeducaoIncentivo.getDisponivelInicialECA());
        declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39());
        if (lItemLimiteDeducaoIncentivo.getSobraIdosoDeducao().comparacao("<", "0,00")) {
            declaracaoIRPF.getColecaoEstatutoIdoso().getValorDisponivelDoacaoExibido().clear();
        } else {
            declaracaoIRPF.getColecaoEstatutoIdoso().getValorDisponivelDoacaoExibido().setConteudo(lItemLimiteDeducaoIncentivo.getSobraIdosoDeducao());
        }
        declaracaoIRPF.getColecaoEstatutoIdoso().getValorDisponivelDoacao().setConteudo(lItemLimiteDeducaoIncentivo.getSobraIdosoDeducao());
        declaracaoIRPF.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoLiquido().setConteudo(lItemLimiteDeducaoIncentivo.getDisponivelInicialIdoso());
        declaracaoIRPF.getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso());
        return lItemLimiteDeducaoIncentivo;
    }

    public static ItemLimiteDeducaoIncentivo calculaDeducaoIncentivo(DeclaracaoIRPF declaracaoIRPF, Valor pImpostoDevido) {
        return CalculosDeducoesIncentivos.calculaDeducaoIncentivo(declaracaoIRPF, pImpostoDevido, true);
    }

    public static ItemLimiteDeducaoIncentivo calculaDeducaoIncentivo(DeclaracaoIRPF declaracaoIRPF, Valor pImpostoDevido, boolean comRendimentosExterior) {
        Valor totalDesporto = CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"43"}, false);
        ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = new ItemLimiteDeducaoIncentivo();
        lItemLimiteDeducaoIncentivo.getTotalDeducoesCod40().setConteudo(CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"40"}, false));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', lItemLimiteDeducaoIncentivo.getTotalDeducoesCod40());
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"41"}, true));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"42"}, false));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', totalDesporto);
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"44"}, false));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"47"}, false));
        Valor percentualIncentivo = new Valor();
        percentualIncentivo.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoIncentivo.getValor());
        percentualIncentivo.append('/', "100,00");
        Valor limite6porcento = new Valor();
        limite6porcento.setCasasDecimais(4);
        limite6porcento.setConteudo(pImpostoDevido);
        limite6porcento.append('*', percentualIncentivo);
        lItemLimiteDeducaoIncentivo.getLimite6porcentoOriginal().setConteudo(limite6porcento);
        Valor percentualDesporto = new Valor();
        percentualDesporto.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncDesporto.getValor());
        percentualDesporto.append('/', "100,00");
        if (totalDesporto.comparacao(">", "0,00")) {
            Valor limiteDesporto = new Valor();
            limiteDesporto.setCasasDecimais(4);
            limiteDesporto.setConteudo(pImpostoDevido);
            limiteDesporto.append('*', percentualDesporto);
            if (totalDesporto.comparacao("<", limiteDesporto)) {
                limiteDesporto.setConteudo(totalDesporto);
            }
            Valor limiteIncentivoComDesporto = new Valor();
            limiteIncentivoComDesporto.setCasasDecimais(4);
            limiteIncentivoComDesporto.setConteudo(limite6porcento);
            limiteIncentivoComDesporto.append('+', limiteDesporto);
            lItemLimiteDeducaoIncentivo.getLimite6porcento().setConteudo(limiteIncentivoComDesporto);
        } else {
            lItemLimiteDeducaoIncentivo.getLimite6porcento().setConteudo(limite6porcento);
        }
        lItemLimiteDeducaoIncentivo.getTotalDeducoesCod45().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"45"}, false));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesCod46().append('+', CalculosDeducoesIncentivos.totalizarDoacoes(declaracaoIRPF.getDoacoes(), new String[]{"46"}, false));
        Valor percentualPrononPronas = new Valor();
        percentualPrononPronas.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncPronas.getValor());
        percentualPrononPronas.append('/', "100,00");
        Valor limite1porcento = new Valor();
        limite1porcento.setCasasDecimais(4);
        limite1porcento.setConteudo(pImpostoDevido);
        limite1porcento.append('*', percentualPrononPronas);
        lItemLimiteDeducaoIncentivo.getLimite1porcento().setConteudo(limite1porcento);
        if (lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().comparacao(">=", lItemLimiteDeducaoIncentivo.getLimite6porcento())) {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39().setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
            lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().setConteudo(Long.valueOf(0L));
        } else {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39());
            lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento().operacao('-', lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39()));
        }
        if (lItemLimiteDeducaoIncentivo.getTotalDeducoesCod45().comparacao(">=", lItemLimiteDeducaoIncentivo.getLimite1porcento())) {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45().setConteudo(lItemLimiteDeducaoIncentivo.getLimite1porcento());
        } else {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod45());
        }
        if (lItemLimiteDeducaoIncentivo.getTotalDeducoesCod46().comparacao(">=", lItemLimiteDeducaoIncentivo.getLimite1porcento())) {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46().setConteudo(lItemLimiteDeducaoIncentivo.getLimite1porcento());
        } else {
            lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod46());
        }
        lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39().append('+', CalculosDeducoesIncentivos.totalizarDoacoesECA(declaracaoIRPF.getColecaoEstatutoCriancaAdolescente()));
        lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso().append('+', CalculosDeducoesIncentivos.totalizarDoacoesIdoso(declaracaoIRPF.getColecaoEstatutoIdoso()));
        Valor percentualECA = new Valor();
        percentualECA.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducoesIncECA.getValor());
        percentualECA.append('/', "100,00");
        Valor limite3porcento = new Valor();
        limite3porcento.setConteudo(pImpostoDevido);
        limite3porcento.append('*', percentualECA);
        lItemLimiteDeducaoIncentivo.getLimite3porcento().setConteudo(limite3porcento);
        if (lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().comparacao("<=", lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39()) && lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().comparacao("<=", lItemLimiteDeducaoIncentivo.getLimite3porcento())) {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA().setConteudo(lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario());
        } else if (lItemLimiteDeducaoIncentivo.getLimite3porcento().comparacao("<=", lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario()) && lItemLimiteDeducaoIncentivo.getLimite3porcento().comparacao("<=", lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39())) {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA().setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
        } else {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39());
        }
        if (lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().comparacao("<=", lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso()) && lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario().comparacao("<=", lItemLimiteDeducaoIncentivo.getLimite3porcento())) {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteIdoso().setConteudo(lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario());
        } else if (lItemLimiteDeducaoIncentivo.getLimite3porcento().comparacao("<=", lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoCalendario()) && lItemLimiteDeducaoIncentivo.getLimite3porcento().comparacao("<=", lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso())) {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteIdoso().setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
        } else {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteIdoso().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso());
        }
        if (lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39().comparacao("<", lItemLimiteDeducaoIncentivo.getLimite6porcento())) {
            lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoSeguinte().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39().operacao('-', lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA()));
        } else {
            lItemLimiteDeducaoIncentivo.getSobraDeducaoAnoSeguinte().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39());
        }
        lItemLimiteDeducaoIncentivo.getUsadoGlobalDeducao().setConteudo(lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39());
        lItemLimiteDeducaoIncentivo.getUsadoGlobalDeducao().append('+', lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39());
        lItemLimiteDeducaoIncentivo.getUsadoGlobalDeducao().append('+', lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso());
        lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().setConteudo(Long.valueOf(0L));
        if (comRendimentosExterior) {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteIdoso());
        } else {
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteECA());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicioSeguinteIdoso());
            if (lItemLimiteDeducaoIncentivo.getUsadoGlobalDeducao().comparacao(">=", lItemLimiteDeducaoIncentivo.getLimite6porcento())) {
                lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
                lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().converteQtdCasasDecimais(2);
            }
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod45());
            lItemLimiteDeducaoIncentivo.getValorAceitoDeducaoExercicio().append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaCod46());
        }
        lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao().setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
        lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao().append('-', lItemLimiteDeducaoIncentivo.getUsadoGlobalDeducao());
        Valor tresMenosECA = new Valor();
        tresMenosECA.setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
        tresMenosECA.append('-', lItemLimiteDeducaoIncentivo.getTotalDeducoesCod39());
        if (lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao().comparacao("<", tresMenosECA)) {
            lItemLimiteDeducaoIncentivo.getSobraECADeducao().setConteudo(lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao());
        } else {
            lItemLimiteDeducaoIncentivo.getSobraECADeducao().setConteudo(tresMenosECA);
        }
        Valor tresMenosIdoso = new Valor();
        tresMenosIdoso.setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
        tresMenosIdoso.append('-', lItemLimiteDeducaoIncentivo.getTotalDeducoesIdoso());
        if (lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao().comparacao("<", tresMenosIdoso)) {
            lItemLimiteDeducaoIncentivo.getSobraIdosoDeducao().setConteudo(lItemLimiteDeducaoIncentivo.getSobraGlobalDeducao());
        } else {
            lItemLimiteDeducaoIncentivo.getSobraIdosoDeducao().setConteudo(tresMenosIdoso);
        }
        Valor disponivelInicialIncentivo = new Valor();
        disponivelInicialIncentivo.setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
        disponivelInicialIncentivo.append('-', lItemLimiteDeducaoIncentivo.getTotalDeducoesSemCod39());
        if (disponivelInicialIncentivo.comparacao("<", "0,00")) {
            disponivelInicialIncentivo.clear();
        }
        if (disponivelInicialIncentivo.comparacao("<", lItemLimiteDeducaoIncentivo.getLimite3porcento())) {
            lItemLimiteDeducaoIncentivo.getDisponivelInicialECA().setConteudo(disponivelInicialIncentivo);
            lItemLimiteDeducaoIncentivo.getDisponivelInicialIdoso().setConteudo(disponivelInicialIncentivo);
        } else {
            lItemLimiteDeducaoIncentivo.getDisponivelInicialECA().setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
            lItemLimiteDeducaoIncentivo.getDisponivelInicialIdoso().setConteudo(lItemLimiteDeducaoIncentivo.getLimite3porcento());
        }
        return lItemLimiteDeducaoIncentivo;
    }

    public static Valor totalizarDoacoes(Doacoes doacoes, String[] codigo, boolean abateParcelaNaoDedutivel) {
        Valor total = new Valor();
        total.setCasasDecimais(4);
        List objColecao = doacoes.itens();
        for (int i = 0; i <= objColecao.size() - 1; ++i) {
            Doacao obj = (Doacao)objColecao.get(i);
            for (int j = 0; j < codigo.length; ++j) {
                if (!obj.getCodigo().toString().equals(codigo[j]) || !obj.getValorPago().comparacao(">=", obj.getParcelaNaoDedutivel())) continue;
                total.append('+', obj.getValorPago());
                if (!abateParcelaNaoDedutivel) continue;
                total.append('-', obj.getParcelaNaoDedutivel());
            }
        }
        return total;
    }

    public static Valor totalizarDoacoesECA(ColecaoEstatutoCriancaAdolescente doacoesECA) {
        Valor total = new Valor();
        List objColecao = doacoesECA.itens();
        for (int i = 0; i <= objColecao.size() - 1; ++i) {
            EstatutoCriancaAdolescente obj = (EstatutoCriancaAdolescente)objColecao.get(i);
            total.append('+', obj.getValor());
        }
        return total;
    }

    public static Valor totalizarDoacoesIdoso(ColecaoEstatutoIdoso doacoesIdoso) {
        Valor total = new Valor();
        List objColecao = doacoesIdoso.itens();
        for (int i = 0; i <= objColecao.size() - 1; ++i) {
            EstatutoIdoso obj = (EstatutoIdoso)objColecao.get(i);
            total.append('+', obj.getValor());
        }
        return total;
    }

    public static Valor totalizarDoacoesGlosado(Doacoes doacoes, String[] codigo, boolean abateParcelaNaoDedutivel) {
        Valor result = CalculosDeducoesIncentivos.totalizarDoacoes(doacoes, codigo, abateParcelaNaoDedutivel);
        if (result.comparacao("<", "0,00")) {
            result.clear();
        }
        return result;
    }
}

