/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosBens
extends Observador {
    private Bens bens = null;

    public CalculosBens(Bens bens) {
        this.bens = bens;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ((Bem)valorNovo).getValorExercicioAtual().addObservador((Observador)this);
                ((Bem)valorNovo).getValorExercicioAnterior().addObservador((Observador)this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ((Bem)valorNovo).getValorExercicioAtual().removeObservador((Observador)this);
                ((Bem)valorNovo).getValorExercicioAnterior().removeObservador((Observador)this);
            }
        }
        this.calculaTotalExercicioAtual();
        this.calculaTotalExercicioAnterior();
    }

    private void calculaTotalExercicioAtual() {
        Valor total = new Valor();
        this.bens.getTotalExercicioAtual().clear();
        for (Bem bem : this.bens.itens()) {
            total.append('+', bem.getValorExercicioAtual());
        }
        this.bens.getTotalExercicioAtual().setConteudo(total);
    }

    private void calculaTotalExercicioAnterior() {
        Valor total = new Valor();
        for (Bem bem : this.bens.itens()) {
            total.append('+', bem.getValorExercicioAnterior());
        }
        this.bens.getTotalExercicioAnterior().setConteudo(total);
    }
}

