/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans.autocomplete;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import net.sf.tinylaf.TinyComboBoxUI;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboDocument;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboEditor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboModel;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboRenderer;
import serpro.ppgd.negocio.ElementoTabela;

public class JAutoCompleteComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private final JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
    private String novoPattern;
    private boolean mudouPattern;
    private boolean arrowKeyPressed = false;
    private boolean atualizandoModel = false;
    private boolean atualizandoManual = false;
    private boolean cleared = false;

    public JAutoCompleteComboBox() {
        super(new JAutoCompleteComboModel());
        this.iniciar();
        this.setMaximumRowCount(12);
        this.setUI((ComboBoxUI)((Object)new HScrollJComboBoxUI()));
    }

    public JAutoCompleteComboBox(ArrayList<ElementoTabela> pDados) {
        super(new JAutoCompleteComboModel(pDados));
        this.iniciar();
        this.setUI((ComboBoxUI)((Object)new HScrollJComboBoxUI()));
    }

    private void iniciar() {
        this.mudouPattern = false;
        this.setEditable(true);
        this.textComponent.setDocument(new JAutoCompleteComboDocument(this));
        this.setRenderer(new JAutoCompleteComboRenderer());
        this.setEditor(new JAutoCompleteComboEditor(this.getEditor()));
    }

    public void setModel(ComboBoxModel aModel) {
        this.atualizandoManual = true;
        super.setModel(aModel);
        this.atualizandoManual = false;
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        this.atualizandoManual = true;
        super.setSelectedIndex(anIndex);
        this.atualizandoManual = false;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        this.atualizandoManual = true;
        super.setSelectedItem(anObject);
        this.atualizandoManual = false;
    }

    public void setSelectedItemPorCodigo(String pCodigo) {
        this.atualizandoManual = true;
        ((JAutoCompleteComboModel)this.getModel()).setSelectedItemPorCodigo(pCodigo);
        this.atualizandoManual = false;
    }

    private void verificarAtualizacaoPattern() {
        if (this.mudouPattern && this.isDisplayable()) {
            if (this.arrowKeyPressed) {
                this.arrowKeyPressed = false;
            } else {
                this.setPopupVisible(false);
                this.atualizandoModel = true;
                ((JAutoCompleteComboModel)this.getModel()).updatePattern(this.novoPattern);
                ElementoTabela lPossivelElemento = ((JAutoCompleteComboModel)this.getModel()).getItemByPattern(this.novoPattern);
                this.getModel().setSelectedItem(lPossivelElemento);
                this.atualizandoModel = false;
                if (this.getModel().getSize() > 0 && !this.cleared) {
                    this.setPopupVisible(true);
                }
                this.cleared = false;
            }
            this.mudouPattern = false;
        }
    }

    public void updatePattern(String pPattern) {
        if (!this.atualizandoManual) {
            this.novoPattern = pPattern;
            this.mudouPattern = true;
            this.verificarAtualizacaoPattern();
        }
    }

    public boolean isAtualizandoModel() {
        return this.atualizandoModel;
    }

    public void setAtualizandoModel(boolean atualizandoModel) {
        this.atualizandoModel = atualizandoModel;
    }

    public void clearSelection() {
        this.cleared = true;
        this.textComponent.setText(null);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public class HScrollJComboBoxUI
    extends TinyComboBoxUI {
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){
                private static final long serialVersionUID = 1L;

                @Override
                protected int getPopupHeightForRowCount(int maxRowCount) {
                    Insets insets;
                    Border border;
                    int minRowCount = Math.min(maxRowCount, this.comboBox.getItemCount());
                    int height = 0;
                    ListCellRenderer<Object> renderer = this.list.getCellRenderer();
                    Object value = null;
                    int maxWidth = 0;
                    for (int i = 0; i < minRowCount; ++i) {
                        value = this.list.getModel().getElementAt(i);
                        Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
                        height += c.getPreferredSize().height;
                        maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
                    }
                    if (height == 0) {
                        height = this.comboBox.getHeight();
                    }
                    if ((border = this.scroller.getViewportBorder()) != null) {
                        insets = border.getBorderInsets(null);
                        height += insets.top + insets.bottom;
                    }
                    if ((border = this.scroller.getBorder()) != null) {
                        insets = border.getBorderInsets(null);
                        height += insets.top + insets.bottom;
                    }
                    if (this.comboBox.getWidth() < maxWidth) {
                        height = (int)((double)height + this.scroller.getHorizontalScrollBar().getMaximumSize().getHeight());
                    }
                    return height;
                }

                @Override
                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 20, 30);
                }
            };
            return popup;
        }
    }
}

