/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NewDS
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final JRXPathExecuter xPathExecuter;

    public NewDS(Document document) throws JRException {
        this(document, ".");
    }

    public NewDS(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.xPathExecuter = JRXPathExecuterUtils.getXPathExecuter();
        this.moveFirst();
    }

    public NewDS(InputStream in) throws JRException {
        this(in, ".");
    }

    public NewDS(InputStream in, String selectExpression) throws JRException {
        this(JRXmlUtils.parse((InputSource)new InputSource(in)), selectExpression);
    }

    public NewDS(String uri) throws JRException {
        this(uri, ".");
    }

    public NewDS(String uri, String selectExpression) throws JRException {
        this(JRXmlUtils.parse((String)uri), selectExpression);
    }

    public NewDS(File file) throws JRException {
        this(file, ".");
    }

    public NewDS(File file, String selectExpression) throws JRException {
        this(JRXmlUtils.parse((File)file), selectExpression);
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be null");
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList((Node)this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.currentNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        Class valueClass = jrField.getValueClass();
        Object selectedObject = this.xPathExecuter.selectObject(this.currentNode, expression);
        if (Object.class != valueClass) {
            if (selectedObject != null) {
                if (selectedObject instanceof Node) {
                    String text = this.getText((Node)selectedObject);
                    if (text != null) {
                        value = this.convertStringValue(text, valueClass);
                    }
                } else if (selectedObject instanceof Boolean && valueClass.equals(Boolean.class)) {
                    value = selectedObject;
                } else if (selectedObject instanceof Number && Number.class.isAssignableFrom(valueClass)) {
                    value = this.convertNumber((Number)selectedObject, valueClass);
                } else {
                    String text = selectedObject.toString();
                    value = this.convertStringValue(text, valueClass);
                }
            }
        } else {
            value = selectedObject;
        }
        return value;
    }

    public NewDS subDataSource(String selectExpr) throws JRException {
        return this;
    }

    public NewDS subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        return JRXmlUtils.createDocument((Node)this.currentNode);
    }

    public NewDS dataSource(String selectExpr) throws JRException {
        NewDS subDataSource = new NewDS(this.document, selectExpr);
        subDataSource.setTextAttributes(this);
        return subDataSource;
    }

    public NewDS dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        NewDS ds = new NewDS(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField field = new JRDesignField();
        field.setDescription("CustomerID");
        field.setValueClass(String.class);
        ds.next();
        String v = (String)ds.getFieldValue((JRField)field);
        System.out.println(field.getDescription() + "=" + v);
        NewDS subDs = ds.dataSource("/Northwind/Orders");
        JRDesignField field1 = new JRDesignField();
        field1.setDescription("OrderID");
        field1.setValueClass(String.class);
        subDs.next();
        String v1 = (String)subDs.getFieldValue((JRField)field1);
        System.out.println(field1.getDescription() + "=" + v1);
    }
}

