/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.ListValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class ListDatatype
extends AbstractDatatype {
    private Datatype listDatatype;
    ListValue listValues;

    public ListDatatype(Datatype listDatatype, QNameContext schemaType) {
        super(BuiltInType.LIST, schemaType);
        if (listDatatype.getBuiltInType() == BuiltInType.LIST) {
            throw new IllegalArgumentException();
        }
        this.listDatatype = listDatatype;
    }

    public DatatypeID getDatatypeID() {
        return this.listDatatype.getDatatypeID();
    }

    public Datatype getListDatatype() {
        return this.listDatatype;
    }

    protected boolean isValidString(String value) {
        this.listValues = ListValue.parse(value, this.listDatatype);
        return this.listValues != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof ListValue) {
            ListValue lv = (ListValue)value;
            if (this.listDatatype.getBuiltInType() == lv.getListDatatype().getBuiltInType()) {
                this.listValues = lv;
                return true;
            }
            this.listValues = null;
            return false;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        Value[] values = this.listValues.toValues();
        valueChannel.encodeUnsignedInteger(values.length);
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            boolean valid = this.listDatatype.isValid(v);
            if (!valid) {
                throw new RuntimeException("ListValue is not valid, " + v);
            }
            this.listDatatype.writeValue(qnContext, valueChannel, stringEncoder);
        }
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        int len = valueChannel.decodeUnsignedInteger();
        Value[] values = new Value[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.listDatatype.readValue(qnContext, valueChannel, stringDecoder);
        }
        ListValue retVal = new ListValue(values, this.listDatatype);
        return retVal;
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof ListDatatype) {
            ListDatatype l = (ListDatatype)o;
            return this.listDatatype.equals(l.listDatatype);
        }
        return false;
    }
}

