/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.FloatValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class FloatDatatype
extends AbstractDatatype {
    protected FloatValue lastValidFloat;

    public FloatDatatype(QNameContext schemaType) {
        super(BuiltInType.FLOAT, schemaType);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_double;
    }

    protected boolean isValidString(String value) {
        this.lastValidFloat = FloatValue.parse(value);
        return this.lastValidFloat != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof FloatValue) {
            this.lastValidFloat = (FloatValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeFloat(this.lastValidFloat);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return valueChannel.decodeFloatValue();
    }
}

