/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamDecoder;
import com.siemens.ct.exi.core.EXIHeaderDecoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class EXIStreamDecoderImpl
implements EXIStreamDecoder {
    protected final EXIHeaderDecoder exiHeader = new EXIHeaderDecoder();
    protected EXIBodyDecoder exiBody;
    protected final EXIFactory noOptionsFactory;

    public EXIStreamDecoderImpl(EXIFactory noOptionsFactory) throws EXIException {
        this.exiBody = noOptionsFactory.createEXIBodyDecoder();
        this.noOptionsFactory = noOptionsFactory;
    }

    public EXIBodyDecoder getBodyOnlyDecoder(InputStream is) throws EXIException, IOException {
        is = this.checkBufferedAndPushbackStream(is);
        this.exiBody.setInputStream(is);
        return this.exiBody;
    }

    public EXIBodyDecoder decodeHeader(InputStream is) throws EXIException, IOException {
        BitDecoderChannel headerChannel = new BitDecoderChannel(is = this.checkBufferedAndPushbackStream(is));
        EXIFactory exiFactory = this.exiHeader.parse(headerChannel, this.noOptionsFactory);
        if (exiFactory != this.noOptionsFactory) {
            this.exiBody = exiFactory.createEXIBodyDecoder();
        }
        if (exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.exiBody.setInputChannel(headerChannel);
        } else {
            this.exiBody.setInputStream(is);
        }
        return this.exiBody;
    }

    private InputStream checkBufferedAndPushbackStream(InputStream is) {
        if (!(is instanceof PushbackInputStream || is instanceof BufferedInputStream || is instanceof ByteArrayInputStream)) {
            is = new BufferedInputStream(is);
        }
        return is;
    }
}

